/*
 * P3 python wrapper
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*****************************************
 * Copyright (C) 2003 Bertrand 'blam' LAMY
 *****************************************/

#ifdef WIN32
PyObject* PYP3_GENERIC_ALLOC (PyTypeObject* type, int nitems) {
  return PyType_GenericAlloc (type, nitems);
}
void PYP3_GENERIC_NEW (PyObject* o) {
  PyType_GenericNew (o);
}
void PYP3_GENERIC_FREE (PyObject* o) {
  PyObject_Del (o);
}
void PYP3_GENERIC_GC_FREE (PyObject* o) {
  PyObject_GC_Del (o);
}
PyObject* PYP3_GENERIC_GETATTR (PyObject* obj, PyObject* name) {
  return PyObject_GenericGetAttr (obj, name);
}
PyObject* PYP3_GENERIC_SETATTR (PyObject* obj, PyObject* name) {
  return PyObject_GenericSetAttr (obj, name);
}
#else /* WIN32 */
#define PYP3_GENERIC_ALLOC   PyType_GenericAlloc
#define PYP3_GENERIC_NEW     PyType_GenericNew
#define PYP3_GENERIC_FREE    _PyObject_Del
#define PYP3_GENERIC_GC_FREE _PyObject_GC_Del
#define PYP3_GENERIC_GETATTR PyObject_GenericGetAttr
#define PYP3_GENERIC_SETATTR PyObject_GenericSetAttr
#endif /* WIN32 */


/* Macros to convert Python object to C */

#define PY_TUPLE_FLOAT_TO_ARRAY_3(r, seq) \
  r[0] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (seq, 0)); \
  r[1] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (seq, 1)); \
  r[2] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (seq, 2))

#define PY_TUPLE_FLOAT_TO_ARRAY_4(r, seq) \
  r[0] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (seq, 0)); \
  r[1] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (seq, 1)); \
  r[2] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (seq, 2)); \
  r[3] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (seq, 3))


/* Macros for fast getsets definition */

#ifdef SAFE_MODE
#define PY_GET_SET_ON_INT_ADD(objtypename, objtype, attrname, attr, additional) \
  static PyObject* PyP3##objtypename##_Get##attrname (objtype a, void* context) { \
    return PyInt_FromLong((long) a->attr); \
  } \
  static int PyP3##objtypename##_Set##attrname (objtype a, PyObject* value, void* context) { \
    a->attr = (int) PyInt_AS_LONG (value); \
    additional \
    return 0; \
  }
#else /* ! SAFE_MODE */
#define PY_GET_SET_ON_INT_ADD(objtypename, objtype, attrname, attr, additional) \
  static PyObject* PyP3##objtypename##_Get##attrname (objtype a, void* context) { \
    return PyInt_FromLong((long) a->attr); \
  } \
  static int PyP3##objtypename##_Set##attrname (objtype a, PyObject* value, void* context) { \
    if (!(PyInt_Check (value))) { \
      PyErr_SetString (PyExc_RuntimeError, "waiting for an Int !\n"); \
      return -1; \
    } \
    a->attr = (int) PyInt_AS_LONG (value); \
    additional \
    return 0; \
  }
#endif /* ! SAFE_MODE */

#ifdef SAFE_MODE
#define PY_GET_SET_ON_INT(objtypename, objtype, attrname, attr) \
  static PyObject* PyP3##objtypename##_Get##attrname (objtype a, void* context) { \
    return PyInt_FromLong((long) a->attr); \
  } \
  static int PyP3##objtypename##_Set##attrname (objtype a, PyObject* value, void* context) { \
    a->attr = (int) PyInt_AS_LONG (value); \
    return 0; \
  }
#else /* ! SAFE_MODE */
#define PY_GET_SET_ON_INT(objtypename, objtype, attrname, attr) \
  static PyObject* PyP3##objtypename##_Get##attrname (objtype a, void* context) { \
    return PyInt_FromLong((long) a->attr); \
  } \
  static int PyP3##objtypename##_Set##attrname (objtype a, PyObject* value, void* context) { \
    if (!(PyInt_Check (value))) { \
      PyErr_SetString (PyExc_RuntimeError, "waiting for an Int !\n"); \
      return -1; \
    } \
    a->attr = (int) PyInt_AS_LONG (value); \
    return 0; \
  }
#endif /* ! SAFE_MODE */

#ifdef SAFE_MODE
#define PY_GET_SET_ON_FLOAT_ADD(objtypename, objtype, attrname, attr, additional) \
  static PyObject* PyP3##objtypename##_Get##attrname (objtype a, void* context) { \
    return PyFloat_FromDouble((double) a->attr); \
  } \
  static int PyP3##objtypename##_Set##attrname (objtype a, PyObject* value, void* context) { \
    if (!(PyFloat_Check (value))) { \
      PyErr_SetString (PyExc_RuntimeError, "waiting for a Float !\n"); \
      return -1; \
    } \
    a->attr = (GLfloat) PyFloat_AS_DOUBLE (value); \
    additional \
    return 0; \
  }
#else /* ! SAFE_MODE */
#define PY_GET_SET_ON_FLOAT_ADD(objtypename, objtype, attrname, attr, additional) \
  static PyObject* PyP3##objtypename##_Get##attrname (objtype a, void* context) { \
    return PyFloat_FromDouble((double) a->attr); \
  } \
  static int PyP3##objtypename##_Set##attrname (objtype a, PyObject* value, void* context) { \
    a->attr = PyFloat_AS_DOUBLE (value); \
    additional \
    return 0; \
  }
#endif /* ! SAFE_MODE */

#ifdef SAFE_MODE
#define PY_GET_SET_ON_FLOAT(objtypename, objtype, attrname, attr) \
  static PyObject* PyP3##objtypename##_Get##attrname (objtype a, void* context) { \
    return PyFloat_FromDouble((double) a->attr); \
  } \
  static int PyP3##objtypename##_Set##attrname (objtype a, PyObject* value, void* context) { \
    if (!(PyFloat_Check (value))) { \
      PyErr_SetString (PyExc_RuntimeError, "waiting for a Float !\n"); \
      return -1; \
    } \
    a->attr = (GLfloat) PyFloat_AS_DOUBLE (value); \
    return 0; \
  }
#else /* ! SAFE_MODE */
#define PY_GET_SET_ON_FLOAT(objtypename, objtype, attrname, attr) \
  static PyObject* PyP3##objtypename##_Get##attrname (objtype a, void* context) { \
    return PyFloat_FromDouble((double) a->attr); \
  } \
  static int PyP3##objtypename##_Set##attrname (objtype a, PyObject* value, void* context) { \
    a->attr = PyFloat_AS_DOUBLE (value); \
    return 0; \
  }
#endif /* ! SAFE_MODE */

#define PY_GET_SET_ON_OPTION_ADD(objtypename, objtype, optionname, optionflag, additional) \
  static PyObject* PyP3##objtypename##_Get##optionname (objtype a, void* context) { \
    if (a->option & optionflag) { \
      return PyInt_FromLong (1); \
    } else { \
      return PyInt_FromLong (0); \
    } \
  } \
  static int PyP3##objtypename##_Set##optionname (objtype a, PyObject* value, void* context) { \
    if (PyObject_IsTrue (value) == 1) { \
      a->option |= optionflag; \
    } else { \
      a->option &= ~optionflag; \
    } \
    additional \
    return 0; \
  }

#define PY_GET_SET_ON_OPTION(objtypename, objtype, optionname, optionflag) \
  static PyObject* PyP3##objtypename##_Get##optionname (objtype a, void* context) { \
    if (a->option & optionflag) { \
      return PyInt_FromLong (1); \
    } else { \
      return PyInt_FromLong (0); \
    } \
  } \
  static int PyP3##objtypename##_Set##optionname (objtype a, PyObject* value, void* context) { \
    if (PyObject_IsTrue (value) == 1) { \
      a->option |= optionflag; \
    } else { \
      a->option &= ~optionflag; \
    } \
    return 0; \
  }

#ifdef SAFE_MODE
#define PY_GET_SET_ON_FLOAT_ARRAY_ADD(objtypename, objtype, attrname, array, nb, additional) \
  static PyObject* PyP3##objtypename##_Get##attrname (objtype a, void* context) { \
    PyObject* tuple; int iter; \
    tuple = PyTuple_New (nb); \
    for (iter = 0; iter < nb; iter++) { \
      PyTuple_SET_ITEM (tuple, iter, PyFloat_FromDouble ((double) (a->array)[iter])); \
    } \
    return tuple; \
  } \
  static int PyP3##objtypename##_Set##attrname (objtype a, PyObject* value, void* context) { \
    PyObject* o; \
    int iter; \
    if (!PySequence_Check (value) || PySequence_Size (value) < nb) { \
      PyErr_SetString (PyExc_RuntimeError, "you must give a tuple with the right number of elements\n"); \
      return -1; \
    } \
    for (iter = 0; iter < nb; iter++) { \
      o = PySequence_Fast_GET_ITEM (value, iter); \
      if (!(PyFloat_Check (o))) { \
        PyErr_SetString (PyExc_RuntimeError, "waiting for a Float !\n"); \
        return -1; \
      } \
      (a->array)[iter] = (GLfloat) PyFloat_AS_DOUBLE (o); \
    } \
    additional \
    return 0; \
  }
#else /* ! SAFE_MODE */
#define PY_GET_SET_ON_FLOAT_ARRAY_ADD(objtypename, objtype, attrname, array, nb, additional) \
  static PyObject* PyP3##objtypename##_Get##attrname (objtype a, void* context) { \
    PyObject* tuple; int iter; \
    tuple = PyTuple_New (nb); \
    for (iter = 0; iter < nb; iter++) { \
      PyTuple_SET_ITEM (tuple, iter, PyFloat_FromDouble ((double) (a->array)[iter])); \
    } \
    return tuple; \
  } \
  static int PyP3##objtypename##_Set##attrname (objtype a, PyObject* value, void* context) { \
    int iter; \
    for (iter = 0; iter < nb; iter++) { \
      (a->array)[iter] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (value, iter)); \
    } \
    additional \
    return 0; \
  }
#endif /* ! SAFE_MODE */

#ifdef SAFE_MODE
#define PY_GET_SET_ON_FLOAT_ARRAY(objtypename, objtype, attrname, array, nb) \
  static PyObject* PyP3##objtypename##_Get##attrname (objtype a, void* context) { \
    PyObject* tuple; int iter; \
    tuple = PyTuple_New (nb); \
    for (iter = 0; iter < nb; iter++) { \
      PyTuple_SET_ITEM (tuple, iter, PyFloat_FromDouble ((double) (a->array)[iter])); \
    } \
    return tuple; \
  } \
  static int PyP3##objtypename##_Set##attrname (objtype a, PyObject* value, void* context) { \
    PyObject* o; \
    int iter; \
    if (!PySequence_Check (value) || PySequence_Size (value) < nb) { \
      PyErr_SetString (PyExc_RuntimeError, "you must give a tuple with the right number of elements\n"); \
      return -1; \
    } \
    for (iter = 0; iter < nb; iter++) { \
      o = PySequence_Fast_GET_ITEM (value, iter); \
      if (!(PyFloat_Check (o))) { \
        PyErr_SetString (PyExc_RuntimeError, "waiting for a Float !\n"); \
        return -1; \
      } \
      (a->array)[iter] = (GLfloat) PyFloat_AS_DOUBLE (o); \
    } \
    return 0; \
  }
#else /* ! SAFE_MODE */
#define PY_GET_SET_ON_FLOAT_ARRAY(objtypename, objtype, attrname, array, nb) \
  static PyObject* PyP3##objtypename##_Get##attrname (objtype a, void* context) { \
    PyObject* tuple; int iter; \
    tuple = PyTuple_New (nb); \
    for (iter = 0; iter < nb; iter++) { \
      PyTuple_SET_ITEM (tuple, iter, PyFloat_FromDouble ((double) (a->array)[iter])); \
    } \
    return tuple; \
  } \
  static int PyP3##objtypename##_Set##attrname (objtype a, PyObject* value, void* context) { \
    int iter; \
    for (iter = 0; iter < nb; iter++) { \
      (a->array)[iter] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (value, iter)); \
    } \
    return 0; \
  }
#endif /* ! SAFE_MODE */

#define PY_GET_SET_ON_OBJECT_ADD(objtypename, objtype, attrname, attr, attrtype, additional) \
  static PyObject* PyP3##objtypename##_Get##attrname (objtype a, void* context) { \
    if (a->attr == NULL) { \
      Py_INCREF (Py_None); \
      return Py_None; \
    } else { \
      Py_INCREF ((PyObject*) a->attr); \
      return (PyObject*) a->attr; \
    } \
  } \
  static int PyP3##objtypename##_Set##attrname (objtype a, PyObject* value, void* context) { \
    Py_XDECREF ((PyObject*) a->attr); \
    if (value == Py_None || value == NULL) { \
      a->attr = NULL; \
    } else { \
      Py_INCREF (value); \
      a->attr = (attrtype) value; \
    } \
    additional \
    return 0; \
  }

#define PY_GET_SET_ON_OBJECT(objtypename, objtype, attrname, attr, attrtype) \
  static PyObject* PyP3##objtypename##_Get##attrname (objtype a, void* context) { \
    if (a->attr == NULL) { \
      Py_INCREF (Py_None); \
      return Py_None; \
    } else { \
      Py_INCREF ((PyObject*) a->attr); \
      return (PyObject*) a->attr; \
    } \
  } \
  static int PyP3##objtypename##_Set##attrname (objtype a, PyObject* value, void* context) { \
    Py_XDECREF ((PyObject*) a->attr); \
    if (value == Py_None || value == NULL) { \
      a->attr = NULL; \
    } else { \
      Py_INCREF (value); \
      a->attr = (attrtype) value; \
    } \
    return 0; \
  }

/* Various macros */

#define GET_PY_COORD(array, point, pyobj) \
  pyobj = PyObject_GetAttrString (point, "x"); \
  array[0] = (GLfloat) PyFloat_AS_DOUBLE (pyobj); \
  Py_DECREF (pyobj); \
  pyobj = PyObject_GetAttrString (point, "y"); \
  array[1] = (GLfloat) PyFloat_AS_DOUBLE (pyobj); \
  Py_DECREF (pyobj); \
  pyobj = PyObject_GetAttrString (point, "z"); \
  array[2] = (GLfloat) PyFloat_AS_DOUBLE (pyobj); \
  Py_DECREF (pyobj);

#define GET_PY_POINT_COORD(array, point, pyobj, coordsys) \
  pyobj = PyObject_GetAttrString (point, "x"); \
  array[0] = (GLfloat) PyFloat_AS_DOUBLE (pyobj); \
  Py_DECREF (pyobj); \
  pyobj = PyObject_GetAttrString (point, "y"); \
  array[1] = (GLfloat) PyFloat_AS_DOUBLE (pyobj); \
  Py_DECREF (pyobj); \
  pyobj = PyObject_GetAttrString (point, "z"); \
  array[2] = (GLfloat) PyFloat_AS_DOUBLE (pyobj); \
  Py_DECREF (pyobj); \
  pyobj = PyObject_GetAttrString (point, "parent"); \
  if (pyobj != Py_None && coordsys != NULL && pyobj != (PyObject*) coordsys) { \
    P3_point_by_matrix (array, P3_coordsys_get_root_matrix ((P3_coordsys*) pyobj)); \
    P3_point_by_matrix (array, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) coordsys)); \
  } \
  Py_DECREF (pyobj);

#define GET_PY_VECTOR_COORD(array, vector, pyobj, coordsys) \
  pyobj = PyObject_GetAttrString (vector, "x"); \
  array[0] = (GLfloat) PyFloat_AS_DOUBLE (pyobj); \
  Py_DECREF (pyobj); \
  pyobj = PyObject_GetAttrString (vector, "y"); \
  array[1] = (GLfloat) PyFloat_AS_DOUBLE (pyobj); \
  Py_DECREF (pyobj); \
  pyobj = PyObject_GetAttrString (vector, "z"); \
  array[2] = (GLfloat) PyFloat_AS_DOUBLE (pyobj); \
  Py_DECREF (pyobj); \
  pyobj = PyObject_GetAttrString (vector, "parent"); \
  if (pyobj != Py_None && coordsys != NULL && pyobj != (PyObject*) coordsys) { \
    P3_vector_by_matrix (array, P3_coordsys_get_root_matrix ((P3_coordsys*) pyobj)); \
    P3_vector_by_matrix (array, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) coordsys)); \
  } \
  Py_DECREF (pyobj);


/* macros to add new types or constants in the module dictionary */

#define PY_MODULE_ADD_TYPE(name, pyname) \
  PyP3##name##_Type.ob_type = &PyType_Type; \
  Py_INCREF (&PyP3##name##_Type); \
  PyDict_SetItemString (P3Module_Dict, pyname, (PyObject*) &PyP3##name##_Type)

#define PY_MODULE_ADD_SYMBOL(sym, psym) \
  PyModule_AddIntConstant (P3Module, psym, sym)
//  PyDict_SetItemString (P3Module_Dict, psym, PyInt_FromLong (sym))

