/*
 * P3 python wrapper
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*****************************************
 * Copyright (C) 2002 Bertrand 'blam' LAMY
 *****************************************/

static void PyP3_GetRaypickData (P3_raypick_data* data, PyObject* args) {
//  PyObject*  o = PySequence_Fast_GET_ITEM (args, 0);
  P3_vector* v = (P3_vector*) PySequence_Fast_GET_ITEM (args, 1);
  PyP3_GetPositionIntoNull (PySequence_Fast_GET_ITEM (args, 0), data->root_data);
/*
  if (PyObject_IsInstance (o, (PyObject*) &PyP3Point_Type) == 1) {
    P3_point* p = (P3_point*) o;
    if (p->parent == NULL) {
      memcpy (rdata, p->coord, 3 * sizeof (GLfloat));
    } else {
      P3_point_by_matrix_copy (rdata, p->coord, P3_coordsys_get_root_matrix (p->parent));
    }
  } else {
    P3_coordsys* c = (P3_coordsys*) o;
    if (c->parent == NULL) {
      memcpy (rdata, c->m + 12, 3 * sizeof (GLfloat));
    } else {
      P3_point_by_matrix_copy (rdata, c->m + 12, P3_coordsys_get_root_matrix (c->parent));
    }
  }
*/
  if (v->parent == NULL) {
    memcpy (data->root_data + 3, v->coord, 3 * sizeof (GLfloat));
  } else {
    P3_vector_by_matrix_copy (data->root_data + 3, v->coord, P3_coordsys_get_root_matrix (v->parent));
  }
  P3_vector_normalize (data->root_data + 3);
  data->root_data[6] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 2));
  data->option = (int) PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 3));

#if 0
  PyObject* t;
  PyObject* o;
  /* position */
  t = PySequence_Fast_GET_ITEM (args, 0);
  o = PyObject_GetAttrString (t, "x");
  rdata[0] = (GLfloat) PyFloat_AS_DOUBLE (o);
  Py_DECREF (o);
  o = PyObject_GetAttrString (t, "y");
  rdata[1] = (GLfloat) PyFloat_AS_DOUBLE (o);
  Py_DECREF (o);
  o = PyObject_GetAttrString (t, "z");
  rdata[2] = (GLfloat) PyFloat_AS_DOUBLE (o);
  Py_DECREF (o);
  o = PyObject_GetAttrString (t, "parent");
  if (o != Py_None) {
    P3_point_by_matrix (rdata, P3_coordsys_get_root_matrix ((P3_coordsys*) o));
  }
  Py_DECREF (o);
  /* direction */
  t = PySequence_Fast_GET_ITEM (args, 1);
  o = PyObject_GetAttrString (t, "x");
  rdata[3] = (GLfloat) PyFloat_AS_DOUBLE (o);
  Py_DECREF (o);
  o = PyObject_GetAttrString (t, "y");
  rdata[4] = (GLfloat) PyFloat_AS_DOUBLE (o);
  Py_DECREF (o);
  o = PyObject_GetAttrString (t, "z");
  rdata[5] = (GLfloat) PyFloat_AS_DOUBLE (o);
  Py_DECREF (o);
  o = PyObject_GetAttrString (t, "parent");
  P3_vector_normalize (rdata + 3);
  if (o != Py_None) {
    P3_vector_by_matrix (rdata + 3, P3_coordsys_get_root_matrix ((P3_coordsys*) o));
  }
  Py_DECREF (o);
  /* length */
  rdata[6] = (GLfloat) PyFloat_AS_DOUBLE (PySequence_Fast_GET_ITEM (args, 2));
#endif

}

static PyObject* PyP3_MakeRaypickResult (GLfloat* f, GLfloat z, GLfloat* normal, void* csys, PyObject* args) {
  P3_point* p;
  P3_vector* v;
  if (f == NULL) {
    Py_INCREF (Py_None);
    return Py_None;
  } else {
    Py_INCREF ((PyObject*) csys);
    Py_INCREF ((PyObject*) csys);
    if (PySequence_Size (args) == 6) {
      p = (P3_point*) PySequence_Fast_GET_ITEM (args, 4);
      Py_XDECREF ((PyObject*) p->parent);
      v = (P3_vector*) PySequence_Fast_GET_ITEM (args, 5);
      Py_XDECREF ((PyObject*) v->parent);
      p->parent = csys;
      p->coord[0] = f[0] + f[3] * z;
      p->coord[1] = f[1] + f[4] * z;
      p->coord[2] = f[2] + f[5] * z;
      v->parent = csys;
      memcpy (v->coord, normal, 3 * sizeof (GLfloat));
      return PyInt_FromLong (1);
    } else {
      PyObject* o;
      p = (P3_point*)  PyP3Point_Type.tp_alloc  (&PyP3Point_Type,  0);
      v = (P3_vector*) PyP3Vector_Type.tp_alloc (&PyP3Vector_Type, 0);
      p->parent = csys;
      p->coord[0] = f[0] + f[3] * z;
      p->coord[1] = f[1] + f[4] * z;
      p->coord[2] = f[2] + f[5] * z;
      v->parent = csys;
      memcpy (v->coord, normal, 3 * sizeof (GLfloat));
      o = PyTuple_New (2);
      PyTuple_SET_ITEM (o, 0, (PyObject*) p);
      PyTuple_SET_ITEM (o, 1, (PyObject*) v);
      return o;
    }
  }
  
/*
  if (csys != NULL) {
    f = P3_raypickable_get_raypick_data ((P3_raypickable*) csys, rdata);
    if (PySequence_Size (args) == 6) {
      o = PySequence_Fast_GET_ITEM (args, 4);
      PyObject_SetAttrString (o, "parent", (PyObject*) csys);
      t = PyFloat_FromDouble ((double) f[0] + f[3] * z);
      PyObject_SetAttrString (o, "x", t);
      Py_DECREF (t);
      t = PyFloat_FromDouble ((double) f[1] + f[4] * z);
      PyObject_SetAttrString (o, "y", t);
      Py_DECREF (t);
      t = PyFloat_FromDouble ((double) f[2] + f[5] * z);
      PyObject_SetAttrString (o, "z", t);
      Py_DECREF (t);
      o = PySequence_Fast_GET_ITEM (args, 5);
      PyObject_SetAttrString (o, "parent", (PyObject*) csys);
      t = PyFloat_FromDouble ((double) normal[0]);
      PyObject_SetAttrString (o, "x", t);
      Py_DECREF (t);
      t = PyFloat_FromDouble ((double) normal[1]);
      PyObject_SetAttrString (o, "y", t);
      Py_DECREF (t);
      t = PyFloat_FromDouble ((double) normal[2]);
      PyObject_SetAttrString (o, "z", t);
      Py_DECREF (t);
      return PyInt_FromLong (1);
    } else {
      o = PyTuple_New (2);
      PyTuple_SET_ITEM (o, 0, PyObject_CallMethod (P3Module, "new_point",  "Offf", csys, (double) f[0] + f[3] * z, (double) f[1] + f[4] * z, (double) f[2] + f[5] * z));
      PyTuple_SET_ITEM (o, 1, PyObject_CallMethod (P3Module, "new_vector", "Offf", csys, (double) normal[0], (double) normal[1], (double) normal[2]));
      return o;
    }
  }
*/
}

static PyObject* PyP3Coordsys_Raypick (P3_any_object* w, PyObject* args) {
  P3_raypick_data data;
  GLfloat* f;
  if (w->class->raypick == 0) { 
    Py_INCREF (Py_None);
    return Py_None;
  }
  PyP3_GetRaypickData (&data, args);
  f = P3_raypick (w, &data);
  return PyP3_MakeRaypickResult (f, data.result, data.normal, data.ret_csys, args);
}

static PyObject* PyP3Coordsys_RaypickB (P3_any_object* w, PyObject* args) {
  P3_raypick_data data;
  if (w->class->raypick_b == 0) return PyInt_FromLong (0);
  PyP3_GetRaypickData (&data, args);
  if (P3_raypick_b (w, &data) == P3_TRUE) {
    return PyInt_FromLong (1);
  } else {
    return PyInt_FromLong (0);
  }
}


/*=================+
 | RAYPICK CONTEXT |
 +=================*/

typedef struct {
  P3_SYSTEM_OBJECT_HEADER
  P3_chunk* chunk;
} PyP3RaypickContext;

static int PyP3RaypickContext_Init (PyP3RaypickContext* a, PyObject* args, PyObject* kwds) {
  a->chunk = P3_chunk_new ();
  return 0;
}

static void PyP3RaypickContext_Dealloc (PyP3RaypickContext* a) {
  P3_chunk_dealloc (a->chunk);
  a->ob_type->tp_free ((PyObject*) a);
}

static PyObject* PyP3RaypickContext_Raypick (PyP3RaypickContext* a, PyObject* args) {
  P3_raypick_data data;
  GLfloat* f;
  PyP3_GetRaypickData (&data, args);
  f = P3_raypick_context_raypick (a->chunk, &data);
  return PyP3_MakeRaypickResult (f, data.result, data.normal, data.ret_csys, args);
}

static PyObject* PyP3RaypickContext_RaypickB (PyP3RaypickContext* a, PyObject* args) {
  P3_raypick_data data;
  PyP3_GetRaypickData (&data, args);
  if (P3_raypick_context_raypick_b (a->chunk, &data) == P3_TRUE) {
    return PyInt_FromLong (1);
  } else {
    return PyInt_FromLong (0);
  }
}

static PyMethodDef PyP3RaypickContext_Methods[] = {
  { "raypick",   (PyCFunction) PyP3RaypickContext_Raypick,  METH_VARARGS },
  { "raypick_b", (PyCFunction) PyP3RaypickContext_RaypickB, METH_VARARGS },
  { NULL, NULL }
};

PyTypeObject PyP3RaypickContext_Type = {
  PyObject_HEAD_INIT(NULL)
  0,
  "_soya._RaypickContext",
  sizeof(PyP3RaypickContext),
  0,
  (destructor) PyP3RaypickContext_Dealloc,/* tp_dealloc */
  0,/* tp_print */
  0,/* tp_getattr */
  0,/* tp_setattr */
  0,/* tp_compare */
  0,/* tp_repr */
  0,/* tp_as_number */
  0,/* tp_as_sequence */
  0,/* tp_as_mapping */
  0,/* tp_hash */
  0,/* tp_call */
  0,/* tp_str */
  PYP3_GENERIC_GETATTR,/* tp_getattro */
  0,/* tp_setattro */
  0,/* tp_as_buffer */
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,/* tp_flags */
  0,/* tp_doc */
  (traverseproc) 0,/* tp_traverse */
  (inquiry) 0,/* tp_clear */
  0,/* tp_richcompare */
  0,/* tp_weaklistoffset */
  0,/* tp_iter */
  0,/* tp_iternext */
  (PyMethodDef*) &PyP3RaypickContext_Methods,/* tp_methods */
  0,/* tp_members */
  (PyGetSetDef*) 0,/* tp_getset */
  0,/* tp_base */
  0,/* tp_dict */
  0,/* tp_descr_get */
  0,/* tp_descr_set */
  0,/* tp_dictoffset */
  (initproc) 0,/* tp_init */
  PYP3_GENERIC_ALLOC,/* tp_alloc */
  (newfunc) PyP3Object_New,/* tp_new */
  PYP3_GENERIC_FREE,/* tp_free */
};

