/*
 * P3 python wrapper
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*****************************************
 * Copyright (C) 2003 Bertrand 'blam' LAMY
 *****************************************/

/*=======*
 * SHAPE *
 *=======*/

void P3_shape_batch (PyObject* o, P3_instance* csys) {
  PyObject* f;
  PyObject* p;
  long i;
  if (!(((P3_any_object*) o)->option & P3_OBJECT_HIDDEN)) {
    f = PyObject_CallMethod (o, "batch", NULL);
#ifdef SAFE_MODE
    if (PyErr_Occurred () != NULL) { PyErr_Print (); }
#endif /* SAFE_MODE */
    if (f != NULL) {
      i = PyInt_AS_LONG (PySequence_Fast_GET_ITEM (f, 0));
      p = PySequence_Fast_GET_ITEM (f, 1);
      if (p != Py_None) {
        csys = (P3_instance*) p;
      }
      if (i == 0) {
        P3_renderer_add (o, csys);
      } else if (i == 1) {
        P3_renderer_add_alpha (o, csys);
      } else if (i == 2) {
        P3_renderer_add       (o, csys);
        P3_renderer_add_alpha (o, csys);
      } else if (i == 3) {
        P3_renderer_batch (renderer->specials, o, csys, -1);
      }
      Py_DECREF (f);
    }
  }
}

void P3_shape_render (PyObject* o, P3_instance* csys) {
  PyObject* f;
  f = PyObject_CallMethod (o, "render", NULL);
#ifdef SAFE_MODE
  if (PyErr_Occurred () != NULL) { PyErr_Print (); }
#endif /* SAFE_MODE */
  Py_XDECREF (f);
}

P3_class P3_class_shape = { 
  P3_ID_SHAPE,
  (batch_func)     P3_shape_batch,
  (render_func)    P3_shape_render,
  (shadow_func)    0,
  (raypick_func)   0,
  (raypick_b_func) 0,
};

static PyObject* PyP3Object_New (PyTypeObject* type, PyObject* args, PyObject* kwds) {
  PyObject* self;
#ifdef SAFE_MODE
  assert (type != NULL && type->tp_alloc != NULL);
#endif /* SAFE_MODE */
  self = type->tp_alloc (type, 0);
  return self;
}

static void PyP3Object_Dealloc (PyObject* o) {
  o->ob_type->tp_free ((PyObject*) o);
}

static int PyP3Shape_Init (PyObject* self, PyObject* args, PyObject* kwds) {
  ((P3_any_object*) self)->class = &P3_class_shape;
	return 0;
}

static PyObject* PyP3Object_GetVisible (P3_any_object* m, void* context) {
  if (m->option & P3_OBJECT_HIDDEN) {
    return PyInt_FromLong (0);
  } else {
    return PyInt_FromLong (1);
  }
}
static int PyP3Object_SetVisible (P3_any_object* m, PyObject* value, void* context) {
  if (PyObject_IsTrue (value) == 1) {
    if (m->option & P3_OBJECT_HIDDEN) {
      m->option -= P3_OBJECT_HIDDEN;
    }
  } else {
    m->option |= P3_OBJECT_HIDDEN;
  }
  return 0;
}

static PyObject* PyP3Object_GetSolid (P3_any_object* m, void* context) {
  if (m->option & P3_OBJECT_NON_SOLID) {
    return PyInt_FromLong (0);
  } else {
    return PyInt_FromLong (1);
  }
}
static int PyP3Object_SetSolid (P3_any_object* m, PyObject* value, void* context) {
  if (PyObject_IsTrue (value) == 1) {
    if (m->option & P3_OBJECT_NON_SOLID) { m->option -= P3_OBJECT_NON_SOLID; }
  } else {
    m->option |= P3_OBJECT_NON_SOLID;
  }
  return 0;
}

#define PYP3_VISIBLE_GETSETS \
  { "visible", (getter) PyP3Object_GetVisible, (setter) PyP3Object_SetVisible, NULL }

#define PYP3_SOLID_GETSETS \
  { "solid", (getter) PyP3Object_GetSolid, (setter) PyP3Object_SetSolid, NULL }

PyTypeObject PyP3Shape_Type = {
  PyObject_HEAD_INIT(NULL)
  0,
  "_Shape",
  sizeof(P3_any_object),
  0,
  (destructor) PyP3Object_Dealloc,/* tp_dealloc */
  0,/* tp_print */
  0,/* tp_getattr */
  0,/* tp_setattr */
  0,/* tp_compare */
  0,/* tp_repr */
  0,/* tp_as_number */
  0,/* tp_as_sequence */
  0,/* tp_as_mapping */
  0,/* tp_hash */
  0,/* tp_call */
  0,/* tp_str */
  PYP3_GENERIC_GETATTR,/* tp_getattro */
  0,/* tp_setattro */
  0,/* tp_as_buffer */
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,/* tp_flags */
  0,/* tp_doc */
  (traverseproc) 0,/* tp_traverse */
  (inquiry) 0,/* tp_clear */
  0,/* tp_richcompare */
  0,/* tp_weaklistoffset */
  0,/* tp_iter */
  0,/* tp_iternext */
  (PyMethodDef*) 0,/* tp_methods */
  0,/* tp_members */
  (PyGetSetDef*) 0,/* tp_getset */
  0,/* tp_base */
  0,/* tp_dict */
  0,/* tp_descr_get */
  0,/* tp_descr_set */
  0,/* tp_dictoffset */
  (initproc) PyP3Shape_Init,/* tp_init */
  PYP3_GENERIC_ALLOC,/* tp_alloc */
  (newfunc) PyP3Object_New,/* tp_new */
  PYP3_GENERIC_FREE,/* tp_free */
};


