/*
 * P3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**********************************************
 * text.h
 * Copyright (C) 2001-2002 Bertrand 'blam' LAMY
 **********************************************/


P3_font_raster* P3_font_raster_from_image (P3_font_raster*, P3_image* image, int w, int h, int first_char);
void            P3_font_raster_print_2i   (P3_font_raster*, char*, int x, int y, int *rw, int* rh);
void            P3_font_raster_print_3f   (P3_font_raster*, char*, GLfloat x, GLfloat y, GLfloat z);
int             P3_font_raster_print_area (P3_font_raster*, char*, int x1, int y1, int width, int height, int align);
void            P3_font_raster_init       (P3_font_raster*);
void            P3_font_raster_save       (P3_font_raster*, char* filename);
P3_font_raster* P3_font_raster_load       (P3_font_raster*, FILE*);

P3_font_texture* P3_font_texture_from_image    (P3_font_texture*, P3_image* image, int first_char, GLubyte* color_limit);
void             P3_font_texture_init          (P3_font_texture*);
void             P3_font_texture_print_2i      (P3_font_texture*, char*, int x, int y, int *rw, int* rh);
void             P3_font_texture_print_2i_s    (P3_font_texture*, char*, int x, int y, float scale_x, float scale_y, int *rw, int* rh);
void             P3_font_texture_print_2i_c    (P3_font_texture*, char*, int x, int y, GLfloat* color1, GLfloat* color2, int *rw, int* rh);
void             P3_font_texture_print_2i_sc   (P3_font_texture*, char*, int x, int y, float scale_x, float scale_y, GLfloat* color1, GLfloat* color2, int *rw, int* rh);
int              P3_font_texture_print_area    (P3_font_texture*, char*, int x1, int y1, int width, int height, int align);
char*            P3_font_texture_get_size      (P3_font_texture*, char*, int w, int* width, int* height, char* txt);
void             P3_font_texture_dealloc       (P3_font_texture*);
void             P3_font_texture_save          (P3_font_texture*, char* filename);
P3_font_texture* P3_font_texture_load          (P3_font_texture*, FILE*);

P3_font_raster*  P3_font_raster_from_freetype  (P3_font_raster*,  char* filename, int pix_w, int pix_h, int from, int to);
P3_font_texture* P3_font_texture_from_freetype (P3_font_texture*, char* filename, int pix_w, int pix_h, int from, int to);

