# Soya 3D
# Copyright (C) 2001-2002 Jean-Baptiste LAMY -- jiba@tuxfamily.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""soya.laser

Provide a Laser -- a red ray that starts at a given position in a given
direction, and ends when it encounter something.

See tutorial lesson 105.

Usefull to debug raypicking !

Properties:

- color:   the color of the ray
- reflect: true (1) if you want the laser to be reflected on wall (default to false)"""

import soya, _soya, soya.soya3d as soya3d
from soya.math3d import *


class Laser(soya._CObj, soya3d.GraphicElement, _soya._Coordsys):
  def __init__(self, parent = None, color = (1.0, 0.0, 0.0, 1.0), reflect = 0):
    _soya._Coordsys.__init__(self)
    
    self.name    = ""
    self.color   = color
    self.reflect = reflect
    self.points  = []
    
    if parent: parent.add(self)
    
  def batch(self):
    if self.color[3] < 1.0:
      return (1, None)
    else:
      return (0, None)
    # return (self.color[3] != 1.0, None)
  
  def render(self):
    _soya.activate_material(None)
    _soya.glDisable(_soya.GL_TEXTURE_2D)
    _soya.glDisable(_soya.GL_LIGHTING)

    _soya.glColor4f(*self.color)
    _soya.glBegin(_soya.GL_LINES)
    _soya.glVertex3f(0.0, 0.0, 0.0)
    
    self.points = []
    
    i     = 0
    pos   = self.position()
    direc = Vector(self, 0.0, 0.0, -1.0)

    while direc and (i < 50):
      i = i + 1

      impact = self.get_root().raypick(pos, direc, -1.0, 3)
      if not impact:
        pos   = pos + (direc * 32000.0)
        direc = None
      else:
        pos = impact[0]
        
        if self.reflect:

          normal   = impact[1] % self

          # changing coordsys can alterate normal size
          normal.normalize()
          
          normal.set_length(-2.0 * direc.dot_product(normal))
          direc    = normal + direc

        else: direc = None
        
      _soya.glVertex3f(*self.transform_point(pos.x, pos.y, pos.z, pos.parent))
      if direc: _soya.glVertex3f(*self.transform_point(pos.x, pos.y, pos.z, pos.parent))
      
      self.points.append(pos)
      

    _soya.glEnd()
    
    _soya.glEnable(_soya.GL_LIGHTING)
    _soya.glEnable(_soya.GL_TEXTURE_2D)
    

