# Soya 3D tutorial
# Copyright (C) 2001-2002 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Intro :

# You are reading the Soya tutorial. Welcome !
# Lessons 0xx explain the basic of Soya and are understood to be followed in
# order. Lessons 1xx are focused on specific features and can be followed in
# (quite) any order.
# 
# Please forget about bad English ! Enjoy Soya !
#
#                                   Your teacher, Jiba


# Lesson 001: Setting up : a moving cube

# This is the first lesson of the Soya tutorial.
# This lesson just sets up everything and display a cube. In order to do that,
# we need :
#  - a cube,
#  - a light,
#  - a camera,
#  - a scene, to group the three other.
# Those basic element (except the cube) are provided by the soya.soya3d module.

# Import some Soya modules.

import soya, soya.soya3d as soya3d, soya.model as model, soya.cube as cube

# Initializes Soya (and creates the 3D window).

soya.init()

# Creates a scene. The scene is a World, which contains all the 3D scene we are
# about to render. A World is a 3D object that can contain other 3D object.

scene = soya3d.World()

# Now, we create the cube.
# The soya.cube module provides function for that; we'll see later how to create
# such geometric shapes by hand.

# First, we create a material for the cube. The material is an object that
# encapsulates all the surface properties, such as colors, texture, ...
# With no argument, the Material constructor creates a new white material.

material = model.Material()

# Creates a cube with our material. The first argument of the constructor is
# the cube's parent : the scene (this is a convention, similarly to Tkinter,
# where the first argument of a widget's constructor is the master).

cube = cube.Cube(scene, material)

# Rotates the cube vertically (= around the X axis), for a better view. The
# angle is given in degrees.

cube.rotate_vertical(30.0)

# Creates a light in the scene (same convention: the first argument of the
# constructor is the parent) and moves it to (1.5, 2.0, 0.2).

light = soya3d.Light(scene)
light.set_xyz(1.5, 2.0, 0.2)

# Creates a camera in the scene and moves it to z = 5.0. The camera looks in the
# -Z direction, so, in this case, towards the cube.
#
# When relevant, Soya always considers the X direction to be on the right of an
# object, the Y direction to be on the top and the -Z to be the front. If using
# -Z for front seems silly for you, I just want to give you the reason:
# using Z for front makes all coordinate systems indirect (which is a
# mathematical nightmare) !

camera = soya3d.Camera(scene)
camera.z = 2.0

# Say to Soya that the camera is what we want to be rendered.
# When you will call soya.render(), Soya will allways render the "root widget".
# NB: A Camera is a Widget.

soya.set_root_widget(camera)

# Defines what to do when the time advances.
# proportion is the proportion of time that has passed.

def advance_time(proportion):
  
  # Rotates the cube laterally (= around the Y axis) and inclines it (= rotate
  # around the Z axis).
  
  cube.rotate_lateral(proportion * 10.0)
  cube.rotate_incline(proportion *  5.0)

# The advance_time method will be called between each rendering.

cube.advance_time = advance_time


# The following is the rendering loop; see Py2Play for a better such loop.

import time

while 1:
  # Renders and swaps the buffers.

  soya.render()
  
  # Start a new round and advance the time.
  # advance_time() will call the previously defined rotating function.
  
  scene.begin_round()
  scene.advance_time()
  
  # Sleeps until the next rendering (to avoid wasting the whole CPU time).
  
  time.sleep(0.1)
