# Soya 3D tutorial
# Copyright (C) 2001-2002 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Lesson 004: Modeling : a textured cube

# This lesson is the following of the previous one.
# The cube is now textured !

import soya, soya.soya3d as soya3d, soya.model as model, soya.cube as cube

soya.init()

scene = soya3d.World()

# Defines the directory where the textures are loaded. We use the directory
# "./data" in the tutorial directory.
# The directory must be set in the variable "soya.Image.PATH"

import os, os.path, sys
data_dir = os.path.join(os.path.dirname(os.path.abspath(sys.argv[0])), "data")

model.Image   .PATH = os.path.join(data_dir, "images")
model.Material.PATH = os.path.join(data_dir, "materials")
soya3d.World  .PATH = os.path.join(data_dir, "worlds")
model.Shape   .PATH = os.path.join(data_dir, "shapes")

# Creates the material.

material = model.Material()

# Define the texture of the material. Soya 3D associates the texture to the
# material, contrary to most of the 3D engine.
# 
# The tex_name attribute of the material is the filename of the texture image,
# without the directory. The image file is searched in the model.Image.PATH
# directory. This is a common mecanism is Soya 3D.
# 
# Soya 3D currently supports PNG and TGA image format.

material.tex_filename  = "block2.tga"

# Notice that diffuse / specular color,... can be combined with texture.

# Other interesting attributes of materials are:
# - wireframed        : draw in wireframe
# - additive_blending : usefull for alpha-blending and special effect
# - separate_specular : for textured material, computes the specular in a
#     separate stage, giving a brigher specular effect.
# All are boolean (0 / 1) attributes.

# Creates the cube -- the soya.cube module generate the texture coordinates
# automatically.
# Texture coordinates are given on a per-vertex basis, with the tex_x and tex_y
# attributes of the vertices.

cube = cube.Cube(scene, material)
cube.rotate_vertical(30.0)

light = soya3d.Light(scene)
light.set_xyz(0.0, 0.2, 1.0)

camera = soya3d.Camera(scene)
camera.z = 2.0
soya.set_root_widget(camera)


def advance_time(proportion):
  cube.rotate_lateral(proportion * 10.0)
  cube.rotate_incline(proportion *  5.0)
  
cube.advance_time = advance_time


import time

while 1:
  soya.render()
  
  scene.begin_round()
  scene.advance_time()
  
  time.sleep(0.1)
