# Soya 3D tutorial
# Copyright (C) 2001-2002 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Lesson 005: Shape : an optimized textured cube

# This lesson optimizes the textured cube into a Shape.
# The Shape is rendered faster, and can be used several times
# (in order to display two cubes or more) !

import soya, soya.soya3d as soya3d, soya.model as model, soya.cube as cube

soya.init()

scene = soya3d.World()

import os, os.path, sys
data_dir = os.path.join(os.path.dirname(os.path.abspath(sys.argv[0])), "data")

model.Image   .PATH = os.path.join(data_dir, "images")
model.Material.PATH = os.path.join(data_dir, "materials")
soya3d.World  .PATH = os.path.join(data_dir, "worlds")
model.Shape   .PATH = os.path.join(data_dir, "shapes")

material = model.Material()
material.tex_filename = "block2.tga"

# Creates the cube.
# Notice that the cube is no longer in the scene !
# (the first argument is None, meaning that the cube is... no where!)

cube = cube.Cube(None, material)

# Creates a cubic Shape from the World.

shape = cube.shapify()

# Creates a Volume that displays this Shape

volume_1 = soya3d.Volume(scene, shape)
volume_1.set_xyz(-1.1, 0.5, 0.0)

# Creates another Volume that displays the same Shape

volume_2 = soya3d.Volume(scene, shape)
volume_2.set_xyz(0.0, 0.0, 0.0)

# Creates a third Volume that displays the same Shape

volume_3 = soya3d.Volume(scene, shape)
volume_3.set_xyz(1.1, -0.5, 0.0)

light = soya3d.Light(scene)
light.set_xyz(0.0, 0.2, 1.0)

camera = soya3d.Camera(scene)
camera.z = 3.0
soya.set_root_widget(camera)

# Returns a function that rotate OBJ around the z axis with angle ANGLE.

def rotate_advance_time(obj, angle):
  return lambda proportion: obj.rotate_incline(proportion * angle)

volume_1.advance_time = rotate_advance_time(volume_1,  5.0)
volume_2.advance_time = rotate_advance_time(volume_2, -5.0)
volume_3.advance_time = rotate_advance_time(volume_3,  5.0)


import time

while 1:
  soya.render()
  
  scene.begin_round()
  scene.advance_time()
  scene.end_round()
  
  time.sleep(0.1)
