# Soya 3D tutorial
# Copyright (C) 2001-2002 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Lesson 008: File management : saving materials and worlds

# This lesson explains how to save materials and worlds into files.

# The Soya file management system assumes that:
# - ALL your materials and your worlds are saved in a directory. The directory
#   (sometimes called "PATH") can be different for worlds and material, or it can
#   be the same.


# In this lesson, we are going to save the textured cube of the lesson 4.
# This implies saving the material, and the cube.

import soya, soya.soya3d as soya3d, soya.model as model, soya.cube as cube
import os, os.path, sys

soya.init()

scene = soya3d.World()


# Defines the texture, material and world directories. We use the directory
# "./data" in the tutorial directory. You may use 3 different directories.

data_dir = os.path.join(os.path.dirname(os.path.abspath(sys.argv[0])), "data")

model.Image   .PATH = os.path.join(data_dir, "images")
model.Material.PATH = os.path.join(data_dir, "materials")
soya3d.World  .PATH = os.path.join(data_dir, "worlds")
model.Shape   .PATH = os.path.join(data_dir, "shapes")


# Creates the textured cube -- see lesson 4

material = model.Material()

material.tex_filename = "block2.tga"

cube = cube.Cube(scene, material)
cube.rotate_vertical(30.0)

light = soya3d.Light(scene)
light.set_xyz(0.0, 0.2, 1.0)

camera = soya3d.Camera(scene)
camera.z = 2.0
soya.set_root_widget(camera)


# Defines the material's and the cube's filename. The filename is understood to
# be located in the material / world PATH.

material.filename = "wall_material"
cube    .filename = "textured_cube"


# Saves the material and the cube -- they'll be saved in the corresponding PATH
# The save() method can receive an optional FILENAME parameter, which can be used
# to save the object into an arbitrary location.
# The ".data" extension is automatically added to the file, but it must not be
# present in filenames !!!

material.save()
cube    .save()


# Renders and waits

soya.render()

import time
while 1: time.sleep(0.1)


# Notice that, if we had saved the cube without saving the material,
# Soya3D would have saved the material along with the cube !!!

# Saving the material in a separed file is interesting, though: it allows several
# worlds to share the same materials.

# The availables() methods of the Material / World class can be used to get a list
# of the names of all the available Materials / Worlds.
