# Soya 3D tutorial
# Copyright (C) 2001-2002 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Lesson 013: Idler : FPS regulation

# This lesson is similar to lesson 001, but use the soya.idler main loop
# for FPS regulation

import soya, soya.soya3d as soya3d, soya.model as model, soya.cube as cube, soya.idler as idler, soya.widget as widget

soya.init()

scene = soya3d.World()

material = model.Material()

cube = cube.Cube(scene, material)
cube.rotate_vertical(30.0)

light = soya3d.Light(scene)
light.set_xyz(1.5, 2.0, 0.2)

camera = soya3d.Camera(scene)
camera.z = 2.0

# Creates a root widget, which is a Group. The Group contains the camera and a label
# that shows the FPS.

soya.set_root_widget(widget.Group())
soya.root_widget.add(camera)
soya.root_widget.add(widget.FPSLabel())


# Defines what to do when the time advances.
# proportion is the proportion of time that has passed.

def advance_time(proportion):
  
  # Rotates the cube laterally (= around the Y axis) and inclines it (= rotate
  # around the Z axis).
  
  cube.rotate_lateral(proportion * 2.0)
  cube.rotate_incline(proportion * 1.0)
  
# The advance_time method will be called when time advances.

cube.advance_time = advance_time


# Creates an Idler (= a main loop) and calls it.

idler.Idler(scene).idle()
