# Soya 3D tutorial
# Copyright (C) 2001-2002 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Lesson 101: Setting up : a fullscreen moving cube

# This lesson shows how to use fullscreen and other initialization's options;
# it also introduces the event management.
# As the user cannot close the demo, it ends when a key is pressed.

import sys
import soya, soya.soya3d as soya3d, soya.model as model, soya.cube as cube, soya.idler as idler, soya.widget as widget

# Initializes Soya (and creates the 3D window).
# The first argument is the window's title (for windowed rendering).
# The second and third ones are the resolution in pixels (800x600, 1024x768,...).
# The fourth one is true for fullscreen and false for windowed rendering.
# The fifth one (not used here) is true for a resizeable window.

soya.init("Soya tutorial !", 800, 600, 1)

# The toggle_fullscreen function can be used to switch between fullscreen and
# windowed mode.
#
#soya.toggle_fullscreen()

# Hides the mouse cursor over the 3D view. This can also be used in windowed
# mode.
# Use "soya.cursor_set_visible(1)" to shows the cursor again.

soya.cursor_set_visible(0)

# This function will be called to check if the user has pressed a key.

def manage_event():
  
  # soya.process_event() returns all the events that have occurred since the
  # previous call. We scan all the event.
  
  for event in soya.process_event():
    
    # If the event is a keydown, ends the demo.
    # Events are tupples; the first item indicates the nature of the event.
    
    if event[0] == soya.KEYDOWN: sys.exit()
      
# See lesson 001 for the rest of the code !

scene = soya3d.World()

material = model.Material()

cube = cube.Cube(scene, material)
cube.rotate_vertical(30.0)

light = soya3d.Light(scene)
light.set_xyz(1.5, 2.0, 0.2)

camera = soya3d.Camera(scene)
camera.z = 5.0

soya.set_root_widget(widget.Group())
soya.root_widget.add(camera)
soya.root_widget.add(widget.FPSLabel())


def advance_time(proportion):
  cube.rotate_lateral(proportion * 2.0)
  cube.rotate_incline(proportion * 1.0)
  
cube.advance_time = advance_time
cube.begin_round  = manage_event

idler.Idler(scene).idle()
