# Soya 3D tutorial
# Copyright (C) 2001-2002 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Lesson 102: Particle system : firework !

# This lesson shows how to use do a firework !

import sys
import soya, soya.soya3d as soya3d, soya.model as model, soya.particle as particle, soya.idler as idler, soya.widget as widget

soya.init()

scene = soya3d.World()

camera = soya3d.Camera(scene)
camera.z = 7.0

soya.set_root_widget(widget.Group())
soya.root_widget.add(camera)
soya.root_widget.add(widget.FPSLabel())

# Simply use the function of soya.particle to create an impressive firework.
# The default values are usually the one you want.

firework = particle.Firework(scene, nb_particles = 12)

# Moves it down

firework.y = -4.0

idler.Idler(scene).idle()
