# Soya 3D tutorial
# Copyright (C) 2001-2002 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Lesson 113: Setting up : use Soya along with PyGame !!!

# This lesson is similar to lesson 001, but it renders on a PyGame / SDL surface.
# You'll need to have PyGame installed to run this lesson.


# First, init PyGame.
# We need an OpenGL compatible surface, with flag OPENGLBLIT to use PyGame blit on it.

import pygame, pygame.display

pygame.display.init()
screen = pygame.display.set_mode((640, 480), pygame.HWSURFACE | pygame.DOUBLEBUF | pygame.OPENGL | pygame.OPENGLBLIT)


# Then, init Soya.
# We use the special "init_for_pygame" function, which takes the screen dimension
# as arguments.

import soya, soya.soya3d as soya3d, soya.model as model, soya.cube as cube, soya.idler as idler, soya.widget as widget

soya.init_for_pygame(640, 480)


# The following is lesson 001

scene = soya3d.World()

material = model.Material()

cube = cube.Cube(scene, material)
cube.rotate_vertical(30.0)

light = soya3d.Light(scene)
light.set_xyz(1.5, 2.0, 0.2)

camera = soya3d.Camera(scene)
camera.z = 2.0

soya.set_root_widget(widget.Group())
soya.root_widget.add(camera)
soya.root_widget.add(widget.FPSLabel())

def advance_time(proportion):
  cube.rotate_lateral(proportion * 2.0)
  cube.rotate_incline(proportion * 1.0)

cube.advance_time = advance_time


class Idler(idler.Idler):
  def render(self):
    
    # Render 3D with Soya, without flipping / swapping buffer.
    # You can also use the soya.render() function if you do not need performing
    # PyGame / SDL drawing after 3D rendering (in this case, use the normal Idler
    # without subclassing it).
    
    soya.render_no_flip()
    
    # You may perform PyGame / SDL calls here
    
    
    # Flips buffers with PyGame.
    
    pygame.display.flip()
    

# Creates a widget group, containing the camera and a label showing the FPS.
soya.set_root_widget(widget.Group())
soya.root_widget.add(camera)
soya.root_widget.add(widget.FPSLabel())

Idler(scene).idle()
