# Soya 3D tutorial
# Copyright (C) 2001-2002 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Lesson 115: Face cutter : a patchwork !

# The cute facecutter strikes again !
#
# In this lesson we use the facecutter to craete a patchwork.

import soya, soya.soya3d as soya3d, soya.model as model, soya.facecutter as facecutter

import random

soya.init()

scene = soya3d.World()

# We start with only 2 faces !

patchwork = soya3d.World()
f = model.Face(patchwork, [
  model.Vertex(patchwork, 0.3, 0.5, 0.0),
  model.Vertex(patchwork, 0.0, 0.0, 0.0),
  model.Vertex(patchwork, 0.5, 0.0, 0.2),
  ])
f = model.Face(patchwork, [
  model.Vertex(patchwork,  0.0, 0.0, 0.0),
  model.Vertex(patchwork,  0.3, 0.5, 0.0),
  model.Vertex(patchwork,  0.0, 0.5, 0.0),
  model.Vertex(patchwork, -0.2, 0.0, 0.0),
  ])


# Add about 100 faces; the exact number of faces added is returned.

nb_new_faces = facecutter.cut(patchwork, 70)

print nb_new_faces, "faces added !"


# Gives each face a random color

for face in patchwork:
  color = (random.random(), random.random(), random.random(), 1.0)
  for vertex in face: vertex.color = color


# Shapify the patchwork and put it in a volume (for faster rendering)

soya3d.Volume(scene, patchwork.shapify())

light = soya3d.Light(scene)
light.set_xyz(1.5, 2.0, 2.2)

camera = soya3d.Camera(scene)
camera.y = 0.3
camera.z = 1.0

soya.set_root_widget(camera)

import time

while 1:
  soya.render()
  
  time.sleep(0.1)
