# Soya 3D tutorial
# Copyright (C) 2003 Bertrand 'blam!' LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


# ----------------------------
# Lesson 121: Multiple cameras
# ----------------------------


import os, os.path, sys, time

import soya
import soya.widget
import soya.soya3d
import soya.cube


soya.init()
soya.model.Image.PATH = os.path.join(os.path.dirname(os.path.abspath(sys.argv[0])), "data", "images")


# Create world 1
world1 = soya.soya3d.World()

atm1 = soya.soya3d.Atmosphere()
atm1.ambient     = (0.8, 0.8, 0.8, 1.0)
atm1.bg_color    = (0.2, 0.1, 0.4, 1.0)
atm1.fog_color   = (0.0, 0.0, 1.0, 1.0)
atm1.fog_type    = 0
atm1.fog_start   = 0.0
atm1.fog_end     = 50.0
atm1.fog_density = 0.0
atm1.fog         = 1
atm1.skyplane    = 1
atm1.sky_color   = (1.0, 1.0, 0.5, 1.0)

world1.atmosphere = atm1

# Add a cube
material = soya.model.Material()
material.tex_filename = "block2.tga"
cube = soya.cube.Cube(world1, material)
world1.set_shape(cube.shapify())


# Create world 2
world2 = soya.soya3d.World()
atm2 = soya.soya3d.Atmosphere()
atm2.ambient = (1.0, 1.0, 1.0, 1.0)
atm2.bg_color  = (0.0, 0.0, 0.0, 1.0)
world2.atmosphere = atm2

# Add a cube
material = soya.model.Material()
cube = soya.cube.Cube(world2, None)
world2.set_shape(cube.shapify())


# create the cameras

camera1 = soya.soya3d.Camera(world1)

# When this attribute is true, the camera, before rendering, will
# clear only the part of the screen corresponding to its widget
# (ie the rectangle defined by (camera.left, camera.top, camera.width,
# camera.height) instead of clearing all the screen
camera1.partial = 1

# Change the resize_style of the Camera cause by default a Camera is
# maximized to the entire size of screen ie resize_style = (('maximize', ))
camera1.resize_style = (('percent left', 0.0), ('percent top', 0.0), ('percent width', 0.48), ('percent height', 0.48))

camera1.set_xyz(4.0, 1.0, 0.0)
camera1.look_at(soya.soya3d.Point(world1, 0.0, 0.0, 0.0))

# second camera
camera2 = soya.soya3d.Camera(world1)
camera2.partial = 1
camera2.resize_style = (('percent left', 0.5), ('percent top', 0.0), ('percent width', 0.52), ('percent height', 0.48))
camera2.set_xyz(-2.0, -1.0, -2.0)
camera2.look_at(soya.soya3d.Point(world1, 0.0, 0.0, 0.0))

# third camera
camera3 = soya.soya3d.Camera(world2)
camera3.partial = 1
camera3.resize_style = (('percent left', 0.0), ('percent top', 0.52), ('percent width', 1.0), ('percent height', 0.48))
camera3.set_xyz(6.0, 1.0, 0.0)
camera3.look_at(soya.soya3d.Point(world2, 0.0, 0.0, 0.0))


group = soya.widget.Group()
soya.widget.Clearer(group, (1.0, 0.5, 0.1, 1.0))
group.add(camera1)
group.add(camera2)
group.add(camera3)

label = soya.widget.Label(group, " - Multiple camera -")
label.resize_style = soya.widget.WIDGET_RESIZE_MAXIMIZE

soya.set_root_widget(group)


while(1):
  soya.render()
  time.sleep(0.1)

  for event in soya.process_event():
    if event[0] == soya.KEYDOWN:
      sys.exit()
