# Soya 3D tutorial
# Copyright (C) 2003 Bertrand 'blam!' LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


# -----------------------------
# Lesson 124: Shape FX Instance
# -----------------------------
#
# When you use vertex_fx on a Shape, all Volume or World that have this
# Shape will be changed. ShapeFXInstance 

import os, os.path, sys, time

import soya
import soya.model
import soya.widget
import soya.soya3d
import soya.sphere


# Use first argv as name of the shape to use, or default shape if nothing given
if len(sys.argv) > 1:
  shape = soya.model.Shape.get(sys.argv[1])
else:
  soya.soya3d.World.PATH    = os.path.join(os.path.dirname(os.path.abspath(sys.argv[0])), "data", "worlds")
  soya.model.Material.PATH = os.path.join(os.path.dirname(os.path.abspath(sys.argv[0])), "data", "materials")
  w = soya.soya3d.World.get('tux')
  shape = w.shapify()


soya.init()


# Create a world
scene = soya.soya3d.World()
atm1 = soya.soya3d.Atmosphere()
atm1.ambient     = (0.0, 0.0, 0.0, 1.0)
atm1.bg_color    = (0.2, 0.1, 0.4, 1.0)
atm1.fog         = 0
atm1.skyplane    = 1
atm1.sky_color   = (1.0, 1.0, 0.5, 1.0)
scene.atmosphere = atm1
scene.shape = shape


# ShapeFXInstance creation
# ------------------------
fx = soya.model.ShapeFXInstance(shape)
# We don't need to init_fx whatever, it's automatically done
# when creating a ShapeFXInstance (cause this object is designed
# only to do fx).
# However after creating the ShapeFXInstance, its vertex colors
# are left undefined, that's why we must apply some white everywhere:
fx.vertex_fx(None, (1.0, 1.0, 1.0, 1.0))


volume = soya.soya3d.Volume(scene)
volume.set_xyz(0.5, 0.0, 0.0)
volume.shape = fx


# Add a light
light = soya.soya3d.Light(scene)
light.set_xyz(-2.0, 2.0, -2.0)

# Add a camera and a loop to render
roow = soya.widget.Group()
camera = soya.soya3d.Camera(scene)
camera.set_xyz(0.25, 0.25, -1.0)
camera.rotate_lateral(180.0)
roow.add(camera)

label = soya.widget.Label(roow, " - Shape FX Instance demo -")
label.resize_style = soya.widget.WIDGET_RESIZE_MAXIMIZE

soya.set_root_widget(roow)

direction = 1
position  = 0.0

while(1):
  time.sleep(0.1)


# ShapeFXInstance stuff
# ---------------------
# Make the left Shape disappear as if it was in a teleporter!
  if direction == 1:
    fx.vertex_fx((-10.0, position), (1.0, 1.0, 0.0, 0.0), 10.0)
    position += 0.02
    if position > 0.7: direction = -1
# and then reappear
  elif direction == -1:
    fx.vertex_fx((position, 10.0), (1.0, 1.0, 1.0, 1.0), 10.0)
    position -= 0.02
    if position < -0.1: direction = 1


  for event in soya.process_event():

    if event[0] == soya.KEYDOWN:
      sys.exit()

  soya.advance_time(1.0)
  soya.render()
