#! /usr/bin/perl

# Usage:
#
#   wl, mew ǻȤäƤͤ
#     % cp -p ~/.spamfilter ~/.spamfilter.org
#     % perl convert_corpus_0.9_to_0.10.pl ~/.spamfilter > ~/.spamfilter.new
#     % mv ~/.spamfilter.new ~/.spamfilter
#
#   navi2ch ǻȤäƤͤ
#     % cp -p ~/.navi2ch/spamfilter ~/.navi2ch/spamfilter.org
#     % perl convert_corpus_0.9_to_0.10.pl -navi2ch ~/.navi2ch/spamfilter > ~/.navi2ch/spamfilter.new
#     % mv ~/.navi2ch/spamfilter.new ~/.navi2ch/spamfilter
#

$is_navi2ch = 0;

if ($ARGV[0] =~ /^-navi2ch$/o) {
    $is_navi2ch = 1;
    shift;
}

while (<>) {
    if (/^\(when \(zerop \(spamf-corpus-message-count (.+)\)\)/) {
	$corpus_name = $1;
	$new_corpus_name = to_new_corpus_name($corpus_name);
	print ("(when (zerop (spamf-corpus-message-count $new_corpus_name))\n");
    } elsif (/^  \(setq $corpus_name/) {
	# do nothing
    } elsif (/^        \(make-spamf-corpus :table \(make-hash-table :test #'eq\) :message-count (.+)\)\)/) {
	$message_count = $1;
	$new_corpus_name = to_new_corpus_name($corpus_name);
	print("  (clrhash (spamf-corpus-table $new_corpus_name))\n");
	print("  (setf (spamf-corpus-message-count $new_corpus_name) $message_count)\n");
    } elsif (/^   \(spamf-corpus-table $corpus_name\)\)\)/) {
	$new_corpus_name = to_new_corpus_name($corpus_name);
	print("   (spamf-corpus-table $new_corpus_name)))\n");
    } else {
	print;
    }
}

sub to_new_corpus_name {
    my ($name) = @_;
    if ($is_navi2ch) {
	$name =~ s/spamf/navi2ch-spamf/;
    }
    return $name;
}
