///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// $Id: Message.cc,v 1.9 2004/01/26 22:07:09 bburton Exp $
//
// Copyright (C) 2000 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//

#include "MimeMessageReader.h"
#include "Message.h"

typedef vector<string>::size_type vsindex_t;
typedef map<string,Token *>::const_iterator tokiter_t;

Message::Message()
  : m_reader(0)
{
}

Message::~Message()
{
  clear();
}

void Message::clear()
{
  for (tokiter_t i = m_tokens.begin(); i != m_tokens.end(); ++i) {
    delete i->second;
  }
  m_id.erase();
  m_words.clear();
  m_tokens.clear();
}

int Message::getAllTokensCount() const
{
  int total = 0;
  for (tokiter_t i = m_tokens.begin(); i != m_tokens.end(); ++i) {
    total += i->second->getCount();
  }
  return total;
}

Token *Message::getToken(int index) const
{
  assert(index >= 0);
  assert((vsindex_t)index < m_words.size());

  return getToken(m_words[index]);
}

Token *Message::getToken(const string &word) const
{
  assert(m_tokens.size() == m_words.size());

  tokiter_t i = m_tokens.find(word);
  return (i != m_tokens.end()) ? i->second : 0;
}

void Message::addToken(const string &word,
                       const string &prefix)
{
  assert(word.length() > 0);

  if (prefix.length() > 0) {
    addToken(prefix + word);
  } else {
    addToken(word);
  }
}

void Message::addToken(const string &word)
{
  assert(word.length() > 0);

  Token *tok = getToken(word);
  if (tok) {
    tok->incrementCount();
  } else {
    tok = new Token(word);
    m_words.push_back(word);
    m_tokens.insert(make_pair(word, tok));
  }
  if (is_debug) {
    cerr << "ADD TOKEN " << word << endl;
  }
}

Token *Message::getTopToken(int i)
{
  assert(i >= 0);
  assert(i < (int)m_topTokens.size());
  return m_topTokens[i];
}

bool Message::getField(const string &name,
                       string &value)
{
  if (m_reader) {
    return m_reader->getField(name, value);
  } else {
    return false;
  }
}
