#ifndef _CleanupManager_h
#define _CleanupManager_h

#include <vector>
#include "WordData.h"

class CleanupManager
{
public:
  CleanupManager();
  CleanupManager(int junk_count,
                 int max_age);
  ~CleanupManager();

  void addLimit(int junk_count,
                int max_age);

  bool shouldDelete(const WordData &word_data) const;

private:
  /// Not implemented.
  CleanupManager(const CleanupManager &);

  /// Not implemented.
  CleanupManager& operator=(const CleanupManager &);

private:
  struct CleanupNode {
    CleanupNode(int _junk_count, int _max_age) : junk_count(_junk_count), max_age(_max_age) {}
    int junk_count;
    int max_age;
  };
  typedef vector<CleanupNode>::const_iterator NodeIter_t;
  vector<CleanupNode> m_nodes;
};

#endif // _CleanupManager_h
