///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// http://www.cooldevtools.com
// $Id: AutoPurger.h 241 2006-01-04 14:31:37Z brian $
//
// Copyright (C) 2005 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//    http://www.cooldevtools.com/qpl.html
//

#ifndef _AutoPurger_h
#define _AutoPurger_h

#include "util.h"

class ConfigManager;
class CleanupManager;
class FrequencyDB;
class SpamFilter;

class AutoPurger
{
public:
  AutoPurger(const ConfigManager &config,
             SpamFilter &filter,
             int junk_count = 2);
  ~AutoPurger();

  void disable();
  void processedMessage();
  void finish();

private:
  /// Not implemented.
  AutoPurger(const AutoPurger &);

  /// Not implemented.
  AutoPurger& operator=(const AutoPurger &);

private:
  Ptr<CleanupManager> m_cleaner;
  FrequencyDB *m_db;
  int m_messageCount;
  int m_messagesPerPurge;
};

#endif // _AutoPurger_h
