/*
 * SpanDSP - a series of DSP components for telephony
 *
 * v17rx_fixed_rrc.h - ITU V.17 modem receive part.
 *                     Fixed point RRC filter coeffs.
 *
 * Written by Steve Underwood <steveu@coppice.org>
 *
 * Copyright (C) 2007 Steve Underwood
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: v17rx_fixed_rrc.h,v 1.2 2007/08/13 11:35:32 steveu Exp $
 */

/* Raised root cosine pulse shaping; Beta = 0.5; 4 symbols either
   side of the centre. We cannot simplify this by using only half
   the filter, as each variant are each skewed by n/PULSESHAPER_COEFF_SETS
   of a sample. Only one is symmetric. */
#define PULSESHAPER_GAIN        32768.0f
#define PULSESHAPER_COEFF_SETS  192
static const complexi16_t pulseshaper[PULSESHAPER_COEFF_SETS][V17_RX_FILTER_STEPS] =
{
    {
        {    -1,    -25},   /* Filter 0 */
        {    12,     -3},
        {   -19,    -31},
        {    28,    -28},
        {   -22,    -14},
        {    16,    -52},
        {   -47,     -3},
        {   -21,   -133},
        {   -44,     18},
        {  -252,   -347},
        {   280,   -328},
        {  -453,   -231},
        {   509,  -2121},
        {  3527,      0},
        {   823,   3430},
        { -1944,    990},
        {  -330,   -387},
        {  -254,    349},
        {  -397,   -164},
        {     7,    -47},
        {  -134,     10},
        {   -14,    -45},
        {   -46,     28},
        {   -19,    -19},
        {   -21,     34},
        {   -34,    -11},
        {     0,     12},
    },
    {
        {    -1,    -22},   /* Filter 1 */
        {    11,     -3},
        {   -19,    -31},
        {    28,    -28},
        {   -23,    -14},
        {    16,    -51},
        {   -48,     -3},
        {   -21,   -133},
        {   -46,     19},
        {  -253,   -349},
        {   279,   -327},
        {  -460,   -234},
        {   511,  -2130},
        {  3531,      0},
        {   822,   3426},
        { -1936,    986},
        {  -325,   -381},
        {  -255,    351},
        {  -395,   -163},
        {     7,    -46},
        {  -135,     10},
        {   -14,    -44},
        {   -46,     28},
        {   -18,    -18},
        {   -21,     35},
        {   -34,    -11},
        {    -1,     12},
    },
    {
        {    -1,    -19},   /* Filter 2 */
        {    11,     -3},
        {   -19,    -31},
        {    28,    -28},
        {   -23,    -14},
        {    16,    -51},
        {   -49,     -3},
        {   -21,   -133},
        {   -48,     19},
        {  -254,   -350},
        {   277,   -325},
        {  -466,   -237},
        {   513,  -2139},
        {  3535,      0},
        {   821,   3422},
        { -1928,    982},
        {  -320,   -375},
        {  -256,    353},
        {  -394,   -163},
        {     7,    -44},
        {  -135,     10},
        {   -14,    -44},
        {   -46,     28},
        {   -18,    -18},
        {   -21,     35},
        {   -34,    -11},
        {    -1,     13},
    },
    {
        {    -1,    -16},   /* Filter 3 */
        {    11,     -3},
        {   -19,    -31},
        {    28,    -28},
        {   -23,    -14},
        {    16,    -51},
        {   -49,     -3},
        {   -21,   -133},
        {   -49,     20},
        {  -255,   -351},
        {   276,   -323},
        {  -473,   -241},
        {   515,  -2147},
        {  3539,      0},
        {   820,   3418},
        { -1920,    978},
        {  -316,   -370},
        {  -257,    354},
        {  -392,   -162},
        {     6,    -42},
        {  -135,     10},
        {   -14,    -43},
        {   -47,     28},
        {   -18,    -18},
        {   -21,     35},
        {   -34,    -11},
        {    -1,     13},
    },
    {
        {    -1,    -13},   /* Filter 4 */
        {    11,     -3},
        {   -19,    -32},
        {    28,    -28},
        {   -24,    -14},
        {    16,    -51},
        {   -50,     -3},
        {   -21,   -133},
        {   -51,     21},
        {  -256,   -353},
        {   274,   -321},
        {  -480,   -244},
        {   517,  -2156},
        {  3543,      0},
        {   819,   3414},
        { -1912,    974},
        {  -311,   -364},
        {  -259,    356},
        {  -391,   -162},
        {     6,    -40},
        {  -135,     10},
        {   -13,    -42},
        {   -47,     28},
        {   -17,    -17},
        {   -21,     35},
        {   -34,    -11},
        {    -1,     13},
    },
    {
        {    -1,    -13},   /* Filter 5 */
        {    11,     -3},
        {   -19,    -32},
        {    28,    -28},
        {   -24,    -15},
        {    16,    -51},
        {   -51,     -4},
        {   -21,   -133},
        {   -53,     21},
        {  -257,   -354},
        {   273,   -320},
        {  -486,   -248},
        {   519,  -2165},
        {  3547,      0},
        {   818,   3409},
        { -1904,    970},
        {  -306,   -359},
        {  -260,    358},
        {  -389,   -161},
        {     6,    -39},
        {  -135,     10},
        {   -13,    -42},
        {   -47,     29},
        {   -17,    -17},
        {   -21,     35},
        {   -33,    -11},
        {    -1,     13},
    },
    {
        {    -1,    -13},   /* Filter 6 */
        {    10,     -3},
        {   -19,    -32},
        {    27,    -27},
        {   -24,    -15},
        {    16,    -50},
        {   -52,     -4},
        {   -21,   -133},
        {   -54,     22},
        {  -258,   -355},
        {   271,   -318},
        {  -493,   -251},
        {   521,  -2173},
        {  3551,      0},
        {   817,   3405},
        { -1896,    966},
        {  -301,   -353},
        {  -261,    359},
        {  -388,   -160},
        {     5,    -37},
        {  -135,     10},
        {   -13,    -41},
        {   -47,     29},
        {   -17,    -17},
        {   -21,     35},
        {   -33,    -10},
        {    -1,     13},
    },
    {
        {    -1,    -14},   /* Filter 7 */
        {    10,     -3},
        {   -19,    -32},
        {    27,    -27},
        {   -25,    -15},
        {    16,    -50},
        {   -52,     -4},
        {   -21,   -132},
        {   -56,     23},
        {  -259,   -356},
        {   270,   -316},
        {  -500,   -255},
        {   524,  -2182},
        {  3555,      0},
        {   816,   3401},
        { -1888,    962},
        {  -297,   -347},
        {  -262,    361},
        {  -386,   -160},
        {     5,    -35},
        {  -135,     10},
        {   -13,    -40},
        {   -47,     29},
        {   -17,    -17},
        {   -22,     36},
        {   -33,    -10},
        {    -1,     14},
    },
    {
        {    -1,    -14},   /* Filter 8 */
        {    10,     -3},
        {   -20,    -32},
        {    27,    -27},
        {   -25,    -15},
        {    16,    -50},
        {   -53,     -4},
        {   -21,   -132},
        {   -58,     24},
        {  -260,   -358},
        {   268,   -314},
        {  -507,   -258},
        {   526,  -2191},
        {  3558,      0},
        {   815,   3397},
        { -1880,    957},
        {  -292,   -342},
        {  -263,    363},
        {  -384,   -159},
        {     5,    -33},
        {  -135,     10},
        {   -12,    -39},
        {   -47,     29},
        {   -16,    -16},
        {   -22,     36},
        {   -33,    -10},
        {    -1,     14},
    },
    {
        {    -1,    -14},   /* Filter 9 */
        {    10,     -3},
        {   -20,    -32},
        {    27,    -27},
        {   -25,    -15},
        {    16,    -50},
        {   -54,     -4},
        {   -20,   -132},
        {   -59,     24},
        {  -261,   -359},
        {   267,   -312},
        {  -514,   -261},
        {   528,  -2199},
        {  3562,      0},
        {   814,   3393},
        { -1871,    953},
        {  -287,   -336},
        {  -264,    364},
        {  -383,   -158},
        {     5,    -32},
        {  -135,     10},
        {   -12,    -39},
        {   -48,     29},
        {   -16,    -16},
        {   -22,     36},
        {   -33,    -10},
        {    -1,     14},
    },
    {
        {    -1,    -14},   /* Filter 10 */
        {     9,     -3},
        {   -20,    -33},
        {    27,    -27},
        {   -26,    -16},
        {    16,    -49},
        {   -54,     -4},
        {   -20,   -132},
        {   -61,     25},
        {  -262,   -360},
        {   265,   -310},
        {  -520,   -265},
        {   530,  -2208},
        {  3566,      0},
        {   813,   3388},
        { -1863,    949},
        {  -282,   -331},
        {  -266,    366},
        {  -381,   -158},
        {     4,    -30},
        {  -135,     10},
        {   -12,    -38},
        {   -48,     29},
        {   -16,    -16},
        {   -22,     36},
        {   -32,    -10},
        {    -1,     14},
    },
    {
        {    -1,    -14},   /* Filter 11 */
        {     9,     -3},
        {   -20,    -33},
        {    27,    -27},
        {   -26,    -16},
        {    16,    -49},
        {   -55,     -4},
        {   -20,   -132},
        {   -63,     26},
        {  -263,   -361},
        {   263,   -309},
        {  -527,   -268},
        {   532,  -2217},
        {  3569,      0},
        {   812,   3384},
        { -1855,    945},
        {  -278,   -325},
        {  -267,    367},
        {  -380,   -157},
        {     4,    -28},
        {  -135,     10},
        {   -12,    -37},
        {   -48,     29},
        {   -16,    -16},
        {   -22,     36},
        {   -32,    -10},
        {    -1,     14},
    },
    {
        {    -1,    -15},   /* Filter 12 */
        {     9,     -3},
        {   -20,    -33},
        {    27,    -27},
        {   -26,    -16},
        {    16,    -49},
        {   -56,     -4},
        {   -20,   -132},
        {   -64,     26},
        {  -263,   -363},
        {   262,   -307},
        {  -534,   -272},
        {   534,  -2225},
        {  3573,      0},
        {   811,   3380},
        { -1847,    941},
        {  -273,   -320},
        {  -268,    369},
        {  -378,   -156},
        {     4,    -27},
        {  -135,     10},
        {   -12,    -37},
        {   -48,     29},
        {   -15,    -15},
        {   -22,     36},
        {   -32,    -10},
        {    -1,     15},
    },
    {
        {    -1,    -15},   /* Filter 13 */
        {     9,     -3},
        {   -20,    -33},
        {    26,    -26},
        {   -27,    -16},
        {    15,    -49},
        {   -57,     -4},
        {   -20,   -131},
        {   -66,     27},
        {  -264,   -364},
        {   260,   -305},
        {  -541,   -275},
        {   536,  -2234},
        {  3577,      0},
        {   810,   3375},
        { -1839,    937},
        {  -268,   -314},
        {  -269,    370},
        {  -376,   -156},
        {     4,    -25},
        {  -135,     10},
        {   -11,    -36},
        {   -48,     29},
        {   -15,    -15},
        {   -22,     36},
        {   -32,    -10},
        {    -1,     15},
    },
    {
        {    -1,    -15},   /* Filter 14 */
        {     9,     -2},
        {   -20,    -33},
        {    26,    -26},
        {   -27,    -16},
        {    15,    -48},
        {   -57,     -4},
        {   -20,   -131},
        {   -68,     28},
        {  -265,   -365},
        {   259,   -303},
        {  -548,   -279},
        {   538,  -2242},
        {  3580,      0},
        {   809,   3371},
        { -1831,    933},
        {  -264,   -309},
        {  -270,    372},
        {  -375,   -155},
        {     3,    -23},
        {  -135,     10},
        {   -11,    -35},
        {   -48,     29},
        {   -15,    -15},
        {   -22,     37},
        {   -31,    -10},
        {    -1,     15},
    },
    {
        {    -1,    -15},   /* Filter 15 */
        {     8,     -2},
        {   -20,    -33},
        {    26,    -26},
        {   -27,    -17},
        {    15,    -48},
        {   -58,     -4},
        {   -20,   -131},
        {   -70,     29},
        {  -266,   -366},
        {   257,   -301},
        {  -555,   -282},
        {   540,  -2251},
        {  3584,      0},
        {   808,   3366},
        { -1823,    929},
        {  -259,   -304},
        {  -271,    373},
        {  -373,   -154},
        {     3,    -22},
        {  -135,     10},
        {   -11,    -35},
        {   -48,     29},
        {   -14,    -14},
        {   -22,     37},
        {   -31,    -10},
        {    -1,     15},
    },
    {
        {    -1,    -15},   /* Filter 16 */
        {     8,     -2},
        {   -20,    -34},
        {    26,    -26},
        {   -28,    -17},
        {    15,    -48},
        {   -59,     -4},
        {   -20,   -131},
        {   -71,     29},
        {  -267,   -368},
        {   255,   -299},
        {  -562,   -286},
        {   542,  -2260},
        {  3587,      0},
        {   807,   3362},
        { -1815,    925},
        {  -255,   -298},
        {  -272,    375},
        {  -371,   -154},
        {     3,    -20},
        {  -135,     10},
        {   -11,    -34},
        {   -48,     29},
        {   -14,    -14},
        {   -22,     37},
        {   -31,    -10},
        {    -1,     15},
    },
    {
        {    -1,    -16},   /* Filter 17 */
        {     8,     -2},
        {   -20,    -34},
        {    26,    -26},
        {   -28,    -17},
        {    15,    -48},
        {   -60,     -4},
        {   -20,   -130},
        {   -73,     30},
        {  -268,   -369},
        {   253,   -297},
        {  -569,   -289},
        {   544,  -2268},
        {  3590,      0},
        {   806,   3357},
        { -1807,    920},
        {  -250,   -293},
        {  -273,    376},
        {  -370,   -153},
        {     2,    -18},
        {  -135,     10},
        {   -10,    -33},
        {   -49,     30},
        {   -14,    -14},
        {   -23,     37},
        {   -31,    -10},
        {    -1,     16},
    },
    {
        {    -1,    -16},   /* Filter 18 */
        {     8,     -2},
        {   -21,    -34},
        {    25,    -25},
        {   -28,    -17},
        {    15,    -47},
        {   -60,     -4},
        {   -20,   -130},
        {   -75,     31},
        {  -269,   -370},
        {   252,   -295},
        {  -576,   -293},
        {   546,  -2277},
        {  3594,      0},
        {   804,   3353},
        { -1799,    916},
        {  -245,   -288},
        {  -274,    377},
        {  -368,   -152},
        {     2,    -17},
        {  -135,     10},
        {   -10,    -33},
        {   -49,     30},
        {   -14,    -14},
        {   -23,     37},
        {   -30,    -10},
        {    -1,     16},
    },
    {
        {    -1,    -16},   /* Filter 19 */
        {     8,     -2},
        {   -21,    -34},
        {    25,    -25},
        {   -29,    -17},
        {    15,    -47},
        {   -61,     -4},
        {   -20,   -130},
        {   -77,     31},
        {  -269,   -371},
        {   250,   -293},
        {  -583,   -297},
        {   548,  -2285},
        {  3597,      0},
        {   803,   3348},
        { -1791,    912},
        {  -241,   -282},
        {  -275,    379},
        {  -366,   -151},
        {     2,    -15},
        {  -135,     10},
        {   -10,    -32},
        {   -49,     30},
        {   -13,    -13},
        {   -23,     37},
        {   -30,     -9},
        {    -1,     16},
    },
    {
        {    -1,    -16},   /* Filter 20 */
        {     7,     -2},
        {   -21,    -34},
        {    25,    -25},
        {   -29,    -17},
        {    15,    -47},
        {   -62,     -4},
        {   -20,   -130},
        {   -78,     32},
        {  -270,   -372},
        {   248,   -291},
        {  -590,   -300},
        {   550,  -2294},
        {  3600,      0},
        {   802,   3343},
        { -1782,    908},
        {  -236,   -277},
        {  -276,    380},
        {  -365,   -151},
        {     2,    -14},
        {  -135,     10},
        {   -10,    -31},
        {   -49,     30},
        {   -13,    -13},
        {   -23,     37},
        {   -30,     -9},
        {    -1,     16},
    },
    {
        {    -1,    -16},   /* Filter 21 */
        {     7,     -2},
        {   -21,    -34},
        {    25,    -25},
        {   -29,    -18},
        {    15,    -47},
        {   -62,     -4},
        {   -20,   -129},
        {   -80,     33},
        {  -271,   -373},
        {   246,   -289},
        {  -597,   -304},
        {   552,  -2302},
        {  3604,      0},
        {   801,   3339},
        { -1774,    904},
        {  -232,   -272},
        {  -277,    382},
        {  -363,   -150},
        {     1,    -12},
        {  -135,     10},
        {   -10,    -30},
        {   -49,     30},
        {   -13,    -13},
        {   -23,     38},
        {   -30,     -9},
        {    -1,     16},
    },
    {
        {    -1,    -16},   /* Filter 22 */
        {     7,     -2},
        {   -21,    -35},
        {    25,    -25},
        {   -29,    -18},
        {    15,    -46},
        {   -63,     -5},
        {   -20,   -129},
        {   -82,     34},
        {  -272,   -374},
        {   245,   -286},
        {  -604,   -307},
        {   554,  -2311},
        {  3607,      0},
        {   800,   3334},
        { -1766,    900},
        {  -227,   -266},
        {  -278,    383},
        {  -361,   -149},
        {     1,    -10},
        {  -135,     10},
        {    -9,    -30},
        {   -49,     30},
        {   -12,    -12},
        {   -23,     38},
        {   -30,     -9},
        {    -1,     16},
    },
    {
        {    -1,    -17},   /* Filter 23 */
        {     7,     -2},
        {   -21,    -35},
        {    25,    -25},
        {   -30,    -18},
        {    15,    -46},
        {   -64,     -5},
        {   -20,   -129},
        {   -84,     34},
        {  -273,   -376},
        {   243,   -284},
        {  -611,   -311},
        {   556,  -2319},
        {  3610,      0},
        {   799,   3329},
        { -1758,    896},
        {  -223,   -261},
        {  -279,    384},
        {  -360,   -149},
        {     1,     -9},
        {  -134,     10},
        {    -9,    -29},
        {   -49,     30},
        {   -12,    -12},
        {   -23,     38},
        {   -29,     -9},
        {    -1,     17},
    },
    {
        {    -1,    -17},   /* Filter 24 */
        {     6,     -2},
        {   -21,    -35},
        {    24,    -24},
        {   -30,    -18},
        {    15,    -46},
        {   -65,     -5},
        {   -20,   -129},
        {   -85,     35},
        {  -274,   -377},
        {   241,   -282},
        {  -618,   -314},
        {   558,  -2328},
        {  3613,      0},
        {   798,   3324},
        { -1750,    891},
        {  -218,   -256},
        {  -280,    385},
        {  -358,   -148},
        {     1,     -7},
        {  -134,     10},
        {    -9,    -28},
        {   -49,     30},
        {   -12,    -12},
        {   -23,     38},
        {   -29,     -9},
        {    -1,     17},
    },
    {
        {    -1,    -17},   /* Filter 25 */
        {     6,     -2},
        {   -21,    -35},
        {    24,    -24},
        {   -30,    -18},
        {    14,    -46},
        {   -65,     -5},
        {   -20,   -128},
        {   -87,     36},
        {  -274,   -378},
        {   239,   -280},
        {  -625,   -318},
        {   560,  -2336},
        {  3616,      0},
        {   797,   3319},
        { -1742,    887},
        {  -214,   -251},
        {  -281,    387},
        {  -356,   -147},
        {     0,     -6},
        {  -134,     10},
        {    -9,    -28},
        {   -49,     30},
        {   -12,    -12},
        {   -23,     38},
        {   -29,     -9},
        {    -1,     17},
    },
    {
        {    -1,    -17},   /* Filter 26 */
        {     6,     -2},
        {   -21,    -35},
        {    24,    -24},
        {   -31,    -19},
        {    14,    -45},
        {   -66,     -5},
        {   -20,   -128},
        {   -89,     37},
        {  -275,   -379},
        {   237,   -278},
        {  -632,   -322},
        {   563,  -2345},
        {  3619,      0},
        {   795,   3314},
        { -1734,    883},
        {  -209,   -245},
        {  -282,    388},
        {  -355,   -147},
        {     0,     -4},
        {  -134,     10},
        {    -8,    -27},
        {   -49,     30},
        {   -11,    -11},
        {   -23,     38},
        {   -29,     -9},
        {    -1,     17},
    },
    {
        {    -1,    -17},   /* Filter 27 */
        {     6,     -2},
        {   -21,    -35},
        {    24,    -24},
        {   -31,    -19},
        {    14,    -45},
        {   -67,     -5},
        {   -20,   -128},
        {   -91,     37},
        {  -276,   -380},
        {   235,   -276},
        {  -639,   -325},
        {   565,  -2353},
        {  3622,      0},
        {   794,   3310},
        { -1726,    879},
        {  -205,   -240},
        {  -282,    389},
        {  -353,   -146},
        {     0,     -2},
        {  -134,     10},
        {    -8,    -26},
        {   -49,     30},
        {   -11,    -11},
        {   -23,     38},
        {   -28,     -9},
        {    -1,     17},
    },
    {
        {    -1,    -18},   /* Filter 28 */
        {     5,     -1},
        {   -22,    -35},
        {    24,    -24},
        {   -31,    -19},
        {    14,    -45},
        {   -67,     -5},
        {   -20,   -127},
        {   -93,     38},
        {  -277,   -381},
        {   233,   -273},
        {  -646,   -329},
        {   567,  -2362},
        {  3625,      0},
        {   793,   3305},
        { -1717,    875},
        {  -201,   -235},
        {  -283,    390},
        {  -351,   -145},
        {     0,     -1},
        {  -134,     10},
        {    -8,    -26},
        {   -50,     30},
        {   -11,    -11},
        {   -23,     39},
        {   -28,     -9},
        {    -1,     18},
    },
    {
        {    -1,    -18},   /* Filter 29 */
        {     5,     -1},
        {   -22,    -36},
        {    23,    -23},
        {   -32,    -19},
        {    14,    -44},
        {   -68,     -5},
        {   -20,   -127},
        {   -94,     39},
        {  -277,   -382},
        {   231,   -271},
        {  -653,   -333},
        {   569,  -2370},
        {  3628,      0},
        {   792,   3300},
        { -1709,    871},
        {  -196,   -230},
        {  -284,    391},
        {  -349,   -144},
        {     0,      0},
        {  -134,     10},
        {    -8,    -25},
        {   -50,     30},
        {   -10,    -10},
        {   -23,     39},
        {   -28,     -9},
        {    -1,     18},
    },
    {
        {    -1,    -18},   /* Filter 30 */
        {     5,     -1},
        {   -22,    -36},
        {    23,    -23},
        {   -32,    -19},
        {    14,    -44},
        {   -69,     -5},
        {   -20,   -127},
        {   -96,     40},
        {  -278,   -383},
        {   229,   -269},
        {  -660,   -336},
        {   571,  -2378},
        {  3631,      0},
        {   791,   3295},
        { -1701,    866},
        {  -192,   -225},
        {  -285,    392},
        {  -348,   -144},
        {     0,      1},
        {  -134,     10},
        {    -8,    -24},
        {   -50,     30},
        {   -10,    -10},
        {   -24,     39},
        {   -28,     -9},
        {    -1,     18},
    },
    {
        {    -1,    -18},   /* Filter 31 */
        {     5,     -1},
        {   -22,    -36},
        {    23,    -23},
        {   -32,    -19},
        {    14,    -44},
        {   -70,     -5},
        {   -20,   -126},
        {   -98,     40},
        {  -279,   -384},
        {   227,   -266},
        {  -668,   -340},
        {   573,  -2387},
        {  3634,      0},
        {   789,   3290},
        { -1693,    862},
        {  -187,   -220},
        {  -286,    394},
        {  -346,   -143},
        {     0,      3},
        {  -133,     10},
        {    -7,    -24},
        {   -50,     30},
        {   -10,    -10},
        {   -24,     39},
        {   -27,     -9},
        {    -1,     18},
    },
    {
        {    -1,    -18},   /* Filter 32 */
        {     5,     -1},
        {   -22,    -36},
        {    23,    -23},
        {   -32,    -20},
        {    14,    -43},
        {   -70,     -5},
        {   -20,   -126},
        {  -100,     41},
        {  -280,   -385},
        {   225,   -264},
        {  -675,   -344},
        {   575,  -2395},
        {  3637,      0},
        {   788,   3284},
        { -1685,    858},
        {  -183,   -214},
        {  -287,    395},
        {  -344,   -142},
        {     0,      4},
        {  -133,     10},
        {    -7,    -23},
        {   -50,     30},
        {   -10,    -10},
        {   -24,     39},
        {   -27,     -9},
        {    -1,     18},
    },
    {
        {    -1,    -18},   /* Filter 33 */
        {     4,     -1},
        {   -22,    -36},
        {    23,    -23},
        {   -33,    -20},
        {    14,    -43},
        {   -71,     -5},
        {   -19,   -126},
        {  -102,     42},
        {  -280,   -386},
        {   223,   -262},
        {  -682,   -347},
        {   577,  -2403},
        {  3639,      0},
        {   787,   3279},
        { -1677,    854},
        {  -179,   -209},
        {  -287,    396},
        {  -342,   -141},
        {    -1,      6},
        {  -133,     10},
        {    -7,    -22},
        {   -50,     30},
        {    -9,     -9},
        {   -24,     39},
        {   -27,     -8},
        {    -1,     18},
    },
    {
        {    -1,    -19},   /* Filter 34 */
        {     4,     -1},
        {   -22,    -36},
        {    22,    -22},
        {   -33,    -20},
        {    14,    -43},
        {   -72,     -5},
        {   -19,   -125},
        {  -104,     43},
        {  -281,   -387},
        {   221,   -259},
        {  -689,   -351},
        {   579,  -2412},
        {  3642,      0},
        {   786,   3274},
        { -1668,    850},
        {  -174,   -204},
        {  -288,    397},
        {  -340,   -141},
        {    -1,      7},
        {  -133,     10},
        {    -7,    -22},
        {   -50,     30},
        {    -9,     -9},
        {   -24,     39},
        {   -27,     -8},
        {    -1,     19},
    },
    {
        {    -1,    -19},   /* Filter 35 */
        {     4,     -1},
        {   -22,    -36},
        {    22,    -22},
        {   -33,    -20},
        {    13,    -42},
        {   -72,     -5},
        {   -19,   -125},
        {  -105,     43},
        {  -282,   -388},
        {   219,   -257},
        {  -697,   -355},
        {   581,  -2420},
        {  3645,      0},
        {   784,   3269},
        { -1660,    846},
        {  -170,   -199},
        {  -289,    398},
        {  -339,   -140},
        {    -1,      9},
        {  -133,     10},
        {    -6,    -21},
        {   -50,     30},
        {    -9,     -9},
        {   -24,     39},
        {   -26,     -8},
        {    -1,     19},
    },
    {
        {    -1,    -19},   /* Filter 36 */
        {     4,     -1},
        {   -22,    -37},
        {    22,    -22},
        {   -34,    -20},
        {    13,    -42},
        {   -73,     -5},
        {   -19,   -125},
        {  -107,     44},
        {  -283,   -389},
        {   217,   -254},
        {  -704,   -358},
        {   583,  -2428},
        {  3647,      0},
        {   783,   3264},
        { -1652,    842},
        {  -166,   -194},
        {  -290,    399},
        {  -337,   -139},
        {    -1,     10},
        {  -133,     10},
        {    -6,    -20},
        {   -50,     30},
        {    -8,     -8},
        {   -24,     39},
        {   -26,     -8},
        {    -1,     19},
    },
    {
        {    -1,    -19},   /* Filter 37 */
        {     3,     -1},
        {   -22,    -37},
        {    22,    -22},
        {   -34,    -21},
        {    13,    -42},
        {   -74,     -5},
        {   -19,   -124},
        {  -109,     45},
        {  -283,   -390},
        {   215,   -252},
        {  -711,   -362},
        {   585,  -2437},
        {  3650,      0},
        {   782,   3258},
        { -1644,    837},
        {  -162,   -189},
        {  -290,    400},
        {  -335,   -139},
        {    -1,     12},
        {  -132,     10},
        {    -6,    -20},
        {   -50,     30},
        {    -8,     -8},
        {   -24,     39},
        {   -26,     -8},
        {    -1,     19},
    },
    {
        {    -1,    -19},   /* Filter 38 */
        {     3,     -1},
        {   -22,    -37},
        {    22,    -22},
        {   -34,    -21},
        {    13,    -41},
        {   -75,     -5},
        {   -19,   -124},
        {  -111,     46},
        {  -284,   -391},
        {   213,   -250},
        {  -718,   -366},
        {   587,  -2445},
        {  3652,      0},
        {   781,   3253},
        { -1636,    833},
        {  -157,   -184},
        {  -291,    401},
        {  -333,   -138},
        {    -2,     13},
        {  -132,     10},
        {    -6,    -19},
        {   -50,     30},
        {    -8,     -8},
        {   -24,     40},
        {   -26,     -8},
        {    -1,     19},
    },
    {
        {    -1,    -19},   /* Filter 39 */
        {     3,     -1},
        {   -22,    -37},
        {    21,    -21},
        {   -34,    -21},
        {    13,    -41},
        {   -75,     -5},
        {   -19,   -123},
        {  -113,     46},
        {  -285,   -392},
        {   211,   -247},
        {  -726,   -370},
        {   589,  -2453},
        {  3655,      0},
        {   779,   3248},
        { -1628,    829},
        {  -153,   -179},
        {  -292,    402},
        {  -332,   -137},
        {    -2,     15},
        {  -132,     10},
        {    -6,    -18},
        {   -50,     30},
        {    -8,     -8},
        {   -24,     40},
        {   -26,     -8},
        {    -1,     19},
    },
    {
        {    -1,    -19},   /* Filter 40 */
        {     3,     -1},
        {   -23,    -37},
        {    21,    -21},
        {   -35,    -21},
        {    13,    -41},
        {   -76,     -6},
        {   -19,   -123},
        {  -115,     47},
        {  -285,   -393},
        {   209,   -245},
        {  -733,   -373},
        {   591,  -2461},
        {  3657,      0},
        {   778,   3242},
        { -1619,    825},
        {  -149,   -174},
        {  -292,    403},
        {  -330,   -136},
        {    -2,     16},
        {  -132,     10},
        {    -5,    -18},
        {   -50,     31},
        {    -7,     -7},
        {   -24,     40},
        {   -25,     -8},
        {    -1,     19},
    },
    {
        {    -1,    -20},   /* Filter 41 */
        {     2,      0},
        {   -23,    -37},
        {    21,    -21},
        {   -35,    -21},
        {    13,    -40},
        {   -77,     -6},
        {   -19,   -122},
        {  -116,     48},
        {  -286,   -394},
        {   207,   -242},
        {  -740,   -377},
        {   593,  -2470},
        {  3660,      0},
        {   777,   3237},
        { -1611,    821},
        {  -145,   -170},
        {  -293,    403},
        {  -328,   -136},
        {    -2,     18},
        {  -132,     10},
        {    -5,    -17},
        {   -50,     31},
        {    -7,     -7},
        {   -24,     40},
        {   -25,     -8},
        {    -1,     20},
    },
    {
        {    -1,    -20},   /* Filter 42 */
        {     2,      0},
        {   -23,    -37},
        {    21,    -21},
        {   -35,    -21},
        {    13,    -40},
        {   -77,     -6},
        {   -19,   -122},
        {  -118,     49},
        {  -287,   -395},
        {   204,   -239},
        {  -748,   -381},
        {   594,  -2478},
        {  3662,      0},
        {   775,   3232},
        { -1603,    817},
        {  -141,   -165},
        {  -294,    404},
        {  -326,   -135},
        {    -3,     19},
        {  -131,     10},
        {    -5,    -16},
        {   -50,     31},
        {    -7,     -7},
        {   -24,     40},
        {   -25,     -8},
        {    -1,     20},
    },
    {
        {    -1,    -20},   /* Filter 43 */
        {     2,      0},
        {   -23,    -38},
        {    21,    -21},
        {   -35,    -22},
        {    13,    -40},
        {   -78,     -6},
        {   -19,   -122},
        {  -120,     49},
        {  -287,   -396},
        {   202,   -237},
        {  -755,   -385},
        {   596,  -2486},
        {  3664,      0},
        {   774,   3226},
        { -1595,    812},
        {  -136,   -160},
        {  -294,    405},
        {  -324,   -134},
        {    -3,     21},
        {  -131,     10},
        {    -5,    -16},
        {   -50,     31},
        {    -6,     -6},
        {   -24,     40},
        {   -25,     -8},
        {    -1,     20},
    },
    {
        {    -1,    -20},   /* Filter 44 */
        {     2,      0},
        {   -23,    -38},
        {    20,    -20},
        {   -36,    -22},
        {    12,    -39},
        {   -79,     -6},
        {   -19,   -121},
        {  -122,     50},
        {  -288,   -397},
        {   200,   -234},
        {  -763,   -388},
        {   598,  -2494},
        {  3667,      0},
        {   773,   3221},
        { -1587,    808},
        {  -132,   -155},
        {  -295,    406},
        {  -322,   -133},
        {    -3,     22},
        {  -131,     10},
        {    -4,    -15},
        {   -50,     31},
        {    -6,     -6},
        {   -24,     40},
        {   -24,     -8},
        {    -1,     20},
    },
    {
        {    -1,    -20},   /* Filter 45 */
        {     1,      0},
        {   -23,    -38},
        {    20,    -20},
        {   -36,    -22},
        {    12,    -39},
        {   -79,     -6},
        {   -19,   -121},
        {  -124,     51},
        {  -289,   -397},
        {   198,   -232},
        {  -770,   -392},
        {   600,  -2502},
        {  3669,      0},
        {   771,   3215},
        { -1578,    804},
        {  -128,   -150},
        {  -295,    407},
        {  -321,   -133},
        {    -3,     23},
        {  -131,     10},
        {    -4,    -14},
        {   -50,     31},
        {    -6,     -6},
        {   -24,     40},
        {   -24,     -7},
        {    -1,     20},
    },
    {
        {    -1,    -20},   /* Filter 46 */
        {     1,      0},
        {   -23,    -38},
        {    20,    -20},
        {   -36,    -22},
        {    12,    -39},
        {   -80,     -6},
        {   -19,   -120},
        {  -126,     52},
        {  -289,   -398},
        {   195,   -229},
        {  -777,   -396},
        {   602,  -2510},
        {  3671,      0},
        {   770,   3210},
        { -1570,    800},
        {  -124,   -145},
        {  -296,    408},
        {  -319,   -132},
        {    -4,     25},
        {  -130,     10},
        {    -4,    -14},
        {   -50,     31},
        {    -5,     -5},
        {   -24,     40},
        {   -24,     -7},
        {    -1,     20},
    },
    {
        {    -1,    -21},   /* Filter 47 */
        {     1,      0},
        {   -23,    -38},
        {    20,    -20},
        {   -36,    -22},
        {    12,    -38},
        {   -81,     -6},
        {   -19,   -120},
        {  -128,     53},
        {  -290,   -399},
        {   193,   -226},
        {  -785,   -400},
        {   604,  -2519},
        {  3673,      0},
        {   769,   3204},
        { -1562,    796},
        {  -120,   -140},
        {  -297,    408},
        {  -317,   -131},
        {    -4,     26},
        {  -130,     10},
        {    -4,    -13},
        {   -50,     31},
        {    -5,     -5},
        {   -25,     40},
        {   -24,     -7},
        {    -1,     21},
    },
    {
        {    -1,    -21},   /* Filter 48 */
        {     1,      0},
        {   -23,    -38},
        {    20,    -20},
        {   -37,    -22},
        {    12,    -38},
        {   -81,     -6},
        {   -18,   -119},
        {  -130,     53},
        {  -290,   -400},
        {   191,   -224},
        {  -792,   -403},
        {   606,  -2527},
        {  3675,      0},
        {   767,   3198},
        { -1554,    792},
        {  -116,   -136},
        {  -297,    409},
        {  -315,   -130},
        {    -4,     28},
        {  -130,     10},
        {    -4,    -12},
        {   -50,     31},
        {    -5,     -5},
        {   -25,     40},
        {   -23,     -7},
        {    -1,     21},
    },
    {
        {    -1,    -21},   /* Filter 49 */
        {     0,      0},
        {   -23,    -38},
        {    19,    -19},
        {   -37,    -22},
        {    12,    -38},
        {   -82,     -6},
        {   -18,   -119},
        {  -131,     54},
        {  -291,   -401},
        {   189,   -221},
        {  -800,   -407},
        {   608,  -2535},
        {  3677,      0},
        {   766,   3193},
        { -1546,    787},
        {  -112,   -131},
        {  -298,    410},
        {  -313,   -129},
        {    -4,     29},
        {  -130,     10},
        {    -3,    -12},
        {   -50,     31},
        {    -5,     -5},
        {   -25,     41},
        {   -23,     -7},
        {    -1,     21},
    },
    {
        {    -1,    -21},   /* Filter 50 */
        {     0,      0},
        {   -23,    -38},
        {    19,    -19},
        {   -37,    -23},
        {    12,    -37},
        {   -83,     -6},
        {   -18,   -118},
        {  -133,     55},
        {  -292,   -402},
        {   186,   -218},
        {  -807,   -411},
        {   610,  -2543},
        {  3679,      0},
        {   765,   3187},
        { -1538,    783},
        {  -108,   -126},
        {  -298,    411},
        {  -311,   -129},
        {    -4,     30},
        {  -129,     10},
        {    -3,    -11},
        {   -50,     31},
        {    -4,     -4},
        {   -25,     41},
        {   -23,     -7},
        {    -1,     21},
    },
    {
        {    -1,    -21},   /* Filter 51 */
        {     0,      0},
        {   -23,    -38},
        {    19,    -19},
        {   -38,    -23},
        {    12,    -37},
        {   -83,     -6},
        {   -18,   -118},
        {  -135,     56},
        {  -292,   -402},
        {   184,   -215},
        {  -815,   -415},
        {   612,  -2551},
        {  3681,      0},
        {   763,   3181},
        { -1529,    779},
        {  -104,   -121},
        {  -299,    411},
        {  -309,   -128},
        {    -5,     32},
        {  -129,     10},
        {    -3,    -10},
        {   -50,     31},
        {    -4,     -4},
        {   -25,     41},
        {   -23,     -7},
        {    -1,     21},
    },
    {
        {    -1,    -21},   /* Filter 52 */
        {     0,      0},
        {   -23,    -39},
        {    19,    -19},
        {   -38,    -23},
        {    11,    -36},
        {   -84,     -6},
        {   -18,   -117},
        {  -137,     56},
        {  -293,   -403},
        {   182,   -213},
        {  -822,   -419},
        {   614,  -2559},
        {  3683,      0},
        {   762,   3175},
        { -1521,    775},
        {  -100,   -117},
        {  -299,    412},
        {  -308,   -127},
        {    -5,     33},
        {  -129,     10},
        {    -3,    -10},
        {   -50,     31},
        {    -4,     -4},
        {   -25,     41},
        {   -22,     -7},
        {    -1,     21},
    },
    {
        {    -1,    -21},   /* Filter 53 */
        {     0,      0},
        {   -24,    -39},
        {    18,    -18},
        {   -38,    -23},
        {    11,    -36},
        {   -85,     -6},
        {   -18,   -116},
        {  -139,     57},
        {  -293,   -404},
        {   179,   -210},
        {  -830,   -423},
        {   616,  -2567},
        {  3685,      0},
        {   761,   3170},
        { -1513,    771},
        {   -96,   -112},
        {  -300,    413},
        {  -306,   -126},
        {    -5,     34},
        {  -129,     10},
        {    -3,     -9},
        {   -50,     31},
        {    -3,     -3},
        {   -25,     41},
        {   -22,     -7},
        {    -1,     21},
    },
    {
        {    -1,    -22},   /* Filter 54 */
        {     0,      0},
        {   -24,    -39},
        {    18,    -18},
        {   -38,    -23},
        {    11,    -36},
        {   -85,     -6},
        {   -18,   -116},
        {  -141,     58},
        {  -294,   -405},
        {   177,   -207},
        {  -837,   -426},
        {   618,  -2575},
        {  3687,      0},
        {   759,   3164},
        { -1505,    767},
        {   -92,   -107},
        {  -300,    413},
        {  -304,   -126},
        {    -5,     36},
        {  -128,     10},
        {    -2,     -8},
        {   -50,     31},
        {    -3,     -3},
        {   -25,     41},
        {   -22,     -7},
        {    -1,     22},
    },
    {
        {    -1,    -22},   /* Filter 55 */
        {     0,      0},
        {   -24,    -39},
        {    18,    -18},
        {   -39,    -23},
        {    11,    -35},
        {   -86,     -6},
        {   -18,   -115},
        {  -143,     59},
        {  -294,   -405},
        {   174,   -204},
        {  -845,   -430},
        {   620,  -2583},
        {  3689,      0},
        {   758,   3158},
        { -1497,    762},
        {   -88,   -103},
        {  -301,    414},
        {  -302,   -125},
        {    -5,     37},
        {  -128,     10},
        {    -2,     -8},
        {   -50,     31},
        {    -3,     -3},
        {   -25,     41},
        {   -21,     -7},
        {    -1,     22},
    },
    {
        {    -1,    -22},   /* Filter 56 */
        {     0,      0},
        {   -24,    -39},
        {    18,    -18},
        {   -39,    -24},
        {    11,    -35},
        {   -87,     -6},
        {   -18,   -115},
        {  -145,     60},
        {  -295,   -406},
        {   172,   -201},
        {  -852,   -434},
        {   622,  -2591},
        {  3691,      0},
        {   756,   3152},
        { -1488,    758},
        {   -84,    -98},
        {  -301,    415},
        {  -300,   -124},
        {    -6,     38},
        {  -128,     10},
        {    -2,     -7},
        {   -50,     31},
        {    -3,     -3},
        {   -25,     41},
        {   -21,     -7},
        {    -1,     22},
    },
    {
        {    -1,    -22},   /* Filter 57 */
        {    -1,      0},
        {   -24,    -39},
        {    18,    -18},
        {   -39,    -24},
        {    11,    -34},
        {   -87,     -6},
        {   -18,   -114},
        {  -147,     60},
        {  -295,   -407},
        {   169,   -198},
        {  -860,   -438},
        {   624,  -2599},
        {  3692,      0},
        {   755,   3146},
        { -1480,    754},
        {   -80,    -94},
        {  -302,    415},
        {  -298,   -123},
        {    -6,     40},
        {  -127,     10},
        {    -2,     -6},
        {   -50,     31},
        {    -2,     -2},
        {   -25,     41},
        {   -21,     -6},
        {    -1,     22},
    },
    {
        {    -1,    -22},   /* Filter 58 */
        {    -1,      0},
        {   -24,    -39},
        {    17,    -17},
        {   -39,    -24},
        {    11,    -34},
        {   -88,     -6},
        {   -18,   -114},
        {  -149,     61},
        {  -296,   -408},
        {   167,   -195},
        {  -868,   -442},
        {   625,  -2607},
        {  3694,      0},
        {   754,   3140},
        { -1472,    750},
        {   -76,    -89},
        {  -302,    416},
        {  -296,   -122},
        {    -6,     41},
        {  -127,     10},
        {    -2,     -6},
        {   -50,     30},
        {    -2,     -2},
        {   -25,     41},
        {   -21,     -6},
        {    -1,     22},
    },
    {
        {    -1,    -22},   /* Filter 59 */
        {    -1,      0},
        {   -24,    -39},
        {    17,    -17},
        {   -39,    -24},
        {    11,    -34},
        {   -89,     -7},
        {   -17,   -113},
        {  -150,     62},
        {  -296,   -408},
        {   164,   -193},
        {  -875,   -446},
        {   627,  -2615},
        {  3696,      0},
        {   752,   3134},
        { -1464,    746},
        {   -72,    -84},
        {  -302,    416},
        {  -294,   -122},
        {    -6,     42},
        {  -127,     10},
        {    -1,     -5},
        {   -50,     30},
        {    -2,     -2},
        {   -25,     41},
        {   -20,     -6},
        {    -1,     22},
    },
    {
        {    -1,    -22},   /* Filter 60 */
        {    -1,      0},
        {   -24,    -39},
        {    17,    -17},
        {   -40,    -24},
        {    10,    -33},
        {   -89,     -7},
        {   -17,   -112},
        {  -152,     63},
        {  -297,   -409},
        {   162,   -190},
        {  -883,   -450},
        {   629,  -2623},
        {  3697,      0},
        {   751,   3128},
        { -1456,    742},
        {   -68,    -80},
        {  -303,    417},
        {  -293,   -121},
        {    -6,     44},
        {  -126,      9},
        {    -1,     -5},
        {   -50,     30},
        {    -1,     -1},
        {   -25,     41},
        {   -20,     -6},
        {    -1,     22},
    },
    {
        {    -1,    -22},   /* Filter 61 */
        {    -2,      0},
        {   -24,    -39},
        {    17,    -17},
        {   -40,    -24},
        {    10,    -33},
        {   -90,     -7},
        {   -17,   -112},
        {  -154,     64},
        {  -297,   -410},
        {   159,   -187},
        {  -890,   -453},
        {   631,  -2630},
        {  3699,      0},
        {   749,   3122},
        { -1448,    737},
        {   -64,    -75},
        {  -303,    417},
        {  -291,   -120},
        {    -7,     45},
        {  -126,      9},
        {    -1,     -4},
        {   -50,     30},
        {    -1,     -1},
        {   -25,     41},
        {   -20,     -6},
        {    -1,     22},
    },
    {
        {    -1,    -23},   /* Filter 62 */
        {    -2,      0},
        {   -24,    -40},
        {    16,    -16},
        {   -40,    -24},
        {    10,    -32},
        {   -91,     -7},
        {   -17,   -111},
        {  -156,     64},
        {  -298,   -410},
        {   157,   -184},
        {  -898,   -457},
        {   633,  -2638},
        {  3700,      0},
        {   748,   3116},
        { -1439,    733},
        {   -60,    -71},
        {  -303,    418},
        {  -289,   -119},
        {    -7,     46},
        {  -126,      9},
        {    -1,     -3},
        {   -50,     30},
        {    -1,     -1},
        {   -25,     41},
        {   -20,     -6},
        {    -1,     23},
    },
    {
        {    -1,    -23},   /* Filter 63 */
        {    -2,      0},
        {   -24,    -40},
        {    16,    -16},
        {   -40,    -25},
        {    10,    -32},
        {   -91,     -7},
        {   -17,   -110},
        {  -158,     65},
        {  -298,   -411},
        {   154,   -181},
        {  -906,   -461},
        {   635,  -2646},
        {  3702,      0},
        {   746,   3110},
        { -1431,    729},
        {   -57,    -66},
        {  -304,    418},
        {  -287,   -119},
        {    -7,     47},
        {  -125,      9},
        {    -1,     -3},
        {   -50,     30},
        {    -1,     -1},
        {   -25,     41},
        {   -19,     -6},
        {    -1,     23},
    },
    {
        {    -1,    -23},   /* Filter 64 */
        {    -2,      0},
        {   -24,    -40},
        {    16,    -16},
        {   -41,    -25},
        {    10,    -31},
        {   -92,     -7},
        {   -17,   -110},
        {  -160,     66},
        {  -299,   -412},
        {   152,   -178},
        {  -913,   -465},
        {   637,  -2654},
        {  3703,      0},
        {   745,   3104},
        { -1423,    725},
        {   -53,    -62},
        {  -304,    419},
        {  -285,   -118},
        {    -7,     49},
        {  -125,      9},
        {     0,     -2},
        {   -50,     30},
        {     0,      0},
        {   -25,     41},
        {   -19,     -6},
        {    -1,     23},
    },
    {
        {    -1,    -23},   /* Filter 65 */
        {    -3,      0},
        {   -24,    -40},
        {    16,    -16},
        {   -41,    -25},
        {    10,    -31},
        {   -93,     -7},
        {   -17,   -109},
        {  -162,     67},
        {  -299,   -412},
        {   149,   -174},
        {  -921,   -469},
        {   639,  -2662},
        {  3705,      0},
        {   743,   3098},
        { -1415,    721},
        {   -49,    -57},
        {  -304,    419},
        {  -283,   -117},
        {    -7,     50},
        {  -125,      9},
        {     0,     -1},
        {   -50,     30},
        {     0,      0},
        {   -25,     41},
        {   -19,     -6},
        {    -1,     23},
    },
    {
        {    -1,    -23},   /* Filter 66 */
        {    -3,      1},
        {   -24,    -40},
        {    15,    -15},
        {   -41,    -25},
        {    10,    -31},
        {   -93,     -7},
        {   -17,   -108},
        {  -164,     68},
        {  -300,   -413},
        {   146,   -171},
        {  -929,   -473},
        {   640,  -2669},
        {  3706,      0},
        {   742,   3091},
        { -1407,    717},
        {   -45,    -53},
        {  -305,    420},
        {  -281,   -116},
        {    -8,     51},
        {  -124,      9},
        {     0,     -1},
        {   -50,     30},
        {     0,      0},
        {   -25,     41},
        {   -19,     -6},
        {    -1,     23},
    },
    {
        {    -1,    -23},   /* Filter 67 */
        {    -3,      1},
        {   -24,    -40},
        {    15,    -15},
        {   -41,    -25},
        {     9,    -30},
        {   -94,     -7},
        {   -17,   -108},
        {  -166,     68},
        {  -300,   -413},
        {   144,   -168},
        {  -936,   -477},
        {   642,  -2677},
        {  3707,      0},
        {   740,   3085},
        { -1399,    712},
        {   -41,    -49},
        {  -305,    420},
        {  -279,   -115},
        {    -8,     52},
        {  -124,      9},
        {     0,      0},
        {   -50,     30},
        {     0,      0},
        {   -25,     41},
        {   -18,     -6},
        {    -1,     23},
    },
    {
        {    -1,    -23},   /* Filter 68 */
        {    -3,      1},
        {   -24,    -40},
        {    15,    -15},
        {   -42,    -25},
        {     9,    -30},
        {   -95,     -7},
        {   -17,   -107},
        {  -168,     69},
        {  -301,   -414},
        {   141,   -165},
        {  -944,   -481},
        {   644,  -2685},
        {  3708,      0},
        {   739,   3079},
        { -1391,    708},
        {   -38,    -44},
        {  -305,    420},
        {  -277,   -115},
        {    -8,     54},
        {  -124,      9},
        {     0,      0},
        {   -50,     30},
        {     0,      0},
        {   -25,     42},
        {   -18,     -6},
        {    -1,     23},
    },
    {
        {    -1,    -23},   /* Filter 69 */
        {    -4,      1},
        {   -24,    -40},
        {    15,    -15},
        {   -42,    -25},
        {     9,    -29},
        {   -95,     -7},
        {   -16,   -106},
        {  -170,     70},
        {  -301,   -414},
        {   138,   -162},
        {  -952,   -485},
        {   646,  -2693},
        {  3710,      0},
        {   737,   3073},
        { -1382,    704},
        {   -34,    -40},
        {  -306,    421},
        {  -275,   -114},
        {    -8,     55},
        {  -123,      9},
        {     0,      0},
        {   -50,     30},
        {     0,      0},
        {   -25,     42},
        {   -18,     -5},
        {    -1,     23},
    },
    {
        {    -1,    -23},   /* Filter 70 */
        {    -4,      1},
        {   -24,    -40},
        {    14,    -14},
        {   -42,    -26},
        {     9,    -29},
        {   -96,     -7},
        {   -16,   -106},
        {  -172,     71},
        {  -301,   -415},
        {   136,   -159},
        {  -960,   -489},
        {   648,  -2700},
        {  3711,      0},
        {   736,   3066},
        { -1374,    700},
        {   -30,    -36},
        {  -306,    421},
        {  -273,   -113},
        {    -8,     56},
        {  -123,      9},
        {     0,      1},
        {   -49,     30},
        {     0,      0},
        {   -25,     42},
        {   -18,     -5},
        {    -1,     23},
    },
    {
        {    -1,    -24},   /* Filter 71 */
        {    -4,      1},
        {   -25,    -40},
        {    14,    -14},
        {   -42,    -26},
        {     9,    -28},
        {   -96,     -7},
        {   -16,   -105},
        {  -174,     72},
        {  -302,   -415},
        {   133,   -156},
        {  -967,   -493},
        {   650,  -2708},
        {  3712,      0},
        {   734,   3060},
        { -1366,    696},
        {   -27,    -31},
        {  -306,    421},
        {  -271,   -112},
        {    -9,     57},
        {  -122,      9},
        {     0,      1},
        {   -49,     30},
        {     1,      1},
        {   -25,     42},
        {   -17,     -5},
        {    -1,     24},
    },
    {
        {    -1,    -24},   /* Filter 72 */
        {    -4,      1},
        {   -25,    -40},
        {    14,    -14},
        {   -42,    -26},
        {     9,    -28},
        {   -97,     -7},
        {   -16,   -104},
        {  -176,     72},
        {  -302,   -416},
        {   130,   -152},
        {  -975,   -497},
        {   652,  -2716},
        {  3713,      0},
        {   733,   3054},
        { -1358,    692},
        {   -23,    -27},
        {  -306,    422},
        {  -270,   -111},
        {    -9,     58},
        {  -122,      9},
        {     0,      2},
        {   -49,     30},
        {     1,      1},
        {   -25,     42},
        {   -17,     -5},
        {    -1,     24},
    },
    {
        {    -1,    -24},   /* Filter 73 */
        {    -5,      1},
        {   -25,    -40},
        {    14,    -14},
        {   -43,    -26},
        {     9,    -27},
        {   -98,     -7},
        {   -16,   -104},
        {  -178,     73},
        {  -302,   -416},
        {   127,   -149},
        {  -983,   -501},
        {   653,  -2723},
        {  3714,      0},
        {   731,   3047},
        { -1350,    688},
        {   -19,    -23},
        {  -306,    422},
        {  -268,   -111},
        {    -9,     60},
        {  -122,      9},
        {     0,      3},
        {   -49,     30},
        {     1,      1},
        {   -25,     42},
        {   -17,     -5},
        {    -1,     24},
    },
    {
        {    -1,    -24},   /* Filter 74 */
        {    -5,      1},
        {   -25,    -41},
        {    13,    -13},
        {   -43,    -26},
        {     8,    -27},
        {   -98,     -7},
        {   -16,   -103},
        {  -179,     74},
        {  -303,   -417},
        {   125,   -146},
        {  -991,   -504},
        {   655,  -2731},
        {  3715,      0},
        {   730,   3041},
        { -1342,    683},
        {   -16,    -19},
        {  -307,    422},
        {  -266,   -110},
        {    -9,     61},
        {  -121,      9},
        {     1,      3},
        {   -49,     30},
        {     2,      2},
        {   -25,     42},
        {   -17,     -5},
        {    -1,     24},
    },
    {
        {    -1,    -24},   /* Filter 75 */
        {    -5,      1},
        {   -25,    -41},
        {    13,    -13},
        {   -43,    -26},
        {     8,    -26},
        {   -99,     -7},
        {   -16,   -102},
        {  -181,     75},
        {  -303,   -417},
        {   122,   -143},
        {  -998,   -508},
        {   657,  -2738},
        {  3716,      0},
        {   728,   3034},
        { -1334,    679},
        {   -12,    -14},
        {  -307,    422},
        {  -264,   -109},
        {    -9,     62},
        {  -121,      9},
        {     1,      4},
        {   -49,     30},
        {     2,      2},
        {   -25,     42},
        {   -16,     -5},
        {    -1,     24},
    },
    {
        {    -1,    -24},   /* Filter 76 */
        {    -5,      1},
        {   -25,    -41},
        {    13,    -13},
        {   -43,    -26},
        {     8,    -26},
        {   -99,     -7},
        {   -16,   -101},
        {  -183,     76},
        {  -303,   -418},
        {   119,   -139},
        { -1006,   -512},
        {   659,  -2746},
        {  3717,      0},
        {   727,   3028},
        { -1325,    675},
        {    -9,    -10},
        {  -307,    423},
        {  -262,   -108},
        {   -10,     63},
        {  -120,      9},
        {     1,      4},
        {   -49,     30},
        {     2,      2},
        {   -25,     42},
        {   -16,     -5},
        {    -1,     24},
    },
    {
        {    -1,    -24},   /* Filter 77 */
        {    -6,      2},
        {   -25,    -41},
        {    13,    -13},
        {   -43,    -26},
        {     8,    -25},
        {  -100,     -7},
        {   -15,   -101},
        {  -185,     76},
        {  -304,   -418},
        {   116,   -136},
        { -1014,   -516},
        {   661,  -2753},
        {  3718,      0},
        {   725,   3021},
        { -1317,    671},
        {    -5,     -6},
        {  -307,    423},
        {  -260,   -107},
        {   -10,     64},
        {  -120,      9},
        {     1,      5},
        {   -49,     30},
        {     2,      2},
        {   -25,     42},
        {   -16,     -5},
        {    -1,     24},
    },
    {
        {    -1,    -24},   /* Filter 78 */
        {    -6,      2},
        {   -25,    -41},
        {    12,    -12},
        {   -44,    -27},
        {     8,    -25},
        {  -101,     -7},
        {   -15,   -100},
        {  -187,     77},
        {  -304,   -419},
        {   113,   -133},
        { -1022,   -520},
        {   662,  -2761},
        {  3718,      0},
        {   723,   3015},
        { -1309,    667},
        {    -1,     -2},
        {  -307,    423},
        {  -258,   -107},
        {   -10,     65},
        {  -119,      9},
        {     1,      6},
        {   -49,     30},
        {     3,      3},
        {   -25,     42},
        {   -15,     -5},
        {    -1,     24},
    },
    {
        {    -1,    -24},   /* Filter 79 */
        {    -6,      2},
        {   -25,    -41},
        {    12,    -12},
        {   -44,    -27},
        {     8,    -24},
        {  -101,     -8},
        {   -15,    -99},
        {  -189,     78},
        {  -304,   -419},
        {   110,   -129},
        { -1030,   -524},
        {   664,  -2768},
        {  3719,      0},
        {   722,   3008},
        { -1301,    663},
        {     1,      1},
        {  -307,    423},
        {  -256,   -106},
        {   -10,     66},
        {  -119,      9},
        {     2,      6},
        {   -49,     30},
        {     3,      3},
        {   -25,     42},
        {   -15,     -5},
        {    -1,     24},
    },
    {
        {    -1,    -24},   /* Filter 80 */
        {    -6,      2},
        {   -25,    -41},
        {    12,    -12},
        {   -44,    -27},
        {     7,    -24},
        {  -102,     -8},
        {   -15,    -98},
        {  -191,     79},
        {  -305,   -420},
        {   107,   -126},
        { -1037,   -528},
        {   666,  -2776},
        {  3720,      0},
        {   720,   3001},
        { -1293,    659},
        {     5,      6},
        {  -308,    423},
        {  -254,   -105},
        {   -10,     68},
        {  -119,      9},
        {     2,      7},
        {   -49,     30},
        {     3,      3},
        {   -25,     42},
        {   -15,     -5},
        {    -1,     24},
    },
    {
        {    -1,    -25},   /* Filter 81 */
        {    -7,      2},
        {   -25,    -41},
        {    12,    -12},
        {   -44,    -27},
        {     7,    -23},
        {  -102,     -8},
        {   -15,    -97},
        {  -193,     80},
        {  -305,   -420},
        {   104,   -122},
        { -1045,   -532},
        {   668,  -2783},
        {  3721,      0},
        {   719,   2995},
        { -1285,    654},
        {     8,     10},
        {  -308,    424},
        {  -252,   -104},
        {   -10,     69},
        {  -118,      9},
        {     2,      7},
        {   -49,     30},
        {     4,      4},
        {   -25,     42},
        {   -15,     -4},
        {    -1,     25},
    },
    {
        {    -1,    -25},   /* Filter 82 */
        {    -7,      2},
        {   -25,    -41},
        {    11,    -11},
        {   -44,    -27},
        {     7,    -23},
        {  -103,     -8},
        {   -15,    -96},
        {  -195,     81},
        {  -305,   -420},
        {   102,   -119},
        { -1053,   -536},
        {   670,  -2791},
        {  3721,      0},
        {   717,   2988},
        { -1277,    650},
        {    12,     14},
        {  -308,    424},
        {  -250,   -103},
        {   -11,     70},
        {  -118,      9},
        {     2,      8},
        {   -48,     29},
        {     4,      4},
        {   -25,     42},
        {   -14,     -4},
        {    -1,     25},
    },
    {
        {    -1,    -25},   /* Filter 83 */
        {    -7,      2},
        {   -25,    -41},
        {    11,    -11},
        {   -45,    -27},
        {     7,    -22},
        {  -104,     -8},
        {   -15,    -96},
        {  -197,     81},
        {  -305,   -421},
        {    99,   -115},
        { -1061,   -540},
        {   671,  -2798},
        {  3722,      0},
        {   715,   2981},
        { -1269,    646},
        {    15,     18},
        {  -308,    424},
        {  -248,   -102},
        {   -11,     71},
        {  -117,      9},
        {     2,      8},
        {   -48,     29},
        {     4,      4},
        {   -25,     42},
        {   -14,     -4},
        {    -1,     25},
    },
    {
        {    -1,    -25},   /* Filter 84 */
        {    -8,      2},
        {   -25,    -41},
        {    11,    -11},
        {   -45,    -27},
        {     7,    -22},
        {  -104,     -8},
        {   -15,    -95},
        {  -199,     82},
        {  -306,   -421},
        {    96,   -112},
        { -1069,   -544},
        {   673,  -2805},
        {  3722,      0},
        {   714,   2975},
        { -1261,    642},
        {    19,     22},
        {  -308,    424},
        {  -246,   -102},
        {   -11,     72},
        {  -117,      9},
        {     3,      9},
        {   -48,     29},
        {     4,      4},
        {   -25,     42},
        {   -14,     -4},
        {    -1,     25},
    },
    {
        {    -1,    -25},   /* Filter 85 */
        {    -8,      2},
        {   -25,    -41},
        {    11,    -11},
        {   -45,    -27},
        {     7,    -21},
        {  -105,     -8},
        {   -14,    -94},
        {  -201,     83},
        {  -306,   -421},
        {    93,   -108},
        { -1077,   -548},
        {   675,  -2813},
        {  3723,      0},
        {   712,   2968},
        { -1253,    638},
        {    22,     26},
        {  -308,    424},
        {  -244,   -101},
        {   -11,     73},
        {  -116,      9},
        {     3,     10},
        {   -48,     29},
        {     5,      5},
        {   -25,     42},
        {   -14,     -4},
        {    -1,     25},
    },
    {
        {    -2,    -25},   /* Filter 86 */
        {    -8,      2},
        {   -25,    -41},
        {    10,    -10},
        {   -45,    -27},
        {     6,    -21},
        {  -105,     -8},
        {   -14,    -93},
        {  -203,     84},
        {  -306,   -422},
        {    90,   -105},
        { -1085,   -552},
        {   677,  -2820},
        {  3723,      0},
        {   711,   2961},
        { -1245,    634},
        {    25,     30},
        {  -308,    424},
        {  -242,   -100},
        {   -11,     74},
        {  -116,      9},
        {     3,     10},
        {   -48,     29},
        {     5,      5},
        {   -25,     42},
        {   -13,     -4},
        {    -2,     25},
    },
    {
        {    -2,    -25},   /* Filter 87 */
        {    -8,      2},
        {   -25,    -41},
        {    10,    -10},
        {   -45,    -28},
        {     6,    -20},
        {  -106,     -8},
        {   -14,    -92},
        {  -205,     85},
        {  -306,   -422},
        {    87,   -101},
        { -1093,   -557},
        {   678,  -2827},
        {  3724,      0},
        {   709,   2954},
        { -1237,    630},
        {    29,     34},
        {  -308,    424},
        {  -240,    -99},
        {   -11,     75},
        {  -115,      9},
        {     3,     11},
        {   -48,     29},
        {     5,      5},
        {   -25,     42},
        {   -13,     -4},
        {    -2,     25},
    },
    {
        {    -2,    -25},   /* Filter 88 */
        {    -9,      2},
        {   -25,    -41},
        {    10,    -10},
        {   -45,    -28},
        {     6,    -20},
        {  -106,     -8},
        {   -14,    -91},
        {  -207,     85},
        {  -307,   -422},
        {    84,    -98},
        { -1101,   -561},
        {   680,  -2835},
        {  3724,      0},
        {   707,   2948},
        { -1228,    626},
        {    32,     38},
        {  -308,    424},
        {  -238,    -98},
        {   -12,     76},
        {  -115,      9},
        {     3,     11},
        {   -48,     29},
        {     5,      5},
        {   -25,     42},
        {   -13,     -4},
        {    -2,     25},
    },
    {
        {    -2,    -25},   /* Filter 89 */
        {    -9,      3},
        {   -25,    -41},
        {    10,    -10},
        {   -46,    -28},
        {     6,    -19},
        {  -107,     -8},
        {   -14,    -91},
        {  -209,     86},
        {  -307,   -422},
        {    80,    -94},
        { -1109,   -565},
        {   682,  -2842},
        {  3724,      0},
        {   706,   2941},
        { -1220,    622},
        {    35,     42},
        {  -308,    424},
        {  -236,    -98},
        {   -12,     77},
        {  -114,      9},
        {     4,     12},
        {   -48,     29},
        {     6,      6},
        {   -25,     42},
        {   -13,     -4},
        {    -2,     25},
    },
    {
        {    -2,    -25},   /* Filter 90 */
        {    -9,      3},
        {   -25,    -41},
        {     9,     -9},
        {   -46,    -28},
        {     6,    -19},
        {  -108,     -8},
        {   -14,    -90},
        {  -211,     87},
        {  -307,   -423},
        {    77,    -91},
        { -1116,   -569},
        {   684,  -2849},
        {  3725,      0},
        {   704,   2934},
        { -1212,    617},
        {    39,     45},
        {  -308,    424},
        {  -234,    -97},
        {   -12,     78},
        {  -114,      8},
        {     4,     12},
        {   -47,     29},
        {     6,      6},
        {   -25,     42},
        {   -12,     -4},
        {    -2,     25},
    },
    {
        {    -2,    -25},   /* Filter 91 */
        {    -9,      3},
        {   -25,    -41},
        {     9,     -9},
        {   -46,    -28},
        {     6,    -18},
        {  -108,     -8},
        {   -14,    -89},
        {  -213,     88},
        {  -307,   -423},
        {    74,    -87},
        { -1124,   -573},
        {   685,  -2856},
        {  3725,      0},
        {   702,   2927},
        { -1204,    613},
        {    42,     49},
        {  -308,    424},
        {  -232,    -96},
        {   -12,     79},
        {  -113,      8},
        {     4,     13},
        {   -47,     29},
        {     6,      6},
        {   -25,     42},
        {   -12,     -4},
        {    -2,     25},
    },
    {
        {    -2,    -25},   /* Filter 92 */
        {   -10,      3},
        {   -25,    -41},
        {     9,     -9},
        {   -46,    -28},
        {     5,    -18},
        {  -109,     -8},
        {   -13,    -88},
        {  -215,     89},
        {  -307,   -423},
        {    71,    -83},
        { -1132,   -577},
        {   687,  -2864},
        {  3725,      0},
        {   701,   2920},
        { -1196,    609},
        {    45,     53},
        {  -308,    424},
        {  -230,    -95},
        {   -12,     80},
        {  -113,      8},
        {     4,     14},
        {   -47,     29},
        {     7,      7},
        {   -25,     42},
        {   -12,     -3},
        {    -2,     25},
    },
    {
        {    -2,    -25},   /* Filter 93 */
        {   -10,      3},
        {   -25,    -42},
        {     8,     -8},
        {   -46,    -28},
        {     5,    -17},
        {  -109,     -8},
        {   -13,    -87},
        {  -217,     89},
        {  -307,   -423},
        {    68,    -80},
        { -1140,   -581},
        {   689,  -2871},
        {  3725,      0},
        {   699,   2913},
        { -1188,    605},
        {    49,     57},
        {  -308,    424},
        {  -229,    -94},
        {   -12,     81},
        {  -112,      8},
        {     4,     14},
        {   -47,     29},
        {     7,      7},
        {   -25,     42},
        {   -11,     -3},
        {    -2,     25},
    },
    {
        {    -2,    -26},   /* Filter 94 */
        {   -10,      3},
        {   -25,    -42},
        {     8,     -8},
        {   -46,    -28},
        {     5,    -17},
        {  -110,     -8},
        {   -13,    -86},
        {  -219,     90},
        {  -307,   -423},
        {    65,    -76},
        { -1148,   -585},
        {   691,  -2878},
        {  3725,      0},
        {   697,   2906},
        { -1180,    601},
        {    52,     61},
        {  -308,    424},
        {  -227,    -94},
        {   -13,     82},
        {  -112,      8},
        {     4,     15},
        {   -47,     29},
        {     7,      7},
        {   -25,     42},
        {   -11,     -3},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 95 */
        {   -10,      3},
        {   -25,    -42},
        {     8,     -8},
        {   -46,    -28},
        {     5,    -16},
        {  -110,     -8},
        {   -13,    -85},
        {  -221,     91},
        {  -308,   -423},
        {    62,    -72},
        { -1156,   -589},
        {   692,  -2885},
        {  3726,      0},
        {   696,   2899},
        { -1172,    597},
        {    55,     65},
        {  -308,    424},
        {  -225,    -93},
        {   -13,     83},
        {  -111,      8},
        {     5,     15},
        {   -47,     28},
        {     7,      7},
        {   -25,     42},
        {   -11,     -3},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 96 */
        {   -11,      3},
        {   -25,    -42},
        {     8,     -8},
        {   -47,    -28},
        {     5,    -16},
        {  -111,     -8},
        {   -13,    -84},
        {  -223,     92},
        {  -308,   -424},
        {    58,    -68},
        { -1164,   -593},
        {   694,  -2892},
        {  3726,      0},
        {   694,   2892},
        { -1164,    593},
        {    58,     68},
        {  -308,    424},
        {  -223,    -92},
        {   -13,     84},
        {  -111,      8},
        {     5,     16},
        {   -47,     28},
        {     8,      8},
        {   -25,     42},
        {   -11,     -3},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 97 */
        {   -11,      3},
        {   -25,    -42},
        {     7,     -7},
        {   -47,    -28},
        {     5,    -15},
        {  -111,     -8},
        {   -13,    -83},
        {  -225,     93},
        {  -308,   -424},
        {    55,    -65},
        { -1172,   -597},
        {   696,  -2899},
        {  3726,      0},
        {   692,   2885},
        { -1156,    589},
        {    62,     72},
        {  -308,    423},
        {  -221,    -91},
        {   -13,     85},
        {  -110,      8},
        {     5,     16},
        {   -46,     28},
        {     8,      8},
        {   -25,     42},
        {   -10,     -3},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 98 */
        {   -11,      3},
        {   -25,    -42},
        {     7,     -7},
        {   -47,    -29},
        {     4,    -15},
        {  -112,     -8},
        {   -13,    -82},
        {  -227,     94},
        {  -308,   -424},
        {    52,    -61},
        { -1180,   -601},
        {   697,  -2906},
        {  3725,      0},
        {   691,   2878},
        { -1148,    585},
        {    65,     76},
        {  -307,    423},
        {  -219,    -90},
        {   -13,     86},
        {  -110,      8},
        {     5,     17},
        {   -46,     28},
        {     8,      8},
        {   -25,     42},
        {   -10,     -3},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 99 */
        {   -11,      3},
        {   -25,    -42},
        {     7,     -7},
        {   -47,    -29},
        {     4,    -14},
        {  -112,     -8},
        {   -12,    -81},
        {  -229,     94},
        {  -308,   -424},
        {    49,    -57},
        { -1188,   -605},
        {   699,  -2913},
        {  3725,      0},
        {   689,   2871},
        { -1140,    581},
        {    68,     80},
        {  -307,    423},
        {  -217,    -89},
        {   -13,     87},
        {  -109,      8},
        {     5,     17},
        {   -46,     28},
        {     8,      8},
        {   -25,     42},
        {   -10,     -3},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 100 */
        {   -12,      3},
        {   -25,    -42},
        {     7,     -7},
        {   -47,    -29},
        {     4,    -14},
        {  -113,     -8},
        {   -12,    -80},
        {  -230,     95},
        {  -308,   -424},
        {    45,    -53},
        { -1196,   -609},
        {   701,  -2920},
        {  3725,      0},
        {   687,   2864},
        { -1132,    577},
        {    71,     83},
        {  -307,    423},
        {  -215,    -89},
        {   -13,     88},
        {  -109,      8},
        {     5,     18},
        {   -46,     28},
        {     9,      9},
        {   -25,     41},
        {   -10,     -3},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 101 */
        {   -12,      4},
        {   -25,    -42},
        {     6,     -6},
        {   -47,    -29},
        {     4,    -13},
        {  -113,     -8},
        {   -12,    -79},
        {  -232,     96},
        {  -308,   -424},
        {    42,    -49},
        { -1204,   -613},
        {   702,  -2927},
        {  3725,      0},
        {   685,   2856},
        { -1124,    573},
        {    74,     87},
        {  -307,    423},
        {  -213,    -88},
        {   -14,     89},
        {  -108,      8},
        {     6,     18},
        {   -46,     28},
        {     9,      9},
        {   -25,     41},
        {    -9,     -3},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 102 */
        {   -12,      4},
        {   -25,    -42},
        {     6,     -6},
        {   -47,    -29},
        {     4,    -12},
        {  -114,     -8},
        {   -12,    -78},
        {  -234,     97},
        {  -308,   -424},
        {    39,    -45},
        { -1212,   -617},
        {   704,  -2934},
        {  3725,      0},
        {   684,   2849},
        { -1116,    569},
        {    77,     91},
        {  -307,    423},
        {  -211,    -87},
        {   -14,     90},
        {  -108,      8},
        {     6,     19},
        {   -46,     28},
        {     9,      9},
        {   -25,     41},
        {    -9,     -3},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 103 */
        {   -13,      4},
        {   -25,    -42},
        {     6,     -6},
        {   -48,    -29},
        {     4,    -12},
        {  -114,     -9},
        {   -12,    -77},
        {  -236,     98},
        {  -308,   -424},
        {    35,    -42},
        { -1220,   -622},
        {   706,  -2941},
        {  3724,      0},
        {   682,   2842},
        { -1109,    565},
        {    80,     94},
        {  -307,    422},
        {  -209,    -86},
        {   -14,     91},
        {  -107,      8},
        {     6,     19},
        {   -46,     28},
        {    10,     10},
        {   -25,     41},
        {    -9,     -3},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 104 */
        {   -13,      4},
        {   -25,    -42},
        {     5,     -5},
        {   -48,    -29},
        {     3,    -11},
        {  -115,     -9},
        {   -12,    -76},
        {  -238,     98},
        {  -308,   -424},
        {    32,    -38},
        { -1228,   -626},
        {   707,  -2948},
        {  3724,      0},
        {   680,   2835},
        { -1101,    561},
        {    84,     98},
        {  -307,    422},
        {  -207,    -85},
        {   -14,     91},
        {  -106,      8},
        {     6,     20},
        {   -45,     28},
        {    10,     10},
        {   -25,     41},
        {    -9,     -2},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 105 */
        {   -13,      4},
        {   -25,    -42},
        {     5,     -5},
        {   -48,    -29},
        {     3,    -11},
        {  -115,     -9},
        {   -11,    -75},
        {  -240,     99},
        {  -308,   -424},
        {    29,    -34},
        { -1237,   -630},
        {   709,  -2954},
        {  3724,      0},
        {   678,   2827},
        { -1093,    557},
        {    87,    101},
        {  -306,    422},
        {  -205,    -85},
        {   -14,     92},
        {  -106,      8},
        {     6,     20},
        {   -45,     28},
        {    10,     10},
        {   -25,     41},
        {    -8,     -2},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 106 */
        {   -13,      4},
        {   -25,    -42},
        {     5,     -5},
        {   -48,    -29},
        {     3,    -10},
        {  -116,     -9},
        {   -11,    -74},
        {  -242,    100},
        {  -308,   -424},
        {    25,    -30},
        { -1245,   -634},
        {   711,  -2961},
        {  3723,      0},
        {   677,   2820},
        { -1085,    552},
        {    90,    105},
        {  -306,    422},
        {  -203,    -84},
        {   -14,     93},
        {  -105,      8},
        {     6,     21},
        {   -45,     27},
        {    10,     10},
        {   -25,     41},
        {    -8,     -2},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 107 */
        {   -14,      4},
        {   -25,    -42},
        {     5,     -5},
        {   -48,    -29},
        {     3,    -10},
        {  -116,     -9},
        {   -11,    -73},
        {  -244,    101},
        {  -308,   -424},
        {    22,    -26},
        { -1253,   -638},
        {   712,  -2968},
        {  3723,      0},
        {   675,   2813},
        { -1077,    548},
        {    93,    108},
        {  -306,    421},
        {  -201,    -83},
        {   -14,     94},
        {  -105,      8},
        {     7,     21},
        {   -45,     27},
        {    11,     11},
        {   -25,     41},
        {    -8,     -2},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 108 */
        {   -14,      4},
        {   -25,    -42},
        {     4,     -4},
        {   -48,    -29},
        {     3,     -9},
        {  -117,     -9},
        {   -11,    -72},
        {  -246,    102},
        {  -308,   -424},
        {    19,    -22},
        { -1261,   -642},
        {   714,  -2975},
        {  3722,      0},
        {   673,   2805},
        { -1069,    544},
        {    96,    112},
        {  -306,    421},
        {  -199,    -82},
        {   -15,     95},
        {  -104,      8},
        {     7,     22},
        {   -45,     27},
        {    11,     11},
        {   -25,     41},
        {    -8,     -2},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 109 */
        {   -14,      4},
        {   -25,    -42},
        {     4,     -4},
        {   -48,    -29},
        {     2,     -8},
        {  -117,     -9},
        {   -11,    -71},
        {  -248,    102},
        {  -308,   -424},
        {    15,    -18},
        { -1269,   -646},
        {   715,  -2981},
        {  3722,      0},
        {   671,   2798},
        { -1061,    540},
        {    99,    115},
        {  -305,    421},
        {  -197,    -81},
        {   -15,     96},
        {  -104,      8},
        {     7,     22},
        {   -45,     27},
        {    11,     11},
        {   -25,     41},
        {    -7,     -2},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 110 */
        {   -14,      4},
        {   -25,    -42},
        {     4,     -4},
        {   -48,    -29},
        {     2,     -8},
        {  -118,     -9},
        {   -11,    -70},
        {  -250,    103},
        {  -308,   -424},
        {    12,    -14},
        { -1277,   -650},
        {   717,  -2988},
        {  3721,      0},
        {   670,   2791},
        { -1053,    536},
        {   102,    119},
        {  -305,    420},
        {  -195,    -81},
        {   -15,     96},
        {  -103,      8},
        {     7,     23},
        {   -44,     27},
        {    11,     11},
        {   -25,     41},
        {    -7,     -2},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 111 */
        {   -15,      4},
        {   -25,    -42},
        {     4,     -4},
        {   -49,    -30},
        {     2,     -7},
        {  -118,     -9},
        {   -10,    -69},
        {  -252,    104},
        {  -308,   -424},
        {     8,    -10},
        { -1285,   -654},
        {   719,  -2995},
        {  3721,      0},
        {   668,   2783},
        { -1045,    532},
        {   104,    122},
        {  -305,    420},
        {  -193,    -80},
        {   -15,     97},
        {  -102,      8},
        {     7,     23},
        {   -44,     27},
        {    12,     12},
        {   -25,     41},
        {    -7,     -2},
        {    -2,     26},
    },
    {
        {    -2,    -27},   /* Filter 112 */
        {   -15,      5},
        {   -25,    -42},
        {     3,     -3},
        {   -49,    -30},
        {     2,     -7},
        {  -119,     -9},
        {   -10,    -68},
        {  -254,    105},
        {  -308,   -423},
        {     5,     -6},
        { -1293,   -659},
        {   720,  -3001},
        {  3720,      0},
        {   666,   2776},
        { -1037,    528},
        {   107,    126},
        {  -305,    420},
        {  -191,    -79},
        {   -15,     98},
        {  -102,      8},
        {     7,     24},
        {   -44,     27},
        {    12,     12},
        {   -25,     41},
        {    -6,     -2},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 113 */
        {   -15,      5},
        {   -25,    -42},
        {     3,     -3},
        {   -49,    -30},
        {     2,     -6},
        {  -119,     -9},
        {   -10,    -66},
        {  -256,    106},
        {  -307,   -423},
        {     1,     -1},
        { -1301,   -663},
        {   722,  -3008},
        {  3719,      0},
        {   664,   2768},
        { -1030,    524},
        {   110,    129},
        {  -304,    419},
        {  -189,    -78},
        {   -15,     99},
        {  -101,      8},
        {     8,     24},
        {   -44,     27},
        {    12,     12},
        {   -25,     41},
        {    -6,     -2},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 114 */
        {   -15,      5},
        {   -25,    -42},
        {     3,     -3},
        {   -49,    -30},
        {     1,     -6},
        {  -119,     -9},
        {   -10,    -65},
        {  -258,    107},
        {  -307,   -423},
        {    -1,      2},
        { -1309,   -667},
        {   723,  -3015},
        {  3718,      0},
        {   662,   2761},
        { -1022,    520},
        {   113,    133},
        {  -304,    419},
        {  -187,    -77},
        {   -15,    100},
        {  -101,      7},
        {     8,     25},
        {   -44,     27},
        {    12,     12},
        {   -25,     41},
        {    -6,     -2},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 115 */
        {   -16,      5},
        {   -25,    -42},
        {     2,     -2},
        {   -49,    -30},
        {     1,     -5},
        {  -120,     -9},
        {   -10,    -64},
        {  -260,    107},
        {  -307,   -423},
        {    -5,      6},
        { -1317,   -671},
        {   725,  -3021},
        {  3718,      0},
        {   661,   2753},
        { -1014,    516},
        {   116,    136},
        {  -304,    418},
        {  -185,    -76},
        {   -15,    101},
        {  -100,      7},
        {     8,     25},
        {   -43,     26},
        {    13,     13},
        {   -25,     41},
        {    -6,     -2},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 116 */
        {   -16,      5},
        {   -25,    -42},
        {     2,     -2},
        {   -49,    -30},
        {     1,     -4},
        {  -120,     -9},
        {   -10,    -63},
        {  -262,    108},
        {  -307,   -423},
        {    -9,     10},
        { -1325,   -675},
        {   727,  -3028},
        {  3717,      0},
        {   659,   2746},
        { -1006,    512},
        {   119,    139},
        {  -303,    418},
        {  -183,    -76},
        {   -16,    101},
        {   -99,      7},
        {     8,     26},
        {   -43,     26},
        {    13,     13},
        {   -25,     41},
        {    -5,     -1},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 117 */
        {   -16,      5},
        {   -25,    -42},
        {     2,     -2},
        {   -49,    -30},
        {     1,     -4},
        {  -121,     -9},
        {    -9,    -62},
        {  -264,    109},
        {  -307,   -422},
        {   -12,     14},
        { -1334,   -679},
        {   728,  -3034},
        {  3716,      0},
        {   657,   2738},
        {  -998,    508},
        {   122,    143},
        {  -303,    417},
        {  -181,    -75},
        {   -16,    102},
        {   -99,      7},
        {     8,     26},
        {   -43,     26},
        {    13,     13},
        {   -25,     41},
        {    -5,     -1},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 118 */
        {   -17,      5},
        {   -25,    -42},
        {     2,     -2},
        {   -49,    -30},
        {     1,     -3},
        {  -121,     -9},
        {    -9,    -61},
        {  -266,    110},
        {  -307,   -422},
        {   -16,     19},
        { -1342,   -683},
        {   730,  -3041},
        {  3715,      0},
        {   655,   2731},
        {  -991,    504},
        {   125,    146},
        {  -303,    417},
        {  -179,    -74},
        {   -16,    103},
        {   -98,      7},
        {     8,     27},
        {   -43,     26},
        {    13,     13},
        {   -25,     41},
        {    -5,     -1},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 119 */
        {   -17,      5},
        {   -25,    -42},
        {     1,     -1},
        {   -49,    -30},
        {     0,     -3},
        {  -122,     -9},
        {    -9,    -60},
        {  -268,    111},
        {  -306,   -422},
        {   -19,     23},
        { -1350,   -688},
        {   731,  -3047},
        {  3714,      0},
        {   653,   2723},
        {  -983,    501},
        {   127,    149},
        {  -302,    416},
        {  -178,    -73},
        {   -16,    104},
        {   -98,      7},
        {     9,     27},
        {   -43,     26},
        {    14,     14},
        {   -25,     40},
        {    -5,     -1},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 120 */
        {   -17,      5},
        {   -25,    -42},
        {     1,     -1},
        {   -49,    -30},
        {     0,     -2},
        {  -122,     -9},
        {    -9,    -58},
        {  -270,    111},
        {  -306,   -422},
        {   -23,     27},
        { -1358,   -692},
        {   733,  -3054},
        {  3713,      0},
        {   652,   2716},
        {  -975,    497},
        {   130,    152},
        {  -302,    416},
        {  -176,    -72},
        {   -16,    104},
        {   -97,      7},
        {     9,     28},
        {   -42,     26},
        {    14,     14},
        {   -25,     40},
        {    -4,     -1},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 121 */
        {   -17,      5},
        {   -25,    -42},
        {     1,     -1},
        {   -49,    -30},
        {     0,     -1},
        {  -122,     -9},
        {    -9,    -57},
        {  -271,    112},
        {  -306,   -421},
        {   -27,     31},
        { -1366,   -696},
        {   734,  -3060},
        {  3712,      0},
        {   650,   2708},
        {  -967,    493},
        {   133,    156},
        {  -302,    415},
        {  -174,    -72},
        {   -16,    105},
        {   -96,      7},
        {     9,     28},
        {   -42,     26},
        {    14,     14},
        {   -25,     40},
        {    -4,     -1},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 122 */
        {   -18,      5},
        {   -25,    -42},
        {     0,      0},
        {   -49,    -30},
        {     0,     -1},
        {  -123,     -9},
        {    -8,    -56},
        {  -273,    113},
        {  -306,   -421},
        {   -30,     36},
        { -1374,   -700},
        {   736,  -3066},
        {  3711,      0},
        {   648,   2700},
        {  -960,    489},
        {   136,    159},
        {  -301,    415},
        {  -172,    -71},
        {   -16,    106},
        {   -96,      7},
        {     9,     29},
        {   -42,     26},
        {    14,     14},
        {   -24,     40},
        {    -4,     -1},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 123 */
        {   -18,      5},
        {   -25,    -42},
        {     0,      0},
        {   -50,    -30},
        {     0,      0},
        {  -123,     -9},
        {    -8,    -55},
        {  -275,    114},
        {  -306,   -421},
        {   -34,     40},
        { -1382,   -704},
        {   737,  -3073},
        {  3710,      0},
        {   646,   2693},
        {  -952,    485},
        {   138,    162},
        {  -301,    414},
        {  -170,    -70},
        {   -16,    106},
        {   -95,      7},
        {     9,     29},
        {   -42,     25},
        {    15,     15},
        {   -24,     40},
        {    -4,     -1},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 124 */
        {   -18,      6},
        {   -25,    -42},
        {     0,      0},
        {   -50,    -30},
        {     0,      0},
        {  -124,     -9},
        {    -8,    -54},
        {  -277,    115},
        {  -305,   -420},
        {   -38,     44},
        { -1391,   -708},
        {   739,  -3079},
        {  3708,      0},
        {   644,   2685},
        {  -944,    481},
        {   141,    165},
        {  -301,    414},
        {  -168,    -69},
        {   -17,    107},
        {   -95,      7},
        {     9,     30},
        {   -42,     25},
        {    15,     15},
        {   -24,     40},
        {    -3,     -1},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 125 */
        {   -18,      6},
        {   -25,    -41},
        {     0,      0},
        {   -50,    -30},
        {     0,      0},
        {  -124,     -9},
        {    -8,    -52},
        {  -279,    115},
        {  -305,   -420},
        {   -41,     49},
        { -1399,   -712},
        {   740,  -3085},
        {  3707,      0},
        {   642,   2677},
        {  -936,    477},
        {   144,    168},
        {  -300,    413},
        {  -166,    -68},
        {   -17,    108},
        {   -94,      7},
        {     9,     30},
        {   -41,     25},
        {    15,     15},
        {   -24,     40},
        {    -3,     -1},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 126 */
        {   -19,      6},
        {   -25,    -41},
        {     0,      0},
        {   -50,    -30},
        {     0,      1},
        {  -124,     -9},
        {    -8,    -51},
        {  -281,    116},
        {  -305,   -420},
        {   -45,     53},
        { -1407,   -717},
        {   742,  -3091},
        {  3706,      0},
        {   640,   2669},
        {  -929,    473},
        {   146,    171},
        {  -300,    413},
        {  -164,    -68},
        {   -17,    108},
        {   -93,      7},
        {    10,     31},
        {   -41,     25},
        {    15,     15},
        {   -24,     40},
        {    -3,     -1},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 127 */
        {   -19,      6},
        {   -25,    -41},
        {     0,      0},
        {   -50,    -30},
        {     0,      1},
        {  -125,     -9},
        {    -7,    -50},
        {  -283,    117},
        {  -304,   -419},
        {   -49,     57},
        { -1415,   -721},
        {   743,  -3098},
        {  3705,      0},
        {   639,   2662},
        {  -921,    469},
        {   149,    174},
        {  -299,    412},
        {  -162,    -67},
        {   -17,    109},
        {   -93,      7},
        {    10,     31},
        {   -41,     25},
        {    16,     16},
        {   -24,     40},
        {    -3,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 128 */
        {   -19,      6},
        {   -25,    -41},
        {     0,      0},
        {   -50,    -30},
        {     0,      2},
        {  -125,     -9},
        {    -7,    -49},
        {  -285,    118},
        {  -304,   -419},
        {   -53,     62},
        { -1423,   -725},
        {   745,  -3104},
        {  3703,      0},
        {   637,   2654},
        {  -913,    465},
        {   152,    178},
        {  -299,    412},
        {  -160,    -66},
        {   -17,    110},
        {   -92,      7},
        {    10,     31},
        {   -41,     25},
        {    16,     16},
        {   -24,     40},
        {    -2,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 129 */
        {   -19,      6},
        {   -25,    -41},
        {    -1,      1},
        {   -50,    -30},
        {    -1,      3},
        {  -125,     -9},
        {    -7,    -47},
        {  -287,    119},
        {  -304,   -418},
        {   -57,     66},
        { -1431,   -729},
        {   746,  -3110},
        {  3702,      0},
        {   635,   2646},
        {  -906,    461},
        {   154,    181},
        {  -298,    411},
        {  -158,    -65},
        {   -17,    110},
        {   -91,      7},
        {    10,     32},
        {   -40,     25},
        {    16,     16},
        {   -24,     40},
        {    -2,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 130 */
        {   -20,      6},
        {   -25,    -41},
        {    -1,      1},
        {   -50,    -30},
        {    -1,      3},
        {  -126,     -9},
        {    -7,    -46},
        {  -289,    119},
        {  -303,   -418},
        {   -60,     71},
        { -1439,   -733},
        {   748,  -3116},
        {  3700,      0},
        {   633,   2638},
        {  -898,    457},
        {   157,    184},
        {  -298,    410},
        {  -156,    -64},
        {   -17,    111},
        {   -91,      7},
        {    10,     32},
        {   -40,     24},
        {    16,     16},
        {   -24,     40},
        {    -2,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 131 */
        {   -20,      6},
        {   -25,    -41},
        {    -1,      1},
        {   -50,    -30},
        {    -1,      4},
        {  -126,     -9},
        {    -7,    -45},
        {  -291,    120},
        {  -303,   -417},
        {   -64,     75},
        { -1448,   -737},
        {   749,  -3122},
        {  3699,      0},
        {   631,   2630},
        {  -890,    453},
        {   159,    187},
        {  -297,    410},
        {  -154,    -64},
        {   -17,    112},
        {   -90,      7},
        {    10,     33},
        {   -40,     24},
        {    17,     17},
        {   -24,     39},
        {    -2,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 132 */
        {   -20,      6},
        {   -25,    -41},
        {    -1,      1},
        {   -50,    -30},
        {    -1,      5},
        {  -126,     -9},
        {    -6,    -44},
        {  -293,    121},
        {  -303,   -417},
        {   -68,     80},
        { -1456,   -742},
        {   751,  -3128},
        {  3697,      0},
        {   629,   2623},
        {  -883,    450},
        {   162,    190},
        {  -297,    409},
        {  -152,    -63},
        {   -17,    112},
        {   -89,      7},
        {    10,     33},
        {   -40,     24},
        {    17,     17},
        {   -24,     39},
        {    -1,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 133 */
        {   -20,      6},
        {   -25,    -41},
        {    -2,      2},
        {   -50,    -30},
        {    -1,      5},
        {  -127,    -10},
        {    -6,    -42},
        {  -294,    122},
        {  -302,   -416},
        {   -72,     84},
        { -1464,   -746},
        {   752,  -3134},
        {  3696,      0},
        {   627,   2615},
        {  -875,    446},
        {   164,    193},
        {  -296,    408},
        {  -150,    -62},
        {   -17,    113},
        {   -89,      7},
        {    11,     34},
        {   -39,     24},
        {    17,     17},
        {   -24,     39},
        {    -1,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 134 */
        {   -21,      6},
        {   -25,    -41},
        {    -2,      2},
        {   -50,    -30},
        {    -2,      6},
        {  -127,    -10},
        {    -6,    -41},
        {  -296,    122},
        {  -302,   -416},
        {   -76,     89},
        { -1472,   -750},
        {   754,  -3140},
        {  3694,      0},
        {   625,   2607},
        {  -868,    442},
        {   167,    195},
        {  -296,    408},
        {  -149,    -61},
        {   -18,    114},
        {   -88,      6},
        {    11,     34},
        {   -39,     24},
        {    17,     17},
        {   -24,     39},
        {    -1,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 135 */
        {   -21,      6},
        {   -25,    -41},
        {    -2,      2},
        {   -50,    -31},
        {    -2,      6},
        {  -127,    -10},
        {    -6,    -40},
        {  -298,    123},
        {  -302,   -415},
        {   -80,     94},
        { -1480,   -754},
        {   755,  -3146},
        {  3692,      0},
        {   624,   2599},
        {  -860,    438},
        {   169,    198},
        {  -295,    407},
        {  -147,    -60},
        {   -18,    114},
        {   -87,      6},
        {    11,     34},
        {   -39,     24},
        {    18,     18},
        {   -24,     39},
        {    -1,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 136 */
        {   -21,      7},
        {   -25,    -41},
        {    -3,      3},
        {   -50,    -31},
        {    -2,      7},
        {  -128,    -10},
        {    -6,    -38},
        {  -300,    124},
        {  -301,   -415},
        {   -84,     98},
        { -1488,   -758},
        {   756,  -3152},
        {  3691,      0},
        {   622,   2591},
        {  -852,    434},
        {   172,    201},
        {  -295,    406},
        {  -145,    -60},
        {   -18,    115},
        {   -87,      6},
        {    11,     35},
        {   -39,     24},
        {    18,     18},
        {   -24,     39},
        {     0,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 137 */
        {   -21,      7},
        {   -25,    -41},
        {    -3,      3},
        {   -50,    -31},
        {    -2,      8},
        {  -128,    -10},
        {    -5,    -37},
        {  -302,    125},
        {  -301,   -414},
        {   -88,    103},
        { -1497,   -762},
        {   758,  -3158},
        {  3689,      0},
        {   620,   2583},
        {  -845,    430},
        {   174,    204},
        {  -294,    405},
        {  -143,    -59},
        {   -18,    115},
        {   -86,      6},
        {    11,     35},
        {   -39,     23},
        {    18,     18},
        {   -24,     39},
        {     0,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 138 */
        {   -22,      7},
        {   -25,    -41},
        {    -3,      3},
        {   -50,    -31},
        {    -2,      8},
        {  -128,    -10},
        {    -5,    -36},
        {  -304,    126},
        {  -300,   -413},
        {   -92,    107},
        { -1505,   -767},
        {   759,  -3164},
        {  3687,      0},
        {   618,   2575},
        {  -837,    426},
        {   177,    207},
        {  -294,    405},
        {  -141,    -58},
        {   -18,    116},
        {   -85,      6},
        {    11,     36},
        {   -38,     23},
        {    18,     18},
        {   -24,     39},
        {     0,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 139 */
        {   -22,      7},
        {   -25,    -41},
        {    -3,      3},
        {   -50,    -31},
        {    -3,      9},
        {  -129,    -10},
        {    -5,    -34},
        {  -306,    126},
        {  -300,   -413},
        {   -96,    112},
        { -1513,   -771},
        {   761,  -3170},
        {  3685,      0},
        {   616,   2567},
        {  -830,    423},
        {   179,    210},
        {  -293,    404},
        {  -139,    -57},
        {   -18,    116},
        {   -85,      6},
        {    11,     36},
        {   -38,     23},
        {    18,     18},
        {   -24,     39},
        {     0,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 140 */
        {   -22,      7},
        {   -25,    -41},
        {    -4,      4},
        {   -50,    -31},
        {    -3,     10},
        {  -129,    -10},
        {    -5,    -33},
        {  -308,    127},
        {  -299,   -412},
        {  -100,    117},
        { -1521,   -775},
        {   762,  -3175},
        {  3683,      0},
        {   614,   2559},
        {  -822,    419},
        {   182,    213},
        {  -293,    403},
        {  -137,    -56},
        {   -18,    117},
        {   -84,      6},
        {    11,     36},
        {   -38,     23},
        {    19,     19},
        {   -23,     39},
        {     0,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 141 */
        {   -23,      7},
        {   -25,    -41},
        {    -4,      4},
        {   -50,    -31},
        {    -3,     10},
        {  -129,    -10},
        {    -5,    -32},
        {  -309,    128},
        {  -299,   -411},
        {  -104,    121},
        { -1529,   -779},
        {   763,  -3181},
        {  3681,      0},
        {   612,   2551},
        {  -815,    415},
        {   184,    215},
        {  -292,    402},
        {  -135,    -56},
        {   -18,    118},
        {   -83,      6},
        {    12,     37},
        {   -38,     23},
        {    19,     19},
        {   -23,     38},
        {     0,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 142 */
        {   -23,      7},
        {   -25,    -41},
        {    -4,      4},
        {   -50,    -31},
        {    -3,     11},
        {  -129,    -10},
        {    -4,    -30},
        {  -311,    129},
        {  -298,   -411},
        {  -108,    126},
        { -1538,   -783},
        {   765,  -3187},
        {  3679,      0},
        {   610,   2543},
        {  -807,    411},
        {   186,    218},
        {  -292,    402},
        {  -133,    -55},
        {   -18,    118},
        {   -83,      6},
        {    12,     37},
        {   -37,     23},
        {    19,     19},
        {   -23,     38},
        {     0,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 143 */
        {   -23,      7},
        {   -25,    -41},
        {    -5,      5},
        {   -50,    -31},
        {    -3,     12},
        {  -130,    -10},
        {    -4,    -29},
        {  -313,    129},
        {  -298,   -410},
        {  -112,    131},
        { -1546,   -787},
        {   766,  -3193},
        {  3677,      0},
        {   608,   2535},
        {  -800,    407},
        {   189,    221},
        {  -291,    401},
        {  -131,    -54},
        {   -18,    119},
        {   -82,      6},
        {    12,     38},
        {   -37,     22},
        {    19,     19},
        {   -23,     38},
        {     0,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 144 */
        {   -23,      7},
        {   -25,    -40},
        {    -5,      5},
        {   -50,    -31},
        {    -4,     12},
        {  -130,    -10},
        {    -4,    -28},
        {  -315,    130},
        {  -297,   -409},
        {  -116,    136},
        { -1554,   -792},
        {   767,  -3198},
        {  3675,      0},
        {   606,   2527},
        {  -792,    403},
        {   191,    224},
        {  -290,    400},
        {  -130,    -53},
        {   -18,    119},
        {   -81,      6},
        {    12,     38},
        {   -37,     22},
        {    20,     20},
        {   -23,     38},
        {     1,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 145 */
        {   -24,      7},
        {   -25,    -40},
        {    -5,      5},
        {   -50,    -31},
        {    -4,     13},
        {  -130,    -10},
        {    -4,    -26},
        {  -317,    131},
        {  -297,   -408},
        {  -120,    140},
        { -1562,   -796},
        {   769,  -3204},
        {  3673,      0},
        {   604,   2519},
        {  -785,    400},
        {   193,    226},
        {  -290,    399},
        {  -128,    -53},
        {   -19,    120},
        {   -81,      6},
        {    12,     38},
        {   -36,     22},
        {    20,     20},
        {   -23,     38},
        {     1,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 146 */
        {   -24,      7},
        {   -24,    -40},
        {    -5,      5},
        {   -50,    -31},
        {    -4,     14},
        {  -130,    -10},
        {    -4,    -25},
        {  -319,    132},
        {  -296,   -408},
        {  -124,    145},
        { -1570,   -800},
        {   770,  -3210},
        {  3671,      0},
        {   602,   2510},
        {  -777,    396},
        {   195,    229},
        {  -289,    398},
        {  -126,    -52},
        {   -19,    120},
        {   -80,      6},
        {    12,     39},
        {   -36,     22},
        {    20,     20},
        {   -23,     38},
        {     1,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 147 */
        {   -24,      7},
        {   -24,    -40},
        {    -6,      6},
        {   -50,    -31},
        {    -4,     14},
        {  -131,    -10},
        {    -3,    -23},
        {  -321,    133},
        {  -295,   -407},
        {  -128,    150},
        { -1578,   -804},
        {   771,  -3215},
        {  3669,      0},
        {   600,   2502},
        {  -770,    392},
        {   198,    232},
        {  -289,    397},
        {  -124,    -51},
        {   -19,    121},
        {   -79,      6},
        {    12,     39},
        {   -36,     22},
        {    20,     20},
        {   -23,     38},
        {     1,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 148 */
        {   -24,      8},
        {   -24,    -40},
        {    -6,      6},
        {   -50,    -31},
        {    -4,     15},
        {  -131,    -10},
        {    -3,    -22},
        {  -322,    133},
        {  -295,   -406},
        {  -132,    155},
        { -1587,   -808},
        {   773,  -3221},
        {  3667,      0},
        {   598,   2494},
        {  -763,    388},
        {   200,    234},
        {  -288,    397},
        {  -122,    -50},
        {   -19,    121},
        {   -79,      6},
        {    12,     39},
        {   -36,     22},
        {    20,     20},
        {   -23,     38},
        {     2,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 149 */
        {   -25,      8},
        {   -24,    -40},
        {    -6,      6},
        {   -50,    -31},
        {    -5,     16},
        {  -131,    -10},
        {    -3,    -21},
        {  -324,    134},
        {  -294,   -405},
        {  -136,    160},
        { -1595,   -812},
        {   774,  -3226},
        {  3664,      0},
        {   596,   2486},
        {  -755,    385},
        {   202,    237},
        {  -287,    396},
        {  -120,    -49},
        {   -19,    122},
        {   -78,      6},
        {    13,     40},
        {   -35,     22},
        {    21,     21},
        {   -23,     38},
        {     2,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 150 */
        {   -25,      8},
        {   -24,    -40},
        {    -7,      7},
        {   -50,    -31},
        {    -5,     16},
        {  -131,    -10},
        {    -3,    -19},
        {  -326,    135},
        {  -294,   -404},
        {  -141,    165},
        { -1603,   -817},
        {   775,  -3232},
        {  3662,      0},
        {   594,   2478},
        {  -748,    381},
        {   204,    239},
        {  -287,    395},
        {  -118,    -49},
        {   -19,    122},
        {   -77,      6},
        {    13,     40},
        {   -35,     21},
        {    21,     21},
        {   -23,     37},
        {     2,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 151 */
        {   -25,      8},
        {   -24,    -40},
        {    -7,      7},
        {   -50,    -31},
        {    -5,     17},
        {  -132,    -10},
        {    -2,    -18},
        {  -328,    136},
        {  -293,   -403},
        {  -145,    170},
        { -1611,   -821},
        {   777,  -3237},
        {  3660,      0},
        {   593,   2470},
        {  -740,    377},
        {   207,    242},
        {  -286,    394},
        {  -116,    -48},
        {   -19,    122},
        {   -77,      6},
        {    13,     40},
        {   -35,     21},
        {    21,     21},
        {   -23,     37},
        {     2,      0},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 152 */
        {   -25,      8},
        {   -24,    -40},
        {    -7,      7},
        {   -50,    -31},
        {    -5,     18},
        {  -132,    -10},
        {    -2,    -16},
        {  -330,    136},
        {  -292,   -403},
        {  -149,    174},
        { -1619,   -825},
        {   778,  -3242},
        {  3657,      0},
        {   591,   2461},
        {  -733,    373},
        {   209,    245},
        {  -285,    393},
        {  -115,    -47},
        {   -19,    123},
        {   -76,      6},
        {    13,     41},
        {   -35,     21},
        {    21,     21},
        {   -23,     37},
        {     3,      1},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 153 */
        {   -26,      8},
        {   -24,    -40},
        {    -8,      8},
        {   -50,    -30},
        {    -6,     18},
        {  -132,    -10},
        {    -2,    -15},
        {  -332,    137},
        {  -292,   -402},
        {  -153,    179},
        { -1628,   -829},
        {   779,  -3248},
        {  3655,      0},
        {   589,   2453},
        {  -726,    370},
        {   211,    247},
        {  -285,    392},
        {  -113,    -46},
        {   -19,    123},
        {   -75,      5},
        {    13,     41},
        {   -34,     21},
        {    21,     21},
        {   -22,     37},
        {     3,      1},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 154 */
        {   -26,      8},
        {   -24,    -40},
        {    -8,      8},
        {   -50,    -30},
        {    -6,     19},
        {  -132,    -10},
        {    -2,    -13},
        {  -333,    138},
        {  -291,   -401},
        {  -157,    184},
        { -1636,   -833},
        {   781,  -3253},
        {  3652,      0},
        {   587,   2445},
        {  -718,    366},
        {   213,    250},
        {  -284,    391},
        {  -111,    -46},
        {   -19,    124},
        {   -75,      5},
        {    13,     41},
        {   -34,     21},
        {    22,     22},
        {   -22,     37},
        {     3,      1},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 155 */
        {   -26,      8},
        {   -24,    -39},
        {    -8,      8},
        {   -50,    -30},
        {    -6,     20},
        {  -132,    -10},
        {    -1,    -12},
        {  -335,    139},
        {  -290,   -400},
        {  -162,    189},
        { -1644,   -837},
        {   782,  -3258},
        {  3650,      0},
        {   585,   2437},
        {  -711,    362},
        {   215,    252},
        {  -283,    390},
        {  -109,    -45},
        {   -19,    124},
        {   -74,      5},
        {    13,     42},
        {   -34,     21},
        {    22,     22},
        {   -22,     37},
        {     3,      1},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 156 */
        {   -26,      8},
        {   -24,    -39},
        {    -8,      8},
        {   -50,    -30},
        {    -6,     20},
        {  -133,    -10},
        {    -1,    -10},
        {  -337,    139},
        {  -290,   -399},
        {  -166,    194},
        { -1652,   -842},
        {   783,  -3264},
        {  3647,      0},
        {   583,   2428},
        {  -704,    358},
        {   217,    254},
        {  -283,    389},
        {  -107,    -44},
        {   -19,    125},
        {   -73,      5},
        {    13,     42},
        {   -34,     20},
        {    22,     22},
        {   -22,     37},
        {     4,      1},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 157 */
        {   -26,      8},
        {   -24,    -39},
        {    -9,      9},
        {   -50,    -30},
        {    -6,     21},
        {  -133,    -10},
        {    -1,     -9},
        {  -339,    140},
        {  -289,   -398},
        {  -170,    199},
        { -1660,   -846},
        {   784,  -3269},
        {  3645,      0},
        {   581,   2420},
        {  -697,    355},
        {   219,    257},
        {  -282,    388},
        {  -105,    -43},
        {   -19,    125},
        {   -72,      5},
        {    13,     42},
        {   -33,     20},
        {    22,     22},
        {   -22,     36},
        {     4,      1},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 158 */
        {   -27,      8},
        {   -24,    -39},
        {    -9,      9},
        {   -50,    -30},
        {    -7,     22},
        {  -133,    -10},
        {    -1,     -7},
        {  -340,    141},
        {  -288,   -397},
        {  -174,    204},
        { -1668,   -850},
        {   786,  -3274},
        {  3642,      0},
        {   579,   2412},
        {  -689,    351},
        {   221,    259},
        {  -281,    387},
        {  -104,    -43},
        {   -19,    125},
        {   -72,      5},
        {    14,     43},
        {   -33,     20},
        {    22,     22},
        {   -22,     36},
        {     4,      1},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 159 */
        {   -27,      8},
        {   -24,    -39},
        {    -9,      9},
        {   -50,    -30},
        {    -7,     22},
        {  -133,    -10},
        {    -1,     -6},
        {  -342,    141},
        {  -287,   -396},
        {  -179,    209},
        { -1677,   -854},
        {   787,  -3279},
        {  3639,      0},
        {   577,   2403},
        {  -682,    347},
        {   223,    262},
        {  -280,    386},
        {  -102,    -42},
        {   -19,    126},
        {   -71,      5},
        {    14,     43},
        {   -33,     20},
        {    23,     23},
        {   -22,     36},
        {     4,      1},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 160 */
        {   -27,      9},
        {   -24,    -39},
        {   -10,     10},
        {   -50,    -30},
        {    -7,     23},
        {  -133,    -10},
        {     0,     -4},
        {  -344,    142},
        {  -287,   -395},
        {  -183,    214},
        { -1685,   -858},
        {   788,  -3284},
        {  3637,      0},
        {   575,   2395},
        {  -675,    344},
        {   225,    264},
        {  -280,    385},
        {  -100,    -41},
        {   -20,    126},
        {   -70,      5},
        {    14,     43},
        {   -32,     20},
        {    23,     23},
        {   -22,     36},
        {     5,      1},
        {    -2,     27},
    },
    {
        {    -2,    -27},   /* Filter 161 */
        {   -27,      9},
        {   -24,    -39},
        {   -10,     10},
        {   -50,    -30},
        {    -7,     24},
        {  -133,    -10},
        {     0,     -3},
        {  -346,    143},
        {  -286,   -394},
        {  -187,    220},
        { -1693,   -862},
        {   789,  -3290},
        {  3634,      0},
        {   573,   2387},
        {  -668,    340},
        {   227,    266},
        {  -279,    384},
        {   -98,    -40},
        {   -20,    126},
        {   -70,      5},
        {    14,     44},
        {   -32,     19},
        {    23,     23},
        {   -22,     36},
        {     5,      1},
        {    -2,     27},
    },
    {
        {    -2,    -26},   /* Filter 162 */
        {   -28,      9},
        {   -24,    -39},
        {   -10,     10},
        {   -50,    -30},
        {    -8,     24},
        {  -134,    -10},
        {     0,     -1},
        {  -348,    144},
        {  -285,   -392},
        {  -192,    225},
        { -1701,   -866},
        {   791,  -3295},
        {  3631,      0},
        {   571,   2378},
        {  -660,    336},
        {   229,    269},
        {  -278,    383},
        {   -96,    -40},
        {   -20,    127},
        {   -69,      5},
        {    14,     44},
        {   -32,     19},
        {    23,     23},
        {   -22,     36},
        {     5,      1},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 163 */
        {   -28,      9},
        {   -23,    -39},
        {   -10,     10},
        {   -50,    -30},
        {    -8,     25},
        {  -134,    -10},
        {     0,      0},
        {  -349,    144},
        {  -284,   -391},
        {  -196,    230},
        { -1709,   -871},
        {   792,  -3300},
        {  3628,      0},
        {   569,   2370},
        {  -653,    333},
        {   231,    271},
        {  -277,    382},
        {   -94,    -39},
        {   -20,    127},
        {   -68,      5},
        {    14,     44},
        {   -32,     19},
        {    23,     23},
        {   -22,     36},
        {     5,      1},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 164 */
        {   -28,      9},
        {   -23,    -39},
        {   -11,     11},
        {   -50,    -30},
        {    -8,     26},
        {  -134,    -10},
        {     0,      1},
        {  -351,    145},
        {  -283,   -390},
        {  -201,    235},
        { -1717,   -875},
        {   793,  -3305},
        {  3625,      0},
        {   567,   2362},
        {  -646,    329},
        {   233,    273},
        {  -277,    381},
        {   -93,    -38},
        {   -20,    127},
        {   -67,      5},
        {    14,     45},
        {   -31,     19},
        {    24,     24},
        {   -22,     35},
        {     5,      1},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 165 */
        {   -28,      9},
        {   -23,    -38},
        {   -11,     11},
        {   -49,    -30},
        {    -8,     26},
        {  -134,    -10},
        {     0,      2},
        {  -353,    146},
        {  -282,   -389},
        {  -205,    240},
        { -1726,   -879},
        {   794,  -3310},
        {  3622,      0},
        {   565,   2353},
        {  -639,    325},
        {   235,    276},
        {  -276,    380},
        {   -91,    -37},
        {   -20,    128},
        {   -67,      5},
        {    14,     45},
        {   -31,     19},
        {    24,     24},
        {   -21,     35},
        {     6,      2},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 166 */
        {   -29,      9},
        {   -23,    -38},
        {   -11,     11},
        {   -49,    -30},
        {    -8,     27},
        {  -134,    -10},
        {     0,      4},
        {  -355,    147},
        {  -282,   -388},
        {  -209,    245},
        { -1734,   -883},
        {   795,  -3314},
        {  3619,      0},
        {   563,   2345},
        {  -632,    322},
        {   237,    278},
        {  -275,    379},
        {   -89,    -37},
        {   -20,    128},
        {   -66,      5},
        {    14,     45},
        {   -31,     19},
        {    24,     24},
        {   -21,     35},
        {     6,      2},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 167 */
        {   -29,      9},
        {   -23,    -38},
        {   -12,     12},
        {   -49,    -30},
        {    -9,     28},
        {  -134,    -10},
        {     0,      6},
        {  -356,    147},
        {  -281,   -387},
        {  -214,    251},
        { -1742,   -887},
        {   797,  -3319},
        {  3616,      0},
        {   560,   2336},
        {  -625,    318},
        {   239,    280},
        {  -274,    378},
        {   -87,    -36},
        {   -20,    128},
        {   -65,      5},
        {    14,     46},
        {   -30,     18},
        {    24,     24},
        {   -21,     35},
        {     6,      2},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 168 */
        {   -29,      9},
        {   -23,    -38},
        {   -12,     12},
        {   -49,    -30},
        {    -9,     28},
        {  -134,    -10},
        {     1,      7},
        {  -358,    148},
        {  -280,   -385},
        {  -218,    256},
        { -1750,   -891},
        {   798,  -3324},
        {  3613,      0},
        {   558,   2328},
        {  -618,    314},
        {   241,    282},
        {  -274,    377},
        {   -85,    -35},
        {   -20,    129},
        {   -65,      5},
        {    15,     46},
        {   -30,     18},
        {    24,     24},
        {   -21,     35},
        {     6,      2},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 169 */
        {   -29,      9},
        {   -23,    -38},
        {   -12,     12},
        {   -49,    -30},
        {    -9,     29},
        {  -134,    -10},
        {     1,      9},
        {  -360,    149},
        {  -279,   -384},
        {  -223,    261},
        { -1758,   -896},
        {   799,  -3329},
        {  3610,      0},
        {   556,   2319},
        {  -611,    311},
        {   243,    284},
        {  -273,    376},
        {   -84,    -34},
        {   -20,    129},
        {   -64,      5},
        {    15,     46},
        {   -30,     18},
        {    25,     25},
        {   -21,     35},
        {     7,      2},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 170 */
        {   -30,      9},
        {   -23,    -38},
        {   -12,     12},
        {   -49,    -30},
        {    -9,     30},
        {  -135,    -10},
        {     1,     10},
        {  -361,    149},
        {  -278,   -383},
        {  -227,    266},
        { -1766,   -900},
        {   800,  -3334},
        {  3607,      0},
        {   554,   2311},
        {  -604,    307},
        {   245,    286},
        {  -272,    374},
        {   -82,    -34},
        {   -20,    129},
        {   -63,      5},
        {    15,     46},
        {   -29,     18},
        {    25,     25},
        {   -21,     35},
        {     7,      2},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 171 */
        {   -30,      9},
        {   -23,    -38},
        {   -13,     13},
        {   -49,    -30},
        {   -10,     30},
        {  -135,    -10},
        {     1,     12},
        {  -363,    150},
        {  -277,   -382},
        {  -232,    272},
        { -1774,   -904},
        {   801,  -3339},
        {  3604,      0},
        {   552,   2302},
        {  -597,    304},
        {   246,    289},
        {  -271,    373},
        {   -80,    -33},
        {   -20,    129},
        {   -62,      4},
        {    15,     47},
        {   -29,     18},
        {    25,     25},
        {   -21,     34},
        {     7,      2},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 172 */
        {   -30,      9},
        {   -23,    -37},
        {   -13,     13},
        {   -49,    -30},
        {   -10,     31},
        {  -135,    -10},
        {     2,     14},
        {  -365,    151},
        {  -276,   -380},
        {  -236,    277},
        { -1782,   -908},
        {   802,  -3343},
        {  3600,      0},
        {   550,   2294},
        {  -590,    300},
        {   248,    291},
        {  -270,    372},
        {   -78,    -32},
        {   -20,    130},
        {   -62,      4},
        {    15,     47},
        {   -29,     17},
        {    25,     25},
        {   -21,     34},
        {     7,      2},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 173 */
        {   -30,      9},
        {   -23,    -37},
        {   -13,     13},
        {   -49,    -30},
        {   -10,     32},
        {  -135,    -10},
        {     2,     15},
        {  -366,    151},
        {  -275,   -379},
        {  -241,    282},
        { -1791,   -912},
        {   803,  -3348},
        {  3597,      0},
        {   548,   2285},
        {  -583,    297},
        {   250,    293},
        {  -269,    371},
        {   -77,    -31},
        {   -20,    130},
        {   -61,      4},
        {    15,     47},
        {   -29,     17},
        {    25,     25},
        {   -21,     34},
        {     8,      2},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 174 */
        {   -30,     10},
        {   -23,    -37},
        {   -14,     14},
        {   -49,    -30},
        {   -10,     33},
        {  -135,    -10},
        {     2,     17},
        {  -368,    152},
        {  -274,   -377},
        {  -245,    288},
        { -1799,   -916},
        {   804,  -3353},
        {  3594,      0},
        {   546,   2277},
        {  -576,    293},
        {   252,    295},
        {  -269,    370},
        {   -75,    -31},
        {   -20,    130},
        {   -60,      4},
        {    15,     47},
        {   -28,     17},
        {    25,     25},
        {   -21,     34},
        {     8,      2},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 175 */
        {   -31,     10},
        {   -23,    -37},
        {   -14,     14},
        {   -49,    -30},
        {   -10,     33},
        {  -135,    -10},
        {     2,     18},
        {  -370,    153},
        {  -273,   -376},
        {  -250,    293},
        { -1807,   -920},
        {   806,  -3357},
        {  3590,      0},
        {   544,   2268},
        {  -569,    289},
        {   253,    297},
        {  -268,    369},
        {   -73,    -30},
        {   -20,    130},
        {   -60,      4},
        {    15,     48},
        {   -28,     17},
        {    26,     26},
        {   -20,     34},
        {     8,      2},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 176 */
        {   -31,     10},
        {   -22,    -37},
        {   -14,     14},
        {   -48,    -29},
        {   -11,     34},
        {  -135,    -10},
        {     3,     20},
        {  -371,    154},
        {  -272,   -375},
        {  -255,    298},
        { -1815,   -925},
        {   807,  -3362},
        {  3587,      0},
        {   542,   2260},
        {  -562,    286},
        {   255,    299},
        {  -267,    368},
        {   -71,    -29},
        {   -20,    131},
        {   -59,      4},
        {    15,     48},
        {   -28,     17},
        {    26,     26},
        {   -20,     34},
        {     8,      2},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 177 */
        {   -31,     10},
        {   -22,    -37},
        {   -14,     14},
        {   -48,    -29},
        {   -11,     35},
        {  -135,    -10},
        {     3,     22},
        {  -373,    154},
        {  -271,   -373},
        {  -259,    304},
        { -1823,   -929},
        {   808,  -3366},
        {  3584,      0},
        {   540,   2251},
        {  -555,    282},
        {   257,    301},
        {  -266,    366},
        {   -70,    -29},
        {   -20,    131},
        {   -58,      4},
        {    15,     48},
        {   -27,     17},
        {    26,     26},
        {   -20,     33},
        {     8,      2},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 178 */
        {   -31,     10},
        {   -22,    -37},
        {   -15,     15},
        {   -48,    -29},
        {   -11,     35},
        {  -135,    -10},
        {     3,     23},
        {  -375,    155},
        {  -270,   -372},
        {  -264,    309},
        { -1831,   -933},
        {   809,  -3371},
        {  3580,      0},
        {   538,   2242},
        {  -548,    279},
        {   259,    303},
        {  -265,    365},
        {   -68,    -28},
        {   -20,    131},
        {   -57,      4},
        {    15,     48},
        {   -27,     16},
        {    26,     26},
        {   -20,     33},
        {     9,      2},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 179 */
        {   -32,     10},
        {   -22,    -36},
        {   -15,     15},
        {   -48,    -29},
        {   -11,     36},
        {  -135,    -10},
        {     4,     25},
        {  -376,    156},
        {  -269,   -370},
        {  -268,    314},
        { -1839,   -937},
        {   810,  -3375},
        {  3577,      0},
        {   536,   2234},
        {  -541,    275},
        {   260,    305},
        {  -264,    364},
        {   -66,    -27},
        {   -20,    131},
        {   -57,      4},
        {    15,     49},
        {   -27,     16},
        {    26,     26},
        {   -20,     33},
        {     9,      3},
        {    -2,     26},
    },
    {
        {    -2,    -26},   /* Filter 180 */
        {   -32,     10},
        {   -22,    -36},
        {   -15,     15},
        {   -48,    -29},
        {   -12,     37},
        {  -135,    -10},
        {     4,     27},
        {  -378,    156},
        {  -268,   -369},
        {  -273,    320},
        { -1847,   -941},
        {   811,  -3380},
        {  3573,      0},
        {   534,   2225},
        {  -534,    272},
        {   262,    307},
        {  -263,    363},
        {   -64,    -26},
        {   -20,    132},
        {   -56,      4},
        {    16,     49},
        {   -26,     16},
        {    27,     27},
        {   -20,     33},
        {     9,      3},
        {    -2,     26},
    },
    {
        {    -2,    -25},   /* Filter 181 */
        {   -32,     10},
        {   -22,    -36},
        {   -16,     16},
        {   -48,    -29},
        {   -12,     37},
        {  -135,    -10},
        {     4,     28},
        {  -380,    157},
        {  -267,   -367},
        {  -278,    325},
        { -1855,   -945},
        {   812,  -3384},
        {  3569,      0},
        {   532,   2217},
        {  -527,    268},
        {   263,    309},
        {  -263,    361},
        {   -63,    -26},
        {   -20,    132},
        {   -55,      4},
        {    16,     49},
        {   -26,     16},
        {    27,     27},
        {   -20,     33},
        {     9,      3},
        {    -2,     25},
    },
    {
        {    -2,    -25},   /* Filter 182 */
        {   -32,     10},
        {   -22,    -36},
        {   -16,     16},
        {   -48,    -29},
        {   -12,     38},
        {  -135,    -10},
        {     4,     30},
        {  -381,    158},
        {  -266,   -366},
        {  -282,    331},
        { -1863,   -949},
        {   813,  -3388},
        {  3566,      0},
        {   530,   2208},
        {  -520,    265},
        {   265,    310},
        {  -262,    360},
        {   -61,    -25},
        {   -20,    132},
        {   -54,      4},
        {    16,     49},
        {   -26,     16},
        {    27,     27},
        {   -20,     33},
        {     9,      3},
        {    -2,     25},
    },
    {
        {    -2,    -25},   /* Filter 183 */
        {   -33,     10},
        {   -22,    -36},
        {   -16,     16},
        {   -48,    -29},
        {   -12,     39},
        {  -135,    -10},
        {     5,     32},
        {  -383,    158},
        {  -264,   -364},
        {  -287,    336},
        { -1871,   -953},
        {   814,  -3393},
        {  3562,      0},
        {   528,   2199},
        {  -514,    261},
        {   267,    312},
        {  -261,    359},
        {   -59,    -24},
        {   -20,    132},
        {   -54,      4},
        {    16,     50},
        {   -25,     15},
        {    27,     27},
        {   -20,     32},
        {    10,      3},
        {    -2,     25},
    },
    {
        {    -2,    -25},   /* Filter 184 */
        {   -33,     10},
        {   -22,    -36},
        {   -16,     16},
        {   -47,    -29},
        {   -12,     39},
        {  -135,    -10},
        {     5,     33},
        {  -384,    159},
        {  -263,   -363},
        {  -292,    342},
        { -1880,   -957},
        {   815,  -3397},
        {  3558,      0},
        {   526,   2191},
        {  -507,    258},
        {   268,    314},
        {  -260,    358},
        {   -58,    -24},
        {   -21,    132},
        {   -53,      4},
        {    16,     50},
        {   -25,     15},
        {    27,     27},
        {   -20,     32},
        {    10,      3},
        {    -2,     25},
    },
    {
        {    -2,    -25},   /* Filter 185 */
        {   -33,     10},
        {   -22,    -36},
        {   -17,     17},
        {   -47,    -29},
        {   -13,     40},
        {  -135,    -10},
        {     5,     35},
        {  -386,    160},
        {  -262,   -361},
        {  -297,    347},
        { -1888,   -962},
        {   816,  -3401},
        {  3555,      0},
        {   524,   2182},
        {  -500,    255},
        {   270,    316},
        {  -259,    356},
        {   -56,    -23},
        {   -21,    132},
        {   -52,      4},
        {    16,     50},
        {   -25,     15},
        {    27,     27},
        {   -19,     32},
        {    10,      3},
        {    -2,     25},
    },
    {
        {    -2,    -25},   /* Filter 186 */
        {   -33,     10},
        {   -21,    -35},
        {   -17,     17},
        {   -47,    -29},
        {   -13,     41},
        {  -135,    -10},
        {     5,     37},
        {  -388,    160},
        {  -261,   -359},
        {  -301,    353},
        { -1896,   -966},
        {   817,  -3405},
        {  3551,      0},
        {   521,   2173},
        {  -493,    251},
        {   271,    318},
        {  -258,    355},
        {   -54,    -22},
        {   -21,    133},
        {   -52,      4},
        {    16,     50},
        {   -24,     15},
        {    27,     27},
        {   -19,     32},
        {    10,      3},
        {    -2,     25},
    },
    {
        {    -2,    -25},   /* Filter 187 */
        {   -33,     11},
        {   -21,    -35},
        {   -17,     17},
        {   -47,    -29},
        {   -13,     42},
        {  -135,    -10},
        {     6,     39},
        {  -389,    161},
        {  -260,   -358},
        {  -306,    359},
        { -1904,   -970},
        {   818,  -3409},
        {  3547,      0},
        {   519,   2165},
        {  -486,    248},
        {   273,    320},
        {  -257,    354},
        {   -53,    -21},
        {   -21,    133},
        {   -51,      4},
        {    16,     51},
        {   -24,     15},
        {    28,     28},
        {   -19,     32},
        {    11,      3},
        {    -2,     25},
    },
    {
        {    -2,    -25},   /* Filter 188 */
        {   -34,     11},
        {   -21,    -35},
        {   -17,     17},
        {   -47,    -28},
        {   -13,     42},
        {  -135,    -10},
        {     6,     40},
        {  -391,    162},
        {  -259,   -356},
        {  -311,    364},
        { -1912,   -974},
        {   819,  -3414},
        {  3543,      0},
        {   517,   2156},
        {  -480,    244},
        {   274,    321},
        {  -256,    353},
        {   -51,    -21},
        {   -21,    133},
        {   -50,      3},
        {    16,     51},
        {   -24,     14},
        {    28,     28},
        {   -19,     32},
        {    11,      3},
        {    -2,     25},
    },
    {
        {    -2,    -25},   /* Filter 189 */
        {   -34,     11},
        {   -21,    -35},
        {   -18,     18},
        {   -47,    -28},
        {   -14,     43},
        {  -135,    -10},
        {     6,     42},
        {  -392,    162},
        {  -257,   -354},
        {  -316,    370},
        { -1920,   -978},
        {   820,  -3418},
        {  3539,      0},
        {   515,   2147},
        {  -473,    241},
        {   276,    323},
        {  -255,    351},
        {   -49,    -20},
        {   -21,    133},
        {   -49,      3},
        {    16,     51},
        {   -23,     14},
        {    28,     28},
        {   -19,     31},
        {    11,      3},
        {    -2,     25},
    },
    {
        {    -1,    -25},   /* Filter 190 */
        {   -34,     11},
        {   -21,    -35},
        {   -18,     18},
        {   -47,    -28},
        {   -14,     44},
        {  -135,    -10},
        {     7,     44},
        {  -394,    163},
        {  -256,   -353},
        {  -320,    375},
        { -1928,   -982},
        {   821,  -3422},
        {  3535,      0},
        {   513,   2139},
        {  -466,    237},
        {   277,    325},
        {  -254,    350},
        {   -48,    -19},
        {   -21,    133},
        {   -49,      3},
        {    16,     51},
        {   -23,     14},
        {    28,     28},
        {   -19,     31},
        {    11,      3},
        {    -1,     25},
    },
    {
        {    -1,    -25},   /* Filter 191 */
        {   -34,     11},
        {   -21,    -35},
        {   -18,     18},
        {   -46,    -28},
        {   -14,     44},
        {  -135,    -10},
        {     7,     46},
        {  -395,    163},
        {  -255,   -351},
        {  -325,    381},
        { -1936,   -986},
        {   822,  -3426},
        {  3532,      0},
        {   511,   2130},
        {  -459,    234},
        {   279,    327},
        {  -253,    349},
        {   -46,    -19},
        {   -21,    133},
        {   -48,      3},
        {    16,     51},
        {   -23,     14},
        {    28,     28},
        {   -19,     31},
        {    11,      3},
        {    -1,     25},
    },
};

/*- End of file ------------------------------------------------------------*/
