-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
procedure down_wf_aggregate_or_expression
  (Node         : in     STree.SyntaxNode;
   EStack       : in out ExpStack.ExpStackType;
   IsAnnotation : in     Boolean;
   Next_Node    :    out STree.SyntaxNode) is
   AGG_LOOKUP       : constant Annotation_Symbol_Table :=
     Annotation_Symbol_Table'(False => SPSymbols.aggregate,
                              True  => SPSymbols.annotation_aggregate);
   POS_ASSOC_LOOKUP : constant Annotation_Symbol_Table :=
     Annotation_Symbol_Table'(False => SPSymbols.positional_association,
                              True  => SPSymbols.annotation_positional_association);

   NameExp, FieldName                                             : Exp_Record;
   RecordFieldFound, ReachedLastDimension, DoingEmbeddedAggregate : Boolean;

begin
   ExpStack.Pop (NameExp, EStack);
   if NameExp.Sort = Is_Parameter_Name then
      RecordFieldFound := True;
      FieldName        := NameExp;
      ExpStack.Pop (NameExp, EStack);
   else
      RecordFieldFound := False;
   end if;
   DoingEmbeddedAggregate := Syntax_Node_Type (Node => Child_Node (Node)) = AGG_LOOKUP (IsAnnotation);

   if Dictionary.IsUnknownTypeMark (NameExp.Type_Symbol) then
      ExpStack.Push (NameExp, EStack);
      if DoingEmbeddedAggregate then
         Next_Node := STree.NullNode;
      else
         Next_Node := Child_Node (Current_Node => Node);
      end if;
   elsif Dictionary.TypeIsArray (NameExp.Type_Symbol) then
      ExpStack.Push (NameExp, EStack);
      ReachedLastDimension := NameExp.Param_Count = Dictionary.GetNumberOfDimensions (NameExp.Type_Symbol);
      if ReachedLastDimension = DoingEmbeddedAggregate then
         Next_Node := STree.NullNode;
         ErrorHandler.Semantic_Error
           (Err_Num   => 38,
            Reference => ErrorHandler.No_Reference,
            Position  => Node_Position (Node => Child_Node (Node)),
            Id_Str    => LexTokenManager.Null_String);

         -- Clause below covers the case where not enough dimensions have been supplied.
         -- Because the tree walk has been pruned as a result of this error the expression
         -- is not traversed and not stacked; this is fine for positional association but
         -- in named association gives a stack underflow later on in either
         -- up_wf_named_association_rep or up_wf_component_association.  To cover these cases
         -- we must put something on the stack.  An UnknownTypeRecord seems appropriate.
         -- We only do this if the association is not positional

         if not ReachedLastDimension
           and then Syntax_Node_Type (Node => Parent_Node (Current_Node => Node)) /= SPSymbols.positional_association_rep
           and then Syntax_Node_Type (Node => Parent_Node (Current_Node => Node)) /= POS_ASSOC_LOOKUP (IsAnnotation) then
            ExpStack.Push (UnknownTypeRecord, EStack);
         end if;
      else
         Next_Node := Child_Node (Current_Node => Node);
      end if;

   else -- must be record
      ExpStack.Push (NameExp, EStack);
      if DoingEmbeddedAggregate then
         Next_Node := STree.NullNode;
         ErrorHandler.Semantic_Error
           (Err_Num   => 38,
            Reference => ErrorHandler.No_Reference,
            Position  => Node_Position (Node => Child_Node (Node)),
            Id_Str    => LexTokenManager.Null_String);
      else
         if RecordFieldFound then
            --# accept Flow, 504, FieldName, "Expected Fieldname to have undefined value";
            ExpStack.Push (FieldName, EStack);  -- expect error FieldName undefined
                                                --# end accept;
         end if;
         Next_Node := Child_Node (Current_Node => Node);
      end if;
   end if;
   --# accept Flow, 602, EStack, FieldName, "Fieldname always defined if needed";
end down_wf_aggregate_or_expression;  -- Fieldname always defined if needed
