-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
procedure up_wf_aggregate
  (Node         : in     STree.SyntaxNode;
   Scope        : in     Dictionary.Scopes;
   EStack       : in out ExpStack.ExpStackType;
   IsAnnotation : in     Boolean) is
   QUAL_EXP_LOOKUP : constant Annotation_Symbol_Table :=
     Annotation_Symbol_Table'(False => SPSymbols.qualified_expression,
                              True  => SPSymbols.annotation_qualified_expression);

   NameExp    : Exp_Record;
   ErrorFound : Boolean := False;

   --------------------------------------------------------------
   --    precondition: aggregate is an array of known type
   procedure CheckArrayCompleteness (Node : in STree.SyntaxNode)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in out AggregateStack.State;
   --#        in out ErrorFound;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives AggregateStack.State,
   --#         ErrorFound                 from *,
   --#                                         AggregateStack.State &
   --#         ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from AggregateStack.State,
   --#                                         CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table;
   is
      IndexTypeSymbol : Dictionary.Symbol;
      TypeLowerBound  : Typ_Type_Bound;
      TypeUpperBound  : Typ_Type_Bound;
      AggregateFlags  : Typ_Agg_Flags;
      EntryCounter    : Natural;
      ExpectedEntries : Natural;
      CompleteRec     : CompleteCheck.T;
   begin
      --# accept Flow, 10, IndexTypeSymbol, "Expect ineffective assignment";
      AggregateStack.Pop (IndexTypeSymbol, -- Expect ineffective assignment
                          TypeLowerBound, TypeUpperBound, AggregateFlags, EntryCounter, CompleteRec);
      --# end accept;

      if AggregateFlags.Has_Others_Part then
         CompleteCheck.SeenOthers (CompleteRec);
      end if;

      if AggregateFlags.Check_Completeness then
         if AggregateFlags.Association_Type = Aggregate_Is_Positional then
            if TypeLowerBound.Is_Defined and TypeUpperBound.Is_Defined then
               ExpectedEntries := (TypeUpperBound.Value - TypeLowerBound.Value) + 1;
               if AggregateFlags.More_Entries_Than_Natural or else EntryCounter > ExpectedEntries then
                  ErrorFound := True;
                  ErrorHandler.Semantic_Error
                    (Err_Num   => 415,
                     Reference => ErrorHandler.No_Reference,
                     Position  => Node_Position (Node => Parent_Node (Current_Node => Node)),
                     Id_Str    => LexTokenManager.Null_String);
               elsif EntryCounter < ExpectedEntries and not AggregateFlags.Has_Others_Part then
                  ErrorFound := True;
                  ErrorHandler.Semantic_Error
                    (Err_Num   => 414,
                     Reference => ErrorHandler.No_Reference,
                     Position  => Node_Position (Node => Parent_Node (Current_Node => Node)),
                     Id_Str    => LexTokenManager.Null_String);
               end if;
            end if;
         else  -- named association
            if CompleteRec.Undeterminable and not AggregateFlags.Has_Others_Part then
               ErrorHandler.Semantic_Warning
                 (Err_Num  => 306,
                  Position => Node_Position (Node => Parent_Node (Current_Node => Node)),
                  Id_Str   => LexTokenManager.Null_String);
            elsif CompleteCheck.IsComplete (CompleteRec) = CompleteCheck.Incomplete then
               ErrorFound := True;
               ErrorHandler.Semantic_Error
                 (Err_Num   => 414,
                  Reference => ErrorHandler.No_Reference,
                  Position  => Node_Position (Node => Parent_Node (Current_Node => Node)),
                  Id_Str    => LexTokenManager.Null_String);
            end if;
         end if;
      end if;

      if AggregateFlags.Signal_Out_Of_Range and AggregateFlags.Out_Of_Range_Seen then
         ErrorHandler.Semantic_Warning
           (Err_Num  => 303,
            Position => Node_Position (Node => Parent_Node (Current_Node => Node)),
            Id_Str   => LexTokenManager.Null_String);
      end if;

      if AggregateFlags.Warn_No_Others and
        not AggregateFlags.Has_Others_Part and
        not (AggregateFlags.Check_Completeness and                           -- don't output
               AggregateFlags.Association_Type /= Aggregate_Is_Positional and  -- 306
               CompleteRec.Undeterminable) then                             -- twice
         ErrorHandler.Semantic_Warning
           (Err_Num  => 306,
            Position => Node_Position (Node => Parent_Node (Current_Node => Node)),
            Id_Str   => LexTokenManager.Null_String);
      end if;
      --# accept Flow, 33, IndexTypeSymbol, "Expected to be neither referenced or exported";
   end CheckArrayCompleteness;

   -----------------------------------------------------------------
begin
   ExpStack.Pop (NameExp, EStack);
   if Syntax_Node_Type (Node => Parent_Node (Current_Node => Node)) = QUAL_EXP_LOOKUP (IsAnnotation) then   --this is a top level,
                                                                                                            --not embedded,
                                                                                                            --aggregate
      if not Dictionary.IsUnknownTypeMark (NameExp.Type_Symbol) then
         NameExp.Sort         := Type_Result;
         NameExp.Param_Count  := 0;
         NameExp.Param_List   := Lists.Null_List;
         NameExp.Other_Symbol := Dictionary.NullSymbol;
         NameExp.Is_ARange    := False;
         NameExp.Is_Static    := False;
         --constant should already be set
         if Dictionary.IsArrayTypeMark (NameExp.Type_Symbol, Scope) then
            CheckArrayCompleteness (Node);
         end if;
      end if;
   else --it is an embedded aggregate of a multi-dim array

      --decrease depth of dimension count
      NameExp.Param_Count := NameExp.Param_Count - 1;
      CheckArrayCompleteness (Node);
   end if;
   NameExp.Errors_In_Expression := NameExp.Errors_In_Expression or ErrorFound;
   ExpStack.Push (NameExp, EStack);
end up_wf_aggregate;
