-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with CommandLineData;
with STree;

use type CommandLineData.Language_Profiles; use type STree.Iterator; use type STree.SyntaxNode;

--# inherit Casing,
--#         CommandLineData,
--#         CompleteCheck,
--#         ComponentManager,
--#         ContextManager.Ops,
--#         Debug,
--#         Declarations,
--#         Dictionary,
--#         ErrorHandler,
--#         ExaminerConstants,
--#         E_Strings,
--#         FlowAnalyser,
--#         Graph,
--#         Heap,
--#         LexTokenManager,
--#         LexTokenManager.Relation_Algebra,
--#         LexTokenManager.Relation_Algebra.String,
--#         LexTokenManager.Seq_Algebra,
--#         Lists,
--#         Maths,
--#         RefList,
--#         RelationAlgebra,
--#         SeqAlgebra,
--#         SimpleLists,
--#         SLI,
--#         SPARK_IO,
--#         SPrint,
--#         SPSymbols,
--#         Statistics,
--#         StmtStack,
--#         STree,
--#         SystemErrors,
--#         VCG;
package Sem is

   procedure CompUnit (Top_Node : in STree.SyntaxNode;
                       Do_VCG   : in Boolean);
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.File_Heap;
   --#        in     ContextManager.Ops.Unit_Heap;
   --#        in     ContextManager.Ops.Unit_Stack;
   --#        in out Declarations.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.Error_Context;
   --#        in out Graph.Table;
   --#        in out LexTokenManager.State;
   --#        in out SLI.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Statistics.TableUsage;
   --#        in out StmtStack.S;
   --#        in out STree.Table;
   --#        in out VCG.Invoked;
   --# derives Declarations.State,
   --#         Dictionary.Dict,
   --#         ErrorHandler.Error_Context,
   --#         Graph.Table,
   --#         LexTokenManager.State,
   --#         SLI.State,
   --#         SPARK_IO.File_Sys,
   --#         Statistics.TableUsage,
   --#         StmtStack.S,
   --#         STree.Table,
   --#         VCG.Invoked                from *,
   --#                                         CommandLineData.Content,
   --#                                         ContextManager.Ops.File_Heap,
   --#                                         ContextManager.Ops.Unit_Heap,
   --#                                         ContextManager.Ops.Unit_Stack,
   --#                                         Dictionary.Dict,
   --#                                         Do_VCG,
   --#                                         ErrorHandler.Error_Context,
   --#                                         LexTokenManager.State,
   --#                                         SLI.State,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table,
   --#                                         Top_Node;

end Sem;
