-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (SPParserActions)
procedure ScanActionTable
  (StateNo      : in     SPProductions.ValidStates;
   Index        : in out ActionIndex;
   ParseAct     :    out SPParseAct;
   ActionSymbol :    out SPSymbols.SPTerminal) is
   IndexPair            : PackedPATIndexPair;
   TableIndex, MaxIndex : PATIndex;
   PackedResult         : PackedSymActionPair;
begin
   IndexPair  := StateTable (StateNo);
   TableIndex := PATIndex (IndexPair mod PATIndexSize);
   MaxIndex   := PATIndex (IndexPair / PATIndexSize);
   if ActionIndex (MaxIndex - TableIndex) < Index then
      ActionSymbol := SPSymbols.SPEND;
      ParseAct     := ErrorAction;
   else
      TableIndex   := PATIndex (Natural (TableIndex) + Natural (Index));
      Index        := Index + 1;
      ActionSymbol := SPSymbols.SPTerminal'Val ((ParseActionTable (TableIndex) / TermSym) mod TermSymLim);
      PackedResult := ParseActionTable (TableIndex);

      case SPActionKind'Val ((PackedResult / Act) mod ActLim) is
         when Shift =>
            ParseAct := SPParseAct'(Shift, SPProductions.SPState ((PackedResult / State) mod StateLim), NoSym, NoRed, NoProd);
         when Reduce =>
            ParseAct :=
              SPParseAct'
              (Reduce,
               SPProductions.NoState,
               SPSymbols.SPSymbol'Val ((PackedResult / Symbol) mod SymbolLim + FirstNonTerminal),
               SPProductions.SPRight ((PackedResult / RedBy) mod RedByLim),
               0);
         when Accpt =>
            ParseAct := AcceptAction;
         when Error =>               -- can never have this option
            ParseAct := ErrorAction;
      end case;
   end if;
end ScanActionTable;
