/*
/ Main.cpp
/ the main core of spatialite-gui  - a SQLite /SpatiaLite GUI tool
/
/ version 1.2, 2008 October 9
/
/ Author: Sandro Furieri a-furieri@lqt.it
/
/ Copyright (C) 2008  Alessandro Furieri
/
/    This program is free software: you can redistribute it and/or modify
/    it under the terms of the GNU General Public License as published by
/    the Free Software Foundation, either version 3 of the License, or
/    (at your option) any later version.
/
/    This program is distributed in the hope that it will be useful,
/    but WITHOUT ANY WARRANTY; without even the implied warranty of
/    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/    GNU General Public License for more details.
/
/    You should have received a copy of the GNU General Public License
/    along with this program.  If not, see <http://www.gnu.org/licenses/>.
/
*/

#include "Classdef.h"

#include "wx/menu.h"
#include "wx/aboutdlg.h"
#include "wx/filename.h"
#include "wx/config.h"

#include <spatialite.h>
#include <proj_api.h>
#include <geos_c.h>

//
// ICONs in XPM format [universally portable]
//
#include "icons/icon.xpm"
#include "icons/icon_info.xpm"
#include "icons/create_new.xpm"
#include "icons/connect.xpm"
#include "icons/disconnect.xpm"
#include "icons/memdb_load.xpm"
#include "icons/memdb_new.xpm"
#include "icons/memdb_clock.xpm"
#include "icons/memdb_save.xpm"
#include "icons/vacuum.xpm"
#include "icons/sql_script.xpm"
#include "icons/loadshp.xpm"
#include "icons/virtshp.xpm"
#include "icons/loadtxt.xpm"
#include "icons/virttxt.xpm"
#include "icons/network.xpm"
#include "icons/exif.xpm"
#include "icons/srids.xpm"
#include "icons/charset.xpm"
#include "icons/help.xpm"
#include "icons/about.xpm"
#include "icons/exit.xpm"

IMPLEMENT_APP(MyApp)
     bool MyApp::OnInit()
{
//
// main APP implementation
//
  wxString path;
  if (argc > 1)
    path = argv[1];
  MyFrame *frame =
    new MyFrame(wxT("spatialite-gui      [a GUI tool for SQLite/SpatiaLite]"),
                wxPoint(0, 0), wxSize(640, 480), path);
  frame->Show(true);
  SetTopWindow(frame);
  frame->LoadConfig();
  return true;
}

MyFrame::MyFrame(const wxString & title, const wxPoint & pos, const wxSize & size, wxString & path):
wxFrame((wxFrame *) NULL, -1, title, pos, size)
{
//
// main GUI frame constructor
//
  MemoryDatabase = false;
  AutoSaveInterval = 0;
  LastTotalChanges = 0;
  TimerAutoSave = NULL;
//
// initializing CHARSET lists
//
  CharsetsLen = 79;
  Charsets = new wxString[CharsetsLen];
  CharsetsNames = new wxString[CharsetsLen];
  *(CharsetsNames + 0) = wxT("ARMSCII-8    Armenian");
  *(CharsetsNames + 1) = wxT("ASCII        US-ASCII");
  *(CharsetsNames + 2) = wxT("BIG5         Chinese/Traditional");
  *(CharsetsNames + 3) = wxT("BIG5-HKSCS   Chinese/Hong Kong");
  *(CharsetsNames + 4) = wxT("BIG5-HKSCS:1999");
  *(CharsetsNames + 5) = wxT("BIG5-HKSCS:2001");
  *(CharsetsNames + 6) = wxT("CP850        DOS/OEM Western Europe");
  *(CharsetsNames + 7) = wxT("CP862        DOS/OEM Hebrew");
  *(CharsetsNames + 8) = wxT("CP866        DOS/OEM Cyrillic");
  *(CharsetsNames + 9) = wxT("CP874        DOS/OEM Thai");
  *(CharsetsNames + 10) = wxT("CP932        DOS/OEM Japanese");
  *(CharsetsNames + 11) = wxT("CP936        DOS/OEM Chinese");
  *(CharsetsNames + 12) = wxT("CP949        DOS/OEM Korean");
  *(CharsetsNames + 13) = wxT("CP950        DOS/OEM Chinese/Big5");
  *(CharsetsNames + 14) = wxT("CP1133       Laotian");
  *(CharsetsNames + 15) = wxT("CP1250       Windows Central Europe");
  *(CharsetsNames + 16) = wxT("CP1251       Windows Cyrillic");
  *(CharsetsNames + 17) = wxT("CP1252       Windows Latin 1");
  *(CharsetsNames + 18) = wxT("CP1253       Windows Greek");
  *(CharsetsNames + 19) = wxT("CP1254       Windows Turkish");
  *(CharsetsNames + 20) = wxT("CP1255       Windows Hebrew");
  *(CharsetsNames + 21) = wxT("CP1256       Windows Arabic");
  *(CharsetsNames + 22) = wxT("CP1257       Windows Baltic");
  *(CharsetsNames + 23) = wxT("CP1258       Windows Vietnamese");
  *(CharsetsNames + 24) = wxT("EUC-CN       Chinese");
  *(CharsetsNames + 25) = wxT("EUC-JP       Japanese");
  *(CharsetsNames + 26) = wxT("EUC-KR       Korean");
  *(CharsetsNames + 27) = wxT("EUC-TW       Taiwan");
  *(CharsetsNames + 28) = wxT("GB18030      Chinese/National Standard");
  *(CharsetsNames + 29) = wxT("GBK          Chinese/Simplified");
  *(CharsetsNames + 30) = wxT("Georgian-Academy");
  *(CharsetsNames + 31) = wxT("Georgian-PS");
  *(CharsetsNames + 32) = wxT("HZ           Chinese");
  *(CharsetsNames + 33) = wxT("ISO-2022-CN  Chinese");
  *(CharsetsNames + 34) = wxT("ISO-2022-CN-EXT");
  *(CharsetsNames + 35) = wxT("ISO-2022-JP  Japanese");
  *(CharsetsNames + 36) = wxT("ISO-2022-JP-1");
  *(CharsetsNames + 37) = wxT("ISO-2022-JP-2");
  *(CharsetsNames + 38) = wxT("ISO-2022-KR  Korean");
  *(CharsetsNames + 39) = wxT("ISO-8859-1   Latin-1 Western European");
  *(CharsetsNames + 40) = wxT("ISO-8859-2   Latin-2 Central European");
  *(CharsetsNames + 41) = wxT("ISO-8859-3   Latin-3 South European");
  *(CharsetsNames + 42) = wxT("ISO-8859-4   Latin-4 North European");
  *(CharsetsNames + 43) = wxT("ISO-8859-5   Latin/Cyrillic");
  *(CharsetsNames + 44) = wxT("ISO-8859-6   Latin/Arabic");
  *(CharsetsNames + 45) = wxT("ISO-8859-7   Latin/Greek");
  *(CharsetsNames + 46) = wxT("ISO-8859-8   Latin/Hebrew");
  *(CharsetsNames + 47) = wxT("ISO-8859-9   Latin-5 Turkish");
  *(CharsetsNames + 48) = wxT("ISO-8859-10  Latin-6 Nordic");
  *(CharsetsNames + 49) = wxT("ISO-8859-11  Latin/Thai");
  *(CharsetsNames + 50) = wxT("ISO-8859-13  Latin-7 Baltic Rim");
  *(CharsetsNames + 51) = wxT("ISO-8859-14  Latin-8 Celtic");
  *(CharsetsNames + 52) = wxT("ISO-8859-15  Latin-9");
  *(CharsetsNames + 53) = wxT("ISO-8859-16  Latin-10 South-Eastern European");
  *(CharsetsNames + 54) = wxT("JOHAB        Korean");
  *(CharsetsNames + 55) = wxT("KOI8-R       Russian");
  *(CharsetsNames + 56) = wxT("KOI8-U       Ukrainian");
  *(CharsetsNames + 57) = wxT("KOI8-RU      Belarusian");
  *(CharsetsNames + 58) = wxT("KOI8-T       Tajik");
  *(CharsetsNames + 59) = wxT("MacArabic    MAC Arabic");
  *(CharsetsNames + 60) = wxT("MacCentralEurope");
  *(CharsetsNames + 61) = wxT("MacCroatian  MAC Croatian");
  *(CharsetsNames + 62) = wxT("MacCyrillic  MAC Cyrillic");
  *(CharsetsNames + 63) = wxT("MacGreek     MAC Greek");
  *(CharsetsNames + 64) = wxT("MacHebrew    MAC Hebrew");
  *(CharsetsNames + 65) = wxT("MacIceland   MAC Iceland");
  *(CharsetsNames + 66) = wxT("Macintosh");
  *(CharsetsNames + 67) = wxT("MacRoman     MAC European/Western languages");
  *(CharsetsNames + 68) = wxT("MacRomania   MAC Romania");
  *(CharsetsNames + 69) = wxT("MacThai      MAC Thai");
  *(CharsetsNames + 70) = wxT("MacTurkish   MAC Turkish");
  *(CharsetsNames + 71) = wxT("MacUkraine   MAC Ukraine");
  *(CharsetsNames + 72) = wxT("MuleLao-1    Laotian");
  *(CharsetsNames + 73) = wxT("PT154        Kazakh");
  *(CharsetsNames + 74) = wxT("RK1048       Kazakh");
  *(CharsetsNames + 75) = wxT("SHIFT_JIS    Japanese");
  *(CharsetsNames + 76) = wxT("TCVN         Vietnamese");
  *(CharsetsNames + 77) = wxT("TIS-620      Thai");
  *(CharsetsNames + 77) = wxT("UTF-8        UNICODE/Universal");
  *(CharsetsNames + 78) = wxT("VISCII       Vietnamese");
  *(Charsets + 0) = wxT("ARMSCII-8");
  *(Charsets + 1) = wxT("ASCII");
  *(Charsets + 2) = wxT("BIG5");
  *(Charsets + 3) = wxT("BIG5-HKSCS");
  *(Charsets + 4) = wxT("BIG5-HKSCS:1999");
  *(Charsets + 5) = wxT("BIG5-HKSCS:2001");
  *(Charsets + 6) = wxT("CP850");
  *(Charsets + 7) = wxT("CP862");
  *(Charsets + 8) = wxT("CP866");
  *(Charsets + 9) = wxT("CP874");
  *(Charsets + 10) = wxT("CP932");
  *(Charsets + 11) = wxT("CP936");
  *(Charsets + 12) = wxT("CP949");
  *(Charsets + 13) = wxT("CP950");
  *(Charsets + 14) = wxT("CP1133");
  *(Charsets + 15) = wxT("CP1250");
  *(Charsets + 16) = wxT("CP1251");
  *(Charsets + 17) = wxT("CP1252");
  *(Charsets + 18) = wxT("CP1253");
  *(Charsets + 19) = wxT("CP1254");
  *(Charsets + 20) = wxT("CP1255");
  *(Charsets + 21) = wxT("CP1256");
  *(Charsets + 22) = wxT("CP1257");
  *(Charsets + 23) = wxT("CP1258");
  *(Charsets + 24) = wxT("EUC-CN");
  *(Charsets + 25) = wxT("EUC-JP");
  *(Charsets + 26) = wxT("EUC-KR");
  *(Charsets + 27) = wxT("EUC-TW");
  *(Charsets + 28) = wxT("GB18030");
  *(Charsets + 29) = wxT("GBK");
  *(Charsets + 30) = wxT("Georgian-Academy");
  *(Charsets + 31) = wxT("Georgian-PS");
  *(Charsets + 32) = wxT("HZ");
  *(Charsets + 33) = wxT("ISO-2022-CN");
  *(Charsets + 34) = wxT("ISO-2022-CN-EXT");
  *(Charsets + 35) = wxT("ISO-2022-JP");
  *(Charsets + 36) = wxT("ISO-2022-JP-1");
  *(Charsets + 37) = wxT("ISO-2022-JP-2");
  *(Charsets + 38) = wxT("ISO-2022-KR");
  *(Charsets + 39) = wxT("ISO-8859-1");
  *(Charsets + 40) = wxT("ISO-8859-2");
  *(Charsets + 41) = wxT("ISO-8859-3");
  *(Charsets + 42) = wxT("ISO-8859-4");
  *(Charsets + 43) = wxT("ISO-8859-5");
  *(Charsets + 44) = wxT("ISO-8859-6");
  *(Charsets + 45) = wxT("ISO-8859-7");
  *(Charsets + 46) = wxT("ISO-8859-8");
  *(Charsets + 47) = wxT("ISO-8859-9");
  *(Charsets + 48) = wxT("ISO-8859-10");
  *(Charsets + 49) = wxT("ISO-8859-11");
  *(Charsets + 50) = wxT("ISO-8859-13");
  *(Charsets + 51) = wxT("ISO-8859-14");
  *(Charsets + 52) = wxT("ISO-8859-15");
  *(Charsets + 53) = wxT("ISO-8859-16");
  *(Charsets + 54) = wxT("JOHAB");
  *(Charsets + 55) = wxT("KOI8-R");
  *(Charsets + 56) = wxT("KOI8-U");
  *(Charsets + 57) = wxT("KOI8-RU");
  *(Charsets + 58) = wxT("KOI8-T");
  *(Charsets + 59) = wxT("MacArabic");
  *(Charsets + 60) = wxT("MacCentralEurope");
  *(Charsets + 61) = wxT("MacCroatian");
  *(Charsets + 62) = wxT("MacCyrillic");
  *(Charsets + 63) = wxT("MacGreek");
  *(Charsets + 64) = wxT("MacHebrew");
  *(Charsets + 65) = wxT("MacIceland");
  *(Charsets + 66) = wxT("Macintosh");
  *(Charsets + 67) = wxT("MacRoman");
  *(Charsets + 68) = wxT("MacRomania");
  *(Charsets + 69) = wxT("MacThai");
  *(Charsets + 70) = wxT("MacTurkish");
  *(Charsets + 71) = wxT("MacUkraine");
  *(Charsets + 72) = wxT("MuleLao-1");
  *(Charsets + 73) = wxT("PT154");
  *(Charsets + 74) = wxT("RK1048");
  *(Charsets + 75) = wxT("SHIFT_JIS");
  *(Charsets + 76) = wxT("TCVN");
  *(Charsets + 77) = wxT("TIS-620");
  *(Charsets + 77) = wxT("UTF-8");
  *(Charsets + 78) = wxT("VISCII");
  LocaleCharset = wxString::FromUTF8(gaiaGetLocaleCharset());
  DefaultCharset = LocaleCharset;
  AskCharset = false;

  spatialite_init(0);           // loading the SpatiaLite extension

  HelpPane = false;
  SqliteHandle = NULL;
  SqlitePath = wxT("");
  BtnConnect = new wxBitmap(connect_xpm);
  BtnCreateNew = new wxBitmap(create_new_xpm);
  BtnDisconnect = new wxBitmap(disconnect_xpm);
  BtnMemDbLoad = new wxBitmap(memdb_load_xpm);
  BtnMemDbNew = new wxBitmap(memdb_new_xpm);
  BtnMemDbClock = new wxBitmap(memdb_clock_xpm);
  BtnMemDbSave = new wxBitmap(memdb_save_xpm);
  BtnVacuum = new wxBitmap(vacuum_xpm);
  BtnSqlScript = new wxBitmap(sql_script_xpm);
  BtnLoadShp = new wxBitmap(loadshp_xpm);
  BtnVirtualShp = new wxBitmap(virtshp_xpm);
  BtnLoadTxt = new wxBitmap(loadtxt_xpm);
  BtnVirtualTxt = new wxBitmap(virttxt_xpm);
  BtnNetwork = new wxBitmap(network_xpm);
  BtnExif = new wxBitmap(exif_xpm);
  BtnSrids = new wxBitmap(srids_xpm);
  BtnCharset = new wxBitmap(charset_xpm);
  BtnHelp = new wxBitmap(help_xpm);
  BtnAbout = new wxBitmap(about_xpm);
  BtnExit = new wxBitmap(exit_xpm);

//
// setting up the application icon
//      
  wxIcon MyIcon(icon_xpm);
  SetIcon(MyIcon);

//
// setting up panes
//
  TableTree = new MyTableTree(this);
  QueryView = new MyQueryView(this);
  RsView = new MyResultSetView(this);
  Manager.SetManagedWindow(this);
  wxAuiPaneInfo paneSql = wxAuiPaneInfo().Top();
  paneSql.Name(wxT("sql_stmt"));
  paneSql.CaptionVisible(false);
  paneSql.Floatable(true);
  paneSql.Dockable(true);
  paneSql.Movable(true);
  paneSql.Gripper(true);
  paneSql.CloseButton(false);
  paneSql.BestSize(wxSize(200, 120));
  Manager.AddPane(QueryView, paneSql);
  wxAuiPaneInfo paneView = wxAuiPaneInfo().Centre();
  paneView.Name(wxT("result_set"));
  paneView.CaptionVisible(false);
  paneView.Floatable(true);
  paneView.Dockable(true);
  paneView.Movable(true);
  paneView.Gripper(false);
  paneView.CloseButton(false);
  Manager.AddPane(RsView, paneView);
  wxAuiPaneInfo paneTree = wxAuiPaneInfo().Left();
  paneTree.Name(wxT("tree_view"));
  paneTree.CaptionVisible(false);
  paneTree.Floatable(true);
  paneTree.Dockable(true);
  paneTree.Movable(true);
  paneTree.Gripper(true);
  paneTree.CloseButton(false);
  paneTree.BestSize(wxSize(200, 480));
  Manager.AddPane(TableTree, paneTree, wxPoint(0, 10));
  Manager.Update();
  Centre();

//
// setting up the status bar
//
  wxStatusBar *statusBar = new wxStatusBar(this);
  SetStatusBar(statusBar);

//
// setting up the menu bar
//
  wxMenu *menuFile = new wxMenu;
  wxMenuItem *menuItem;
  menuItem =
    new wxMenuItem(menuFile, ID_Connect,
                   wxT("&Connecting an existing SQLite DB"));
  menuItem->SetBitmap(*BtnConnect);
  menuFile->Append(menuItem);
  menuItem =
    new wxMenuItem(menuFile, ID_CreateNew,
                   wxT("Creating a &New (empty) SQLite DB"));
  menuItem->SetBitmap(*BtnCreateNew);
  menuFile->Append(menuItem);
  wxMenu *memoryMenu = new wxMenu();
  menuItem =
    new wxMenuItem(memoryMenu, ID_MemoryDbLoad,
                   wxT("&Loading an existing DB into the MEMORY-DB"));
  menuItem->SetBitmap(*BtnMemDbLoad);
  memoryMenu->Append(menuItem);
  menuItem =
    new wxMenuItem(memoryMenu, ID_MemoryDbNew,
                   wxT("Creating a &New (empty) MEMORY-DB"));
  menuItem->SetBitmap(*BtnMemDbNew);
  memoryMenu->Append(menuItem);
  menuItem =
    new wxMenuItem(memoryMenu, ID_MemoryDbClock,
                   wxT("&AutoSaving the current MEMORY-DB"));
  menuItem->SetBitmap(*BtnMemDbClock);
  memoryMenu->Append(menuItem);
  menuItem =
    new wxMenuItem(memoryMenu, ID_MemoryDbSave,
                   wxT("&Saving the current MEMORY-DB"));
  menuItem->SetBitmap(*BtnMemDbSave);
  memoryMenu->Append(menuItem);
  menuFile->AppendSubMenu(memoryMenu, wxT("&MEMORY-DB"));
  menuItem =
    new wxMenuItem(menuFile, ID_Disconnect,
                   wxT("&Disconnecting current SQLite DB"));
  menuItem->SetBitmap(*BtnDisconnect);
  menuFile->Append(menuItem);
  menuItem =
    new wxMenuItem(menuFile, ID_Disconnect,
                   wxT("&Disconnecting current SQLite DB"));
  menuItem->SetBitmap(*BtnDisconnect);
  menuFile->Append(menuItem);
  menuItem =
    new wxMenuItem(menuFile, ID_Vacuum,
                   wxT("&Optimizing current SQLite DB [VACUUM]"));
  menuItem->SetBitmap(*BtnVacuum);
  menuFile->Append(menuItem);
  menuFile->AppendSeparator();
  menuItem = new wxMenuItem(menuFile, ID_SqlScript, wxT("&Execute SQL script"));
  menuItem->SetBitmap(*BtnSqlScript);
  menuFile->Append(menuItem);
  menuFile->AppendSeparator();
  menuItem = new wxMenuItem(menuFile, ID_LoadShp, wxT("&Load Shapefile"));
  menuItem->SetBitmap(*BtnLoadShp);
  menuFile->Append(menuItem);
  menuItem = new wxMenuItem(menuFile, ID_VirtualShp, wxT("&Virtual Shapefile"));
  menuItem->SetBitmap(*BtnVirtualShp);
  menuFile->Append(menuItem);
  menuFile->AppendSeparator();
  menuItem = new wxMenuItem(menuFile, ID_LoadTxt, wxT("Load CSV/&TXT"));
  menuItem->SetBitmap(*BtnLoadTxt);
  menuFile->Append(menuItem);
  menuItem = new wxMenuItem(menuFile, ID_VirtualTxt, wxT("Virtual &CSV/TXT"));
  menuItem->SetBitmap(*BtnVirtualTxt);
  menuFile->Append(menuItem);
  menuFile->AppendSeparator();
  menuItem = new wxMenuItem(menuFile, ID_Network, wxT("Build &Network"));
  menuItem->SetBitmap(*BtnNetwork);
  menuFile->Append(menuItem);
  menuFile->AppendSeparator();
  menuItem = new wxMenuItem(menuFile, ID_Exif, wxT("Import &EXIF photos"));
  menuItem->SetBitmap(*BtnExif);
  menuFile->Append(menuItem);
  menuFile->AppendSeparator();
  menuItem = new wxMenuItem(menuFile, ID_Srids, wxT("&Search SRID by name"));
  menuItem->SetBitmap(*BtnSrids);
  menuFile->Append(menuItem);
  menuItem =
    new wxMenuItem(menuFile, ID_Charset, wxT("&Default Output Charset"));
  menuItem->SetBitmap(*BtnCharset);
  menuFile->Append(menuItem);
  menuFile->AppendSeparator();
  menuItem = new wxMenuItem(menuFile, ID_Help, wxT("&Help"));
  menuItem->SetBitmap(*BtnHelp);
  menuItem = new wxMenuItem(menuFile, wxID_ABOUT, wxT("&About ..."));
  menuItem->SetBitmap(*BtnAbout);
  menuFile->Append(menuItem);
  menuFile->AppendSeparator();
  menuItem = new wxMenuItem(menuFile, wxID_EXIT, wxT("&Quit"));
  menuItem->SetBitmap(*BtnExit);
  menuFile->Append(menuItem);
  wxMenuBar *menuBar = new wxMenuBar;
  menuBar->Append(menuFile, wxT("&Files"));
  SetMenuBar(menuBar);

//
// setting up menu initial state 
//
  menuBar->Enable(ID_Disconnect, false);
  menuBar->Enable(ID_MemoryDbClock, false);
  menuBar->Enable(ID_MemoryDbSave, false);
  menuBar->Enable(ID_Vacuum, false);
  menuBar->Enable(ID_SqlScript, false);
  menuBar->Enable(ID_LoadShp, false);
  menuBar->Enable(ID_VirtualShp, false);
  menuBar->Enable(ID_LoadTxt, false);
  menuBar->Enable(ID_VirtualTxt, false);
  menuBar->Enable(ID_Network, false);
  menuBar->Enable(ID_Exif, false);
  menuBar->Enable(ID_Srids, false);

//
// setting up the toolbar
//      
  wxToolBar *toolBar = CreateToolBar();
  toolBar->AddTool(ID_Connect, wxT("Connecting an existing SQLite DB"),
                   *BtnConnect, wxNullBitmap, wxITEM_NORMAL,
                   wxT("Connecting an existing SQLite DB"));
  toolBar->AddTool(ID_CreateNew, wxT("Creating a &New (empty) SQLite DB"),
                   *BtnCreateNew, wxNullBitmap, wxITEM_NORMAL,
                   wxT("Creating a &New (empty) SQLite DB"));
  toolBar->AddTool(ID_MemoryDbLoad,
                   wxT("Loading an existing DB into the MEMORY-DB"),
                   *BtnMemDbLoad, wxNullBitmap, wxITEM_NORMAL,
                   wxT("Loading an existing DB into the MEMORY-DB"));
  toolBar->AddTool(ID_MemoryDbNew, wxT("Creating a New (empty) MEMORY-DB"),
                   *BtnMemDbNew, wxNullBitmap, wxITEM_NORMAL,
                   wxT("Creating a New (empty) MEMORY-DB"));
  toolBar->AddTool(ID_MemoryDbClock, wxT("AutoSaving the current MEMORY-DB"),
                   *BtnMemDbClock, wxNullBitmap, wxITEM_NORMAL,
                   wxT("AutoSaving the current MEMORY-DB"));
  toolBar->AddTool(ID_MemoryDbSave, wxT("Saving the current MEMORY-DB"),
                   *BtnMemDbSave, wxNullBitmap, wxITEM_NORMAL,
                   wxT("Saving the current MEMORY-DB"));
  toolBar->AddTool(ID_Disconnect, wxT("Disconnecting current SQLite DB"),
                   *BtnDisconnect, wxNullBitmap, wxITEM_NORMAL,
                   wxT("Disconnecting current SQLite DB"));
  toolBar->AddTool(ID_Vacuum, wxT("Optimizing current SQLite DB [VACUUM]"),
                   *BtnVacuum, wxNullBitmap, wxITEM_NORMAL,
                   wxT("Optimizing current SQLite DB [VACUUM]"));
  toolBar->AddSeparator();
  toolBar->AddTool(ID_SqlScript, wxT("Execute SQL script"), *BtnSqlScript,
                   wxNullBitmap, wxITEM_NORMAL, wxT("Execute SQL script"));
  toolBar->AddSeparator();
  toolBar->AddTool(ID_LoadShp, wxT("Load Shapefile"), *BtnLoadShp, wxNullBitmap,
                   wxITEM_NORMAL, wxT("Load Shapefile"));
  toolBar->AddTool(ID_VirtualShp, wxT("Virtual Shapefile"), *BtnVirtualShp,
                   wxNullBitmap, wxITEM_NORMAL, wxT("Virtual Shapefile"));
  toolBar->AddSeparator();
  toolBar->AddTool(ID_LoadTxt, wxT("Load CSV/TXT"), *BtnLoadTxt, wxNullBitmap,
                   wxITEM_NORMAL, wxT("Load CSV/TXT"));
  toolBar->AddTool(ID_VirtualTxt, wxT("Virtual CSV/TXT"), *BtnVirtualTxt,
                   wxNullBitmap, wxITEM_NORMAL, wxT("Virtual CSV/TXT"));
  toolBar->AddSeparator();
  toolBar->AddTool(ID_Network, wxT("Build Network"), *BtnNetwork, wxNullBitmap,
                   wxITEM_NORMAL, wxT("Build Network"));
  toolBar->AddSeparator();
  toolBar->AddTool(ID_Exif, wxT("Import EXIF photos"), *BtnExif, wxNullBitmap,
                   wxITEM_NORMAL, wxT("Import EXIF photos"));
  toolBar->AddSeparator();
  toolBar->AddTool(ID_Srids, wxT("Search SRID by name"), *BtnSrids,
                   wxNullBitmap, wxITEM_NORMAL, wxT("Search SRID by name"));
  toolBar->AddSeparator();
  toolBar->AddTool(ID_Charset, wxT("Default Output Charset"), *BtnCharset,
                   wxNullBitmap, wxITEM_NORMAL, wxT("Default Output Charset"));
  toolBar->AddSeparator();
  toolBar->AddTool(ID_Help, wxT("Help"), *BtnHelp, wxNullBitmap, wxITEM_NORMAL,
                   wxT("Help"));
  toolBar->AddTool(wxID_ABOUT, wxT("About ..."), *BtnAbout, wxNullBitmap,
                   wxITEM_NORMAL, wxT("About ..."));
  toolBar->AddSeparator();
  toolBar->AddTool(wxID_EXIT, wxT("Quit"), *BtnExit, wxNullBitmap,
                   wxITEM_NORMAL, wxT("Quit"));
  toolBar->Realize();
  SetToolBar(toolBar);

//
// setting up the toolbar initial state
//
  toolBar->EnableTool(ID_Disconnect, false);
  toolBar->EnableTool(ID_MemoryDbClock, false);
  toolBar->EnableTool(ID_MemoryDbSave, false);
  toolBar->EnableTool(ID_Vacuum, false);
  toolBar->EnableTool(ID_SqlScript, false);
  toolBar->EnableTool(ID_LoadShp, false);
  toolBar->EnableTool(ID_VirtualShp, false);
  toolBar->EnableTool(ID_LoadTxt, false);
  toolBar->EnableTool(ID_VirtualTxt, false);
  toolBar->EnableTool(ID_Network, false);
  toolBar->EnableTool(ID_Exif, false);
  toolBar->EnableTool(ID_Srids, false);

// updating the status bar
  UpdateStatusBar();

//
// setting up event handlers for menu and toolbar
//
  Connect(ID_Connect, wxEVT_COMMAND_MENU_SELECTED,
          (wxObjectEventFunction) & MyFrame::OnConnect);
  Connect(ID_CreateNew, wxEVT_COMMAND_MENU_SELECTED,
          (wxObjectEventFunction) & MyFrame::OnCreateNew);
  Connect(ID_Disconnect, wxEVT_COMMAND_MENU_SELECTED,
          (wxObjectEventFunction) & MyFrame::OnDisconnect);
  Connect(ID_MemoryDbLoad, wxEVT_COMMAND_MENU_SELECTED,
          (wxObjectEventFunction) & MyFrame::OnMemoryDbLoad);
  Connect(ID_MemoryDbNew, wxEVT_COMMAND_MENU_SELECTED,
          (wxObjectEventFunction) & MyFrame::OnMemoryDbNew);
  Connect(ID_MemoryDbClock, wxEVT_COMMAND_MENU_SELECTED,
          (wxObjectEventFunction) & MyFrame::OnMemoryDbClock);
  Connect(ID_MemoryDbSave, wxEVT_COMMAND_MENU_SELECTED,
          (wxObjectEventFunction) & MyFrame::OnMemoryDbSave);
  Connect(ID_Vacuum, wxEVT_COMMAND_MENU_SELECTED,
          (wxObjectEventFunction) & MyFrame::OnVacuum);
  Connect(ID_SqlScript, wxEVT_COMMAND_MENU_SELECTED,
          (wxObjectEventFunction) & MyFrame::OnSqlScript);
  Connect(ID_LoadShp, wxEVT_COMMAND_MENU_SELECTED,
          (wxObjectEventFunction) & MyFrame::OnLoadShp);
  Connect(ID_VirtualShp, wxEVT_COMMAND_MENU_SELECTED,
          (wxObjectEventFunction) & MyFrame::OnVirtualShp);
  Connect(ID_LoadTxt, wxEVT_COMMAND_MENU_SELECTED,
          (wxObjectEventFunction) & MyFrame::OnLoadTxt);
  Connect(ID_VirtualTxt, wxEVT_COMMAND_MENU_SELECTED,
          (wxObjectEventFunction) & MyFrame::OnVirtualTxt);
  Connect(ID_Network, wxEVT_COMMAND_MENU_SELECTED,
          (wxObjectEventFunction) & MyFrame::OnNetwork);
  Connect(ID_Exif, wxEVT_COMMAND_MENU_SELECTED,
          (wxObjectEventFunction) & MyFrame::OnImportExifPhotos);
  Connect(ID_Srids, wxEVT_COMMAND_MENU_SELECTED,
          (wxObjectEventFunction) & MyFrame::OnSrids);
  Connect(ID_Charset, wxEVT_COMMAND_MENU_SELECTED,
          (wxObjectEventFunction) & MyFrame::OnCharset);
  Connect(ID_Help, wxEVT_COMMAND_MENU_SELECTED,
          (wxObjectEventFunction) & MyFrame::OnHelp);
  Connect(wxID_ABOUT, wxEVT_COMMAND_MENU_SELECTED,
          (wxObjectEventFunction) & MyFrame::OnAbout);
  Connect(wxID_EXIT, wxEVT_COMMAND_MENU_SELECTED,
          (wxObjectEventFunction) & MyFrame::OnQuit);
  Connect(wxID_ANY, wxEVT_MOTION, wxMouseEventHandler(MyFrame::OnMouseMove),
          NULL, this);

//
// setting up event handlers for mouse
//
  TableTree->Connect(wxID_ANY, wxEVT_MOTION,
                     wxMouseEventHandler(MyFrame::OnMouseMove), NULL, this);
  GetMenuBar()->Connect(wxID_ANY, wxEVT_MOTION,
                        wxMouseEventHandler(MyFrame::OnMouseMove), NULL, this);
  GetStatusBar()->Connect(wxID_ANY, wxEVT_MOTION,
                          wxMouseEventHandler(MyFrame::OnMouseMove), NULL,
                          this);
//
// setting up a Timer event handler for AutoSave
//
  Connect(ID_AUTO_SAVE_TIMER, wxEVT_TIMER,
          wxTimerEventHandler(MyFrame::OnTimerAutoSave), NULL, this);
}

MyFrame::~MyFrame()
{
//
// main GUI frame destructor
//
  if (TimerAutoSave)
    {
      TimerAutoSave->Stop();
      delete TimerAutoSave;
    }
  LastDitchMemoryDbSave();
  ConfigLayout = Manager.SavePerspective();
  GetPosition(&ConfigPaneX, &ConfigPaneY);
  GetSize(&ConfigPaneWidth, &ConfigPaneHeight);
  SaveConfig();
  Manager.UnInit();
  if (SqliteHandle)
    sqlite3_close(SqliteHandle);
  if (BtnConnect != NULL)
    delete BtnConnect;
  if (BtnCreateNew != NULL)
    delete BtnCreateNew;
  if (BtnDisconnect != NULL)
    delete BtnDisconnect;
  if (BtnMemDbLoad != NULL)
    delete BtnMemDbLoad;
  if (BtnMemDbNew != NULL)
    delete BtnMemDbNew;
  if (BtnMemDbClock != NULL)
    delete BtnMemDbClock;
  if (BtnMemDbSave != NULL)
    delete BtnMemDbSave;
  if (BtnVacuum != NULL)
    delete BtnVacuum;
  if (BtnSqlScript != NULL)
    delete BtnSqlScript;
  if (BtnLoadShp != NULL)
    delete BtnLoadShp;
  if (BtnVirtualShp != NULL)
    delete BtnVirtualShp;
  if (BtnLoadTxt != NULL)
    delete BtnLoadTxt;
  if (BtnVirtualTxt != NULL)
    delete BtnVirtualTxt;
  if (BtnNetwork != NULL)
    delete BtnNetwork;
  if (BtnExif != NULL)
    delete BtnExif;
  if (BtnSrids != NULL)
    delete BtnSrids;
  if (BtnHelp != NULL)
    delete BtnHelp;
  if (BtnAbout != NULL)
    delete BtnAbout;
  if (BtnExit != NULL)
    delete BtnExit;
  if (Charsets)
    delete[]Charsets;
  if (CharsetsNames)
    delete[]CharsetsNames;
}

void MyFrame::SaveConfig()
{
//
// saves layout configuration
//

  wxConfig *config = new wxConfig(wxT("SpatialiteGui"));
  config->Write(wxT("Layout"), ConfigLayout);
  config->Write(wxT("PaneX"), ConfigPaneX);
  config->Write(wxT("PaneY"), ConfigPaneY);
  config->Write(wxT("PaneWidth"), ConfigPaneWidth);
  config->Write(wxT("PaneHeight"), ConfigPaneHeight);
  config->Write(wxT("SqlitePath"), SqlitePath);
  config->Write(wxT("LastDirectory"), LastDirectory);
  delete config;
}

void MyFrame::LoadConfig()
{
//
// loads layout configuration
//
  ConfigLayout = wxT("");
  ConfigDbPath = wxT("");
  ConfigDir = wxT("");
  wxConfig *config = new wxConfig(wxT("SpatialiteGui"));
  config->Read(wxT("Layout"), &ConfigLayout);
  config->Read(wxT("PaneX"), &ConfigPaneX, -1);
  config->Read(wxT("PaneY"), &ConfigPaneY, -1);
  config->Read(wxT("PaneWidth"), &ConfigPaneWidth, -1);
  config->Read(wxT("PaneHeight"), &ConfigPaneHeight, -1);
  config->Read(wxT("SqlitePath"), &ConfigDbPath);
  config->Read(wxT("LastDirectory"), &ConfigDir);
  delete config;
  Hide();
  if (ConfigLayout.Len() > 0)
    Manager.LoadPerspective(ConfigLayout, true);
  if (ConfigPaneX >= 0 && ConfigPaneY >= 0 && ConfigPaneWidth > 0
      && ConfigPaneHeight > 0)
    SetSize(ConfigPaneX, ConfigPaneY, ConfigPaneWidth, ConfigPaneHeight);
  if (ConfigDir.Len() > 0)
    LastDirectory = ConfigDir;
  if (ConfigDbPath.Len() > 0)
    {
      SqlitePath = ConfigDbPath;
      if (OpenDB() == false)
        SqlitePath = wxT("");
      else
        {
          bool metadata = CheckMetadata();
          wxMenuBar *menuBar = GetMenuBar();
          menuBar->Enable(ID_Connect, false);
          menuBar->Enable(ID_MemoryDbLoad, false);
          menuBar->Enable(ID_MemoryDbNew, false);
          if (MemoryDatabase == true)
            {
              menuBar->Enable(ID_MemoryDbSave, true);
              menuBar->Enable(ID_MemoryDbClock, true);
          } else
            {
              menuBar->Enable(ID_MemoryDbSave, false);
              menuBar->Enable(ID_MemoryDbClock, false);
            }
          menuBar->Enable(ID_CreateNew, false);
          menuBar->Enable(ID_Disconnect, true);
          menuBar->Enable(ID_Vacuum, true);
          menuBar->Enable(ID_SqlScript, true);
          menuBar->Enable(ID_LoadShp, true);
          menuBar->Enable(ID_VirtualShp, true);
          menuBar->Enable(ID_LoadTxt, true);
          menuBar->Enable(ID_VirtualTxt, true);
          menuBar->Enable(ID_Network, true);
          menuBar->Enable(ID_Exif, true);
          menuBar->Enable(ID_Srids, metadata);
          wxToolBar *toolBar = GetToolBar();
          toolBar->EnableTool(ID_Connect, false);
          toolBar->EnableTool(ID_MemoryDbLoad, false);
          toolBar->EnableTool(ID_MemoryDbNew, false);
          if (MemoryDatabase == true)
            {
              toolBar->EnableTool(ID_MemoryDbSave, true);
              toolBar->EnableTool(ID_MemoryDbClock, true);
          } else
            {
              toolBar->EnableTool(ID_MemoryDbSave, false);
              toolBar->EnableTool(ID_MemoryDbClock, false);
            }
          toolBar->EnableTool(ID_CreateNew, false);
          toolBar->EnableTool(ID_Disconnect, true);
          toolBar->EnableTool(ID_Vacuum, true);
          toolBar->EnableTool(ID_SqlScript, true);
          toolBar->EnableTool(ID_LoadShp, true);
          toolBar->EnableTool(ID_VirtualShp, true);
          toolBar->EnableTool(ID_LoadTxt, true);
          toolBar->EnableTool(ID_VirtualTxt, true);
          toolBar->EnableTool(ID_Network, true);
          toolBar->EnableTool(ID_Exif, true);
          toolBar->EnableTool(ID_Srids, metadata);
          UpdateStatusBar();
        }
    }
  Show();
  if (AutoFDOmsg.Len() > 0)
    {
      wxMessageBox(AutoFDOmsg, wxT("spatialite-gui"), wxOK | wxICON_INFORMATION,
                   this);
      AutoFDOmsg = wxT("");
    }
}

void MyFrame::OnQuit(wxCommandEvent & WXUNUSED(event))
{
//
// EXIT - event handler
//
  CloseDB();
  Close(true);
}

void MyFrame::OnHelp(wxCommandEvent & WXUNUSED(event))
{
//
// HELP - event handler
//
  if (HelpPane == true)
    return;
  HelpDialog *help = new HelpDialog(this);
  help->Show();
}

void MyFrame::OnAbout(wxCommandEvent & WXUNUSED(event))
{
//
// ABOUT dialog - event handler
//
  char ver[128];
  wxAboutDialogInfo dlg;
  dlg.SetIcon(wxIcon(icon_info_xpm));
  dlg.SetName(wxT("spatialite-gui"));
  dlg.SetVersion(wxT("v1.2"));
  wxString str = wxT("a GUI-tool for SQLite / SpatiaLite\n\n");
  sprintf(ver, "%d.%d.%d", wxMAJOR_VERSION, wxMINOR_VERSION, wxRELEASE_NUMBER);
  str += wxT("wxWidgets version ") + wxString::FromUTF8(ver) + wxT("\n");
  strcpy(ver, spatialite_version());
  str += wxT("SpatiaLite version ") + wxString::FromUTF8(ver) + wxT("\n");
  strcpy(ver, sqlite3_libversion());
  str += wxT("SQLite version ") + wxString::FromUTF8(ver) + wxT("\n");
  strcpy(ver, GEOSversion());
  str += wxT("GEOS version ") + wxString::FromUTF8(ver) + wxT("\n");
  strcpy(ver, pj_get_release());
  str += wxT("PROJ.4 version ") + wxString::FromUTF8(ver) + wxT("\n\n");
  str += wxT("SQLite's extension 'SpatiaLite' enabled\n");
  str += wxT("SQLite's extension 'VirtualShape' enabled\n");
  str += wxT("SQLite's extension 'VirtualText' enabled\n");
  str += wxT("SQLite's extension 'VirtualNetwork' enabled\n");
  str += wxT("SQLite's extension 'RTree' enabled\n");
  str += wxT("SQLite's extension 'MbrCache' enabled\n");
  str += wxT("SQLite's extension 'VirtualFDO' enabled\n\n");
  dlg.SetDescription(str);
  dlg.SetCopyright(wxT("by Alessandro Furieri - 2008"));
  dlg.SetWebSite(wxT("http://www.gaia-gis.it"));
  wxString license =
    wxT("This program is free software; you can redistribute it\n");
  license +=
    wxT("and/or modify it under the terms of the GNU General Public License\n");
  license += wxT("(GPL) as published by the Free Software Foundation\n\n");
  license +=
    wxT
    ("A copy of the GPL can be found at\nhttp://www.gnu.org/licenses/gpl.txt");
  dlg.SetLicense(license);
  ::wxAboutBox(dlg);
}

void MyFrame::OnMouseMove(wxMouseEvent & event)
{
//
// MOUSE motion - event handler
//
  UpdateStatusBar();
}

void MyFrame::UpdateStatusBar()
{
//
// updating the status bar
//
  if (GetStatusBar() == NULL)
    return;
  if (MemoryDatabase == true)
    {
      GetStatusBar()->SetStatusText(wxT("Current SQLite DB: MEMORY-DB"), 0);
      QueryView->ShowControls();
  } else
    {
      if (SqlitePath.Len() < 1)
        GetStatusBar()->SetStatusText(wxT("not connected"), 0);
      else
        GetStatusBar()->SetStatusText(wxT("Current SQLite DB: ") + SqlitePath,
                                      0);
      if (SqlitePath.Len() < 1)
        {
          QueryView->HideControls();
          RsView->HideControls();
      } else
        QueryView->ShowControls();
    }
}

void MyFrame::OnConnect(wxCommandEvent & WXUNUSED(event))
{
//
// connecting to an existent SQLite DB
//
  int ret;
  wxString lastDir;
  wxFileDialog *fileDialog = new wxFileDialog(this, wxT("DB connection"),
                                              wxT(""), wxT("db.sqlite"),
                                              wxT
                                              ("SQLite DB (*.sqlite)|*.sqlite|All files (*.*)|*.*"),
                                              wxFD_OPEN | wxFD_FILE_MUST_EXIST,
                                              wxDefaultPosition,
                                              wxDefaultSize,
                                              wxT("filedlg"));
  lastDir = GetLastDirectory();
  if (lastDir.Len() >= 1)
    fileDialog->SetDirectory(lastDir);
  ret = fileDialog->ShowModal();
  if (ret == wxID_OK)
    {
      SqlitePath = fileDialog->GetPath();
      if (OpenDB() == false)
        SqlitePath = wxT("");
      else
        {
          wxFileName file(fileDialog->GetPath());
          lastDir = file.GetPath();
          SetLastDirectory(lastDir);
          bool metadata = CheckMetadata();
          wxMenuBar *menuBar = GetMenuBar();
          menuBar->Enable(ID_Connect, false);
          menuBar->Enable(ID_CreateNew, false);
          menuBar->Enable(ID_Disconnect, true);
          menuBar->Enable(ID_MemoryDbLoad, false);
          menuBar->Enable(ID_MemoryDbNew, false);
          if (MemoryDatabase == true)
            {
              menuBar->Enable(ID_MemoryDbSave, true);
              menuBar->Enable(ID_MemoryDbClock, true);
          } else
            {
              menuBar->Enable(ID_MemoryDbSave, false);
              menuBar->Enable(ID_MemoryDbClock, false);
            }
          menuBar->Enable(ID_Vacuum, true);
          menuBar->Enable(ID_SqlScript, true);
          menuBar->Enable(ID_LoadShp, true);
          menuBar->Enable(ID_VirtualShp, true);
          menuBar->Enable(ID_LoadTxt, true);
          menuBar->Enable(ID_VirtualTxt, true);
          menuBar->Enable(ID_Network, true);
          menuBar->Enable(ID_Exif, true);
          menuBar->Enable(ID_Srids, metadata);
          wxToolBar *toolBar = GetToolBar();
          toolBar->EnableTool(ID_Connect, false);
          toolBar->EnableTool(ID_CreateNew, false);
          toolBar->EnableTool(ID_Disconnect, true);
          toolBar->EnableTool(ID_MemoryDbLoad, false);
          toolBar->EnableTool(ID_MemoryDbNew, false);
          if (MemoryDatabase == true)
            {
              toolBar->EnableTool(ID_MemoryDbSave, true);
              toolBar->EnableTool(ID_MemoryDbClock, true);
          } else
            {
              toolBar->EnableTool(ID_MemoryDbSave, false);
              toolBar->EnableTool(ID_MemoryDbClock, false);
            }
          toolBar->EnableTool(ID_Vacuum, true);
          toolBar->EnableTool(ID_SqlScript, true);
          toolBar->EnableTool(ID_LoadShp, true);
          toolBar->EnableTool(ID_VirtualShp, true);
          toolBar->EnableTool(ID_LoadTxt, true);
          toolBar->EnableTool(ID_VirtualTxt, true);
          toolBar->EnableTool(ID_Network, true);
          toolBar->EnableTool(ID_Exif, true);
          toolBar->EnableTool(ID_Srids, metadata);
          UpdateStatusBar();
        }
    }
  if (AutoFDOmsg.Len() > 0)
    {
      wxMessageBox(AutoFDOmsg, wxT("spatialite-gui"), wxOK | wxICON_INFORMATION,
                   this);
      AutoFDOmsg = wxT("");
    }
}

void MyFrame::OnDisconnect(wxCommandEvent & WXUNUSED(event))
{
//
// disconnecting current SQLite DB
//
  if (TimerAutoSave)
    {
      TimerAutoSave->Stop();
      delete TimerAutoSave;
      TimerAutoSave = NULL;
    }
  CloseDB();
  ExternalSqlitePath = wxT("");
  wxMenuBar *menuBar = GetMenuBar();
  menuBar->Enable(ID_Connect, true);
  menuBar->Enable(ID_CreateNew, true);
  menuBar->Enable(ID_Disconnect, false);
  menuBar->Enable(ID_MemoryDbLoad, true);
  menuBar->Enable(ID_MemoryDbNew, true);
  menuBar->Enable(ID_MemoryDbSave, false);
  menuBar->Enable(ID_MemoryDbClock, false);
  menuBar->Enable(ID_Vacuum, false);
  menuBar->Enable(ID_SqlScript, false);
  menuBar->Enable(ID_LoadShp, false);
  menuBar->Enable(ID_VirtualShp, false);
  menuBar->Enable(ID_LoadTxt, false);
  menuBar->Enable(ID_VirtualTxt, false);
  menuBar->Enable(ID_Network, false);
  menuBar->Enable(ID_Exif, false);
  menuBar->Enable(ID_Srids, false);
  wxToolBar *toolBar = GetToolBar();
  toolBar->EnableTool(ID_Connect, true);
  toolBar->EnableTool(ID_CreateNew, true);
  toolBar->EnableTool(ID_Disconnect, false);
  toolBar->EnableTool(ID_MemoryDbLoad, true);
  toolBar->EnableTool(ID_MemoryDbNew, true);
  toolBar->EnableTool(ID_MemoryDbSave, false);
  toolBar->EnableTool(ID_MemoryDbClock, false);
  toolBar->EnableTool(ID_Vacuum, false);
  toolBar->EnableTool(ID_SqlScript, false);
  toolBar->EnableTool(ID_LoadShp, false);
  toolBar->EnableTool(ID_VirtualShp, false);
  toolBar->EnableTool(ID_LoadTxt, false);
  toolBar->EnableTool(ID_VirtualTxt, false);
  toolBar->EnableTool(ID_Network, false);
  toolBar->EnableTool(ID_Exif, false);
  toolBar->EnableTool(ID_Srids, false);
  UpdateStatusBar();
}

void MyFrame::OnCreateNew(wxCommandEvent & WXUNUSED(event))
{
//
// creating a new, empty SQLite DB
//
  int retdlg;
  int ret;
  wxString lastDir;
  wxFileDialog *fileDialog =
    new wxFileDialog(this, wxT("Creating a new, empty DB"),
                     wxT(""), wxT("db.sqlite"),
                     wxT("SQLite DB (*.sqlite)|*.sqlite|All files (*.*)|*.*"),
                     wxFD_SAVE | wxFD_OVERWRITE_PROMPT, wxDefaultPosition,
                     wxDefaultSize,
                     wxT("filedlg"));
  lastDir = GetLastDirectory();
  if (lastDir.Len() >= 1)
    fileDialog->SetDirectory(lastDir);
  retdlg = fileDialog->ShowModal();
  if (retdlg == wxID_OK)
    {
      // creating the new DB
      SqlitePath = fileDialog->GetPath();
      ret = CreateDB();
      if (ret == false)
        goto error;
      wxFileName file(fileDialog->GetPath());
      lastDir = file.GetPath();
      SetLastDirectory(lastDir);
      wxMenuBar *menuBar = GetMenuBar();
      menuBar->Enable(ID_Connect, false);
      menuBar->Enable(ID_CreateNew, false);
      menuBar->Enable(ID_Disconnect, true);
      menuBar->Enable(ID_MemoryDbLoad, false);
      menuBar->Enable(ID_MemoryDbNew, false);
      menuBar->Enable(ID_MemoryDbSave, false);
      menuBar->Enable(ID_MemoryDbClock, false);
      menuBar->Enable(ID_Vacuum, true);
      menuBar->Enable(ID_SqlScript, true);
      menuBar->Enable(ID_LoadShp, true);
      menuBar->Enable(ID_VirtualShp, true);
      menuBar->Enable(ID_LoadTxt, true);
      menuBar->Enable(ID_VirtualTxt, true);
      menuBar->Enable(ID_Network, true);
      menuBar->Enable(ID_Exif, true);
      menuBar->Enable(ID_Srids, false);
      wxToolBar *toolBar = GetToolBar();
      toolBar->EnableTool(ID_Connect, false);
      toolBar->EnableTool(ID_CreateNew, false);
      toolBar->EnableTool(ID_Disconnect, true);
      toolBar->EnableTool(ID_MemoryDbLoad, false);
      toolBar->EnableTool(ID_MemoryDbNew, false);
      toolBar->EnableTool(ID_MemoryDbSave, false);
      toolBar->EnableTool(ID_MemoryDbClock, false);
      toolBar->EnableTool(ID_Vacuum, true);
      toolBar->EnableTool(ID_SqlScript, true);
      toolBar->EnableTool(ID_LoadShp, true);
      toolBar->EnableTool(ID_VirtualShp, true);
      toolBar->EnableTool(ID_LoadTxt, true);
      toolBar->EnableTool(ID_VirtualTxt, true);
      toolBar->EnableTool(ID_Network, true);
      toolBar->EnableTool(ID_Exif, true);
      toolBar->EnableTool(ID_Srids, false);
      UpdateStatusBar();
      return;
  } else
    return;
error:
  unlink(SqlitePath.ToUTF8());
  wxString msg = wxT("An error occurred\nno DB was created");
  wxMessageBox(msg, wxT("spatialite-gui"), wxOK | wxICON_ERROR, this);
  return;
}

void MyFrame::OnMemoryDbLoad(wxCommandEvent & WXUNUSED(event))
{
//
// loading an external DB into the MEMORY-DB
//
  sqlite3 *extSqlite = NULL;
  sqlite3_backup *backup;
  int retdlg;
  int ret;
  wxString lastDir;
  char path[1024];
  wxString error;
  wxFileDialog *fileDialog =
    new wxFileDialog(this, wxT("Loading an existing DB into the MEMORY-DB"),
                     wxT(""), wxT("db.sqlite"),
                     wxT("SQLite DB (*.sqlite)|*.sqlite|All files (*.*)|*.*"),
                     wxFD_OPEN | wxFD_FILE_MUST_EXIST,
                     wxDefaultPosition,
                     wxDefaultSize,
                     wxT("filedlg"));
  lastDir = GetLastDirectory();
  if (lastDir.Len() >= 1)
    fileDialog->SetDirectory(lastDir);
  retdlg = fileDialog->ShowModal();
  if (retdlg == wxID_OK)
    {
      // opening the external DB
      ExternalSqlitePath = fileDialog->GetPath();
      strcpy(path, ExternalSqlitePath.ToUTF8());
      ret = sqlite3_open_v2(path, &extSqlite, SQLITE_OPEN_READWRITE, NULL);
      if (ret)
        {
          // an error occurred
          wxString errCause = wxString::FromUTF8(sqlite3_errmsg(SqliteHandle));
          error = wxT("Failure while connecting to DB\n\n");
          error += errCause;
          error += wxT("\n");
          goto stop;
        }
      ret =
        sqlite3_open_v2(":memory:", &SqliteHandle,
                        SQLITE_OPEN_READWRITE | SQLITE_OPEN_CREATE, NULL);
      if (ret)
        {
          // an error occurred
          wxString errCause = wxString::FromUTF8(sqlite3_errmsg(SqliteHandle));
          error = wxT("MEMORY-DB: an error occurred \n\n");
          error += errCause;
          error += +wxT("\n");
          goto stop;
        }
      wxFileName file(fileDialog->GetPath());
      lastDir = file.GetPath();
      SetLastDirectory(lastDir);
      backup = sqlite3_backup_init(SqliteHandle, "main", extSqlite, "main");
      if (!backup)
        goto stop;
      while (1)
        {
          ret = sqlite3_backup_step(backup, 1024);
          if (ret == SQLITE_DONE)
            break;
        }
      ret = sqlite3_backup_finish(backup);
      sqlite3_close(extSqlite);
      MemoryDatabase = true;
      AutoSaveInterval = 120;
      AutoFDOStart();
      InitTableTree();
      bool metadata = CheckMetadata();
      wxMenuBar *menuBar = GetMenuBar();
      menuBar->Enable(ID_Connect, false);
      menuBar->Enable(ID_CreateNew, false);
      menuBar->Enable(ID_Disconnect, true);
      menuBar->Enable(ID_MemoryDbLoad, false);
      menuBar->Enable(ID_MemoryDbNew, false);
      if (MemoryDatabase == true)
        {
          menuBar->Enable(ID_MemoryDbSave, true);
          menuBar->Enable(ID_MemoryDbClock, true);
      } else
        {
          menuBar->Enable(ID_MemoryDbSave, false);
          menuBar->Enable(ID_MemoryDbClock, false);
        }
      menuBar->Enable(ID_Vacuum, true);
      menuBar->Enable(ID_SqlScript, true);
      menuBar->Enable(ID_LoadShp, true);
      menuBar->Enable(ID_VirtualShp, true);
      menuBar->Enable(ID_LoadTxt, true);
      menuBar->Enable(ID_VirtualTxt, true);
      menuBar->Enable(ID_Network, true);
      menuBar->Enable(ID_Exif, true);
      menuBar->Enable(ID_Srids, metadata);
      wxToolBar *toolBar = GetToolBar();
      toolBar->EnableTool(ID_Connect, false);
      toolBar->EnableTool(ID_CreateNew, false);
      toolBar->EnableTool(ID_Disconnect, true);
      toolBar->EnableTool(ID_MemoryDbLoad, false);
      toolBar->EnableTool(ID_MemoryDbNew, false);
      if (MemoryDatabase == true)
        {
          toolBar->EnableTool(ID_MemoryDbSave, true);
          toolBar->EnableTool(ID_MemoryDbClock, true);
      } else
        {
          toolBar->EnableTool(ID_MemoryDbSave, false);
          toolBar->EnableTool(ID_MemoryDbClock, false);
        }
      toolBar->EnableTool(ID_Vacuum, true);
      toolBar->EnableTool(ID_SqlScript, true);
      toolBar->EnableTool(ID_LoadShp, true);
      toolBar->EnableTool(ID_VirtualShp, true);
      toolBar->EnableTool(ID_LoadTxt, true);
      toolBar->EnableTool(ID_VirtualTxt, true);
      toolBar->EnableTool(ID_Network, true);
      toolBar->EnableTool(ID_Exif, true);
      toolBar->EnableTool(ID_Srids, metadata);
      UpdateStatusBar();
      if (AutoSaveInterval <= 0)
        {
          if (TimerAutoSave)
            {
              TimerAutoSave->Stop();
              delete TimerAutoSave;
              TimerAutoSave = NULL;
            }
      } else
        {
          //
          // starting the AutoSave timer
          //
          if (!TimerAutoSave)
            TimerAutoSave = new wxTimer(this, ID_AUTO_SAVE_TIMER);
          else
            TimerAutoSave->Stop();
          LastTotalChanges = 0;
          TimerAutoSave->Start(AutoSaveInterval * 1000, wxTIMER_ONE_SHOT);
        }
    }
  if (AutoFDOmsg.Len() > 0)
    {
      wxMessageBox(AutoFDOmsg, wxT("spatialite-gui"), wxOK | wxICON_INFORMATION,
                   this);
      AutoFDOmsg = wxT("");
    }
  return;
stop:
  MemoryDatabase = false;
  if (SqliteHandle)
    sqlite3_close(SqliteHandle);
  if (extSqlite)
    sqlite3_close(extSqlite);
  wxString msg = wxT("MEMORY-DB wasn't loaded\n\n");
  msg += error;
  wxMessageBox(msg, wxT("spatialite-gui"), wxOK | wxICON_ERROR, this);
  SqliteHandle = NULL;
}

void MyFrame::OnMemoryDbNew(wxCommandEvent & WXUNUSED(event))
{
//
//creating a new MEMORY-DB
//
  int ret;
  wxToolBar *toolBar;
  wxMenuBar *menuBar;
  bool metadata;
  MemoryDatabase = true;
  AutoSaveInterval = 120;
  ExternalSqlitePath = wxT("");
// creating the new MEMORY-DB
  ret = CreateDB();
  if (ret == false)
    goto error;
  metadata = CheckMetadata();
  menuBar = GetMenuBar();
  menuBar->Enable(ID_Connect, false);
  menuBar->Enable(ID_CreateNew, false);
  menuBar->Enable(ID_Disconnect, true);
  menuBar->Enable(ID_MemoryDbLoad, false);
  menuBar->Enable(ID_MemoryDbNew, false);
  menuBar->Enable(ID_MemoryDbSave, true);
  menuBar->Enable(ID_MemoryDbClock, true);
  menuBar->Enable(ID_Vacuum, true);
  menuBar->Enable(ID_SqlScript, true);
  menuBar->Enable(ID_LoadShp, true);
  menuBar->Enable(ID_VirtualShp, true);
  menuBar->Enable(ID_LoadTxt, true);
  menuBar->Enable(ID_VirtualTxt, true);
  menuBar->Enable(ID_Network, true);
  menuBar->Enable(ID_Exif, true);
  menuBar->Enable(ID_Srids, metadata);
  toolBar = GetToolBar();
  toolBar->EnableTool(ID_Connect, false);
  toolBar->EnableTool(ID_CreateNew, false);
  toolBar->EnableTool(ID_Disconnect, true);
  toolBar->EnableTool(ID_MemoryDbLoad, false);
  toolBar->EnableTool(ID_MemoryDbNew, false);
  toolBar->EnableTool(ID_MemoryDbSave, true);
  toolBar->EnableTool(ID_MemoryDbClock, true);
  toolBar->EnableTool(ID_Vacuum, true);
  toolBar->EnableTool(ID_SqlScript, true);
  toolBar->EnableTool(ID_LoadShp, true);
  toolBar->EnableTool(ID_VirtualShp, true);
  toolBar->EnableTool(ID_LoadTxt, true);
  toolBar->EnableTool(ID_VirtualTxt, true);
  toolBar->EnableTool(ID_Network, true);
  toolBar->EnableTool(ID_Exif, true);
  toolBar->EnableTool(ID_Srids, metadata);
  UpdateStatusBar();
  if (AutoSaveInterval <= 0)
    {
      if (TimerAutoSave)
        {
          TimerAutoSave->Stop();
          delete TimerAutoSave;
          TimerAutoSave = NULL;
        }
  } else
    {
      //
      // starting the AutoSave timer
      //
      if (!TimerAutoSave)
        TimerAutoSave = new wxTimer(this, ID_AUTO_SAVE_TIMER);
      else
        TimerAutoSave->Stop();
      LastTotalChanges = 0;
      TimerAutoSave->Start(AutoSaveInterval * 1000, wxTIMER_ONE_SHOT);
    }
  return;
error:
  wxString msg = wxT("An error occurred\nno MEMORY-DB was created");
  wxMessageBox(msg, wxT("spatialite-gui"), wxOK | wxICON_ERROR, this);
  return;
}

bool MyFrame::MemoryDbSave()
{
//
// trying to export the MEMORY-DB into an external DB
//
  sqlite3 *extSqlite = NULL;
  sqlite3_backup *backup;
  char path[1024];
  char bak_path[1024];
  int ret;
  wxString error;
  if (ExternalSqlitePath.Len() == 0)
    return false;
  ::wxBeginBusyCursor();
  strcpy(path, ExternalSqlitePath.ToUTF8());
  strcpy(bak_path, path);
  strcat(bak_path, ".bak");
  unlink(bak_path);
  rename(path, bak_path);
  ret =
    sqlite3_open_v2(path, &extSqlite,
                    SQLITE_OPEN_READWRITE | SQLITE_OPEN_CREATE, NULL);
  if (ret)
    {
      // an error occurred
      wxString errCause = wxString::FromUTF8(sqlite3_errmsg(extSqlite));
      error = wxT("An error occurred\n\n");
      error += errCause;
      error += +wxT("\n");
      error += ExternalSqlitePath;
      goto stop;
    }
  backup = sqlite3_backup_init(extSqlite, "main", SqliteHandle, "main");
  if (!backup)
    goto stop;
  while (1)
    {
      ret = sqlite3_backup_step(backup, 1024);
      if (ret == SQLITE_DONE)
        break;
    }
  ret = sqlite3_backup_finish(backup);
  sqlite3_close(extSqlite);
  unlink(bak_path);
  ::wxEndBusyCursor();
  LastTotalChanges = sqlite3_total_changes(SqliteHandle);
  return true;
stop:
  if (extSqlite)
    sqlite3_close(extSqlite);
  wxString msg = wxT("Backup failure: MEMORY-DB wasn't saved\n\n");
  msg += error;
  wxMessageBox(msg, wxT("spatialite-gui"), wxOK | wxICON_ERROR, this);
  ExternalSqlitePath = wxT("");
  ::wxEndBusyCursor();
  return false;
}

void MyFrame::OnMemoryDbSave(wxCommandEvent & WXUNUSED(event))
{
//
//  exporting the MEMORY-DB into an external DB 
//
  int retdlg;
  wxString lastDir;
  if (ExternalSqlitePath.Len() > 0)
    {
      if (MemoryDbSave() == true)
        {
          wxMessageBox(wxT("Ok, MEMORY-DB was succesfully saved"),
                       wxT("spatialite-gui"), wxOK | wxICON_INFORMATION, this);
          if (AutoSaveInterval <= 0)
            {
              if (TimerAutoSave)
                {
                  TimerAutoSave->Stop();
                  delete TimerAutoSave;
                  TimerAutoSave = NULL;
                }
          } else
            {
              //
              // restarting the AutoSave timer
              //
              if (!TimerAutoSave)
                TimerAutoSave = new wxTimer(this, ID_AUTO_SAVE_TIMER);
              else
                TimerAutoSave->Stop();
              TimerAutoSave->Start(AutoSaveInterval * 1000, wxTIMER_ONE_SHOT);
            }
          return;
        }
    }
  wxFileDialog *fileDialog = new wxFileDialog(this, wxT("Saving the MEMORY-DB"),
                                              wxT(""), wxT("db.sqlite"),
                                              wxT
                                              ("SQLite DB (*.sqlite)|*.sqlite|All files (*.*)|*.*"),
                                              wxFD_SAVE | wxFD_OVERWRITE_PROMPT,
                                              wxDefaultPosition,
                                              wxDefaultSize,
                                              wxT("filedlg"));
  lastDir = GetLastDirectory();
  if (lastDir.Len() >= 1)
    fileDialog->SetDirectory(lastDir);
  retdlg = fileDialog->ShowModal();
  if (retdlg == wxID_OK)
    {
      // exporting the external DB
      ExternalSqlitePath = fileDialog->GetPath();
      if (MemoryDbSave() == true)
        {
          wxMessageBox(wxT("Ok, MEMORY-DB was succesfully saved"),
                       wxT("spatialite-gui"), wxOK | wxICON_INFORMATION, this);
          wxFileName file(fileDialog->GetPath());
          lastDir = file.GetPath();
          SetLastDirectory(lastDir);
          if (AutoSaveInterval <= 0)
            {
              if (TimerAutoSave)
                {
                  TimerAutoSave->Stop();
                  delete TimerAutoSave;
                  TimerAutoSave = NULL;
                }
          } else
            {
              //
              // restarting the AutoSave timer
              //
              if (!TimerAutoSave)
                TimerAutoSave = new wxTimer(this, ID_AUTO_SAVE_TIMER);
              else
                TimerAutoSave->Stop();
              TimerAutoSave->Start(AutoSaveInterval * 1000, wxTIMER_ONE_SHOT);
            }
        }
    }
}

void MyFrame::OnMemoryDbClock(wxCommandEvent & WXUNUSED(event))
{
//
//  setting up AutoSave for MEMORY-DB 
//
  AutoSaveDialog dlg;
  dlg.Create(this, ExternalSqlitePath, AutoSaveInterval);
  int ret = dlg.ShowModal();
  if (ret == wxID_OK)
    {
      AutoSaveInterval = dlg.GetSeconds();
      if (AutoSaveInterval <= 0)
        {
          //
          // stopping the AutoSave timer
          //
          if (TimerAutoSave)
            {
              TimerAutoSave->Stop();
              delete TimerAutoSave;
              TimerAutoSave = NULL;
            }
      } else
        {
          //
          // restarting the AutoSave timer
          //
          if (!TimerAutoSave)
            TimerAutoSave = new wxTimer(this, ID_AUTO_SAVE_TIMER);
          else
            TimerAutoSave->Stop();
          TimerAutoSave->Start(AutoSaveInterval * 1000, wxTIMER_ONE_SHOT);
        }
    }
}

void MyFrame::OnVacuum(wxCommandEvent & WXUNUSED(event))
{
//
// performing a VACUUM in order to reorganize the current DB
//
  char *errMsg = NULL;
  ::wxBeginBusyCursor();
  int ret = sqlite3_exec(SqliteHandle, "ANALYZE; VACUUM;", NULL, NULL, &errMsg);
  if (ret != SQLITE_OK)
    {
      wxMessageBox(wxT("SQLite SQL error: ") + wxString::FromUTF8(errMsg),
                   wxT("spatialite-gui"), wxOK | wxICON_ERROR, this);
      sqlite3_free(errMsg);
  } else
    {
      wxMessageBox(wxT("Current DB was succesfully optimized"),
                   wxT("spatialite-gui"), wxOK | wxICON_INFORMATION, this);
    }
  ::wxEndBusyCursor();
}

char *MyFrame::ReadSqlLine(FILE * in, int *len, int *eof)
{
//
// reading an SQL script line
//
  int c;
  *eof = 0;
  int size = 4096;
  char *line = (char *) malloc(size);
  int off = 0;
  while ((c = getc(in)) != EOF)
    {
      // consuming input one chat at each time
      if (off == size)
        {
          // buffer overflow; reallocating a bigger one
          // presumably this is because there is some BLOB, so we'll grow by 1MB at each time
          size += 1024 * 1024;
          line = (char *) realloc(line, size);
        }
      *(line + off) = c;
      off++;
      if (c == '\n')
        {
          // end of line marker
          *(line + off) = '\0';
          *len = off;
          return line;
        }
      if (c == ';')
        {
          // end of SQL statement marker
          *(line + off) = '\0';
          *len = off;
          return line;
        }
    }
// EOF reached
  *len = off;
  *eof = 1;
  return line;
}

void MyFrame::OnSqlScript(wxCommandEvent & WXUNUSED(event))
{
//
// executing an SQL Script
//
  int ret;
  wxString lastDir;
  wxString path;
  wxString charset;
  FILE *sql;
  char *line = NULL;
  char *statement = NULL;
  int stmt_len = 0;
  char *prev_stmt;
  int prev_len;
  int eof;
  int rowNo = 1;
  int stmt = 0;
  int len;
  wxString msg;
  char dummy[128];
  void *cvtCS = NULL;
  char *utf8stmt = NULL;
  int cvtErr;
  wxFileDialog *fileDialog = new wxFileDialog(this, wxT("SQL Script"),
                                              wxT(""),
                                              wxT("init_spatialite.sql"),
                                              wxT
                                              ("SQL script (*.sql)|*.sql|All files (*.*)|*.*"),
                                              wxFD_OPEN | wxFD_FILE_MUST_EXIST,
                                              wxDefaultPosition,
                                              wxDefaultSize,
                                              wxT("filedlg"));
  lastDir = GetLastDirectory();
  if (lastDir.Len() >= 1)
    fileDialog->SetDirectory(lastDir);
  ret = fileDialog->ShowModal();
  if (ret == wxID_OK)
    {
      path = fileDialog->GetPath();
      SqlScriptDialog dlg;
      dlg.Create(this, path, LocaleCharset);
      ret = dlg.ShowModal();
      if (ret == wxID_OK)
        charset = dlg.GetCharset();
      else
        return;
      // opening the SQL script
      sql = fopen(path.ToUTF8(), "r");
      if (sql == NULL)
        {
          wxMessageBox(wxT("can't open: ") + fileDialog->GetPath(),
                       wxT("spatialite-gui"), wxOK | wxICON_ERROR, this);
      } else
        {
          wxFileName file(fileDialog->GetPath());
          lastDir = file.GetPath();
          SetLastDirectory(lastDir);
          cvtCS = gaiaCreateUTF8Converter(charset.ToUTF8());
          if (!cvtCS)
            {
              msg = charset + wxT(": unsupported CharacterSet");
              wxMessageBox(msg, wxT("spatialite-gui"), wxOK | wxICON_WARNING,
                           this);
              goto stop;
            }
          ::wxBeginBusyCursor();
          while (1)
            {
              // reading the SQL script lines
              line = ReadSqlLine(sql, &len, &eof);
              if (len > 0)
                {
                  if (statement == NULL)
                    {
                      statement = line;
                      stmt_len = len;
                  } else
                    {
                      // appending line to SQL statement
                      prev_stmt = statement;
                      prev_len = stmt_len;
                      stmt_len = prev_len + len;
                      statement = (char *) malloc(stmt_len + 1);
                      memcpy(statement, prev_stmt, prev_len);
                      memcpy(statement + prev_len, line, len);
                      *(statement + stmt_len) = '\0';
                      free(prev_stmt);
                      free(line);
                      line = NULL;
                    }
              } else
                {
                  free(line);
                  line = NULL;
                }
              if (statement)
                {
                  if (sqlite3_complete(statement))
                    {
                      // executing the SQL statement
                      utf8stmt =
                        gaiaConvertToUTF8(cvtCS, statement, stmt_len, &cvtErr);
                      free(statement);
                      statement = NULL;
                      stmt_len = 0;
                      if (cvtErr || !utf8stmt)
                        {
                          Rollback();
                          msg =
                            wxT
                            ("SQL Script abnormal termination\nillegal character sequence");
                          msg +=
                            wxT("\n\nROLLBACK was automatically performed");
                          wxMessageBox(msg, wxT("spatialite-gui"),
                                       wxOK | wxICON_WARNING, this);
                          goto stop;
                        }
                      if (ExecuteSql(utf8stmt, rowNo) == false)
                        {
                          Rollback();
                          msg =
                            wxT
                            ("SQL Script abnormal termination\nan error occurred");
                          msg +=
                            wxT("\n\nROLLBACK was automatically performed");
                          wxMessageBox(msg, wxT("spatialite-gui"),
                                       wxOK | wxICON_WARNING, this);
                          goto stop;
                      } else
                        {
                          stmt++;
                          free(utf8stmt);
                          utf8stmt = NULL;
                        }
                    }
                }
              rowNo++;
              if (eof)
                break;
            }
          sprintf(dummy,
                  "SQL Script normal termination\n\n%d SQL statements where performed",
                  stmt);
          msg = wxString::FromUTF8(dummy);
          wxMessageBox(msg, wxT("spatialite-gui"), wxOK | wxICON_INFORMATION,
                       this);
        stop:
          if (cvtCS)
            gaiaFreeUTF8Converter(cvtCS);
          if (utf8stmt)
            free(utf8stmt);
          if (statement)
            free(statement);
          if (line)
            free(line);
          fclose(sql);
          ::wxEndBusyCursor();
        }
    }
}

void MyFrame::OnLoadShp(wxCommandEvent & WXUNUSED(event))
{
//
// loading a shapefile
//
  int ret;
  wxString table;
  wxString column = wxT("Geometry");
  wxString charset;
  int srid = -1;
  wxString path;
  wxString lastDir;
  wxFileDialog *fileDialog = new wxFileDialog(this, wxT("Load Shapefile"),
                                              wxT(""),
                                              wxT("shapefile.shp"),
                                              wxT
                                              ("Shapefile (*.shp)|*.shp|All files (*.*)|*.*"),
                                              wxFD_OPEN | wxFD_FILE_MUST_EXIST,
                                              wxDefaultPosition,
                                              wxDefaultSize,
                                              wxT("filedlg"));
  lastDir = GetLastDirectory();
  if (lastDir.Len() >= 1)
    fileDialog->SetDirectory(lastDir);
  ret = fileDialog->ShowModal();
  if (ret == wxID_OK)
    {
      wxFileName file(fileDialog->GetPath());
      lastDir = file.GetPath();
      table = file.GetName();
      path = file.GetPath();
      path += file.GetPathSeparator();
      path += file.GetName();
      LoadShpDialog dlg;
      dlg.Create(this, path, table, srid, column, LocaleCharset);
      ret = dlg.ShowModal();
      if (ret == wxID_OK)
        {
          SetLastDirectory(lastDir);
          table = dlg.GetTable();
          srid = dlg.GetSrid();
          column = dlg.GetColumn();
          charset = dlg.GetCharset();
          LoadShapefile(path, table, srid, column, charset);
        }
    }
}

void MyFrame::OnVirtualShp(wxCommandEvent & WXUNUSED(event))
{
//
// creating a VirtualShape
//
  int ret;
  wxString charset;
  int srid;
  char dummy[128];
  wxString sql;
  wxString path;
  wxString table;
  wxString lastDir;
  char *errMsg = NULL;
  sqlite3 *sqlite = GetSqlite();
  wxFileDialog *fileDialog = new wxFileDialog(this, wxT("VirtualShape"),
                                              wxT(""),
                                              wxT("shapefile.shp"),
                                              wxT
                                              ("Shapefile (*.shp)|*.shp|All files (*.*)|*.*"),
                                              wxFD_OPEN | wxFD_FILE_MUST_EXIST,
                                              wxDefaultPosition,
                                              wxDefaultSize,
                                              wxT("filedlg"));
  lastDir = GetLastDirectory();
  if (lastDir.Len() >= 1)
    fileDialog->SetDirectory(lastDir);
  ret = fileDialog->ShowModal();
  if (ret == wxID_OK)
    {
      path = fileDialog->GetPath();
      wxFileName file(path);
      table = file.GetName();
      VirtualShpDialog dlg;
      dlg.Create(this, path, table, LocaleCharset);
      ret = dlg.ShowModal();
      if (ret == wxID_OK)
        {
          table = dlg.GetTable();
          srid = dlg.GetSrid();
          charset = dlg.GetCharset();
      } else
        return;
      lastDir = file.GetPath();
      SetLastDirectory(lastDir);
      sql = wxT("CREATE VIRTUAL TABLE \"");
      sql += table;
      sql += wxT("\"\nUSING VirtualShape('");
      sql += file.GetPath();
      sql += file.GetPathSeparator();
      sql += file.GetName();
      sql += wxT("',\n'");
      sql += charset;
      sprintf(dummy, "', %d", srid);
      sql += wxString::FromUTF8(dummy);
      sql += wxT(")");
      ret = sqlite3_exec(sqlite, sql.ToUTF8(), NULL, NULL, &errMsg);
      if (ret != SQLITE_OK)
        {
          wxMessageBox(wxT("SQLite SQL error: ") + wxString::FromUTF8(errMsg),
                       wxT("spatialite-gui"), wxOK | wxICON_ERROR, this);
          sqlite3_free(errMsg);
          return;
        }
      wxMessageBox(wxT("Virtual Table \"") + table +
                   wxT("\" was successfully created"), wxT("spatialite-gui"),
                   wxOK | wxICON_INFORMATION, this);
      InitTableTree();
    }
}

void MyFrame::OnLoadTxt(wxCommandEvent & WXUNUSED(event))
{
//
// loading a CSV/TXT
//
  int ret;
  wxString charset;
  wxString sql;
  wxString path;
  wxString table;
  wxString lastDir;
  bool first_titles;
  bool decimal_comma;
  char separator;
  char text_separator;
  wxString filelist = wxT("TXT and CSV files (*.txt;*.csv)|*.txt;*.csv");
  filelist +=
    wxT("|Text file (*.txt)|*.txt|CSV file (*.csv)|*.csv|All files (*.*)|*.*");
  wxFileDialog *fileDialog = new wxFileDialog(this, wxT("Load CSV/TXT"),
                                              wxT(""),
                                              wxT("textfile.txt"),
                                              filelist,
                                              wxFD_OPEN | wxFD_FILE_MUST_EXIST,
                                              wxDefaultPosition,
                                              wxDefaultSize,
                                              wxT("filedlg"));
  lastDir = GetLastDirectory();
  if (lastDir.Len() >= 1)
    fileDialog->SetDirectory(lastDir);
  ret = fileDialog->ShowModal();
  if (ret == wxID_OK)
    {
      path = fileDialog->GetPath();
      wxFileName file(path);
      table = file.GetName();
      LoadTxtDialog dlg;
      dlg.Create(this, path, table, LocaleCharset);
      ret = dlg.ShowModal();
      if (ret == wxID_OK)
        {
          SetLastDirectory(lastDir);
          table = dlg.GetTable();
          charset = dlg.GetCharset();
          first_titles = dlg.IsFirstLineTitles();
          decimal_comma = dlg.IsDecimalPointComma();
          separator = dlg.GetSeparator();
          text_separator = dlg.GetTextSeparator();
          char decimal_separator = '.';
          if (decimal_comma == true)
            decimal_separator = ',';
          LoadText(path, table, charset, first_titles, decimal_separator,
                   separator, text_separator);
        }
    }
}

void MyFrame::OnVirtualTxt(wxCommandEvent & WXUNUSED(event))
{
//
// creating a VirtualText
//
  int ret;
  wxString charset;
  wxString sql;
  wxString path;
  wxString table;
  wxString lastDir;
  bool first_titles;
  bool decimal_comma;
  char separator;
  char text_separator;
  char dummy[16];
  char *errMsg = NULL;
  sqlite3 *sqlite = GetSqlite();
  wxString filelist = wxT("TXT and CSV files (*.txt;*.csv)|*.txt;*.csv");
  filelist +=
    wxT("|Text file (*.txt)|*.txt|CSV file (*.csv)|*.csv|All files (*.*)|*.*");
  wxFileDialog *fileDialog = new wxFileDialog(this, wxT("VirtualText"),
                                              wxT(""),
                                              wxT("textfile.txt"),
                                              filelist,
                                              wxFD_OPEN | wxFD_FILE_MUST_EXIST,
                                              wxDefaultPosition,
                                              wxDefaultSize,
                                              wxT("filedlg"));
  lastDir = GetLastDirectory();
  if (lastDir.Len() >= 1)
    fileDialog->SetDirectory(lastDir);
  ret = fileDialog->ShowModal();
  if (ret == wxID_OK)
    {
      path = fileDialog->GetPath();
      wxFileName file(path);
      table = file.GetName();
      VirtualTxtDialog dlg;
      dlg.Create(this, path, table, LocaleCharset);
      ret = dlg.ShowModal();
      if (ret == wxID_OK)
        {
          table = dlg.GetTable();
          charset = dlg.GetCharset();
          first_titles = dlg.IsFirstLineTitles();
          decimal_comma = dlg.IsDecimalPointComma();
          separator = dlg.GetSeparator();
          text_separator = dlg.GetTextSeparator();
      } else
        return;
      lastDir = file.GetPath();
      SetLastDirectory(lastDir);
      sql = wxT("CREATE VIRTUAL TABLE \"");
      sql += table;
      sql += wxT("\"\nUSING VirtualText('");
      sql += path;
      sql += wxT("',\n'");
      sql += charset;
      if (first_titles == true)
        sql += wxT("', 1");
      else
        sql += wxT("', 0");
      if (decimal_comma == true)
        sql += wxT(", COMMA");
      else
        sql += wxT(", POINT");
      if (text_separator == '\'')
        sql += wxT(", SINGLEQUOTE");
      else
        sql += wxT(", DOUBLEQUOTE");
      if (separator == '\t')
        sql += wxT(", TAB");
      else
        {
          sprintf(dummy, ", '%c'", separator);
          sql += wxString::FromUTF8(dummy);
        }
      sql += wxT(")");
      ret = sqlite3_exec(sqlite, sql.ToUTF8(), NULL, NULL, &errMsg);
      if (ret != SQLITE_OK)
        {
          wxMessageBox(wxT("SQLite SQL error: ") + wxString::FromUTF8(errMsg),
                       wxT("spatialite-gui"), wxOK | wxICON_ERROR, this);
          sqlite3_free(errMsg);
          return;
        }
      wxMessageBox(wxT("Virtual Table \"") + table +
                   wxT("\" was successfully created"), wxT("spatialite-gui"),
                   wxOK | wxICON_INFORMATION, this);
      InitTableTree();
    }
}

void MyFrame::OnNetwork(wxCommandEvent & WXUNUSED(event))
{
//
// building a Network
//
  NetworkDialog dlg;
  int ret;
  wxString table;
  wxString from;
  wxString to;
  wxString geom;
  bool isGeomLength;
  wxString cost;
  bool isBidirectional;
  bool isOneWays;
  wxString oneWayToFrom;
  wxString oneWayFromTo;
  dlg.Create(this);
  ret = dlg.ShowModal();
  if (ret == wxID_OK)
    {
      table = dlg.GetTableName();
      from = dlg.GetFromColumn();
      to = dlg.GetToColumn();
      geom = dlg.GetGeomColumn();
      isGeomLength = dlg.IsGeomLength();
      cost = dlg.GetCostColumn();
      isBidirectional = dlg.IsBidirectional();
      isOneWays = dlg.IsOneWays();
      oneWayToFrom = dlg.GetOneWayToFrom();
      oneWayFromTo = dlg.GetOneWayFromTo();
      BuildNetwork(table, from, to, geom, isGeomLength, cost, isBidirectional,
                   isOneWays, oneWayFromTo, oneWayToFrom);
    }
}

void MyFrame::OnImportExifPhotos(wxCommandEvent & WXUNUSED(event))
{
//
// importing EXIF Photos
//
  ExifDialog dlg;
  int ret;
  wxString path;
  bool isFolder;
  bool isMetadata;
  bool isGpsOnly;
  wxString lastDir;
  wxString dir_path;
  wxString img_path;
  wxString filelist = wxT("JPEG files (*.jpg;*.jpeg)|*.jpg;*.jpeg|");
  filelist += wxT("All files (*.*)|*.*");
  wxFileDialog *fileDialog =
    new wxFileDialog(this, wxT("EXIF File/Folder selection"),
                     wxT(""),
                     wxT(""),
                     filelist,
                     wxFD_OPEN | wxFD_FILE_MUST_EXIST,
                     wxDefaultPosition,
                     wxDefaultSize,
                     wxT("filedlg"));
  lastDir = GetLastDirectory();
  if (lastDir.Len() >= 1)
    fileDialog->SetDirectory(lastDir);
  ret = fileDialog->ShowModal();
  if (ret == wxID_OK)
    {
      img_path = fileDialog->GetPath();
      wxFileName file(img_path);
      dir_path = file.GetPath();
  } else
    return;
  dlg.Create(this, dir_path, img_path);
  ret = dlg.ShowModal();
  if (ret == wxID_OK)
    {
      SetLastDirectory(dir_path);
      isFolder = dlg.IsFolder();
      if (isFolder == true)
        path = dlg.GetDirPath();
      else
        path = dlg.GetImgPath();
      isMetadata = dlg.IsMetadata();
      isGpsOnly = dlg.IsGpsOnly();
      ImportExifPhotos(path, isFolder, isMetadata, isGpsOnly);
    }
}

void MyFrame::OnSrids(wxCommandEvent & WXUNUSED(event))
{
//
// searching a SRID by name
//
  SearchSridDialog dlg;
  int ret;
  wxString string;
  wxString sql;
  dlg.Create(this);
  ret = dlg.ShowModal();
  if (ret == wxID_OK)
    {
      string = dlg.GetString();
      sql = wxT("SELECT * FROM spatial_ref_sys\n");
      sql += wxT("WHERE ref_sys_name LIKE '%");
      sql += string;
      sql += wxT("%'\nORDER BY srid");
      QueryView->SetSql(sql, true);
    }
}

void MyFrame::OnCharset(wxCommandEvent & WXUNUSED(event))
{
//
// setting the default CHARSET
//
  DefaultCharsetDialog dlg;
  int ret;
  dlg.Create(this, DefaultCharset, AskCharset);
  ret = dlg.ShowModal();
  if (ret == wxID_OK)
    {
      DefaultCharset = dlg.GetCharset();
      AskCharset = dlg.IsSetAskCharset();
    }
}

void MyFrame::OnTimerAutoSave(wxTimerEvent & event)
{
//
// AutoSave - Timer event handler
// 
  int tc = sqlite3_total_changes(SqliteHandle);
  if (tc != LastTotalChanges)
    MemoryDbSave();
  if (AutoSaveInterval <= 0)
    {
      delete TimerAutoSave;
      TimerAutoSave = NULL;
  } else
    TimerAutoSave->Start(AutoSaveInterval * 1000, wxTIMER_ONE_SHOT);
}

bool MyFrame::ExecuteSql(const char *sql, int rowNo)
{
//
// executes an SQL statement from the SQL script
//
  int ret;
  char *errMsg = NULL;
  wxString msg;
  char dummy[128];
  ret = sqlite3_exec(SqliteHandle, sql, NULL, NULL, &errMsg);
  if (ret != SQLITE_OK)
    {
      sprintf(dummy, "row %d\n\nSQLite SQL error: ", rowNo);
      msg = wxString::FromUTF8(dummy);
      wxMessageBox(msg + wxString::FromUTF8(errMsg), wxT("spatialite-gui"),
                   wxOK | wxICON_ERROR, this);
      sqlite3_free(errMsg);
      return false;
    }
  return true;
}

void MyFrame::Rollback()
{
//
// performing a ROLLBACK
//
  sqlite3_exec(SqliteHandle, "ROLLBACK", NULL, NULL, NULL);
}

bool MyFrame::OpenDB()
{
//
// establishing a physical connetion to some DB SQLite
//
  int ret;
  ret =
    sqlite3_open_v2(SqlitePath.ToUTF8(), &SqliteHandle, SQLITE_OPEN_READWRITE,
                    NULL);
  if (ret)
    {
      // an error occurred
      wxString errCause;
      errCause = wxString::FromUTF8(sqlite3_errmsg(SqliteHandle));
      sqlite3_close(SqliteHandle);
      wxMessageBox(wxT("Failure while connecting to DB\n\n") + errCause +
                   wxT("\n") + SqlitePath, wxT("spatialite-gui"),
                   wxOK | wxICON_ERROR, this);
      SqliteHandle = NULL;
      ClearTableTree();
      MemoryDatabase = false;
      return false;
    }
  AutoFDOStart();
  InitTableTree();
  return true;
}

void MyFrame::LastDitchMemoryDbSave()
{
//
// performing the last desperate attempt to save a MEMORY-DB
//
  int tc;
  int ret;
  wxString lastDir;
  if (MemoryDatabase == false)
    return;
  if (!SqliteHandle)
    return;
  tc = sqlite3_total_changes(SqliteHandle);
  if (tc == LastTotalChanges)
    return;
  while (1)
    {
      // OK, this MEMORY-DB needs to be saved
      if (MemoryDbSave() == true)
        break;
      // we must ask the user
      wxString msg =
        wxT("WARNING: the MEMORY-DB contains uncommitted changes\n\n");
      msg += wxT("The MEMORY_DB is intrinsecally volatile, so these changes\n");
      msg +=
        wxT("will be irremediably lost if you don't export them to some\n");
      msg += wxT("persistent storage [i.e. on the file-system]\n\n");
      msg +=
        wxT
        ("Do you want to export [SAVE] the MEMORY-DB to some external database ?");
      ret =
        wxMessageBox(msg, wxT("spatialite-gui"), wxYES_NO | wxICON_QUESTION,
                     this);
      if (ret != wxYES)
        break;
      // asking a PATHNAME to the user
      wxFileDialog *fileDialog =
        new wxFileDialog(this, wxT("Saving the MEMORY-DB"),
                         wxT(""), wxT("db.sqlite"),
                         wxT
                         ("SQLite DB (*.sqlite)|*.sqlite|All files (*.*)|*.*"),
                         wxFD_SAVE | wxFD_OVERWRITE_PROMPT,
                         wxDefaultPosition,
                         wxDefaultSize,
                         wxT("filedlg"));
      lastDir = GetLastDirectory();
      if (lastDir.Len() >= 1)
        fileDialog->SetDirectory(lastDir);
      ret = fileDialog->ShowModal();
      if (ret == wxID_OK)
        {
          // exporting the external DB
          ExternalSqlitePath = fileDialog->GetPath();
          if (MemoryDbSave() == true)
            {
              wxMessageBox(wxT("Ok, MEMORY-DB was succesfully saved"),
                           wxT("spatialite-gui"), wxOK | wxICON_INFORMATION,
                           this);
              break;
            }
        }
    }
}

void MyFrame::CloseDB()
{
//
// disconnecting current SQLite DB
//
  if (!SqliteHandle)
    return;
  AutoFDOStop();
  if (AutoFDOmsg.Len() > 0)
    wxMessageBox(AutoFDOmsg, wxT("spatialite-gui"), wxOK | wxICON_INFORMATION,
                 this);
  LastDitchMemoryDbSave();
  sqlite3_close(SqliteHandle);
  SqliteHandle = NULL;
  SqlitePath = wxT("");
  MemoryDatabase = false;
  ClearTableTree();
}

bool MyFrame::CreateDB()
{
// creating a new, empty SQLite DB
  int ret;
  char path[1024];
  if (MemoryDatabase == true)
    strcpy(path, ":memory:");
  else
    {
      strcpy(path, SqlitePath.ToUTF8());
      unlink(path);
    }
  ret =
    sqlite3_open_v2(path, &SqliteHandle,
                    SQLITE_OPEN_READWRITE | SQLITE_OPEN_CREATE, NULL);
  if (ret)
    {
      // an error occurred
      wxString errCause;
      errCause = wxString::FromUTF8(sqlite3_errmsg(SqliteHandle));
      sqlite3_close(SqliteHandle);
      wxMessageBox(wxT("An error occurred\n\n") + errCause + wxT("\n") +
                   SqlitePath, wxT("spatialite-gui"), wxOK | wxICON_ERROR,
                   this);
      SqliteHandle = NULL;
      ClearTableTree();
      MemoryDatabase = false;
      return false;
    }
  if (CreateSpatialMetaData() == false)
    wxMessageBox(wxT("Spatial Metadata tables creation error\n") +
                 SqlitePath, wxT("spatialite-gui"), wxOK | wxICON_ERROR, this);
  AutoFDOStart();
  InitTableTree();
  return true;
}

void MyFrame::CleanSql(char *buf)
{
// well-formatting a string to be used as an SQL string
  char tmp[1024];
  char *in = tmp;
  char *out = buf;
  strcpy(tmp, buf);
  while (*in != '\0')
    {
      if (*in == '\'')
        *out++ = '\'';
      *out++ = *in++;
    }
  *out = '\0';
}

void MyFrame::InitTableTree()
{
// loads the table TREE list
  int i;
  char **results;
  int rows;
  int columns;
  char *errMsg = NULL;
  char *name;
  char *createSql;
  char *type;
  wxString tblName;
  wxString sql;
  bool virtualTable = false;
  TableTree->Show(false);
  if (MemoryDatabase == true)
    {
      wxString memory = wxT("MEMORY-DB");
      TableTree->SetPath(memory);
  } else
    TableTree->SetPath(SqlitePath);
  TableTree->FlushAll();
  sql =
    wxT
    ("SELECT name, sql, type FROM sqlite_master WHERE (type = 'table' OR type = 'view') ORDER BY name");
  int ret = sqlite3_get_table(SqliteHandle, sql.ToUTF8(), &results,
                              &rows, &columns, &errMsg);
  if (ret != SQLITE_OK)
    {
      wxMessageBox(wxT("SQLite SQL error: ") + wxString::FromUTF8(errMsg),
                   wxT("spatialite-gui"), wxOK | wxICON_ERROR, this);
      sqlite3_free(errMsg);
      return;
    }
  if (rows < 1)
    ;
  else
    {
      for (i = 1; i <= rows; i++)
        {
          name = results[(i * columns) + 0];
          createSql = results[(i * columns) + 1];
          type = results[(i * columns) + 2];
          if (strstr(createSql, "VIRTUAL") || strstr(createSql, "virtual"))
            virtualTable = true;
          else
            virtualTable = false;
          tblName = wxString::FromUTF8(name);
          if (strcmp(type, "view") == 0)
            TableTree->AddView(tblName);
          else
            TableTree->AddTable(tblName, virtualTable);
        }
    }
  sqlite3_free_table(results);
  TableTree->ExpandRoot();
  TableTree->Show(true);
}

wxString *MyFrame::GetTables(int *n)
{
// loads the table list
  int i;
  char **results;
  int rows;
  int columns;
  char *errMsg = NULL;
  char *name;
  wxString *tables = NULL;
  wxString sql;
  *n = 0;
  sql =
    wxT("SELECT name FROM sqlite_master WHERE type = 'table' ORDER BY name");
  int ret = sqlite3_get_table(SqliteHandle, sql.ToUTF8(), &results,
                              &rows, &columns, &errMsg);
  if (ret != SQLITE_OK)
    {
      wxMessageBox(wxT("SQLite SQL error: ") + wxString::FromUTF8(errMsg),
                   wxT("spatialite-gui"), wxOK | wxICON_ERROR, this);
      sqlite3_free(errMsg);
      return tables;
    }
  if (rows < 1)
    ;
  else
    {
      tables = new wxString[rows];
      *n = rows;
      for (i = 1; i <= rows; i++)
        {
          name = results[(i * columns) + 0];
          tables[i - 1] = wxString::FromUTF8(name);
        }
    }
  sqlite3_free_table(results);
  return tables;
}

void MyFrame::GetTableColumns(wxString & tableName, MyTableInfo * list)
{
// loads the table's column list
  int i;
  char **results;
  int rows;
  int columns;
  char *errMsg = NULL;
  char *name;
  char *column;
  wxString Name;
  wxString Column;
  bool pKey;
  bool index;
  bool cached;
  wxString sql;
  sql = wxT("PRAGMA table_info(\"");
  sql += tableName;
  sql += wxT("\")");
  int ret = sqlite3_get_table(SqliteHandle, sql.ToUTF8(), &results,
                              &rows, &columns, &errMsg);
  if (ret != SQLITE_OK)
    {
      wxMessageBox(wxT("SQLite SQL error: ") + wxString::FromUTF8(errMsg),
                   wxT("spatialite-gui"), wxOK | wxICON_ERROR, this);
      sqlite3_free(errMsg);
      return;
    }
  if (rows < 1)
    ;
  else
    {
      for (i = 1; i <= rows; i++)
        {
          name = results[(i * columns) + 1];
          if (atoi(results[(i * columns) + 5]) == 0)
            pKey = false;
          else
            pKey = true;
          Name = wxString::FromUTF8(name);
          list->AddColumn(Name, pKey);
        }
    }
  sqlite3_free_table(results);
  if (CheckMetadata() == true)
    {
      // ok, Spatial MetaData exists; retrieving Geometries and Spatial Indices
      sql =
        wxT
        ("SELECT f_geometry_column, spatial_index_enabled FROM geometry_columns ");
      sql += wxT("WHERE f_table_name = '");
      sql += tableName;
      sql += wxT("'");
      ret =
        sqlite3_get_table(SqliteHandle, sql.ToUTF8(), &results, &rows, &columns,
                          &errMsg);
      if (ret != SQLITE_OK)
        {
          wxMessageBox(wxT("SQLite SQL error: ") + wxString::FromUTF8(errMsg),
                       wxT("spatialite-gui"), wxOK | wxICON_ERROR, this);
          sqlite3_free(errMsg);
          return;
        }
      if (rows < 1)
        ;
      else
        {
          for (i = 1; i <= rows; i++)
            {
              column = results[(i * columns) + 0];
              if (atoi(results[(i * columns) + 1]) == 1)
                index = true;
              else
                index = false;
              if (atoi(results[(i * columns) + 1]) == 2)
                cached = true;
              else
                cached = false;
              Column = wxString::FromUTF8(column);
              list->SetGeometry(Column, index, cached);
            }
        }
      sqlite3_free_table(results);
    }
}

void MyFrame::GetViewColumns(wxString & tableName, MyViewInfo * list)
{
// loads the view's column list
  int i;
  char **results;
  int rows;
  int columns;
  char *errMsg = NULL;
  char *name;
  wxString Name;
  wxString sql;
  sql = wxT("PRAGMA table_info(\"");
  sql += tableName;
  sql += wxT("\")");
  int ret = sqlite3_get_table(SqliteHandle, sql.ToUTF8(), &results,
                              &rows, &columns, &errMsg);
  if (ret != SQLITE_OK)
    {
      wxMessageBox(wxT("SQLite SQL error: ") + wxString::FromUTF8(errMsg),
                   wxT("spatialite-gui"), wxOK | wxICON_ERROR, this);
      sqlite3_free(errMsg);
      return;
    }
  if (rows < 1)
    ;
  else
    {
      for (i = 1; i <= rows; i++)
        {
          name = results[(i * columns) + 1];
          Name = wxString::FromUTF8(name);
          list->AddColumn(Name);
        }
    }
  sqlite3_free_table(results);
}

void MyFrame::GetTableIndices(wxString & tableName, MyTableInfo * list)
{
// loads the table's indices list
  int i;
  char **results;
  int rows;
  int columns;
  char *errMsg = NULL;
  char *name;
  wxString Name;
  wxString sql;
  sql = wxT("PRAGMA index_list(\"");
  sql += tableName;
  sql += wxT("\")");
  int ret = sqlite3_get_table(SqliteHandle, sql.ToUTF8(), &results,
                              &rows, &columns, &errMsg);
  if (ret != SQLITE_OK)
    {
      wxMessageBox(wxT("SQLite SQL error: ") + wxString::FromUTF8(errMsg),
                   wxT("spatialite-gui"), wxOK | wxICON_ERROR, this);
      sqlite3_free(errMsg);
      return;
    }
  if (rows < 1)
    ;
  else
    {
      for (i = 1; i <= rows; i++)
        {
          name = results[(i * columns) + 1];
          Name = wxString::FromUTF8(name);
          list->AddIndex(Name);
        }
    }
  sqlite3_free_table(results);
}

void MyFrame::GetTableTriggers(wxString & tableName, MyTableInfo * list)
{
// loads the table's indices list
  int i;
  char **results;
  int rows;
  int columns;
  char *errMsg = NULL;
  char *name;
  wxString Name;
  wxString sql;
  sql =
    wxT
    ("SELECT name FROM sqlite_master WHERE type = 'trigger' AND tbl_name = '");
  sql += tableName;
  sql += wxT("' ORDER BY \"name\"");
  int ret = sqlite3_get_table(SqliteHandle, sql.ToUTF8(), &results,
                              &rows, &columns, &errMsg);
  if (ret != SQLITE_OK)
    {
      wxMessageBox(wxT("SQLite SQL error: ") + wxString::FromUTF8(errMsg),
                   wxT("spatialite-gui"), wxOK | wxICON_ERROR, this);
      sqlite3_free(errMsg);
      return;
    }
  if (rows < 1)
    ;
  else
    {
      for (i = 1; i <= rows; i++)
        {
          name = results[(i * columns) + 0];
          Name = wxString::FromUTF8(name);
          list->AddTrigger(Name);
        }
    }
  sqlite3_free_table(results);
  TableTree->ExpandRoot();
}

wxString *MyFrame::GetColumnNames(wxString & tableName, int *n_cols)
{
// loads the table's column names list
  wxString *cols = NULL;
  int nCols = 0;
  char **results;
  int rows;
  int columns;
  int i;
  char *errMsg = NULL;
  wxString sql;
  char *column;
  sql = wxT("PRAGMA table_info(\"");
  sql += tableName;
  sql += wxT("\")");
  int ret = sqlite3_get_table(SqliteHandle, sql.ToUTF8(), &results,
                              &rows, &columns, &errMsg);
  if (ret != SQLITE_OK)
    {
      wxMessageBox(wxT("SQLite SQL error: ") + wxString::FromUTF8(errMsg),
                   wxT("spatialite-gui"), wxOK | wxICON_ERROR, this);
      sqlite3_free(errMsg);
      return NULL;
    }
  sql = wxT("");
  if (rows < 1)
    ;
  else
    {
      nCols = rows;
      cols = new wxString[rows];
      for (i = 1; i <= rows; i++)
        {
          column = results[(i * columns) + 1];
          *(cols + i - 1) += wxString::FromUTF8(column);
        }
    }
  sqlite3_free_table(results);
  *n_cols = nCols;
  return cols;
}

int MyFrame::GetCharsetIndex(wxString & charset)
{
// identifies the INDEX for a given charset
  int i;
  for (i = 0; i < CharsetsLen; i++)
    {
      if (*(Charsets + i) == charset)
        return i;
    }
  return wxNOT_FOUND;
}

wxString & MyFrame::GetCharsetName(wxString & charset)
{
// identifies the full name for a given charset code
  int i;
  for (i = 0; i < CharsetsLen; i++)
    {
      if (*(Charsets + i) == charset)
        return *(CharsetsNames + i);
    }
  return charset;
}

void MyFrame::ClearTableTree()
{
// resets the table TREE list to the empty state
  wxString path = wxT("no current DB");
  TableTree->SetPath(path);
  TableTree->FlushAll();
}

void MyFrame::AutoFDOStart()
{
//
// trying to start the FDO-OGR auto-wrapper
//
  int ret;
  const char *name;
  int i;
  char **results;
  int rows;
  int columns;
  char sql[1024];
  int count = 0;
  int len;
  int spatial_type = 0;
  AutoFDOTables tables;
  AutoFDOTable *p;
  wxString fdoNames[5];
  SpatiaLiteMetadata = false;
  AutoFDOmsg = wxT("");
  strcpy(sql, "SELECT CheckSpatialMetadata()");
  ret = sqlite3_get_table(SqliteHandle, sql, &results, &rows, &columns, NULL);
  if (ret != SQLITE_OK)
    goto error1;
  if (rows < 1)
    ;
  else
    {
      for (i = 1; i <= rows; i++)
        spatial_type = atoi(results[(i * columns) + 0]);
    }
  sqlite3_free_table(results);
error1:
  if (spatial_type == 1)
    SpatiaLiteMetadata = true;
  if (spatial_type == 2)
    {
      //
      // ok, creating VirtualFDO tables 
      //
      strcpy(sql, "SELECT DISTINCT f_table_name FROM geometry_columns");
      ret =
        sqlite3_get_table(SqliteHandle, sql, &results, &rows, &columns, NULL);
      if (ret != SQLITE_OK)
        goto error;
      if (rows < 1)
        ;
      else
        {
          for (i = 1; i <= rows; i++)
            {
              name = results[(i * columns) + 0];
              if (name)
                {
                  len = strlen(name);
                  tables.Add(name, len);
                }
            }
        }
      sqlite3_free_table(results);
      p = tables.GetFirst();
      while (p)
        {
          //
          // destroying the VirtualFDO table [if existing] 
          //
          sprintf(sql, "DROP TABLE IF EXISTS \"fdo_%s\"", p->GetName());
          ret = sqlite3_exec(SqliteHandle, sql, NULL, 0, NULL);
          if (ret != SQLITE_OK)
            goto error;
          //
          // creating the VirtualFDO table 
          //
          sprintf(sql, "CREATE VIRTUAL TABLE \"fdo_%s\" USING VirtualFDO(%s)",
                  p->GetName(), p->GetName());
          ret = sqlite3_exec(SqliteHandle, sql, NULL, 0, NULL);
          if (ret != SQLITE_OK)
            goto error;
          if (count < 5)
            fdoNames[count] =
              wxT("- VirtualTable: \"fdo_") + wxString::FromUTF8(p->GetName()) +
              wxT("\"");
          else
            fdoNames[4] = wxT("- ... and others ...");
          count++;
          p = p->GetNext();
        }
    error:
      if (count++)
        {
          AutoFDOmsg =
            wxT("FDO-OGR detected; activating FDO-OGR auto-wrapping ...\n\n");
          if (fdoNames[0].Len() > 0)
            AutoFDOmsg += fdoNames[0] + wxT("\n");
          if (fdoNames[1].Len() > 0)
            AutoFDOmsg += fdoNames[1] + wxT("\n");
          if (fdoNames[2].Len() > 0)
            AutoFDOmsg += fdoNames[2] + wxT("\n");
          if (fdoNames[3].Len() > 0)
            AutoFDOmsg += fdoNames[3] + wxT("\n");
          if (fdoNames[4].Len() > 0)
            AutoFDOmsg += fdoNames[4] + wxT("\n");
          AutoFDOmsg +=
            wxT
            ("\nAccessing these fdo_XX tables you can take full advantage of\n");
          AutoFDOmsg += wxT("FDO-OGR auto-wrapping facility\n");
          AutoFDOmsg +=
            wxT
            ("This allows you to access any specific FDO-OGR Geometry as if it\n");
          AutoFDOmsg +=
            wxT
            ("where native SpatiaLite ones in a completely transparent way.\n");
        }
      return;
    }
}

void MyFrame::AutoFDOStop()
{
//
// trying to stop the FDO-OGR auto-wrapper
//
  int ret;
  const char *name;
  int i;
  char **results;
  int rows;
  int columns;
  char sql[1024];
  int count = 0;
  int len;
  int spatial_type = 0;
  AutoFDOTables tables;
  AutoFDOTable *p;
  AutoFDOmsg = wxT("");
  strcpy(sql, "SELECT CheckSpatialMetadata()");
  ret = sqlite3_get_table(SqliteHandle, sql, &results, &rows, &columns, NULL);
  if (ret != SQLITE_OK)
    goto error1;
  if (rows < 1)
    ;
  else
    {
      for (i = 1; i <= rows; i++)
        spatial_type = atoi(results[(i * columns) + 0]);
    }
  sqlite3_free_table(results);
error1:
  if (spatial_type == 2)
    {
      //
      // ok, destroying VirtualFDO tables 
      //
      strcpy(sql, "SELECT DISTINCT f_table_name FROM geometry_columns");
      ret =
        sqlite3_get_table(SqliteHandle, sql, &results, &rows, &columns, NULL);
      if (ret != SQLITE_OK)
        goto error;
      if (rows < 1)
        ;
      else
        {
          for (i = 1; i <= rows; i++)
            {
              name = results[(i * columns) + 0];
              if (name)
                {
                  len = strlen(name);
                  tables.Add(name, len);
                }
            }
        }
      sqlite3_free_table(results);
      p = tables.GetFirst();
      while (p)
        {
          //
          // destroying the VirtualFDO table [if existing] 
          //
          sprintf(sql, "DROP TABLE IF EXISTS \"fdo_%s\"", p->GetName());
          ret = sqlite3_exec(SqliteHandle, sql, NULL, 0, NULL);
          if (ret != SQLITE_OK)
            goto error;
          count++;
          p = p->GetNext();
        }
    error:
      if (count++)
        AutoFDOmsg = wxT("FDO-OGR auto-wrapping shutdown done");
      return;
    }
}

void MyFrame::GetHelp(wxString & html)
{
//
// return the HTML Help
//
  html =
    wxT("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
  html += wxT("<html>");
  html += wxT("<head>");
  html +=
    wxT
    ("<meta content=\"text/html; charset=UTF-8\" http-equiv=\"content-type\">");
  html += wxT("<title>SQLite + SpatiaLite quick Help</title>");
  html += wxT("</head>");
  html += wxT("<body bgcolor=\"#e8e8e8\">");
  html += wxT("<h1><a name=\"index\">SQLite + SpatiaLite quick Help</a></h1>");
  html += wxT("<table cellspacing=\"2\" cellpadding=\"2\">");
  html +=
    wxT
    ("<tr><td align=\"center\" bgcolor=\"#e0ffe0\" colspan=\"2\">Index of contents</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">1.</td><td bgcolor=\"#f0fff0\"><a href=\"#c1\">SQLite SQL syntax</a></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">2.</td><td bgcolor=\"#f0fff0\"><a href=\"#c2\">SQLite SQL functions</a><ul>");
  html += wxT("<li><a href=\"#c21\">ordinary functions</a></li>");
  html += wxT("<li><a href=\"#c22\">aggregate functions</a></li>");
  html += wxT("</ul></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">3.</td><td bgcolor=\"#f0fff0\"><a href=\"#c3\">SpatiaLite SQL Spatial functions</a><ul>");
  html += wxT("<li><a href=\"#math\">math functions</a></li>");
  html +=
    wxT("<li><a href=\"#blob\">utility functions for BLOB objects</a></li>");
  html +=
    wxT
    ("<li><a href=\"#c30\">utility functions [non-standard] for geometric objects</a></li>");
  html +=
    wxT
    ("<li><a href=\"#c31\">functions for constructing a geometric object given its Well-known Text Representation</a></li>");
  html +=
    wxT
    ("<li><a href=\"#c32\">functions for constructing a geometric object given its Well-known Binary Representation</a></li>");
  html +=
    wxT
    ("<li><a href=\"#c33\">functions for obtaining the Well-known Text / Well-known Binary Representation of a geometric object</a></li>");
  html +=
    wxT
    ("<li><a href=\"#c33misc\">functions supporting exotic geometric formats</a></li>");
  html += wxT("<li><a href=\"#c34\">functions on type Geometry</a></li>");
  html += wxT("<li><a href=\"#c35\">functions on type Point</a></li>");
  html +=
    wxT
    ("<li><a href=\"#c36\">functions on type Surface [Polygon or Ring]</a></li>");
  html += wxT("<li><a href=\"#c37\">functions on type Polygon</a></li>");
  html += wxT("<li><a href=\"#c38\">functions on type GeomCollection</a></li>");
  html +=
    wxT
    ("<li><a href=\"#c39\">functions testing approximative spatial relationships via MBRs</a></li>");
  html +=
    wxT
    ("<li><a href=\"#c40\">functions testing spatial relationships</a></li>");
  html +=
    wxT
    ("<li><a href=\"#c41\">functions implementing spatial operators</a></li>");
  html +=
    wxT
    ("<li><a href=\"#c42\">functions for coordinate transformations</a></li>");
  html +=
    wxT
    ("<li><a href=\"#c43\">functions for Spatial-MetaData and Spatial-Index handling</a></li>");
  html +=
    wxT
    ("<li><a href=\"#c43fdo\">functions implementing FDO/OGR compatibily</a></li>");
  html +=
    wxT("<li><a href=\"#c44\">functions for MbrCache-based queries</a></li>");
  html += wxT("</ul></td></tr>");
  html += wxT("</table>");
  html += wxT("<h3><a name=\"c1\">SQLite SQL syntax</a></h3>");
  html += wxT("<table cellspacing=\"4\" cellpadding=\"2\"width=\"100%\">");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">ALTER TABLE</td><td bgcolor=\"#f0fff0\">sql-statement ::= ALTER TABLE [database-name .] table-name alteration<br>");
  html += wxT("alteration ::= RENAME TO new-table-name<br>");
  html += wxT("alteration ::= ADD [COLUMN] column-def<br></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">ANALYZE</td><td bgcolor=\"#f0fff0\">sql-statement ::= ANALYZE<br>");
  html += wxT("sql-statement ::= ANALYZE database-name<br>");
  html +=
    wxT("sql-statement ::= ANALYZE [database-name .] table-name<br></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">ATTACH DATABASE</td><td bgcolor=\"#f0fff0\">sql-statement ::= ATTACH [DATABASE] database-filename AS database-name</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">BEGIN TRANSACTION</td><td bgcolor=\"#f0fff0\">sql-statement ::= BEGIN [ DEFERRED | IMMEDIATE | EXCLUSIVE ] [TRANSACTION [name]]<br>");
  html += wxT("sql-statement ::= END [TRANSACTION [name]]<br>");
  html += wxT("sql-statement ::= COMMIT [TRANSACTION [name]]<br>");
  html += wxT("sql-statement ::= ROLLBACK [TRANSACTION [name]]<br></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">COMMIT TRANSACTION</td><td bgcolor=\"#f0fff0\">sql-statement ::= BEGIN [ DEFERRED | IMMEDIATE | EXCLUSIVE ] [TRANSACTION [name]]<br>");
  html += wxT("sql-statement ::= END [TRANSACTION [name]]<br>");
  html += wxT("sql-statement ::= COMMIT [TRANSACTION [name]]<br>");
  html += wxT("sql-statement ::= ROLLBACK [TRANSACTION [name]]<br></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">CREATE INDEX</td><td bgcolor=\"#f0fff0\">sql-statement ::= CREATE [UNIQUE] INDEX [IF NOT EXISTS] [database-name .] index-name<br>");
  html += wxT("ON table-name ( column-name [, column-name]* )<br>");
  html +=
    wxT
    ("column-name ::= name [ COLLATE collation-name] [ ASC | DESC ]</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">CREATE TABLE</td><td bgcolor=\"#f0fff0\">sql-command ::= CREATE [TEMP | TEMPORARY] TABLE [IF NOT EXISTS] [database-name .] table-name (<br>");
  html += wxT("column-def [, column-def]*<br>");
  html += wxT("[, constraint]*<br>");
  html += wxT(")<br>");
  html +=
    wxT
    ("sql-command ::= CREATE [TEMP | TEMPORARY] TABLE [database-name.] table-name AS select-statement<br>");
  html +=
    wxT
    ("column-def ::= name [type] [[CONSTRAINT name] column-constraint]*<br>");
  html += wxT("type ::= typename |<br>");
  html += wxT("typename ( number ) |<br>");
  html += wxT("typename ( number , number )<br>");
  html += wxT("column-constraint ::= NOT NULL [ conflict-clause ] |<br>");
  html +=
    wxT("PRIMARY KEY [sort-order] [ conflict-clause ] [AUTOINCREMENT] |<br>");
  html += wxT("UNIQUE [ conflict-clause ] |<br>");
  html += wxT("CHECK ( expr ) |<br>");
  html += wxT("DEFAULT value |<br>");
  html += wxT("COLLATE collation-name<br>");
  html +=
    wxT("constraint ::= PRIMARY KEY ( column-list ) [ conflict-clause ] |<br>");
  html += wxT("UNIQUE ( column-list ) [ conflict-clause ] |<br>");
  html += wxT("CHECK ( expr )<br>");
  html += wxT("conflict-clause ::= ON CONFLICT conflict-algorithm</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">CREATE TRIGGER</td><td bgcolor=\"#f0fff0\">sql-statement ::= CREATE [TEMP | TEMPORARY] TRIGGER [IF NOT EXISTS] trigger-name [ BEFORE | AFTER ]<br>");
  html += wxT("database-event ON [database-name .] table-name<br>");
  html += wxT("trigger-action<br>");
  html +=
    wxT
    ("sql-statement ::= CREATE [TEMP | TEMPORARY] TRIGGER [IF NOT EXISTS] trigger-name INSTEAD OF<br>");
  html += wxT("database-event ON [database-name .] view-name<br>");
  html += wxT("trigger-action<br>");
  html += wxT("database-event ::= DELETE |<br>");
  html += wxT("INSERT |<br>");
  html += wxT("UPDATE |<br>");
  html += wxT("UPDATE OF column-list<br>");
  html += wxT("trigger-action ::= [ FOR EACH ROW ] [ WHEN expression ]<br>");
  html += wxT("BEGIN<br>");
  html += wxT("trigger-step ; [ trigger-step ; ]*<br>");
  html += wxT("END<br>");
  html += wxT("trigger-step ::= update-statement | insert-statement |<br>");
  html += wxT("delete-statement | select-statement</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">CREATE VIEW</td><td bgcolor=\"#f0fff0\">sql-command ::= CREATE [TEMP | TEMPORARY] VIEW [IF NOT EXISTS] [database-name.] view-name AS select-statement</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">CREATE VIRTUAL TABLE</td><td bgcolor=\"#f0fff0\">sql-command ::= CREATE VIRTUAL TABLE [database-name .] table-name USING module-name [( arguments )]</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">DELETE</td><td bgcolor=\"#f0fff0\">sql-statement ::= DELETE FROM [database-name .] table-name [WHERE expr]</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">DETACH DATABASE</td><td bgcolor=\"#f0fff0\">sql-command ::= DETACH [DATABASE] database-name</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">DROP INDEX</td><td bgcolor=\"#f0fff0\">sql-command ::= DROP INDEX [IF EXISTS] [database-name .] index-name</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">DROP TABLE</td><td bgcolor=\"#f0fff0\">sql-command ::= DROP TABLE [IF EXISTS] [database-name.] table-name</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">DROP TRIGGER</td><td bgcolor=\"#f0fff0\">sql-statement ::= DROP TRIGGER [IF EXISTS] [database-name .] trigger-name</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">DROP VIEW</td><td bgcolor=\"#f0fff0\">sql-command ::= DROP VIEW [IF EXISTS] view-name</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">END TRANSACTION</td><td bgcolor=\"#f0fff0\">sql-statement ::= BEGIN [ DEFERRED | IMMEDIATE | EXCLUSIVE ] [TRANSACTION [name]]<br>");
  html += wxT("sql-statement ::= END [TRANSACTION [name]]<br>");
  html += wxT("sql-statement ::= COMMIT [TRANSACTION [name]]<br>");
  html += wxT("sql-statement ::= ROLLBACK [TRANSACTION [name]]<br></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">EXPLAIN</td><td bgcolor=\"#f0fff0\">sql-statement ::= EXPLAIN sql-statement</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">INSERT</td><td bgcolor=\"#f0fff0\">sql-statement ::= INSERT [OR conflict-algorithm] INTO [database-name .] table-name [(column-list)] VALUES(value-list) |<br>");
  html +=
    wxT
    ("INSERT [OR conflict-algorithm] INTO [database-name .] table-name [(column-list)] select-statement</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">ON CONFLICT clause</td><td bgcolor=\"#f0fff0\">conflict-clause ::= ON CONFLICT conflict-algorithm<br>");
  html +=
    wxT
    ("conflict-algorithm ::= ROLLBACK | ABORT | FAIL | IGNORE | REPLACE</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">PRAGMA</td><td bgcolor=\"#f0fff0\">sql-statement ::= PRAGMA name [= value] |<br>");
  html += wxT("PRAGMA function(arg)<hr>");
  html += wxT("PRAGMA auto_vacuum;<br>");
  html +=
    wxT("PRAGMA auto_vacuum = 0 | none | 1 | full | 2 | incremental;<hr>");
  html += wxT("PRAGMA cache_size;<br>");
  html += wxT("PRAGMA cache_size = Number-of-pages;<hr>");
  html += wxT("PRAGMA case_sensitive_like;<br>");
  html += wxT("PRAGMA case_sensitive_like = 0 | 1;<hr>");
  html += wxT("PRAGMA count_changes;<br>");
  html += wxT("PRAGMA count_changes = 0 | 1;<hr>");
  html += wxT("PRAGMA default_cache_size;<br>");
  html += wxT("PRAGMA default_cache_size = Number-of-pages;<hr>");
  html += wxT("PRAGMA empty_result_callbacks;<br>");
  html += wxT("PRAGMA empty_result_callbacks = 0 | 1;<hr>");
  html += wxT("PRAGMA encoding;<br>");
  html += wxT("PRAGMA encoding = \"UTF-8\";<br>");
  html += wxT("PRAGMA encoding = \"UTF-16\";<br>");
  html += wxT("PRAGMA encoding = \"UTF-16le\";<br>");
  html += wxT("PRAGMA encoding = \"UTF-16be\";<hr>");
  html += wxT("PRAGMA full_column_names;<br>");
  html += wxT("PRAGMA full_column_names = 0 | 1;<hr>");
  html += wxT("PRAGMA fullfsync;<br>");
  html += wxT("PRAGMA fullfsync = 0 | 1;<hr>");
  html += wxT("PRAGMA journal_mode;<br>");
  html += wxT("PRAGMA database.journal_mode;<br>");
  html += wxT("PRAGMA journal_mode = DELETE | PERSIST | OFF<br>");
  html += wxT("PRAGMA database.journal_mode = DELETE | PERSIST | OFF<hr>");
  html += wxT("PRAGMA legacy_file_format;<br>");
  html += wxT("PRAGMA legacy_file_format = ON | OFF<hr>");
  html += wxT("PRAGMA locking_mode;<br>");
  html += wxT("PRAGMA locking_mode = NORMAL | EXCLUSIVE<hr>");
  html += wxT("PRAGMA page_size;<br>");
  html += wxT("PRAGMA page_size = bytes;<hr>");
  html += wxT("PRAGMA max_page_count;<br>");
  html += wxT("PRAGMA max_page_count = N;<hr>");
  html += wxT("PRAGMA read_uncommitted;<br>");
  html += wxT("PRAGMA read_uncommitted = 0 | 1;<hr>");
  html += wxT("PRAGMA short_column_names;<br>");
  html += wxT("PRAGMA short_column_names = 0 | 1;<hr>");
  html += wxT("PRAGMA synchronous;<br>");
  html += wxT("PRAGMA synchronous = FULL; (2)<br>");
  html += wxT("PRAGMA synchronous = NORMAL; (1)<br>");
  html += wxT("PRAGMA synchronous = OFF; (0)<hr>");
  html += wxT("PRAGMA temp_store;<br>");
  html += wxT("PRAGMA temp_store = DEFAULT; (0)<br>");
  html += wxT("PRAGMA temp_store = FILE; (1)<br>");
  html += wxT("PRAGMA temp_store = MEMORY; (2)<hr>");
  html += wxT("PRAGMA temp_store_directory;<br>");
  html += wxT("PRAGMA temp_store_directory = 'directory-name';<hr>");
  html += wxT("PRAGMA database_list;<hr>");
  html += wxT("PRAGMA foreign_key_list(table-name);<hr>");
  html += wxT("PRAGMA [database].freelist_count;<hr>");
  html += wxT("PRAGMA index_info(index-name);<hr>");
  html += wxT("PRAGMA index_list(table-name);<hr>");
  html += wxT("PRAGMA table_info(table-name);<hr>");
  html += wxT("PRAGMA [database.]schema_version;<br>");
  html += wxT("PRAGMA [database.]schema_version = integer ;<br>");
  html += wxT("PRAGMA [database.]user_version;<br>");
  html += wxT("PRAGMA [database.]user_version = integer ;<hr>");
  html += wxT("PRAGMA integrity_check;<br>");
  html += wxT("PRAGMA integrity_check(integer)<hr>");
  html += wxT("PRAGMA parser_trace = ON; (1)<br>");
  html += wxT("PRAGMA parser_trace = OFF; (0)<hr>");
  html += wxT("PRAGMA vdbe_trace = ON; (1)<br>");
  html += wxT("PRAGMA vdbe_trace = OFF; (0)<hr>");
  html += wxT("PRAGMA vdbe_listing = ON; (1)<br>");
  html += wxT("PRAGMA vdbe_listing = OFF; (0)</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">REINDEX</td><td bgcolor=\"#f0fff0\">sql-statement ::= REINDEX collation name<br>");
  html +=
    wxT
    ("sql-statement ::= REINDEX [database-name .] table/index-name</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">REPLACE</td><td bgcolor=\"#f0fff0\">sql-statement ::= REPLACE INTO [database-name .] table-name [( column-list )] VALUES ( value-list ) |<br>");
  html +=
    wxT
    ("REPLACE INTO [database-name .] table-name [( column-list )] select-statement</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">ROLLBACK TRANSACTION</td><td bgcolor=\"#f0fff0\">sql-statement ::= BEGIN [ DEFERRED | IMMEDIATE | EXCLUSIVE ] [TRANSACTION [name]]<br>");
  html += wxT("sql-statement ::= END [TRANSACTION [name]]<br>");
  html += wxT("sql-statement ::= COMMIT [TRANSACTION [name]]<br>");
  html += wxT("sql-statement ::= ROLLBACK [TRANSACTION [name]]<br></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">SELECT</td><td bgcolor=\"#f0fff0\">sql-statement ::= SELECT [ALL | DISTINCT] result [FROM table-list]<br>");
  html += wxT("[WHERE expr]<br>");
  html += wxT("[GROUP BY expr-list]<br>");
  html += wxT("[HAVING expr]<br>");
  html += wxT("[compound-op select]*<br>");
  html += wxT("[ORDER BY sort-expr-list]<br>");
  html += wxT("[LIMIT integer [( OFFSET | , ) integer]]<br>");
  html += wxT("result ::= result-column [, result-column]*<br>");
  html +=
    wxT("result-column ::= * | table-name . * | expr [ [AS] string ]<br>");
  html += wxT("table-list ::= table [join-op table join-args]*<br>");
  html += wxT("table ::= table-name [AS alias] |<br>");
  html += wxT("( select ) [AS alias]<br>");
  html +=
    wxT
    ("join-op ::= , | [NATURAL] [LEFT | RIGHT | FULL] [OUTER | INNER | CROSS] JOIN<br>");
  html += wxT("join-args ::= [ON expr] [USING ( id-list )]<br>");
  html +=
    wxT("sort-expr-list ::= expr [sort-order] [, expr [sort-order]]*<br>");
  html += wxT("sort-order ::= [ COLLATE collation-name ] [ ASC | DESC ]<br>");
  html +=
    wxT("compound_op ::= UNION | UNION ALL | INTERSECT | EXCEPT</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">UPDATE</td><td bgcolor=\"#f0fff0\">sql-statement ::= UPDATE [ OR conflict-algorithm ] [database-name .] table-name<br>");
  html += wxT("SET assignment [, assignment]*<br>");
  html += wxT("[WHERE expr]<br>");
  html += wxT("assignment ::= column-name = expr</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">VACUUM</td><td bgcolor=\"#f0fff0\">sql-statement ::= VACUUM</td></tr>");
  html += wxT("</table>");
  html += wxT("<a href=\"#index\">back to index</a>");
  html +=
    wxT
    ("<h3><a align=\"center\" bgcolor=\"#e0ffe0\" name=\"c2\">SQLite SQL functions</a></h3>");
  html += wxT("<table cellspacing=\"4\" cellpadding=\"2\" width=\"100%\">");
  html +=
    wxT
    ("<tr><td align=\"center\" bgcolor=\"#e0ffe0\" colspan=\"2\"><a name=\"c21\">ordinary functions</a><br><a href=\"#index\">back to index</a></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">abs(X)</td><td bgcolor=\"#f0fff0\">Return the absolute value of the numeric argument X. ");
  html +=
    wxT
    ("Return NULL if X is NULL. Return 0.0 if X is not a numeric value.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">coalesce(X,Y,...)</td><td bgcolor=\"#f0fff0\">Return a copy of the first non-NULL argument. ");
  html +=
    wxT
    ("If all arguments are NULL then NULL is returned. There must be at least 2 arguments.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">glob(X,Y)</td><td bgcolor=\"#f0fff0\">This function is used to implement the \"X GLOB Y\" syntax of SQLite. ");
  html +=
    wxT
    ("The sqlite3_create_function() interface can be used to override this function and thereby change the operation of the GLOB operator.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">ifnull(X,Y)</td><td bgcolor=\"#f0fff0\">Return a copy of the first non-NULL argument. ");
  html +=
    wxT
    ("If both arguments are NULL then NULL is returned. This behaves the same as coalesce().</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">hex(X)</td><td bgcolor=\"#f0fff0\">The argument is interpreted as a BLOB. ");
  html +=
    wxT
    ("The result is a hexadecimal rendering of the content of that blob.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">last_insert_rowid()</td><td bgcolor=\"#f0fff0\">Return the ROWID of the last row insert from this connection to the database. ");
  html +=
    wxT
    ("This is the same value that would be returned from the sqlite3_last_insert_rowid() API function.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">length(X)</td><td bgcolor=\"#f0fff0\">Return the string length of X in characters. ");
  html +=
    wxT
    ("If SQLite is configured to support UTF-8, then the number of UTF-8 characters is returned, not the number of bytes.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">like(X,Y)<br>like(X,Y,Z)</td><td bgcolor=\"#f0fff0\">This function is used to implement the \"X LIKE Y [ESCAPE Z]\" syntax of SQL.");
  html +=
    wxT
    ("If the optional ESCAPE clause is present, then the user-function is invoked with three arguments. ");
  html += wxT("Otherwise, it is invoked with two arguments only. ");
  html +=
    wxT
    ("The sqlite3_create_function() interface can be used to override this function and thereby change the operation of the LIKE operator. ");
  html +=
    wxT
    ("When doing this, it may be important to override both the two and three argument versions of the like() function. ");
  html +=
    wxT
    ("Otherwise, different code may be called to implement the LIKE operator depending on whether or not an ESCAPE clause was specified.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">load_extension(X)</br>load_extension(X,Y)</td><td bgcolor=\"#f0fff0\">Load SQLite extensions ");
  html +=
    wxT("out of the shared library file named X using the entry point Y. ");
  html +=
    wxT
    ("The result is a NULL. If Y is omitted then the default entry point of sqlite3_extension_init is used. ");
  html +=
    wxT
    ("This function raises an exception if the extension fails to load or initialize correctly.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">lower(X)</td><td bgcolor=\"#f0fff0\">Return a copy of string X will all ASCII characters converted to lower case. ");
  html +=
    wxT
    ("The C library tolower() routine is used for the conversion, which means that this function might not work correctly on non-ASCII UTF-8 characters.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">ltrim(X)<br>ltrim(X,Y)</td><td bgcolor=\"#f0fff0\">Return a string formed by removing any and all characters ");
  html +=
    wxT
    ("that appear in Y from the left side of X. If the Y argument is omitted, spaces are removed.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">max(X,Y,...)</td><td bgcolor=\"#f0fff0\">Return the argument with the maximum value. ");
  html += wxT("Arguments may be strings in addition to numbers. ");
  html += wxT("The maximum value is determined by the usual sort order. ");
  html +=
    wxT
    ("Note that max() is a simple function when it has 2 or more arguments but converts to an aggregate function if given only a single argument.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">min(X,Y,...)</td><td bgcolor=\"#f0fff0\">Return the argument with the minimum value. ");
  html += wxT("Arguments may be strings in addition to numbers. ");
  html += wxT("The minimum value is determined by the usual sort order. ");
  html +=
    wxT
    ("Note that min() is a simple function when it has 2 or more arguments but converts to an aggregate function if given only a single argument.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">nullif(X,Y)</td><td bgcolor=\"#f0fff0\">Return the first argument if the arguments are different, otherwise return NULL.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">quote(X)</td><td bgcolor=\"#f0fff0\">This routine return a string which is the value of its argument suitable for inclusion ");
  html +=
    wxT
    ("into another SQL statement. Strings are surrounded by single-quotes with escapes on interior quotes as needed. ");
  html +=
    wxT
    ("BLOBs are encoded as hexadecimal literals. The implementation of VACUUM uses this function. ");
  html +=
    wxT
    ("The function is also useful when writing triggers to implement undo/redo functionality.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">random()</td><td bgcolor=\"#f0fff0\">Return a pseudo-random integer between -9223372036854775808 and +9223372036854775807.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">randomblob(N)</td><td bgcolor=\"#f0fff0\">Return an N-byte blob containing pseudo-random bytes. N should be a postive integer.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">replace(X,Y,Z)</td><td bgcolor=\"#f0fff0\">Return a string formed by substituting string Z for every occurrance of string Y in string X. ");
  html +=
    wxT("The BINARY collating sequence is used for comparisons.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">round(X)<br>round(X,Y)</td><td bgcolor=\"#f0fff0\">Round off the number X to Y digits to the right of the decimal point. ");
  html += wxT("If the Y argument is omitted, 0 is assumed.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">rtrim(X)<br>rtrim(X,Y)</td><td bgcolor=\"#f0fff0\">Return a string formed by removing any and all characters ");
  html +=
    wxT
    ("that appear in Y from the right side of X. If the Y argument is omitted, spaces are removed.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">sqlite_version(X)</td><td bgcolor=\"#f0fff0\">Return the version string for the SQLite library that is running. Example: \"3.5.9\"</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">substr(X,Y,Z)<br>substr(X,Y)</td><td bgcolor=\"#f0fff0\">Return a substring of input string X that begins with the Y-th character ");
  html +=
    wxT
    ("and which is Z characters long. If Z is omitted then all character through the end of the string are returned. ");
  html += wxT("The left-most character of X is number 1. ");
  html +=
    wxT
    ("If Y is negative the the first character of the substring is found by counting from the right rather than the left. ");
  html +=
    wxT
    ("If X is string then characters indices refer to actual UTF-8 characters. If X is a BLOB then the indices refer to bytes.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">trim(X)<br>trim(X,Y)</td><td bgcolor=\"#f0fff0\">Return a string formed by removing any and all characters that appear in Y from both ends of X. ");
  html += wxT("If the Y argument is omitted, spaces are removed.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">typeof(X)</td><td bgcolor=\"#f0fff0\">Return the type of the expression X. ");
  html +=
    wxT
    ("The only return values are \"null\", \"integer\", \"real\", \"text\", and \"blob\".</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">upper(X)</td><td bgcolor=\"#f0fff0\">Return a copy of input string X converted to all upper-case letters. ");
  html +=
    wxT
    ("The implementation of this function uses the C library routine toupper() which means it may not work correctly on non-ASCII UTF-8 strings.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">zeroblob(N)</td><td bgcolor=\"#f0fff0\">Return a BLOB consisting of N bytes of 0x00. ");
  html += wxT("SQLite manages these zeroblobs very efficiently. ");
  html +=
    wxT
    ("Zeroblobs can be used to reserve space for a BLOB that is later written using incremental BLOB I/O.</td></tr> ");
  html +=
    wxT
    ("<tr><td align=\"center\" bgcolor=\"#e0ffe0\" colspan=\"2\"><a name=\"c22\">aggregate functions</a><br><a href=\"#index\">back to index</a></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">avg(X)</td><td bgcolor=\"#f0fff0\">Return the average value of all non-NULL X within a group. ");
  html +=
    wxT
    ("String and BLOB values that do not look like numbers are interpreted as 0. ");
  html +=
    wxT
    ("The result of avg() is always a floating point value even if all inputs are integers.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">count(X)<br>count(*)</td><td bgcolor=\"#f0fff0\">The first form return a count of the number of times that X is not NULL in a group. ");
  html +=
    wxT
    ("The second form (with no argument) return the total number of rows in the group.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">group_concat(X)<br>group_concat(X,Y)</td><td bgcolor=\"#f0fff0\">The result is a string which is the concatenation of all non-NULL values of X. ");
  html +=
    wxT
    ("If parameter Y is the separator between instances of X. A comma (\",\") is used as the separator if Y is omitted.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">max(X)</td><td bgcolor=\"#f0fff0\">Return the maximum value of all values in the group. ");
  html +=
    wxT("The usual sort order is used to determine the maximum.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">min(X)</td><td bgcolor=\"#f0fff0\">Return the minimum non-NULL value of all values in the group. ");
  html +=
    wxT
    ("The usual sort order is used to determine the minimum. NULL is only returned if all values in the group are NULL.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">sum(X)<br>total(X)</td><td bgcolor=\"#f0fff0\">Return the numeric sum of all non-NULL values in the group. ");
  html +=
    wxT
    ("If there are no non-NULL input rows then sum() return NULL but total() return 0.0. ");
  html +=
    wxT
    ("NULL is not normally a helpful result for the sum of no rows but the SQL standard requires it and most other SQL ");
  html +=
    wxT
    ("database engines implement sum() that way so SQLite does it in the same way in order to be compatible. ");
  html +=
    wxT
    ("The non-standard total() function is provided as a convenient way to work around this design problem in the SQL language.<br>");
  html +=
    wxT
    ("The result of total() is always a floating point value. The result of sum() is an integer value if all non-NULL inputs are integers. ");
  html +=
    wxT
    ("If any input to sum() is neither an integer or a NULL then sum() return a floating point value which might be an approximation to the true sum.<br>");
  html +=
    wxT
    ("Sum() will throw an \"integer overflow\" exception if all inputs are integers or NULL and an integer overflow occurs at any point during the computation.");
  html += wxT("Total() never throws an exception.</td></tr> ");
  html += wxT("</table>");
  html += wxT("<a href=\"#index\">back to index</a>");
  html += wxT("<h3><a name=\"c3\">SpatiaLite SQL Spatial functions</a></h3>");
  html += wxT("<table cellspacing=\"4\" cellpadding=\"2\" width=\"100%\">");
  html +=
    wxT
    ("<tr><td align=\"center\" bgcolor=\"#e0ffe0\" colspan=\"2\"><a name=\"math\">SQL math functions</a></a>");
  html += wxT("<br><a href=\"#index\">back to index</a></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Abs( x Double precision ) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">returns the absolute value of <i>x</i></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Acos( x Double precision ) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">returns the arc cosine of <i>x</i>, that is, the value whose cosine is <i>x</i><br>");
  html += wxT("returns NULL if <i>x</i> is not in the range -1 to 1</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Asin( x Double precision ) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">returns the arc sine of <i>x</i>, that is, the value whose sine is <i>x</i><br>");
  html += wxT("returns NULL if <i>x</i> is not in the range -1 to 1</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Atan( x Double precision ) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">returns the arc tangent of <i>x</i>, that is, the value whose tangent is <i>x</i></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Ceil( x Double precision ) : Double precision<hr>");
  html += wxT("Ceiling( x Double precision ) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">returns the smallest integer value not less than <i>x</i></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Cos( x Double precision ) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">returns the cosine of <i>x</i>, where <i>x</i> is given in <u>radians</u></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Cot( x Double precision ) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">returns the cotangent of <i>x</i>, where <i>x</i> is given in <u>radians</u></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Degrees( x Double precision ) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">returns the argument <i>x</i>, converted from radians to degrees</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Exp( x Double precision ) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">returns the value of <b><i>e</i></b> (the base of natural logarithms) raised to the power of <i>x</i><hr>");
  html +=
    wxT
    ("the inverse of this function is <i>Log()</i> (using a single argument only) or <i>Ln()</i></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Floor( x Double precision ) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">returns the largest integer value not greater than <i>x</i></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Ln( x Double precision ) : Double precision<hr>");
  html += wxT("Log( x Double precision ) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">returns the natural logarithm of <i>x</i>; that is, the base-<b><i>e</i></b> logarithm of <i>x</i><br>");
  html +=
    wxT
    ("If <i>x</i> is less than or equal to 0, then NULL is returned</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Log( b Double precision, x Double precision ) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">returns the logarithm of <i>x</i> to the base <i>b</i><br>");
  html +=
    wxT
    ("If <i>x</i> is less than or equal to 0, or if <i>b</i> is less than or equal to 1, then NULL is returned<hr>");
  html +=
    wxT
    ("<i>Log(b, x)</i>  is equivalent to <i>Log(x)</i> / <i>Log(b)</i></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Log2( x Double precision ) : Double precision</td>");
  html +=
    wxT("<td bgcolor=\"#f0fff0\">returns the base-2 logarithm of <i>x</i><hr>");
  html +=
    wxT
    ("<i>Log2(x)</i>  is equivalent to <i>Log(x)</i> / <i>Log(2)</i></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Log10( x Double precision ) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">returns the base-10 logarithm of <i>x</i><hr>");
  html +=
    wxT
    ("<i>Log10(x)</i>  is equivalent to <i>Log(x)</i> / <i>Log(10)</i></td></tr>");
  html += wxT("<tr><td bgcolor=\"#fffff0\">PI( void ) : Double precision</td>");
  html +=
    wxT("<td bgcolor=\"#f0fff0\">returns the value of <i>PI</i></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Pow( x Double precision, y Double precision ) : Double precision<hr>");
  html +=
    wxT
    ("Power( x Double precision, y Double precision ) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">returns the value of <i>x</i> raised to the power of <i>y</i></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Radians( x Double precision ) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">returns the argument <i>x</i>, converted from degrees to radians</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Round( x Double precision ) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">returns the integer value nearest to <i>x</i></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Sign( x Double precision ) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">returns the sign of the argument as -1, 0, or 1, ");
  html +=
    wxT
    ("depending on whether <i>x</i> is negative, zero, or positive.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Sin( x Double precision ) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">returns the sine of <i>x</i>, where <i>x</i> is given in <u>radians</u></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Sqrt( x Double precision ) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">returns the square root of a non-negative number <i>x</i></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Stddev_pop( x Double precision ) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">returns the population standard deviation of the input values<br>");
  html += wxT("<b><u>aggregate function</u></b></u></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Stddev_samp( x Double precision ) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">returns the sample standard deviation of the input values<br>");
  html += wxT("<b><u>aggregate function</u></b></u></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Tan( x Double precision ) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">returns the tangent of <i>x</i>, where <i>x</i> is given in <u>radians</u></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Var_pop( x Double precision ) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">returns the population variance of the input values (<i>square of the population standard deviation</i>)<br>");
  html += wxT("<b><u>aggregate function</u></b></u></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Var_samp( x Double precision ) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">returns the sample variance of the input values (<i>square of the sample standard deviation</i>)<br>");
  html += wxT("<b><u>aggregate function</u></b></u></td></tr>");
  html +=
    wxT
    ("<tr><td align=\"center\" bgcolor=\"#e0ffe0\" colspan=\"2\"><a name=\"blob\">SQL utility functions for BLOB objects</a></a>");
  html += wxT("<br><a href=\"#index\">back to index</a></td></tr>");
  html +=
    wxT("<tr><td bgcolor=\"#fffff0\">IsZipBlob( content Blob ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments.<br>");
  html +=
    wxT
    ("TRUE if this BLOB object corresponds to a valid ZIP-compressed file</td></tr>");
  html +=
    wxT("<tr><td bgcolor=\"#fffff0\">IsPdfBlob( content Blob ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments.<br>");
  html +=
    wxT
    ("TRUE if this BLOB object corresponds to a valid PDF document</td></tr>");
  html +=
    wxT("<tr><td bgcolor=\"#fffff0\">IsGifBlob( image Blob ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments.<br>");
  html +=
    wxT("TRUE if this BLOB object corresponds to a valid GIF image</td></tr>");
  html +=
    wxT("<tr><td bgcolor=\"#fffff0\">IsPngBlob( image Blob ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments.<br>");
  html +=
    wxT("TRUE if this BLOB object corresponds to a valid PNG image</td></tr>");
  html +=
    wxT("<tr><td bgcolor=\"#fffff0\">IsJpegBlob( image Blob ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments.<br>");
  html +=
    wxT("TRUE if this BLOB object corresponds to a valid JPEG image</td></tr>");
  html +=
    wxT("<tr><td bgcolor=\"#fffff0\">IsExifBlob( image Blob ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments.<br>");
  html += wxT("TRUE if this BLOB object corresponds to a valid EXIF image<br>");
  html +=
    wxT
    ("<u>Please note:</u> any valid EXIF image is a valid JPEG as well</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">IsExifGpsBlob( image Blob ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments.<br>");
  html +=
    wxT("TRUE if this BLOB object corresponds to a valid EXIF-GPS image<br>");
  html +=
    wxT
    ("<u>Please note:</u> any valid EXIF-GPS image is a valid EXIF and JPEG as well</td></tr>");
  html +=
    wxT
    ("<tr><td align=\"center\" bgcolor=\"#e0ffe0\" colspan=\"2\"><a name=\"c30\">SQL utility functions [<i>non-standard</i>] for geometric objects</a></a>");
  html += wxT("<br><a href=\"#index\">back to index</a></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">GeomFromExifGpsBlob( image Blob ) : Geometry</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">a POINT Geometry will be returned representing the GPS long/lat contained within EXIF-GPS <i>metadata</i>	for the BLOB image<hr>");
  html +=
    wxT
    ("NULL will be returned if for any reason it's not possible to build such a POINT</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">MakePoint( x Double precision , y Double precision [ , SRID Integer] ) : Geometry</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">a Geometry will be returned representing the POINT defined by [x y] coordinates</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">BuildMbr( x1 Double precision , y1 Double precision , x2 Double precision , y2 Double precision, [ , SRID Integer] ) : Geometry</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">[x1 y1] and [x2 y2] are assumed to be Points identifying a line segment;");
  html +=
    wxT
    ("then a Geometry will be returned representing the MBR for this line segment</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">BuildCircleMbr( x Double precision , y Double precision , radius Double precision [ , SRID Integer] ) : Geometry</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">[x y] is assumed to be the center of a circle of given radius; then a Geometry will be returned representing the MBR for this circle</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">MbrMinX( geom Geometry) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">return the x-coordinate for geom MBR's leftmost side as a double precision number</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">MbrMinY( geom Geometry) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">return the y-coordinate for geom MBR's lowermost side as a double precision number</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">MbrMaxX( geom Geometry) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">return the x-coordinate for geom MBR's rightmost side as a double precision number</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">MbrMaxY( geom Geometry) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">return the y-coordinate for geom MBR's uppermost side as a double precision number</td></tr>");
  html +=
    wxT
    ("<tr><td align=\"center\" bgcolor=\"#e0ffe0\" colspan=\"2\"><a name=\"c31\">functions for constructing a geometric object given its Well-known Text Representation</a>");
  html += wxT("<br><a href=\"#index\">back to index</a></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">GeomFromText( wkt String [ , SRID Integer] ) : Geometry</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">construct a geometric object given its Well-known text Representation</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">PointFromText( wktPoint String [ , SRID Integer] ) : Point</td>");
  html += wxT("<td bgcolor=\"#f0fff0\">construct a Point</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">LineFromText( wktLineString String [ , SRID Integer] ) : Linestring<hr>");
  html +=
    wxT
    ("LineStringFromText( wktLineString String [ , SRID Integer] ) : Linestring</td>");
  html += wxT("<td bgcolor=\"#f0fff0\">construct a Linestring</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">PolyFromText( wktPolygon String [ , SRID Integer] ) : Polygon<hr>");
  html +=
    wxT
    ("PolygonFromText( wktPolygon String [ , SRID Integer] ) : Polygon</td>");
  html += wxT("<td bgcolor=\"#f0fff0\">construct a Polygon</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">MPointFromText( wktMultiPoint String [ , SRID Integer] ) : MultiPoint<hr>");
  html +=
    wxT
    ("MultiPointFromText( wktMultiPoint String [ , SRID Integer] ) : MultiPoint</td>");
  html += wxT("<td bgcolor=\"#f0fff0\">construct a MultiPoint</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">MLineFromText( wktMultiLineString String [ , SRID Integer] ) : MultiLinestring<hr>");
  html +=
    wxT
    ("MultiLineStringFromText( wktMultiLineString String [ , SRID Integer] ) : MultiLinestring</td>");
  html += wxT("<td bgcolor=\"#f0fff0\">construct a MultiLinestring</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">MPolyFromText( wktMultiPolygon String [ , SRID Integer] ) : MultiPolygon<hr>");
  html +=
    wxT
    ("MultiPolygonFromText( wktMultiPolygon String [ , SRID Integer] ) : MultiPolygon</td>");
  html += wxT("<td bgcolor=\"#f0fff0\">construct a MultiPolygon</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">GeomCollFromText( wktGeometryCollection String [ , SRID Integer] ) : GeometryCollection<hr>");
  html +=
    wxT
    ("GeometryCollectionFromText( wktGeometryCollection String [ , SRID Integer] ) : GeometryCollection</td>");
  html +=
    wxT("<td bgcolor=\"#f0fff0\">construct a GeometryCollection</td></tr>");
  html +=
    wxT
    ("<tr><td align=\"center\" bgcolor=\"#e0ffe0\" colspan=\"2\"><a name=\"c32\">functions for constructing a geometric object given its Well-known Binary Representation</a>");
  html += wxT("<br><a href=\"#index\">back to index</a></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">GeomFromWKB( wkbGeometry Binary [ , SRID Integer] ) : Geometry</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">construct a geometric object given its Well-known binary Representation</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">PointFromWKB( wkbPoint Binary [ , SRID Integer] ) : Point</td>");
  html += wxT("<td bgcolor=\"#f0fff0\">construct a Point</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">LineFromWKB( wkbLineString Binary [ , SRID Integer] ) : Linestring<hr>");
  html +=
    wxT
    ("LineStringFromText( wkbLineString Binary [ , SRID Integer] ) : Linestring</td>");
  html += wxT("<td bgcolor=\"#f0fff0\">construct a Linestring</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">PolyFromWKB( wkbPolygon Binary [ , SRID Integer] ) : Polygon<br>");
  html +=
    wxT("PolygonFromWKB( wkbPolygon Binary [ , SRID Integer] ) : Polygon</td>");
  html += wxT("<td bgcolor=\"#f0fff0\">construct a Polygon</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">MPointFromWKB( wkbMultiPoint Binary [ , SRID Integer] ) : MultiPoint<hr>");
  html +=
    wxT
    ("MultiPointFromWKB( wkbMultiPoint Binary [ , SRID Integer] ) : MultiPoint</td>");
  html += wxT("<td bgcolor=\"#f0fff0\">construct a MultiPoint</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">MLineFromWKB( wkbMultiLineString Binary [ , SRID Integer] ) : MultiLinestring<hr>");
  html +=
    wxT
    ("MultiLineStringFromWKB( wkbMultiLineString Binary [ , SRID Integer] ) : MultiLinestring</td>");
  html += wxT("<td bgcolor=\"#f0fff0\">construct a MultiLinestring</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">MPolyFromWKB( wkbMultiPolygon Binary [ , SRID Integer] ) : MultiPolygon<hr>");
  html +=
    wxT
    ("MultiPolygonFromWKB( wkbMultiPolygon Binary [ , SRID Integer] ) : MultiPolygon</td>");
  html += wxT("<td bgcolor=\"#f0fff0\">construct a MultiPolygon</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">GeomCollFromWKB( wkbGeometryCollection Binary [ , SRID Integer] ) : GeometryCollection<hr>");
  html +=
    wxT
    ("GeometryCollectionFromWKB( wkbGeometryCollection Binary [ , SRID Integer] ) : GeometryCollection</td>");
  html +=
    wxT("<td bgcolor=\"#f0fff0\">construct a GeometryCollection</td></tr>");
  html +=
    wxT
    ("<tr><td align=\"center\" bgcolor=\"#e0ffe0\" colspan=\"2\"><a name=\"c33\">functions for obtaining the Well-known Text / Well-known Binary Representation of a geometric object</a>");
  html += wxT("<br><a href=\"#index\">back to index</a></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">AsText( geom Geometry ) : String</td><td bgcolor=\"#f0fff0\">return the Well-known Text representation</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">AsBinary( geom Geometry ) : Binary</td><td bgcolor=\"#f0fff0\">return the Well-known Binary representation</td></tr>");
  html +=
    wxT
    ("<tr><td align=\"center\" bgcolor=\"#e0ffe0\" colspan=\"2\"><a name=\"c33misc\">SQL functions supporting exotic geometric formats</a>");
  html += wxT("<br><a href=\"#index\">back to index</a></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">AsSVG( geom Geometry ) : String</td><td bgcolor=\"#f0fff0\">returns the SVG [<i>Scalable Vector Graphics</i>] representation</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">AsFGF( geom Geometry ) : String</td><td bgcolor=\"#f0fff0\">returns the FGF [<i>FDO Geometry Binary Format</i>] representation</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">GeomFromFGF( fgfGeometry Binary [ , SRID Integer] ) : Geometry</td><td bgcolor=\"#f0fff0\">construct a geometric object given its FGF binary Representation</td></tr>");
  html +=
    wxT
    ("<tr><td align=\"center\" bgcolor=\"#e0ffe0\" colspan=\"2\"><a name=\"c34\">functions on type Geometry</a>");
  html += wxT("<br><a href=\"#index\">back to index</a></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Dimension( geom Geometry ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">return the dimension of the geometric object, which is less than or equal to the dimension of the coordinate space</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">GeometryType( geom Geometry ) : String</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">return the name of the instantiable subtype of Geometry of which this geometric object is a member, as a string</td></tr>");
  html +=
    wxT("<tr><td bgcolor=\"#fffff0\">SRID( geom Geometry ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">return the Spatial Reference System ID for this geometric object</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">SetSRID( geom Geometry , SRID Integer ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">directly sets the Spatial Reference System ID for this geometric object [no reprojection is applied].<br>");
  html +=
    wxT
    ("The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a ");
  html += wxT("function invocation on NULL arguments</td></tr>");
  html +=
    wxT("<tr><td bgcolor=\"#fffff0\">IsEmpty( geom Geometry ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments.<br>");
  html +=
    wxT("TRUE if this geometric object corresponds to the empty set</td></tr>");
  html +=
    wxT("<tr><td bgcolor=\"#fffff0\">IsSimple( geom Geometry ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments.<br>");
  html +=
    wxT
    ("TRUE if this geometric object is simple, as defined in the Geometry Model</td></tr>");
  html +=
    wxT("<tr><td bgcolor=\"#fffff0\">IsValid( geom Geometry ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments.<br>");
  html +=
    wxT
    ("TRUE if this geometric object does not contains any topological error</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Boundary( geom Geometry ) : Geometry</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">return a geometric object that is the combinatorial boundary of g as defined in the Geometry Model</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Envelope( geom Geometry ) : Geometry</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">return the rectangle bounding g as a Polygon. ");
  html +=
    wxT
    ("The Polygon is defined by the corner points of the bounding box [(MINX, MINY),(MAXX, MINY), (MAXX, MAXY), (MINX, MAXY), (MINX, MINY)].</td></tr>");
  html +=
    wxT
    ("<tr><td align=\"center\" bgcolor=\"#e0ffe0\" colspan=\"2\"><a name=\"c35\">functions on type Point</a>");
  html += wxT("<br><a href=\"#index\">back to index</a></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">X( pt Point ) : Double precision</td><td bgcolor=\"#f0fff0\">return the x-coordinate of Point p as a double precision number</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Y( pt Point ) : Double precision</td><td bgcolor=\"#f0fff0\">return the y-coordinate of Point p as a double precision number</td></tr>");
  html +=
    wxT
    ("<tr><td align=\"center\" bgcolor=\"#e0ffe0\" colspan=\"2\">functions on type Curve [Linestring or Ring]</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">StartPoint( c Curve ) : Point</td><td bgcolor=\"#f0fff0\">return a Point containing the first Point of c</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">EndPoint( c Curve ) : Point</td><td bgcolor=\"#f0fff0\">return a Point containing the last Point of c</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">NumPoints( line LineString ) : Integer</td><td bgcolor=\"#f0fff0\">return the number of Points in the LineString</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">PointN( line LineString , n Integer ) : Point</td><td bgcolor=\"#f0fff0\">return a Point containing Point n of line</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">GLength( c Curve ) : Double precision</td><td bgcolor=\"#f0fff0\">return the length of c</td></tr>");
  html += wxT("<tr><td bgcolor=\"#fffff0\">IsClosed( c Curve ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments<br>");
  html +=
    wxT
    ("return TRUE if c is closed, i.e., if StartPoint(c) = EndPoint(c)</td></tr>");
  html += wxT("<tr><td bgcolor=\"#fffff0\">IsRing( c Curve ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments<br>");
  html +=
    wxT
    ("return TRUE if c is a ring, i.e., if c is closed and simple. A simple Curve does not pass through the same Point more than once.</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Simplify( c Curve , tolerance Double precision ) : Curve</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">return a geometric object representing a simplified version of c applying the Douglas-Peukert algorithm with given tolerance</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">SimplifyPreserveTopology( c Curve , tolerance Double precision ) : Curve</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">return a geometric object representing a simplified version of c ");
  html +=
    wxT
    ("applying the Douglas-Peukert algorithm with given tolerance and respecting topology</td></tr>");
  html +=
    wxT
    ("<tr><td align=\"center\" bgcolor=\"#e0ffe0\" colspan=\"2\"><a name=\"c36\">functions on type Surface [Polygon or Ring]</a>");
  html += wxT("<br><a href=\"#index\">back to index</a></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Centroid( s Surface ) : Point</td><td bgcolor=\"#f0fff0\">return the centroid of s, which may lie outside s</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">PointOnSurface( s Surface ) : Point</td><td bgcolor=\"#f0fff0\">return a Point guaranteed to lie on the Surface</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Area( s Surface ) : Double precision</td><td bgcolor=\"#f0fff0\">return the area of s</td></tr>");
  html +=
    wxT
    ("<tr><td align=\"center\" bgcolor=\"#e0ffe0\" colspan=\"2\"><a name=\"c37\">functions on type Polygon</a>");
  html += wxT("<br><a href=\"#index\">back to index</a></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">ExteriorRing( polyg Polygon ) : LineString</td><td bgcolor=\"#f0fff0\">return the exteriorRing of p</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">NumInteriorRing( polyg Polygon ) : Integer<hr>NumInteriorRings( polyg Polygon ) : Integer</td>");
  html +=
    wxT("<td bgcolor=\"#f0fff0\">return the number of interiorRings</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">InteriorRingN( polyg Polygon , n Integer ) : LineString</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">return the nth interiorRing. The order of Rings is not geometrically significant.</td></tr>");
  html +=
    wxT
    ("<tr><td align=\"center\" bgcolor=\"#e0ffe0\" colspan=\"2\"><a name=\"c38\">functions on type GeomCollection</a>");
  html += wxT("<br><a href=\"#index\">back to index</a></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">NumGeometries( geom GeomCollection ) : Integer</td><td bgcolor=\"#f0fff0\">return the number of geometries</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">GeometryN( geom GeomCollection , n Integer ) : Geometry</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">return the nth geometric object in the collection. The order of the elements in the collection is not geometrically significant.</td></tr>");
  html +=
    wxT
    ("<tr><td align=\"center\" bgcolor=\"#e0ffe0\" colspan=\"2\"><a name=\"c39\">functions testing approximative spatial relationships via MBRs</a>");
  html += wxT("<br><a href=\"#index\">back to index</a></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">MbrEqual( geom1 Geometry , geom2 Geometry ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments.<br>");
  html += wxT("TRUE if g1 and g2 have equal MBRs</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">MbrDisjoint( geom1 Geometry , geom2 Geometry ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments.<br>");
  html +=
    wxT
    ("TRUE if the intersection of g1 and g2 MBRs is the empty set</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">MbrTouches( geom1 Geometry , geom2 Geometry ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments.<br>");
  html +=
    wxT
    ("TRUE if the only Points in common between g1 and g2 MBRs lie in the union of the boundaries of g1 and g2</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">MbrWithin( geom1 Geometry , geom2 Geometry ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments.<br>");
  html += wxT("TRUE if g1 MBR is completely contained in g2 MBR</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">MbrOverlaps( geom1 Geometry , geom2 Geometry ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments.<br>");
  html +=
    wxT
    ("TRUE if the intersection of g1 and g2 MBRs results in a value of the same dimension as g1 and g2 that is different from both g1 and g2</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">MbrIntersects( geom1 Geometry , geom2 Geometry ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments<br>");
  html +=
    wxT
    ("convenience predicate: TRUE if the intersection of g1 and g2 MBRs is not empty</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">MbrContains( geom1 Geometry , geom2 Geometry ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments<br>");
  html +=
    wxT
    ("convenience predicate: TRUE if g2 MBR is completely contained in g1 MBR</td></tr>");
  html +=
    wxT
    ("<tr><td align=\"center\" bgcolor=\"#e0ffe0\" colspan=\"2\"><a name=\"c40\">functions testing spatial relationships</a>");
  html += wxT("<br><a href=\"#index\">back to index</a></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Equals( geom1 Geometry , geom2 Geometry ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments.<br>");
  html += wxT("TRUE if g1 and g2 are equal</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Disjoint( geom1 Geometry , geom2 Geometry ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments.<br>");
  html +=
    wxT("TRUE if the intersection of g1 and g2 is the empty set</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Touches( geom1 Geometry , geom2 Geometry ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments.<br>");
  html +=
    wxT
    ("TRUE if the only Points in common between g1 and g2 lie in the union of the boundaries of g1 and g2</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Within( geom1 Geometry , geom2 Geometry ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments.<br>");
  html += wxT("TRUE if g1 is completely contained in g2</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Overlaps( geom1 Geometry , geom2 Geometry ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments.<br>");
  html +=
    wxT
    ("TRUE if the intersection of g1 and g2 results in a value of the same dimension as g1 and g2 that is different from both g1 and g2</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Crosses( geom1 Geometry , geom2 Geometry ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments.<br>");
  html +=
    wxT
    ("TRUE if the intersection of g1 and g2 results in a value whose dimension is less than the maximum dimension of g1 and g2 ");
  html +=
    wxT
    ("and the intersection value includes Points interior to both g1 and g2, and the intersection value is not equal to either g1 or g2</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Intersects( geom1 Geometry , geom2 Geometry ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments<br>");
  html +=
    wxT
    ("convenience predicate: TRUE if the intersection of g1 and g2 is not empty</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Contains( geom1 Geometry , geom2 Geometry ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments<br>");
  html +=
    wxT
    ("convenience predicate: TRUE if g2 is completely contained in g1</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Relate( geom1 Geometry , geom2 Geometry , patternMatrix String ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">The return type is Integer, with a return value of 1 for TRUE, 0 for FALSE, and -1 for UNKNOWN corresponding to a function invocation on NULL arguments.<br>");
  html +=
    wxT
    ("return TRUE if the spatial relationship specified by the patternMatrix holds</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Distance( geom1 Geometry , geom2 Geometry ) : Double precision</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">return the distance between geom1 and geom2</td></tr>");
  html +=
    wxT
    ("<tr><td align=\"center\" bgcolor=\"#e0ffe0\" colspan=\"2\"><a name=\"c41\">functions implementing spatial operators</a>");
  html += wxT("<br><a href=\"#index\">back to index</a></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Intersection( geom1 Geometry , geom2 Geometry ) : Geometry</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">return a geometric object that is the intersection of geometric objects geom1 and geom2</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Difference( geom1 Geometry , geom2 Geometry ) : Geometry</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">return a geometric object that is the closure of the set difference of geom1 and geom2</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">GUnion( geom1 Geometry , geom2 Geometry ) : Geometry</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">return a geometric object that is the set union of geom1 and geom2</td></tr>");
  html +=
    wxT("<tr><td bgcolor=\"#fffff0\">GUnion( geom Geometry ) : Geometry</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">return a geometric object that is the set union of input values<br>");
  html += wxT("<b><u>aggregate function</u></b></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">SymDifference( geom1 Geometry , geom2 Geometry ) : Geometry</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">return a geometric object that is the closure of the set symmetric difference of geom1 and geom2 (logical XOR of space)</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Buffer( geom Geometry , dist Double precision ) : Geometry</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">return a geometric object defined by buffering a distance d around geom, ");
  html +=
    wxT
    ("where dist is in the distance units for the Spatial Reference of geom</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">ConvexHull( geom Geometry ) : Geometry</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">return a geometric object that is the convex hull of geom</td></tr>");
  html +=
    wxT
    ("<tr><td align=\"center\" bgcolor=\"#e0ffe0\" colspan=\"2\"><a name=\"c42\">functions for coordinate transformations</a>");
  html += wxT("<br><a href=\"#index\">back to index</a></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">Transform( geom Geometry , newSRID Integer ) : Geometry</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">return a geometric object obtained by reprojecting coordinates into the Reference System identified by newSRID</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">ShiftCoords( geom Geometry , shiftX Double precision , shiftY Double precision ) : Geometry<hr>");
  html +=
    wxT
    ("ShiftCoordinates( geom Geometry , shiftX Double precision , shiftY Double precision ) : Geometry</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">return a geometric object obtained by translating coordinates according to shiftX and shiftY values</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">ScaleCoords( geom Geometry , scaleX Double precision [ , scaleY Double precision ] ) : Geometry<hr>");
  html +=
    wxT
    ("ScaleCoordinates( geom Geometry , scaleX Double precision [ , scaleY Double precision ] ) : Geometry</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">return a geometric object obtained by scaling coordinates according to scaleX and scaleY values<br>");
  html +=
    wxT
    ("if only one scale factor is specified, then an isotropic scaling occurs [i.e. the same scale factor is applied to both axis]");
  html +=
    wxT
    ("otherwise an anisotropic scaling occurs [i.e. each axis is scaled according to its own scale factor]</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">RotateCoords( geom Geometry , angleInDegrees Double precision ) : Geometry<hr>");
  html +=
    wxT
    ("RotateCoordinates( geom Geometry , angleInDegrees Double precision ) : Geometry</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">return a geometric object obtained by rotating coordinates according to angleInDegrees value</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">ReflectCoords( geom Geometry , xAxis Integer , yAxis Integer ) : Geometry<hr>");
  html +=
    wxT
    ("ReflectCoordinates( geom Geometry , xAxis Integer , yAxis Integer ) : Geometry</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">return a geometric object obtained by reflecting coordinates according to xAxis and yAxis switches<br>");
  html +=
    wxT
    ("i.e. if xAxis is 0 (FALSE), then x-coordinates remains untouched; otherwise x-coordinates will be reflected</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">SwapCoords( geom Geometry ) : Geometry<hr>SwapCoordinates( geom Geometry ) : Geometry</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">return a geometric object obtained by swapping x- and y-coordinates</td></tr>");
  html +=
    wxT
    ("<tr><td align=\"center\" bgcolor=\"#e0ffe0\" colspan=\"2\"><a name=\"c43\">functions for Spatial-MetaData and Spatial-Index handling</a>");
  html += wxT("<br><a href=\"#index\">back to index</a></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">InitSpatialMetaData( void ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">Creates the geometry_columns and spatial_ref_sys metadata tables");
  html +=
    wxT
    ("the return type is Integer, with a return value of 1 for TRUE or 0 for FALSE<br>");
  html +=
    wxT
    ("direct invocation of these function is discouraged; you have to run the init_spatialite.sql ");
  html +=
    wxT
    ("script in order to fully initialize the Spatial MetaData tables</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">AddGeometryColumn( table String , column String , srid Integer , geom_type String , dimension Integer [ , not_null Integer ] ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">Creates a new geometry column updating the Spatial Metadata tables and creating any required trigger in order to enforce constraints<br>");
  html +=
    wxT
    ("the return type is Integer, with a return value of 1 for TRUE or 0 for FALSE</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">RecoverGeometryColumn( table String , column String , srid Integer , geom_type String , dimension Integer ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">Validates an existing ordinary column in order to possibly transform it in a real geometry column, ");
  html +=
    wxT
    ("thus updating the Spatial Metadata tables and creating any required trigger in order to enforce constraints<br>");
  html +=
    wxT
    ("the return type is Integer, with a return value of 1 for TRUE or 0 for FALSE</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">DiscardGeometryColumn( table String , column String ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">Removes a geometry column from Spatial MetaData tables and drops any related trigger<br>");
  html +=
    wxT
    ("the column itself still continues to exist untouched as an ordinary, unconstrained column<br>");
  html +=
    wxT
    ("the return type is Integer, with a return value of 1 for TRUE or 0 for FALSE</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">CreateSpatialIndex( table String , column String ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">Builds an RTree Spatial Index on a geometry column, ");
  html +=
    wxT
    ("creating any required trigger required in order to enforce full data coherency between the main table and Spatial Index<br>");
  html +=
    wxT
    ("the return type is Integer, with a return value of 1 for TRUE or 0 for FALSE</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">DisableSpatialIndex( table String , column String ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">Disables an RTree Spatial Index, removing any related trigger<br>");
  html +=
    wxT
    ("the return type is Integer, with a return value of 1 for TRUE or 0 for FALSE</td></tr>");
  html +=
    wxT
    ("<tr><td align=\"center\" bgcolor=\"#e0ffe0\" colspan=\"2\"><a name=\"c43fdo\">functions implementing FDO/OGR compatibily</a>");
  html += wxT("<br><a href=\"#index\">back to index</a></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">CheckSpatialMetaData( void ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">Checks the Spatial Metadata type, then returning:<br>");
  html +=
    wxT
    ("<b>0</b> if <i>geometry_columns</i> and <i>spatial_ref_sys</i> tables does not exists<br>");
  html +=
    wxT
    ("<b>1</b> if both tables exist, and their layout is the one used by <i>SpatiaLite</i><br>");
  html +=
    wxT
    ("<b>2</b> if both tables exist, and their layout is the one used by <i>FDO/OGR</i></td></tr>");
  html +=
    wxT("<tr><td bgcolor=\"#fffff0\">AutoFDOStart( void ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">This function will inspect the Spatial Metadata, then automatically creating/refreshing a <i>VirtualFDO</i>");
  html +=
    wxT
    (" wrapper for each FDO/OGR geometry table<br>the return type is Integer [how many VirtualFDO tables have been created]</td></tr>");
  html += wxT("<tr><td bgcolor=\"#fffff0\">AutoFDOStop( void ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">This function will inspect the Spatial Metadata, then automatically destroying any <i>VirtualFDO</i>");
  html +=
    wxT
    (" wrapper found<br>the return type is Integer [how many VirtualFDO tables have been destroyed]</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">InitFDOSpatialMetaData( void ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">Creates the geometry_columns and spatial_ref_sys metadata tables");
  html +=
    wxT
    ("the return type is Integer, with a return value of 1 for TRUE or 0 for FALSE<br>");
  html +=
    wxT
    ("<u>Please note:</u> Spatial Metadata created using this function will have the FDO/OGR layout, and not the SpatiaLite's own</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">AddFDOGeometryColumn( table String , column String , srid Integer , geom_type String , dimension Integer , geometry_type String ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">Creates a new geometry column updating the FDO/OGR Spatial Metadata tables<br>");
  html +=
    wxT
    ("the return type is Integer, with a return value of 1 for TRUE or 0 for FALSE</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">RecoverFDOGeometryColumn( table String , column String , srid Integer , geom_type String , dimension Integer , geometry_type String ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">Validates an existing ordinary column in order to possibly transform it in a real geometry column, ");
  html += wxT("thus updating the FDO/OGR Spatial Metadata tables<br>");
  html +=
    wxT
    ("the return type is Integer, with a return value of 1 for TRUE or 0 for FALSE</td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">DiscardFDOGeometryColumn( table String , column String ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">Removes a geometry column from FDO/OGR Spatial MetaData tables<br>");
  html +=
    wxT
    ("the column itself still continues to exist untouched as an ordinary column<br>");
  html +=
    wxT
    ("the return type is Integer, with a return value of 1 for TRUE or 0 for FALSE</td></tr>");
  html +=
    wxT
    ("<tr><td align=\"center\" bgcolor=\"#e0ffe0\" colspan=\"2\"><a name=\"c44\">functions for MbrCache-based queries</a>");
  html += wxT("<br><a href=\"#index\">back to index</a></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">FilterMbrWithin( x1 Double precision , y1 Double precision , x2 Double precision , y2 Double precision  ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">Retrieves from an MbrCache any entity whose MBR falls <u><i>within</i></u>");
  html +=
    wxT
    (" the rectangle identified by extreme points <i>x1 y1</i> and <i>x2 y2</i></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">FilterMbrContains( x1 Double precision , y1 Double precision , x2 Double precision , y2 Double precision  ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">Retrieves from an MbrCache any entity whose MBR <u><i>contains</i></u>");
  html +=
    wxT
    (" the rectangle identified by extreme points <i>x1 y1</i> and <i>x2 y2</i></td></tr>");
  html +=
    wxT
    ("<tr><td bgcolor=\"#fffff0\">FilterMbrIntersects( x1 Double precision , y1 Double precision , x2 Double precision , y2 Double precision  ) : Integer</td>");
  html +=
    wxT
    ("<td bgcolor=\"#f0fff0\">Retrieves from an MbrCache any entity whose MBR <u><i>intersects</i></u>");
  html +=
    wxT
    (" the rectangle identified by extreme points <i>x1 y1</i> and <i>x2 y2</i></td></tr>");


  html += wxT("</table>");
  html += wxT("<a href=\"#index\">back to index</a>");
  html += wxT("</body>");
  html += wxT("</html>");
}
