/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Tue Jul 14 19:02:34 2020

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_30 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 6063, "epsg", 6063,
        "GR96 / EPSG Arctic zone 6-28", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-38 +x_0=28500000 +y_0=6500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 6-28\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4747\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",68.6874755555556],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-38],PARAMETER[\"standard_parallel_1\",70.333");
    add_srs_wkt (p, 9,
        "3333333333],PARAMETER[\"standard_parallel_2\",67],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",28500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",6500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"6063\"]]");
    p = add_epsg_def_ex (filter, first, last, 6064, "epsg", 6064,
        "GR96 / EPSG Arctic zone 6-30", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-20 +x_0=30500000 +y_0=6500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 6-30\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4747\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",68.6874755555556],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-20],PARAMETER[\"standard_parallel_1\",70.333");
    add_srs_wkt (p, 9,
        "3333333333],PARAMETER[\"standard_parallel_2\",67],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",30500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",6500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"6064\"]]");
    p = add_epsg_def_ex (filter, first, last, 6065, "epsg", 6065,
        "GR96 / EPSG Arctic zone 7-11", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=67 +lat_2=63.66666666666666 +lat_0=65.3");
    add_proj4text (p, 1,
        "5103930555555 +lon_0=-51 +x_0=11500000 +y_0=7500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 7-11\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4747\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",65.3510393055555],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-51],PARAMETER[\"standard_parallel_1\",67],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"standard_parallel_2\",63.6666666666667],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",11500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",7500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"6065\"]]");
    p = add_epsg_def_ex (filter, first, last, 6066, "epsg", 6066,
        "GR96 / EPSG Arctic zone 7-13", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=67 +lat_2=63.66666666666666 +lat_0=65.3");
    add_proj4text (p, 1,
        "5103930555555 +lon_0=-34 +x_0=13500000 +y_0=7500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 7-13\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4747\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",65.3510393055555],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-34],PARAMETER[\"standard_parallel_1\",67],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"standard_parallel_2\",63.6666666666667],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",13500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",7500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"6066\"]]");
    p = add_epsg_def_ex (filter, first, last, 6067, "epsg", 6067,
        "GR96 / EPSG Arctic zone 8-20", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=63.66666666666666 +lat_2=60.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=62.01530688888889 +lon_0=-52 +x_0=20500000 +y");
    add_proj4text (p, 2,
        "_0=8500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 8-20\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4747\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",62.0153068888889],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-52],PARAMETER[\"standard_parallel_1\",63.666");
    add_srs_wkt (p, 9,
        "6666666667],PARAMETER[\"standard_parallel_2\",60.3333333");
    add_srs_wkt (p, 10,
        "333333],PARAMETER[\"false_easting\",20500000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",8500000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"6067\"]]");
    p = add_epsg_def_ex (filter, first, last, 6068, "epsg", 6068,
        "GR96 / EPSG Arctic zone 8-22", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=63.66666666666666 +lat_2=60.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=62.01530688888889 +lon_0=-37 +x_0=22500000 +y");
    add_proj4text (p, 2,
        "_0=8500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 8-22\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4747\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",62.0153068888889],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-37],PARAMETER[\"standard_parallel_1\",63.666");
    add_srs_wkt (p, 9,
        "6666666667],PARAMETER[\"standard_parallel_2\",60.3333333");
    add_srs_wkt (p, 10,
        "333333],PARAMETER[\"false_easting\",22500000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",8500000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"6068\"]]");
    p = add_epsg_def_ex (filter, first, last, 6069, "epsg", 6069,
        "ETRS89 / EPSG Arctic zone 2-22", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=16 +x_0=22500000 +y_");
    add_proj4text (p, 2,
        "0=2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / EPSG Arctic zone 2-22\",GEOGCS[\"ETRS8");
    add_srs_wkt (p, 1,
        "9\",DATUM[\"European_Terrestrial_Reference_System_1989\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",82.05842");
    add_srs_wkt (p, 8,
        "48888889],PARAMETER[\"central_meridian\",16],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_1\",83.6666666666667],PARAMETER[\"stan");
    add_srs_wkt (p, 10,
        "dard_parallel_2\",80.3333333333333],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",22500000],PARAMETER[\"false_northing\",2500000],");
    add_srs_wkt (p, 12,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 13,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"6069\"]]");
    p = add_epsg_def_ex (filter, first, last, 6070, "epsg", 6070,
        "ETRS89 / EPSG Arctic zone 3-11", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=21 +x_0=11500000 +y_0=3500000 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / EPSG Arctic zone 3-11\",GEOGCS[\"ETRS8");
    add_srs_wkt (p, 1,
        "9\",DATUM[\"European_Terrestrial_Reference_System_1989\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",78.70733");
    add_srs_wkt (p, 8,
        "75277778],PARAMETER[\"central_meridian\",21],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_1\",80.3333333333333],PARAMETER[\"stan");
    add_srs_wkt (p, 10,
        "dard_parallel_2\",77],PARAMETER[\"false_easting\",115000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",3500000],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6070\"]]");
    p = add_epsg_def_ex (filter, first, last, 6071, "epsg", 6071,
        "ETRS89 / EPSG Arctic zone 4-26", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=10 +x_0=26500000 +y_0=4500000 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / EPSG Arctic zone 4-26\",GEOGCS[\"ETRS8");
    add_srs_wkt (p, 1,
        "9\",DATUM[\"European_Terrestrial_Reference_System_1989\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",75.36440");
    add_srs_wkt (p, 8,
        "33055556],PARAMETER[\"central_meridian\",10],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_1\",77],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 10,
        "2\",73.6666666666667],PARAMETER[\"false_easting\",265000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",4500000],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6071\"]]");
    p = add_epsg_def_ex (filter, first, last, 6072, "epsg", 6072,
        "ETRS89 / EPSG Arctic zone 4-28", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=34 +x_0=28500000 +y_0=4500000 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / EPSG Arctic zone 4-28\",GEOGCS[\"ETRS8");
    add_srs_wkt (p, 1,
        "9\",DATUM[\"European_Terrestrial_Reference_System_1989\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",75.36440");
    add_srs_wkt (p, 8,
        "33055556],PARAMETER[\"central_meridian\",34],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_1\",77],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 10,
        "2\",73.6666666666667],PARAMETER[\"false_easting\",285000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",4500000],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6072\"]]");
    p = add_epsg_def_ex (filter, first, last, 6073, "epsg", 6073,
        "ETRS89 / EPSG Arctic zone 5-11", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=14 +x_0=11500000 +y_");
    add_proj4text (p, 2,
        "0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / EPSG Arctic zone 5-11\",GEOGCS[\"ETRS8");
    add_srs_wkt (p, 1,
        "9\",DATUM[\"European_Terrestrial_Reference_System_1989\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",72.02500");
    add_srs_wkt (p, 8,
        "91944445],PARAMETER[\"central_meridian\",14],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_1\",73.6666666666667],PARAMETER[\"stan");
    add_srs_wkt (p, 10,
        "dard_parallel_2\",70.3333333333333],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",11500000],PARAMETER[\"false_northing\",5500000],");
    add_srs_wkt (p, 12,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 13,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"6073\"]]");
    p = add_epsg_def_ex (filter, first, last, 6074, "epsg", 6074,
        "ETRS89 / EPSG Arctic zone 5-13", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=34 +x_0=13500000 +y_");
    add_proj4text (p, 2,
        "0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / EPSG Arctic zone 5-13\",GEOGCS[\"ETRS8");
    add_srs_wkt (p, 1,
        "9\",DATUM[\"European_Terrestrial_Reference_System_1989\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",72.02500");
    add_srs_wkt (p, 8,
        "91944445],PARAMETER[\"central_meridian\",34],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_1\",73.6666666666667],PARAMETER[\"stan");
    add_srs_wkt (p, 10,
        "dard_parallel_2\",70.3333333333333],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",13500000],PARAMETER[\"false_northing\",5500000],");
    add_srs_wkt (p, 12,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 13,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"6074\"]]");
    p = add_epsg_def_ex (filter, first, last, 6075, "epsg", 6075,
        "WGS 84 / EPSG Arctic zone 2-24", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=53 +x_0=24500000 +y_");
    add_proj4text (p, 2,
        "0=2500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 2-24\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",82.0584248888889],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",53],PARAMETER[\"standard_parallel_1\",83.666666666");
    add_srs_wkt (p, 9,
        "6667],PARAMETER[\"standard_parallel_2\",80.3333333333333");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",24500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",2500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"6075\"]]");
    p = add_epsg_def_ex (filter, first, last, 6076, "epsg", 6076,
        "WGS 84 / EPSG Arctic zone 2-26", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=93 +x_0=26500000 +y_");
    add_proj4text (p, 2,
        "0=2500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 2-26\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",82.0584248888889],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",93],PARAMETER[\"standard_parallel_1\",83.666666666");
    add_srs_wkt (p, 9,
        "6667],PARAMETER[\"standard_parallel_2\",80.3333333333333");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",26500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",2500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"6076\"]]");
    p = add_epsg_def_ex (filter, first, last, 6077, "epsg", 6077,
        "WGS 84 / EPSG Arctic zone 3-13", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=52 +x_0=13500000 +y_0=3500000 +datu");
    add_proj4text (p, 2,
        "m=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 3-13\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",78.7073375277778],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",52],PARAMETER[\"standard_parallel_1\",80.333333333");
    add_srs_wkt (p, 9,
        "3333],PARAMETER[\"standard_parallel_2\",77],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",13500000],PARAMETER[\"false_northing\",3");
    add_srs_wkt (p, 11,
        "500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"6077\"]]");
    p = add_epsg_def_ex (filter, first, last, 6078, "epsg", 6078,
        "WGS 84 / EPSG Arctic zone 3-15", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=83 +x_0=15500000 +y_0=3500000 +datu");
    add_proj4text (p, 2,
        "m=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 3-15\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",78.7073375277778],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",83],PARAMETER[\"standard_parallel_1\",80.333333333");
    add_srs_wkt (p, 9,
        "3333],PARAMETER[\"standard_parallel_2\",77],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",15500000],PARAMETER[\"false_northing\",3");
    add_srs_wkt (p, 11,
        "500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"6078\"]]");
    p = add_epsg_def_ex (filter, first, last, 6079, "epsg", 6079,
        "WGS 84 / EPSG Arctic zone 3-17", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=114 +x_0=17500000 +y_0=3500000 +dat");
    add_proj4text (p, 2,
        "um=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 3-17\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",78.7073375277778],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",114],PARAMETER[\"standard_parallel_1\",80.33333333");
    add_srs_wkt (p, 9,
        "33333],PARAMETER[\"standard_parallel_2\",77],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",17500000],PARAMETER[\"false_northing\",3");
    add_srs_wkt (p, 11,
        "500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"6079\"]]");
    p = add_epsg_def_ex (filter, first, last, 6080, "epsg", 6080,
        "WGS 84 / EPSG Arctic zone 3-19", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=145 +x_0=19500000 +y_0=3500000 +dat");
    add_proj4text (p, 2,
        "um=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 3-19\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",78.7073375277778],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",145],PARAMETER[\"standard_parallel_1\",80.33333333");
    add_srs_wkt (p, 9,
        "33333],PARAMETER[\"standard_parallel_2\",77],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",19500000],PARAMETER[\"false_northing\",3");
    add_srs_wkt (p, 11,
        "500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"6080\"]]");
    p = add_epsg_def_ex (filter, first, last, 6081, "epsg", 6081,
        "WGS 84 / EPSG Arctic zone 4-30", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=58 +x_0=30500000 +y_0=4500000 +datu");
    add_proj4text (p, 2,
        "m=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 4-30\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",75.3644033055556],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",58],PARAMETER[\"standard_parallel_1\",77],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"standard_parallel_2\",73.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",30500000],PARAMETER[\"false_northing\",4");
    add_srs_wkt (p, 11,
        "500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"6081\"]]");
    p = add_epsg_def_ex (filter, first, last, 6082, "epsg", 6082,
        "WGS 84 / EPSG Arctic zone 4-32", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=82 +x_0=32500000 +y_0=4500000 +datu");
    add_proj4text (p, 2,
        "m=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 4-32\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",75.3644033055556],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",82],PARAMETER[\"standard_parallel_1\",77],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"standard_parallel_2\",73.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",32500000],PARAMETER[\"false_northing\",4");
    add_srs_wkt (p, 11,
        "500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"6082\"]]");
    p = add_epsg_def_ex (filter, first, last, 6083, "epsg", 6083,
        "WGS 84 / EPSG Arctic zone 4-34", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=106 +x_0=34500000 +y_0=4500000 +dat");
    add_proj4text (p, 2,
        "um=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 4-34\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",75.3644033055556],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",106],PARAMETER[\"standard_parallel_1\",77],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_2\",73.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",34500000],PARAMETER[\"false_northing\",4");
    add_srs_wkt (p, 11,
        "500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"6083\"]]");
    p = add_epsg_def_ex (filter, first, last, 6084, "epsg", 6084,
        "WGS 84 / EPSG Arctic zone 4-36", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=130 +x_0=36500000 +y_0=4500000 +dat");
    add_proj4text (p, 2,
        "um=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 4-36\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",75.3644033055556],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",130],PARAMETER[\"standard_parallel_1\",77],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_2\",73.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",36500000],PARAMETER[\"false_northing\",4");
    add_srs_wkt (p, 11,
        "500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"6084\"]]");
    p = add_epsg_def_ex (filter, first, last, 6085, "epsg", 6085,
        "WGS 84 / EPSG Arctic zone 4-38", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=154 +x_0=38500000 +y_0=4500000 +dat");
    add_proj4text (p, 2,
        "um=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 4-38\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",75.3644033055556],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",154],PARAMETER[\"standard_parallel_1\",77],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_2\",73.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",38500000],PARAMETER[\"false_northing\",4");
    add_srs_wkt (p, 11,
        "500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"6085\"]]");
    p = add_epsg_def_ex (filter, first, last, 6086, "epsg", 6086,
        "WGS 84 / EPSG Arctic zone 4-40", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=179 +x_0=40500000 +y_0=4500000 +dat");
    add_proj4text (p, 2,
        "um=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 4-40\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",75.3644033055556],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",179],PARAMETER[\"standard_parallel_1\",77],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_2\",73.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",40500000],PARAMETER[\"false_northing\",4");
    add_srs_wkt (p, 11,
        "500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"6086\"]]");
    p = add_epsg_def_ex (filter, first, last, 6087, "epsg", 6087,
        "WGS 84 / EPSG Arctic zone 5-15", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=54 +x_0=15500000 +y_");
    add_proj4text (p, 2,
        "0=5500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 5-15\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",72.0250091944445],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",54],PARAMETER[\"standard_parallel_1\",73.666666666");
    add_srs_wkt (p, 9,
        "6667],PARAMETER[\"standard_parallel_2\",70.3333333333333");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",15500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"6087\"]]");
    p = add_epsg_def_ex (filter, first, last, 6088, "epsg", 6088,
        "WGS 84 / EPSG Arctic zone 5-17", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=74 +x_0=17500000 +y_");
    add_proj4text (p, 2,
        "0=5500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 5-17\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",72.0250091944445],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",74],PARAMETER[\"standard_parallel_1\",73.666666666");
    add_srs_wkt (p, 9,
        "6667],PARAMETER[\"standard_parallel_2\",70.3333333333333");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",17500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"6088\"]]");
    p = add_epsg_def_ex (filter, first, last, 6089, "epsg", 6089,
        "WGS 84 / EPSG Arctic zone 5-19", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=95 +x_0=19500000 +y_");
    add_proj4text (p, 2,
        "0=5500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 5-19\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",72.0250091944445],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",95],PARAMETER[\"standard_parallel_1\",73.666666666");
    add_srs_wkt (p, 9,
        "6667],PARAMETER[\"standard_parallel_2\",70.3333333333333");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",19500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"6089\"]]");
    p = add_epsg_def_ex (filter, first, last, 6090, "epsg", 6090,
        "WGS 84 / EPSG Arctic zone 5-21", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=116 +x_0=21500000 +y");
    add_proj4text (p, 2,
        "_0=5500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 5-21\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",72.0250091944445],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",116],PARAMETER[\"standard_parallel_1\",73.66666666");
    add_srs_wkt (p, 9,
        "66667],PARAMETER[\"standard_parallel_2\",70.333333333333");
    add_srs_wkt (p, 10,
        "3],PARAMETER[\"false_easting\",21500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"6090\"]]");
    p = add_epsg_def_ex (filter, first, last, 6091, "epsg", 6091,
        "WGS 84 / EPSG Arctic zone 5-23", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=137 +x_0=23500000 +y");
    add_proj4text (p, 2,
        "_0=5500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 5-23\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",72.0250091944445],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",137],PARAMETER[\"standard_parallel_1\",73.66666666");
    add_srs_wkt (p, 9,
        "66667],PARAMETER[\"standard_parallel_2\",70.333333333333");
    add_srs_wkt (p, 10,
        "3],PARAMETER[\"false_easting\",23500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"6091\"]]");
    p = add_epsg_def_ex (filter, first, last, 6092, "epsg", 6092,
        "WGS 84 / EPSG Arctic zone 5-25", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=158 +x_0=25500000 +y");
    add_proj4text (p, 2,
        "_0=5500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 5-25\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",72.0250091944445],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",158],PARAMETER[\"standard_parallel_1\",73.66666666");
    add_srs_wkt (p, 9,
        "66667],PARAMETER[\"standard_parallel_2\",70.333333333333");
    add_srs_wkt (p, 10,
        "3],PARAMETER[\"false_easting\",25500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"6092\"]]");
    p = add_epsg_def_ex (filter, first, last, 6093, "epsg", 6093,
        "WGS 84 / EPSG Arctic zone 5-27", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=179 +x_0=27500000 +y");
    add_proj4text (p, 2,
        "_0=5500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 5-27\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",72.0250091944445],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",179],PARAMETER[\"standard_parallel_1\",73.66666666");
    add_srs_wkt (p, 9,
        "66667],PARAMETER[\"standard_parallel_2\",70.333333333333");
    add_srs_wkt (p, 10,
        "3],PARAMETER[\"false_easting\",27500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"6093\"]]");
    p = add_epsg_def_ex (filter, first, last, 6094, "epsg", 6094,
        "NAD83(NSRS2007) / EPSG Arctic zone 5-29", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=-163 +x_0=29500000 +");
    add_proj4text (p, 2,
        "y_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / EPSG Arctic zone 5-29\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4759\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",72.0250091944445],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-163],PARAMETER[\"standard_parallel_1\",73.6666666");
    add_srs_wkt (p, 10,
        "666667],PARAMETER[\"standard_parallel_2\",70.33333333333");
    add_srs_wkt (p, 11,
        "33],PARAMETER[\"false_easting\",29500000],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 14,
        "NORTH],AUTHORITY[\"EPSG\",\"6094\"]]");
    p = add_epsg_def_ex (filter, first, last, 6095, "epsg", 6095,
        "NAD83(NSRS2007) / EPSG Arctic zone 5-31", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=-147 +x_0=31500000 +");
    add_proj4text (p, 2,
        "y_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / EPSG Arctic zone 5-31\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4759\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",72.0250091944445],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-147],PARAMETER[\"standard_parallel_1\",73.6666666");
    add_srs_wkt (p, 10,
        "666667],PARAMETER[\"standard_parallel_2\",70.33333333333");
    add_srs_wkt (p, 11,
        "33],PARAMETER[\"false_easting\",31500000],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",5500000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 14,
        "NORTH],AUTHORITY[\"EPSG\",\"6095\"]]");
    p = add_epsg_def_ex (filter, first, last, 6096, "epsg", 6096,
        "NAD83(NSRS2007) / EPSG Arctic zone 6-14", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-165 +x_0=14500000 +y_0=6500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / EPSG Arctic zone 6-14\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4759\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",68.6874755555556],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-165],PARAMETER[\"standard_parallel_1\",70.3333333");
    add_srs_wkt (p, 10,
        "333333],PARAMETER[\"standard_parallel_2\",67],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_easting\",14500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",6500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"6096\"]]");
    p = add_epsg_def_ex (filter, first, last, 6097, "epsg", 6097,
        "NAD83(NSRS2007) / EPSG Arctic zone 6-16", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-147 +x_0=16500000 +y_0=6500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / EPSG Arctic zone 6-16\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4759\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",68.6874755555556],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-147],PARAMETER[\"standard_parallel_1\",70.3333333");
    add_srs_wkt (p, 10,
        "333333],PARAMETER[\"standard_parallel_2\",67],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_easting\",16500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",6500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"6097\"]]");
    p = add_epsg_def_ex (filter, first, last, 6098, "epsg", 6098,
        "NAD83(CSRS) / EPSG Arctic zone 1-23", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=87 +lat_2=83.66666666666667 +lat_0=85.4");
    add_proj4text (p, 1,
        "3711833333333 +lon_0=-90 +x_0=23500000 +y_0=1500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 1-23\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",85.4371183333333],PARAMETER[\"central_meridian\",-90],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_1\",87],PARAMETER[\"standar");
    add_srs_wkt (p, 10,
        "d_parallel_2\",83.6666666666667],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",23500000],PARAMETER[\"false_northing\",1500000],UNI");
    add_srs_wkt (p, 12,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "6098\"]]");
    p = add_epsg_def_ex (filter, first, last, 6099, "epsg", 6099,
        "NAD83(CSRS) / EPSG Arctic zone 2-14", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=-115 +x_0=14500000 +");
    add_proj4text (p, 2,
        "y_0=2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 2-14\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",82.0584248888889],PARAMETER[\"central_meridian\",-115],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_1\",83.6666666666667],PARA");
    add_srs_wkt (p, 10,
        "METER[\"standard_parallel_2\",80.3333333333333],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",14500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 12,
        "\",2500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"6099\"]]");
    p = add_epsg_def_ex (filter, first, last, 6100, "epsg", 6100,
        "NAD83(CSRS) / EPSG Arctic zone 2-16", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=-75 +x_0=16500000 +y");
    add_proj4text (p, 2,
        "_0=2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 2-16\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",82.0584248888889],PARAMETER[\"central_meridian\",-75],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_1\",83.6666666666667],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"standard_parallel_2\",80.3333333333333],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_easting\",16500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",2500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"6100\"]]");
    p = add_epsg_def_ex (filter, first, last, 6101, "epsg", 6101,
        "NAD83(CSRS) / EPSG Arctic zone 3-25", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=-129 +x_0=25500000 +y_0=3500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 3-25\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",78.7073375277778],PARAMETER[\"central_meridian\",-129],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_1\",80.3333333333333],PARA");
    add_srs_wkt (p, 10,
        "METER[\"standard_parallel_2\",77],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",25500000],PARAMETER[\"false_northing\",3500000],UN");
    add_srs_wkt (p, 12,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"6101\"]]");
    p = add_epsg_def_ex (filter, first, last, 6102, "epsg", 6102,
        "NAD83(CSRS) / EPSG Arctic zone 3-27", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=-99 +x_0=27500000 +y_0=3500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 3-27\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",78.7073375277778],PARAMETER[\"central_meridian\",-99],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_1\",80.3333333333333],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"standard_parallel_2\",77],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",27500000],PARAMETER[\"false_northing\",3500000],UNI");
    add_srs_wkt (p, 12,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "6102\"]]");
    p = add_epsg_def_ex (filter, first, last, 6103, "epsg", 6103,
        "NAD83(CSRS) / EPSG Arctic zone 3-29", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=-69 +x_0=29500000 +y_0=3500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 3-29\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",78.7073375277778],PARAMETER[\"central_meridian\",-69],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_1\",80.3333333333333],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"standard_parallel_2\",77],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",29500000],PARAMETER[\"false_northing\",3500000],UNI");
    add_srs_wkt (p, 12,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "6103\"]]");
    p = add_epsg_def_ex (filter, first, last, 6104, "epsg", 6104,
        "NAD83(CSRS) / EPSG Arctic zone 4-14", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=-129 +x_0=14500000 +y_0=4500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 4-14\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",75.3644033055556],PARAMETER[\"central_meridian\",-129],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_1\",77],PARAMETER[\"standa");
    add_srs_wkt (p, 10,
        "rd_parallel_2\",73.6666666666667],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",14500000],PARAMETER[\"false_northing\",4500000],UN");
    add_srs_wkt (p, 12,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"6104\"]]");
    p = add_epsg_def_ex (filter, first, last, 6105, "epsg", 6105,
        "NAD83(CSRS) / EPSG Arctic zone 4-16", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=-104 +x_0=16500000 +y_0=4500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 4-16\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",75.3644033055556],PARAMETER[\"central_meridian\",-104],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_1\",77],PARAMETER[\"standa");
    add_srs_wkt (p, 10,
        "rd_parallel_2\",73.6666666666667],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",16500000],PARAMETER[\"false_northing\",4500000],UN");
    add_srs_wkt (p, 12,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"6105\"]]");
    p = add_epsg_def_ex (filter, first, last, 6106, "epsg", 6106,
        "NAD83(CSRS) / EPSG Arctic zone 4-18", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=-79 +x_0=18500000 +y_0=4500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 4-18\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",75.3644033055556],PARAMETER[\"central_meridian\",-79],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_1\",77],PARAMETER[\"standar");
    add_srs_wkt (p, 10,
        "d_parallel_2\",73.6666666666667],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",18500000],PARAMETER[\"false_northing\",4500000],UNI");
    add_srs_wkt (p, 12,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "6106\"]]");
    p = add_epsg_def_ex (filter, first, last, 6107, "epsg", 6107,
        "NAD83(CSRS) / EPSG Arctic zone 5-33", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=-131 +x_0=33500000 +");
    add_proj4text (p, 2,
        "y_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 5-33\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",72.0250091944445],PARAMETER[\"central_meridian\",-131],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_1\",73.6666666666667],PARA");
    add_srs_wkt (p, 10,
        "METER[\"standard_parallel_2\",70.3333333333333],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",33500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 12,
        "\",5500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"6107\"]]");
    p = add_epsg_def_ex (filter, first, last, 6108, "epsg", 6108,
        "NAD83(CSRS) / EPSG Arctic zone 5-35", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=-111 +x_0=35500000 +");
    add_proj4text (p, 2,
        "y_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 5-35\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",72.0250091944445],PARAMETER[\"central_meridian\",-111],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_1\",73.6666666666667],PARA");
    add_srs_wkt (p, 10,
        "METER[\"standard_parallel_2\",70.3333333333333],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",35500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 12,
        "\",5500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"6108\"]]");
    p = add_epsg_def_ex (filter, first, last, 6109, "epsg", 6109,
        "NAD83(CSRS) / EPSG Arctic zone 5-37", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=-91 +x_0=37500000 +y");
    add_proj4text (p, 2,
        "_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 5-37\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",72.0250091944445],PARAMETER[\"central_meridian\",-91],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_1\",73.6666666666667],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"standard_parallel_2\",70.3333333333333],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_easting\",37500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",5500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"6109\"]]");
    p = add_epsg_def_ex (filter, first, last, 6110, "epsg", 6110,
        "NAD83(CSRS) / EPSG Arctic zone 5-39", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=-71 +x_0=39500000 +y");
    add_proj4text (p, 2,
        "_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 5-39\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",72.0250091944445],PARAMETER[\"central_meridian\",-71],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_1\",73.6666666666667],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"standard_parallel_2\",70.3333333333333],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_easting\",39500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",5500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"6110\"]]");
    p = add_epsg_def_ex (filter, first, last, 6111, "epsg", 6111,
        "NAD83(CSRS) / EPSG Arctic zone 6-18", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-132 +x_0=18500000 +y_0=6500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 6-18\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",68.6874755555556],PARAMETER[\"central_meridian\",-132],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_1\",70.3333333333333],PARA");
    add_srs_wkt (p, 10,
        "METER[\"standard_parallel_2\",67],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",18500000],PARAMETER[\"false_northing\",6500000],UN");
    add_srs_wkt (p, 12,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"6111\"]]");
    p = add_epsg_def_ex (filter, first, last, 6112, "epsg", 6112,
        "NAD83(CSRS) / EPSG Arctic zone 6-20", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-113 +x_0=20500000 +y_0=6500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 6-20\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",68.6874755555556],PARAMETER[\"central_meridian\",-113],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_1\",70.3333333333333],PARA");
    add_srs_wkt (p, 10,
        "METER[\"standard_parallel_2\",67],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",20500000],PARAMETER[\"false_northing\",6500000],UN");
    add_srs_wkt (p, 12,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"6112\"]]");
    p = add_epsg_def_ex (filter, first, last, 6113, "epsg", 6113,
        "NAD83(CSRS) / EPSG Arctic zone 6-22", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-94 +x_0=22500000 +y_0=6500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 6-22\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",68.6874755555556],PARAMETER[\"central_meridian\",-94],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_1\",70.3333333333333],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"standard_parallel_2\",67],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",22500000],PARAMETER[\"false_northing\",6500000],UNI");
    add_srs_wkt (p, 12,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "6113\"]]");
    p = add_epsg_def_ex (filter, first, last, 6114, "epsg", 6114,
        "NAD83(CSRS) / EPSG Arctic zone 6-24", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-75 +x_0=24500000 +y_0=6500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / EPSG Arctic zone 6-24\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",68.6874755555556],PARAMETER[\"central_meridian\",-75],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_1\",70.3333333333333],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"standard_parallel_2\",67],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",24500000],PARAMETER[\"false_northing\",6500000],UNI");
    add_srs_wkt (p, 12,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "6114\"]]");
    p = add_epsg_def_ex (filter, first, last, 6115, "epsg", 6115,
        "WGS 84 / EPSG Arctic zone 1-27", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=87 +lat_2=83.66666666666667 +lat_0=85.4");
    add_proj4text (p, 1,
        "3711833333333 +lon_0=30 +x_0=27500000 +y_0=1500000 +datu");
    add_proj4text (p, 2,
        "m=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 1-27\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",85.4371183333333],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",30],PARAMETER[\"standard_parallel_1\",87],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"standard_parallel_2\",83.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",27500000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 11,
        "500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"6115\"]]");
    p = add_epsg_def_ex (filter, first, last, 6116, "epsg", 6116,
        "WGS 84 / EPSG Arctic zone 1-29", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=87 +lat_2=83.66666666666667 +lat_0=85.4");
    add_proj4text (p, 1,
        "3711833333333 +lon_0=90 +x_0=29500000 +y_0=1500000 +datu");
    add_proj4text (p, 2,
        "m=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 1-29\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",85.4371183333333],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",90],PARAMETER[\"standard_parallel_1\",87],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"standard_parallel_2\",83.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",29500000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 11,
        "500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"6116\"]]");
    p = add_epsg_def_ex (filter, first, last, 6117, "epsg", 6117,
        "WGS 84 / EPSG Arctic zone 1-31", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=87 +lat_2=83.66666666666667 +lat_0=85.4");
    add_proj4text (p, 1,
        "3711833333333 +lon_0=150 +x_0=31500000 +y_0=1500000 +dat");
    add_proj4text (p, 2,
        "um=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 1-31\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",85.4371183333333],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",150],PARAMETER[\"standard_parallel_1\",87],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_2\",83.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",31500000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 11,
        "500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"6117\"]]");
    p = add_epsg_def_ex (filter, first, last, 6118, "epsg", 6118,
        "WGS 84 / EPSG Arctic zone 1-21", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=87 +lat_2=83.66666666666667 +lat_0=85.4");
    add_proj4text (p, 1,
        "3711833333333 +lon_0=-150 +x_0=21500000 +y_0=1500000 +da");
    add_proj4text (p, 2,
        "tum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 1-21\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",85.4371183333333],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",-150],PARAMETER[\"standard_parallel_1\",87],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_2\",83.6666666666667],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",21500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",1500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"6118\"]]");
    p = add_epsg_def_ex (filter, first, last, 6119, "epsg", 6119,
        "WGS 84 / EPSG Arctic zone 2-28", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=133 +x_0=28500000 +y");
    add_proj4text (p, 2,
        "_0=2500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 2-28\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",82.0584248888889],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",133],PARAMETER[\"standard_parallel_1\",83.66666666");
    add_srs_wkt (p, 9,
        "66667],PARAMETER[\"standard_parallel_2\",80.333333333333");
    add_srs_wkt (p, 10,
        "3],PARAMETER[\"false_easting\",28500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",2500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"6119\"]]");
    p = add_epsg_def_ex (filter, first, last, 6120, "epsg", 6120,
        "WGS 84 / EPSG Arctic zone 2-10", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=166 +x_0=10500000 +y");
    add_proj4text (p, 2,
        "_0=2500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 2-10\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",82.0584248888889],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",166],PARAMETER[\"standard_parallel_1\",83.66666666");
    add_srs_wkt (p, 9,
        "66667],PARAMETER[\"standard_parallel_2\",80.333333333333");
    add_srs_wkt (p, 10,
        "3],PARAMETER[\"false_easting\",10500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",2500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"6120\"]]");
    p = add_epsg_def_ex (filter, first, last, 6121, "epsg", 6121,
        "WGS 84 / EPSG Arctic zone 2-12", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=-154 +x_0=12500000 +");
    add_proj4text (p, 2,
        "y_0=2500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 2-12\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",82.0584248888889],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",-154],PARAMETER[\"standard_parallel_1\",83.6666666");
    add_srs_wkt (p, 9,
        "666667],PARAMETER[\"standard_parallel_2\",80.33333333333");
    add_srs_wkt (p, 10,
        "33],PARAMETER[\"false_easting\",12500000],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",2500000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"6121\"]]");
    p = add_epsg_def_ex (filter, first, last, 6122, "epsg", 6122,
        "WGS 84 / EPSG Arctic zone 3-21", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=176 +x_0=21500000 +y_0=3500000 +dat");
    add_proj4text (p, 2,
        "um=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 3-21\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",78.7073375277778],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",176],PARAMETER[\"standard_parallel_1\",80.33333333");
    add_srs_wkt (p, 9,
        "33333],PARAMETER[\"standard_parallel_2\",77],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",21500000],PARAMETER[\"false_northing\",3");
    add_srs_wkt (p, 11,
        "500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"6122\"]]");
    p = add_epsg_def_ex (filter, first, last, 6123, "epsg", 6123,
        "WGS 84 / EPSG Arctic zone 3-23", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=-153 +x_0=23500000 +y_0=3500000 +da");
    add_proj4text (p, 2,
        "tum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 3-23\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",78.7073375277778],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",-153],PARAMETER[\"standard_parallel_1\",80.3333333");
    add_srs_wkt (p, 9,
        "333333],PARAMETER[\"standard_parallel_2\",77],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",23500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",3500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"6123\"]]");
    p = add_epsg_def_ex (filter, first, last, 6124, "epsg", 6124,
        "WGS 84 / EPSG Arctic zone 4-12", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=-155 +x_0=12500000 +y_0=4500000 +da");
    add_proj4text (p, 2,
        "tum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic zone 4-12\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",75.3644033055556],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",-155],PARAMETER[\"standard_parallel_1\",77],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_2\",73.6666666666667],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",12500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",4500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"6124\"]]");
    p = add_epsg_def_ex (filter, first, last, 6125, "epsg", 6125,
        "ETRS89 / EPSG Arctic zone 5-47", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=-5 +x_0=47500000 +y_");
    add_proj4text (p, 2,
        "0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / EPSG Arctic zone 5-47\",GEOGCS[\"ETRS8");
    add_srs_wkt (p, 1,
        "9\",DATUM[\"European_Terrestrial_Reference_System_1989\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",72.02500");
    add_srs_wkt (p, 8,
        "91944445],PARAMETER[\"central_meridian\",-5],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_1\",73.6666666666667],PARAMETER[\"stan");
    add_srs_wkt (p, 10,
        "dard_parallel_2\",70.3333333333333],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",47500000],PARAMETER[\"false_northing\",5500000],");
    add_srs_wkt (p, 12,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 13,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"6125\"]]");
    p = add_epsg_def_ex (filter, first, last, 6128, "epsg", 6128,
        "Grand Cayman National Grid 1959", 0, 0,
        "Clarke 1866", "Greenwich",
        "Grand_Cayman_Geodetic_Datum_1959", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=clrk66 +towgs84=-179.483,-69.3");
    add_proj4text (p, 1,
        "79,-27.584,-7.862,8.163,6.042,-13.925 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Grand Cayman National Grid 1959\",GEOGCS[\"GCGD");
    add_srs_wkt (p, 1,
        "59\",DATUM[\"Grand_Cayman_Geodetic_Datum_1959\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"Clarke 1866\",6378206.4,294.978698213898,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6723\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4723\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-81],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",1640419.9475],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"6128\"]]");
    p = add_epsg_def_ex (filter, first, last, 6129, "epsg", 6129,
        "Sister Islands National Grid 1961", 0, 0,
        "Clarke 1866", "Greenwich",
        "Sister_Islands_Geodetic_Datum_1961", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=clrk66 +towgs84=8.853,-52.644,");
    add_proj4text (p, 1,
        "180.304,-0.393,-2.323,2.96,-24.081 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Sister Islands National Grid 1961\",GEOGCS[\"SI");
    add_srs_wkt (p, 1,
        "GD61\",DATUM[\"Sister_Islands_Geodetic_Datum_1961\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"Clarke 1866\",6378206.4,294.978698213898,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6726\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4726\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",-81],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",1640419.9475],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 12,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"6129\"]]");
    p = add_epsg_def_ex (filter, first, last, 6134, "epsg", 6134,
        "CIGD11", 1, 1,
        "GRS 1980", "Greenwich",
        "Cayman_Islands_Geodetic_Datum_2011", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"CIGD11\",DATUM[\"Cayman Islands Geodetic Datum");
    add_srs_wkt (p, 1,
        " 2011\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LEN");
    add_srs_wkt (p, 2,
        "GTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[");
    add_srs_wkt (p, 3,
        "\"degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"");
    add_srs_wkt (p, 4,
        "geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433]],AXIS[\"geodetic longitude (Lo");
    add_srs_wkt (p, 6,
        "n)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 7,
        "33]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHU");
    add_srs_wkt (p, 8,
        "NIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Cayman");
    add_srs_wkt (p, 9,
        " Islands\"],BBOX[17.58,-83.6,20.68,-78.72]],ID[\"EPSG\",");
    add_srs_wkt (p, 10,
        "6134]]");
    p = add_epsg_def_ex (filter, first, last, 6135, "epsg", 6135,
        "CIGD11", 1, 1,
        "GRS 1980", "Greenwich",
        "Cayman_Islands_Geodetic_Datum_2011", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"CIGD11\",DATUM[\"Cayman_Islands_Geodetic_Datum_");
    add_srs_wkt (p, 1,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1100\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"6135\"]]");
    p = add_epsg_def_ex (filter, first, last, 6141, "epsg", 6141,
        "Cayman Islands National Grid 2011", 0, 0,
        "GRS 1980", "Greenwich",
        "Cayman_Islands_Geodetic_Datum_2011", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=19.33333333333333 +lat_2=19.7 +lat_0=19");
    add_proj4text (p, 1,
        ".33333333333333 +lon_0=80.56666666666666 +x_0=899160 +y_");
    add_proj4text (p, 2,
        "0=579120 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cayman Islands National Grid 2011\",GEOGCS[\"CI");
    add_srs_wkt (p, 1,
        "GD11\",DATUM[\"Cayman_Islands_Geodetic_Datum_2011\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"1100\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"6135\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 7,
        "onic_2SP\"],PARAMETER[\"latitude_of_origin\",19.33333333");
    add_srs_wkt (p, 8,
        "33333],PARAMETER[\"central_meridian\",-80.5666666666667]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_1\",19.3333333333333],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"standard_parallel_2\",19.7],PARAMETER[\"false_e");
    add_srs_wkt (p, 11,
        "asting\",2950000],PARAMETER[\"false_northing\",1900000],");
    add_srs_wkt (p, 12,
        "UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"6391\"]]");
    p = add_epsg_def_ex (filter, first, last, 6144, "epsg", 6144,
        "ETRS89", 1, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + NN54 height\",GEOGCS[\"ETRS89\",DATU");
    add_srs_wkt (p, 1,
        "M[\"European_Terrestrial_Reference_System_1989\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 6,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4258\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norw");
    add_srs_wkt (p, 8,
        "ay Normal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]]");
    add_srs_wkt (p, 9,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"G");
    add_srs_wkt (p, 10,
        "ravity-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]");
    add_srs_wkt (p, 11,
        "],AUTHORITY[\"EPSG\",\"6144\"]]");
    p = add_epsg_def_ex (filter, first, last, 6145, "epsg", 6145,
        "ETRS89 / NTM zone 5", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=5.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vun");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 5 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 5\",GEOGCS[\"ETRS89\",DATUM[\"European");
    add_srs_wkt (p, 2,
        "_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 3,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",58],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "5.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",100000],PARAMETER[\"false_northing\",1000000],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "5105\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway Nor");
    add_srs_wkt (p, 14,
        "mal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNIT[");
    add_srs_wkt (p, 15,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity");
    add_srs_wkt (p, 16,
        "-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTH");
    add_srs_wkt (p, 17,
        "ORITY[\"EPSG\",\"6145\"]]");
    p = add_epsg_def_ex (filter, first, last, 6146, "epsg", 6146,
        "ETRS89 / NTM zone 6", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=6.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vun");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 6 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 6\",GEOGCS[\"ETRS89\",DATUM[\"European");
    add_srs_wkt (p, 2,
        "_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 3,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",58],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "6.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",100000],PARAMETER[\"false_northing\",1000000],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "5106\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway Nor");
    add_srs_wkt (p, 14,
        "mal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNIT[");
    add_srs_wkt (p, 15,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity");
    add_srs_wkt (p, 16,
        "-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTH");
    add_srs_wkt (p, 17,
        "ORITY[\"EPSG\",\"6146\"]]");
    p = add_epsg_def_ex (filter, first, last, 6147, "epsg", 6147,
        "ETRS89 / NTM zone 7", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=7.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vun");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 7 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 7\",GEOGCS[\"ETRS89\",DATUM[\"European");
    add_srs_wkt (p, 2,
        "_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 3,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",58],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "7.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",100000],PARAMETER[\"false_northing\",1000000],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "5107\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway Nor");
    add_srs_wkt (p, 14,
        "mal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNIT[");
    add_srs_wkt (p, 15,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity");
    add_srs_wkt (p, 16,
        "-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTH");
    add_srs_wkt (p, 17,
        "ORITY[\"EPSG\",\"6147\"]]");
    p = add_epsg_def_ex (filter, first, last, 6148, "epsg", 6148,
        "ETRS89 / NTM zone 8", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=8.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vun");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 8 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 8\",GEOGCS[\"ETRS89\",DATUM[\"European");
    add_srs_wkt (p, 2,
        "_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 3,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",58],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "8.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",100000],PARAMETER[\"false_northing\",1000000],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "5108\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway Nor");
    add_srs_wkt (p, 14,
        "mal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNIT[");
    add_srs_wkt (p, 15,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity");
    add_srs_wkt (p, 16,
        "-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTH");
    add_srs_wkt (p, 17,
        "ORITY[\"EPSG\",\"6148\"]]");
    p = add_epsg_def_ex (filter, first, last, 6149, "epsg", 6149,
        "ETRS89 / NTM zone 9", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=9.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vun");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 9 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 9\",GEOGCS[\"ETRS89\",DATUM[\"European");
    add_srs_wkt (p, 2,
        "_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 3,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",58],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "9.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",100000],PARAMETER[\"false_northing\",1000000],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "5109\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway Nor");
    add_srs_wkt (p, 14,
        "mal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNIT[");
    add_srs_wkt (p, 15,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity");
    add_srs_wkt (p, 16,
        "-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUTH");
    add_srs_wkt (p, 17,
        "ORITY[\"EPSG\",\"6149\"]]");
    p = add_epsg_def_ex (filter, first, last, 6150, "epsg", 6150,
        "ETRS89 / NTM zone 10", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=10.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 10 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 10\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",58],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "10.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",100000],PARAMETER[\"false_northing\",1000000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"5110\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway N");
    add_srs_wkt (p, 14,
        "ormal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNI");
    add_srs_wkt (p, 15,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 16,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"6150\"]]");
    p = add_epsg_def_ex (filter, first, last, 6151, "epsg", 6151,
        "ETRS89 / NTM zone 11", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=11.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 11 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 11\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",58],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "11.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",100000],PARAMETER[\"false_northing\",1000000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"5111\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway N");
    add_srs_wkt (p, 14,
        "ormal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNI");
    add_srs_wkt (p, 15,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 16,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"6151\"]]");
    p = add_epsg_def_ex (filter, first, last, 6152, "epsg", 6152,
        "ETRS89 / NTM zone 12", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=12.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 12 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 12\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",58],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "12.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",100000],PARAMETER[\"false_northing\",1000000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"5112\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway N");
    add_srs_wkt (p, 14,
        "ormal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNI");
    add_srs_wkt (p, 15,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 16,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"6152\"]]");
    p = add_epsg_def_ex (filter, first, last, 6153, "epsg", 6153,
        "ETRS89 / NTM zone 13", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=13.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 13 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 13\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",58],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "13.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",100000],PARAMETER[\"false_northing\",1000000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"5113\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway N");
    add_srs_wkt (p, 14,
        "ormal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNI");
    add_srs_wkt (p, 15,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 16,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"6153\"]]");
    p = add_epsg_def_ex (filter, first, last, 6154, "epsg", 6154,
        "ETRS89 / NTM zone 14", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=14.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 14 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 14\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",58],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "14.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",100000],PARAMETER[\"false_northing\",1000000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"5114\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway N");
    add_srs_wkt (p, 14,
        "ormal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNI");
    add_srs_wkt (p, 15,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 16,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"6154\"]]");
    p = add_epsg_def_ex (filter, first, last, 6155, "epsg", 6155,
        "ETRS89 / NTM zone 15", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=15.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 15 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 15\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",58],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "15.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",100000],PARAMETER[\"false_northing\",1000000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"5115\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway N");
    add_srs_wkt (p, 14,
        "ormal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNI");
    add_srs_wkt (p, 15,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 16,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"6155\"]]");
    p = add_epsg_def_ex (filter, first, last, 6156, "epsg", 6156,
        "ETRS89 / NTM zone 16", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=16.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 16 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 16\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",58],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "16.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",100000],PARAMETER[\"false_northing\",1000000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"5116\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway N");
    add_srs_wkt (p, 14,
        "ormal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNI");
    add_srs_wkt (p, 15,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 16,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"6156\"]]");
    p = add_epsg_def_ex (filter, first, last, 6157, "epsg", 6157,
        "ETRS89 / NTM zone 17", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=17.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 17 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 17\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",58],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "17.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",100000],PARAMETER[\"false_northing\",1000000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"5117\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway N");
    add_srs_wkt (p, 14,
        "ormal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNI");
    add_srs_wkt (p, 15,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 16,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"6157\"]]");
    p = add_epsg_def_ex (filter, first, last, 6158, "epsg", 6158,
        "ETRS89 / NTM zone 18", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=18.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 18 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 18\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",58],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "18.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",100000],PARAMETER[\"false_northing\",1000000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"5118\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway N");
    add_srs_wkt (p, 14,
        "ormal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNI");
    add_srs_wkt (p, 15,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 16,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"6158\"]]");
    p = add_epsg_def_ex (filter, first, last, 6159, "epsg", 6159,
        "ETRS89 / NTM zone 19", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=19.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 19 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 19\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",58],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "19.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",100000],PARAMETER[\"false_northing\",1000000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"5119\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway N");
    add_srs_wkt (p, 14,
        "ormal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNI");
    add_srs_wkt (p, 15,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 16,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"6159\"]]");
    p = add_epsg_def_ex (filter, first, last, 6160, "epsg", 6160,
        "ETRS89 / NTM zone 20", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=20.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 20 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 20\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",58],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "20.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",100000],PARAMETER[\"false_northing\",1000000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"5120\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway N");
    add_srs_wkt (p, 14,
        "ormal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNI");
    add_srs_wkt (p, 15,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 16,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"6160\"]]");
    p = add_epsg_def_ex (filter, first, last, 6161, "epsg", 6161,
        "ETRS89 / NTM zone 21", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=21.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 21 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 21\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",58],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "21.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",100000],PARAMETER[\"false_northing\",1000000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"5121\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway N");
    add_srs_wkt (p, 14,
        "ormal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNI");
    add_srs_wkt (p, 15,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 16,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"6161\"]]");
    p = add_epsg_def_ex (filter, first, last, 6162, "epsg", 6162,
        "ETRS89 / NTM zone 22", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=22.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 22 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 22\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",58],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "22.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",100000],PARAMETER[\"false_northing\",1000000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"5122\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway N");
    add_srs_wkt (p, 14,
        "ormal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNI");
    add_srs_wkt (p, 15,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 16,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"6162\"]]");
    p = add_epsg_def_ex (filter, first, last, 6163, "epsg", 6163,
        "ETRS89 / NTM zone 23", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=23.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 23 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 23\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",58],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "23.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",100000],PARAMETER[\"false_northing\",1000000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"5123\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway N");
    add_srs_wkt (p, 14,
        "ormal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNI");
    add_srs_wkt (p, 15,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 16,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"6163\"]]");
    p = add_epsg_def_ex (filter, first, last, 6164, "epsg", 6164,
        "ETRS89 / NTM zone 24", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=24.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 24 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 24\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",58],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "24.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",100000],PARAMETER[\"false_northing\",1000000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"5124\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway N");
    add_srs_wkt (p, 14,
        "ormal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNI");
    add_srs_wkt (p, 15,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 16,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"6164\"]]");
    p = add_epsg_def_ex (filter, first, last, 6165, "epsg", 6165,
        "ETRS89 / NTM zone 25", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=25.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 25 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 25\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",58],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "25.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",100000],PARAMETER[\"false_northing\",1000000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"5125\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway N");
    add_srs_wkt (p, 14,
        "ormal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNI");
    add_srs_wkt (p, 15,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 16,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"6165\"]]");
    p = add_epsg_def_ex (filter, first, last, 6166, "epsg", 6166,
        "ETRS89 / NTM zone 26", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=26.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 26 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 26\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",58],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "26.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",100000],PARAMETER[\"false_northing\",1000000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"5126\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway N");
    add_srs_wkt (p, 14,
        "ormal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNI");
    add_srs_wkt (p, 15,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 16,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"6166\"]]");
    p = add_epsg_def_ex (filter, first, last, 6167, "epsg", 6167,
        "ETRS89 / NTM zone 27", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=27.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 27 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 27\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",58],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "27.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",100000],PARAMETER[\"false_northing\",1000000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"5127\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway N");
    add_srs_wkt (p, 14,
        "ormal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNI");
    add_srs_wkt (p, 15,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 16,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"6167\"]]");
    p = add_epsg_def_ex (filter, first, last, 6168, "epsg", 6168,
        "ETRS89 / NTM zone 28", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=28.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 28 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 28\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",58],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "28.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",100000],PARAMETER[\"false_northing\",1000000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"5128\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway N");
    add_srs_wkt (p, 14,
        "ormal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNI");
    add_srs_wkt (p, 15,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 16,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"6168\"]]");
    p = add_epsg_def_ex (filter, first, last, 6169, "epsg", 6169,
        "ETRS89 / NTM zone 29", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=29.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 29 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 29\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",58],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "29.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",100000],PARAMETER[\"false_northing\",1000000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"5129\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway N");
    add_srs_wkt (p, 14,
        "ormal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNI");
    add_srs_wkt (p, 15,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 16,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"6169\"]]");
    p = add_epsg_def_ex (filter, first, last, 6170, "epsg", 6170,
        "ETRS89 / NTM zone 30", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=30.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 30 + NN54 height\",PROJCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89 / NTM zone 30\",GEOGCS[\"ETRS89\",DATUM[\"Europea");
    add_srs_wkt (p, 2,
        "n_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",58],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "30.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",100000],PARAMETER[\"false_northing\",1000000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"5130\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway N");
    add_srs_wkt (p, 14,
        "ormal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNI");
    add_srs_wkt (p, 15,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 16,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"6170\"]]");
    p = add_epsg_def_ex (filter, first, last, 6171, "epsg", 6171,
        "ETRS89 / UTM zone 31N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 31N + NN54 height\",PROJCS[");
    add_srs_wkt (p, 1,
        "\"ETRS89 / UTM zone 31N\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "25831\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway No");
    add_srs_wkt (p, 14,
        "rmal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNIT");
    add_srs_wkt (p, 15,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravit");
    add_srs_wkt (p, 16,
        "y-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUT");
    add_srs_wkt (p, 17,
        "HORITY[\"EPSG\",\"6171\"]]");
    p = add_epsg_def_ex (filter, first, last, 6172, "epsg", 6172,
        "ETRS89 / UTM zone 32N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 32N + NN54 height\",PROJCS[");
    add_srs_wkt (p, 1,
        "\"ETRS89 / UTM zone 32N\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "25832\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway No");
    add_srs_wkt (p, 14,
        "rmal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UNIT");
    add_srs_wkt (p, 15,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravit");
    add_srs_wkt (p, 16,
        "y-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],AUT");
    add_srs_wkt (p, 17,
        "HORITY[\"EPSG\",\"6172\"]]");
    p = add_epsg_def_ex (filter, first, last, 6173, "epsg", 6173,
        "ETRS89 / UTM zone 33N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 33N + NN54 height\",PROJCS[");
    add_srs_wkt (p, 1,
        "\"ETRS89 / UTM zone 33N\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",15],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"25833\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway ");
    add_srs_wkt (p, 14,
        "Normal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UN");
    add_srs_wkt (p, 15,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Grav");
    add_srs_wkt (p, 16,
        "ity-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],A");
    add_srs_wkt (p, 17,
        "UTHORITY[\"EPSG\",\"6173\"]]");
    p = add_epsg_def_ex (filter, first, last, 6174, "epsg", 6174,
        "ETRS89 / UTM zone 34N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 34N + NN54 height\",PROJCS[");
    add_srs_wkt (p, 1,
        "\"ETRS89 / UTM zone 34N\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",21],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"25834\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway ");
    add_srs_wkt (p, 14,
        "Normal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UN");
    add_srs_wkt (p, 15,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Grav");
    add_srs_wkt (p, 16,
        "ity-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],A");
    add_srs_wkt (p, 17,
        "UTHORITY[\"EPSG\",\"6174\"]]");
    p = add_epsg_def_ex (filter, first, last, 6175, "epsg", 6175,
        "ETRS89 / UTM zone 35N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 35N + NN54 height\",PROJCS[");
    add_srs_wkt (p, 1,
        "\"ETRS89 / UTM zone 35N\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",27],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"25835\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway ");
    add_srs_wkt (p, 14,
        "Normal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UN");
    add_srs_wkt (p, 15,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Grav");
    add_srs_wkt (p, 16,
        "ity-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],A");
    add_srs_wkt (p, 17,
        "UTHORITY[\"EPSG\",\"6175\"]]");
    p = add_epsg_def_ex (filter, first, last, 6176, "epsg", 6176,
        "ETRS89 / UTM zone 36N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 36N + NN54 height\",PROJCS[");
    add_srs_wkt (p, 1,
        "\"ETRS89 / UTM zone 36N\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",33],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"25836\"]],VERT_CS[\"NN54 height\",VERT_DATUM[\"Norway ");
    add_srs_wkt (p, 14,
        "Normal Null 1954\",2005,AUTHORITY[\"EPSG\",\"5174\"]],UN");
    add_srs_wkt (p, 15,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Grav");
    add_srs_wkt (p, 16,
        "ity-related height\",UP],AUTHORITY[\"EPSG\",\"5776\"]],A");
    add_srs_wkt (p, 17,
        "UTHORITY[\"EPSG\",\"6176\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

