#include <stdio.h>
#include <gtk/gtk.h>

#include "specimen.h"
#include "patch.h"
#include "gui.h"

/* main window */
static GtkWidget *window;

/* direction controls */
static GtkWidget *forward_radio;
static GtkWidget *reverse_radio;

/* duration controls */
static GtkWidget *single_radio;
static GtkWidget *trim_radio;
static GtkWidget *loop_radio;
static GtkWidget *ping_radio;

static void cb_close()
{
     gtk_widget_hide(window);
}

static void cb_set()
{
     play_mode_t mode;
     int cp;

     if ((cp = get_current_patch()) < 0)
	  return;

     mode = 0;

     /* set direction */
     if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(reverse_radio))) {
	  mode |= PM_REVERSE;
     } else {
	  mode |= PM_FORWARD;
     }

     /* set duration */
     if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ping_radio))) {
	  mode |= PM_LOOP;
	  mode |= PM_PINGPONG;

     } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(loop_radio))) {
	  mode |= PM_LOOP;

     } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(trim_radio))) {
	  mode |= PM_TRIM;

     } else {
	  mode |= PM_SINGLESHOT;
     }

     if (patch_play_mode_set(cp, mode) < 0)
	  errmsg("Failed to set patch %d play mode\n", cp);

     return;
}

void playmode_settings_show()
{
     play_mode_t mode;
     int cp;

     if ((cp = get_current_patch()) < 0)
	  return;

     mode = patch_play_mode_get(cp);

     /* we assume the parameters we get are sane, because it won't
	really matter when all is said and done if they aren't */
     if (mode & PM_FORWARD)
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(forward_radio), TRUE);

     if (mode & PM_REVERSE)
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(reverse_radio), TRUE);

     if (mode & PM_SINGLESHOT)
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(single_radio), TRUE);

     if (mode & PM_TRIM)
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(trim_radio), TRUE);

     if (mode & PM_LOOP) {
	  if (mode & PM_PINGPONG) {
	       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ping_radio), TRUE);
	  } else {
	       gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(loop_radio), TRUE);
	  }
     }
	  
     gtk_widget_show(window);
}

void playmode_settings_init(GtkWidget *parent)
{
     GtkWidget *vbox, *hbox;
     GtkWidget *button;
     GtkWidget *label;
     GtkWidget *sep;

     /* main window */
     window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
     gtk_window_set_title(GTK_WINDOW(window), "Play Mode");
     gtk_window_set_resizable(GTK_WINDOW(window), FALSE);
     gtk_window_set_transient_for(GTK_WINDOW(window), GTK_WINDOW(parent));
     gtk_window_set_modal(GTK_WINDOW(window), TRUE);
     g_signal_connect(GTK_WINDOW(window), "delete-event", G_CALLBACK(cb_close), NULL);

     /* vbox */
     vbox = gtk_vbox_new(FALSE, SPACING);
     gtk_container_add(GTK_CONTAINER(window), vbox);
     gtk_container_set_border_width(GTK_CONTAINER(window), SPACING);
     gtk_widget_show(vbox);

     /* hbox */
     hbox = gtk_hbox_new(FALSE, SPACING);
     gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
     gtk_widget_show(hbox);

     /*************/
     /* direction */
     /*************/
     label = gtk_label_new("Direction:");
     gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
     gtk_widget_show(label);

     /* forward */
     forward_radio = gtk_radio_button_new_with_label(NULL, "Forward");
     g_signal_connect(G_OBJECT(forward_radio), "toggled", G_CALLBACK(cb_set), NULL);
     gtk_box_pack_start(GTK_BOX(hbox), forward_radio, FALSE, FALSE, 0);
     gtk_widget_show(forward_radio);

     /* reverse */
     reverse_radio = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(forward_radio), "Reverse");
     g_signal_connect(G_OBJECT(reverse_radio), "toggled", G_CALLBACK(cb_set), NULL);
     gtk_box_pack_start(GTK_BOX(hbox), reverse_radio, FALSE, FALSE, 0);
     gtk_widget_show(reverse_radio);

     /* hbox */
     hbox = gtk_hbox_new(FALSE, SPACING);
     gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
     gtk_widget_show(hbox);

     /************/
     /* duration */
     /************/
     label = gtk_label_new("Duration:");
     gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
     gtk_widget_show(label);

     /* single shot */
     single_radio = gtk_radio_button_new_with_label(NULL, "Single Shot");
     gtk_box_pack_start(GTK_BOX(hbox), single_radio, FALSE, FALSE, 0);
     g_signal_connect(G_OBJECT(single_radio), "toggled", G_CALLBACK(cb_set), NULL);
     gtk_widget_show(single_radio);

     /* trim */
     trim_radio = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(single_radio), "Trim");
     gtk_box_pack_start(GTK_BOX(hbox), trim_radio, FALSE, FALSE, 0);
     g_signal_connect(G_OBJECT(trim_radio), "toggled", G_CALLBACK(cb_set), NULL);
     gtk_widget_show(trim_radio);

     /* loop */
     loop_radio = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(single_radio), "Loop");
     gtk_box_pack_start(GTK_BOX(hbox), loop_radio, FALSE, FALSE, 0);
     g_signal_connect(G_OBJECT(loop_radio), "toggled", G_CALLBACK(cb_set), NULL);
     gtk_widget_show(loop_radio);

     /* ping pong */
     ping_radio = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(single_radio), "Ping Pong");
     gtk_box_pack_start(GTK_BOX(hbox), ping_radio, FALSE, FALSE, 0);
     g_signal_connect(G_OBJECT(ping_radio), "toggled", G_CALLBACK(cb_set), NULL);
     gtk_widget_show(ping_radio);

     /**************/
     sep = gtk_hseparator_new();
     gtk_box_pack_start(GTK_BOX(vbox), sep, FALSE, FALSE, 0);
     gtk_widget_show(sep);
     
     /* hbox */
     hbox = gtk_hbox_new(FALSE, SPACING);
     gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
     gtk_widget_show(hbox);

     /* close button */
     button = gtk_button_new_from_stock(GTK_STOCK_CLOSE);
     g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(cb_close), NULL);
     gtk_box_pack_end(GTK_BOX(hbox), button, FALSE, FALSE, 0);
     gtk_widget_show(button);
}

