/* predominantly ripped from the alsa programming tutorial */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <alsa/asoundlib.h>

#include "specimen.h"
#include "patch.h"

static snd_seq_t *open_seq() 
{
     snd_seq_t *seq_handle;
     int portid;

     if (snd_seq_open(&seq_handle, "default", SND_SEQ_OPEN_INPUT, 0) < 0) {
	  fprintf(stderr, "Error opening ALSA sequencer.\n");
	  exit(FUBAR);
     }
     snd_seq_set_client_name(seq_handle, "Specimen Sampler");
     if ((portid = snd_seq_create_simple_port(seq_handle, "Specimen Sampler",
					      SND_SEQ_PORT_CAP_WRITE|SND_SEQ_PORT_CAP_SUBS_WRITE,
					      SND_SEQ_PORT_TYPE_APPLICATION)) < 0) {
	  fprintf(stderr, "Error creating sequencer port.\n");
	  exit(FUBAR);
     }
     return(seq_handle);
}

static void midi_action(snd_seq_t *seq_handle) 
{
     snd_seq_event_t *ev;

     do {
	  snd_seq_event_input(seq_handle, &ev);
	  switch (ev->type) {
	  case SND_SEQ_EVENT_CONTROLLER: 
	       fprintf(stderr, "Control event on Channel %2d: %5d       \r",
		       ev->data.control.channel, ev->data.control.value);
	       break;
	  case SND_SEQ_EVENT_PITCHBEND:
	       fprintf(stderr, "Pitchbender event on Channel %2d: %5d   \r", 
		       ev->data.control.channel, ev->data.control.value);
	       break;
	  case SND_SEQ_EVENT_NOTEON:
	       patch_activate(ev->data.control.channel, ev->data.note.note, ev->data.note.velocity);
	       break;        
	  case SND_SEQ_EVENT_NOTEOFF: 
	       patch_deactivate(ev->data.control.channel, ev->data.note.note);
	       break;        
	  }
	  snd_seq_free_event(ev);
     } while (snd_seq_event_input_pending(seq_handle, 0) > 0);
}

void init_midi(thread_data_t *thread_data) 
{
     snd_seq_t *seq_handle;
     int npfd;
     struct pollfd *pfd;

     debug("Initializing MIDI\n");

     seq_handle = open_seq();
     npfd = snd_seq_poll_descriptors_count(seq_handle, POLLIN);
     pfd = (struct pollfd *)alloca(npfd * sizeof(struct pollfd));
     snd_seq_poll_descriptors(seq_handle, pfd, npfd, POLLIN);

     while (1) {
	  if (poll(pfd, npfd, 100) > 0) {
	       midi_action(seq_handle);
	  }
	  pthread_mutex_lock(thread_data->mutex);
	  if (thread_data->quit) {
	       pthread_mutex_unlock(thread_data->mutex);
	       debug("Shutting down MIDI thread\n");
	       return;
	  }
	  pthread_mutex_unlock(thread_data->mutex);
     }
}
