#include <pthread.h>
#include <gtk/gtk.h>
#include "specimen.h"
#include "gui/gui.h"
#include "midi.h"
#include "driver.h"
#include "lfo.h"
#include "patch.h"
#include "mixer.h"

int main (int argc, char *argv[])
{
     gtk_init (&argc, &argv);

     /* constructors */
     driver_init ( );
     lfo_init    ( );
     gui_init    ( );
     patch_init  ( );
     mixer_init  ( );

     /* start */
     midi_start   ( );
     driver_start (0);

     gtk_main ( );

     /* stop */
     midi_stop   ( );
     driver_stop ( );

     /* destructors */
     patch_shutdown ( );
     mixer_shutdown ( );

     debug ("Goodbye.\n");
     return 0;
}
