/*
 * This file is part of Splashy.
 * 
 * Splashy is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation;
 * either version 2 of the License, or (at your option) any
 * later version.
 * 
 * Splashy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty 
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with Splashy; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA 02110-1301 USA 
 */
#ifndef _XML_FORMAT_H
#define _XML_FORMAT_H

#define CONFIG_XML_FORMAT "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\
<!-- Automatically generated by splashy_config. Do not edit -->\n\
<splashy>\n\
    <!-- themes directory: conventional path //etc/splashy/themes -->\n\
    <themes>%s</themes>\n\
    <!-- current theme could be relative the themes defined above or full path -->\n\
    <current_theme>%s</current_theme>\n\
    <!-- full path to theme to fall back in case of problems. DO NOT CHANGE -->\n\
    <default_theme>//etc/splashy/themes/default</default_theme>\n\
    <pid>%s</pid>\n\
</splashy>\n"

#define THEME_XML_FORMAT "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\
<!-- Automatically generated by splashy_config. Do not edit -->\n\
<splashy xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\
    xsi:schemaLocation=\"http://splashy.alioth.debian.org/schemas/1.1/themes.xsd\">\n\
    <info>\n\
        <!-- theme name is case sensitive. use directory name -->\n\
        <name>%s</name>\n\
        <version>%s</version>\n\
        <description>%s</description>\n\
        <urls>%s</urls>\n\
        <author>%s</author>\n\
    </info>\n\
    <progressbar>\n\
        <!-- here are tags to set the bar... x coordinate,\n\
        y coordinate, width and height are for the progress bar.\n\
        Remember that x, y, width and height are expressed in percentage -->\n\
        <dimension>\n\
            <x>%d</x>\n\
            <y>%d</y>\n\
            <width>%d</width>\n\
            <height>%d</height>\n\
        </dimension>\n\
        <!-- here you can set the color of the progressbar...\n\
        set the amount of red, green, blue and alpha channel. \n\
        Remember that the max value is 255 and the minumun value is 0-->\n\
        <color>\n\
            <red>%d</red>\n\
            <green>%d</green>\n\
            <blue>%d</blue>\n\
            <alpha>%d</alpha>\n\
        </color>\n\
        <!-- whether or not you want a border around the progressbar. default: no -->\n\
        <border>\n\
            <enable>%s</enable>\n\
            <color>\n\
                <red>%d</red>\n\
                <green>%d</green>\n\
                <blue>%d</blue>\n\
                <alpha>%d</alpha>\n\
            </color>\n\
        </border>\n\
        <!-- here you can set the color of the progressbar background\n\
        set the amount of red, green, blue and alpha channel.\n\
        Remember that the max value is 255 and the minumun value is 0-->\n\
        <background>\n\
            <color>\n\
                <red>%d</red>\n\
                <green>%d</green>\n\
                <blue>%d</blue>\n\
                <alpha>%d</alpha>\n\
            </color>\n\
        </background>\n\
        <direction>\n\
            <boot>%s</boot>\n\
            <shutdown>%s</shutdown>\n\
            <resume>%s</resume>\n\
            <suspend>%s</suspend>\n\
        </direction>\n\
        <visibility>\n\
            <boot>%s</boot>\n\
            <shutdown>%s</shutdown>\n\
            <resume>%s</resume>\n\
            <suspend>%s</suspend>\n\
        </visibility>\n\
    </progressbar>\n\
    <!-- conventional path: /etc/splashy/themes + theme-name -->\n\
    <background>\n\
        <boot>%s</boot>\n\
        <shutdown>%s</shutdown>\n\
        <resume>%s</resume>\n\
        <suspend>%s</suspend>\n\
        <errorimg>%s</errorimg>\n\
        <!-- resolution of the images. this value affects where \n\
        the progressbar will be drawn. If VALUE <= 0, then percentages\n\
        of the screen width and hight will be assumed -->\n\
        <dimension>\n\
            <!-- NOTE: x and y are not used by splashy -->\n\
            <x>%d</x>\n\
            <y>%d</y>\n\
            <width>%d</width>\n\
            <height>%d</height>\n\
        </dimension>\n\
    </background>\n\
    <textbox>\n\
        <!-- whether you want the textbox always\n\
        shown or no. If no, it will be shown only on error, \n\
        see autoverboseonerror -->\n\
        <enable>%s</enable>\n\
        <!-- here are tags to set the text area... x coordinate,\n\
        y coordinate, width and height are for the text area.\n\
        Remember that x, y, width and height are expressed in percentage\n\
        or pixel units -->\n\
        <dimension>\n\
            <x>%d</x>\n\
            <y>%d</y>\n\
            <width>%d</width>\n\
            <height>%d</height>\n\
        </dimension>\n\
        <!-- here you can set the color of the text area...\n\
        set the amount of red, green, blue and alpha channel. \n\
        Remember that the max value is 255 and the minumun value is 0-->\n\
        <color>\n\
            <red>%d</red>\n\
            <green>%d</green>\n\
            <blue>%d</blue>\n\
            <alpha>%d</alpha>\n\
        </color>\n\
        <!-- whether or not you want a border around the progressbar. default: no -->\n\
        <border>\n\
            <enable>%s</enable>\n\
            <color>\n\
                <red>%d</red>\n\
                <green>%d</green>\n\
                <blue>%d</blue>\n\
                <alpha>%d</alpha>\n\
            </color>\n\
        </border>\n\
        <text>\n\
            <!-- font file to use, path relative to theme -->\n\
            <font>\n\
                <file>%s</file>\n\
                <height>%d</height>\n\
            </font>\n\
            <!-- here you can set the color of the text/font...\n\
            set the amount of red, green, blue and alpha channel. \n\
            Remember that the max value is 255 and the minumun value is 0-->\n\
            <color>\n\
                <red>%d</red>\n\
                <green>%d</green>\n\
                <blue>%d</blue>\n\
                <alpha>%d</alpha>\n\
            </color>\n\
        </text>\n\
    </textbox>\n\
    <autoverboseonerror>%s</autoverboseonerror>\n\
    <fadein>%s</fadein>\n\
    <fadeout>%s</fadeout>\n\
</splashy>\n"

#endif /* _XML_FORMAT_H */
