#ifdef HAVE_CONFIG_H
#include "config.H"
#endif

#ifdef __GNUC__
#  pragma interface
#endif

#include <iostream.h>
#include "graph2D.H"

enum Ttype {// Settings:
	TITLE,X,Y,Y_RIGHT,Z,
	TEXTVEC,LEFTLABEL,RIGHTLABEL,XLEFTLABEL,XRIGHTLABEL,
	LINECOLOR,LINEWIDTH,LINETYPE,MARKERTYPE,MARKERSIZE,MARKERCOLOR,
	FILLCOLOR,FOREGROUND,BACKGROUND,
	XMIN,XMAX,YMIN,YMAX,YMIN_RIGHT,YMAX_RIGHT,ZMIN,ZMAX,
	XLOG,YLOG,YLOG_RIGHT,ZLOG,PALETTE,
	GRID,FRAMEWIDTH,INTERP,HOURAXIS,SHOWNEG,HOURAXIS_X,
	TITLEFONTSIZE,LABELFONTSIZE,AXISFONTSIZE,ANNOTFONTSIZE,
	LABEL,ENDPOINT_X,ENDPOINT_Y,ARROW,
	// Commands:
	CURVE,CURVE_RIGHT,PCOLOR,
	PANEL,
	TEXTS,TEXTS_UT,
	MARK,
	PLOT};

struct Tentry {
	Ttype type;
	int nrows, ncols;	// for vectors, nrows=1
	real *data;
	Tentry *next;
	Tentry() :type(TITLE), nrows(1), ncols(1), data(0), next(0) {}
	void print(ostream& o) const;
	void print_string(ostream& o) const;
	void print_numeric(ostream& o) const;
};

class Tsppc {
private:
	Tentry *lst;
	Tentry *last;
	void LogProcessing();
public:
	Tsppc();
	bool read(istream& in);
	void plot(Tgraph2D& g, greal xmax, greal ymax,
			  greal titlefontsize, greal labelfontsize, greal axisfontsize, greal annotfontsize,
			  bool DrawCopyrightNotice) const;
	bool plotPS(ostream& out, real paperwidth_pts, real paperheight_pts, bool landscape, const char *paper);
	void print(ostream& o) const;
	void add(Tentry* p);
	friend ostream& operator<<(ostream& o, const Tsppc& S) {S.print(o); return o;}
	~Tsppc() {}
};
