
# you really want to read the templates.py files before
# hacking this file

#this file contains code that is specific to the SQL db used;
# currently only mySQL is supported properly
#

from templates import *
from copy import copy


def load_dbapi(case):
    #load the appropriate module in namespace
    #FIXME this makes it more portable but I am not completely satisfied
    if case == "MySQLdb":
        import _mysql_exceptions
        import MySQLdb    
        dbapi_exceptions=_mysql_exceptions
        dbapi=MySQLdb
    elif "PgSQL":
        from  pyPgSQL import PgSQL
        dbapi_exceptions=PgSQL
        dbapi=PgSQL
    else:
        raise AssertionError, "these module "+case+"is not supported"
    return (dbapi,dbapi_exceptions)


def is_primary(columninfo,description):
    #FIXME I think this is not portable 
    (Field, Type, Null, Key, Default, Extra) = columninfo
    return Key == "PRI"

def is_key(columninfo,description):
    #FIXME I think this is not portable 
    (Field, Type, Null, Key, Default, Extra) = columninfo
    return Key == "MUL"

class table_info(table_info_template):
    "reads info about a table, to create widgets about it"

    #FIXME I dont like these... but have no better ideas
    n_key=None
    n_primary=None
    
    #initizialization
    def __init__(self,db,db_name,table_name):
        #needs to reinit. Damn pyton classes
        self.field_columninfo={}
        self.fields=[]
        self.n_fields=0
        self.field_description={}
        self.key_fields=[]
        self.primary_key_fields=[]
        #init row
        self.default_row=[]
    
        #save data
        self.db_name=copy(db_name)
        self.table_name=copy(table_name)
        self.db=db
        #self.readonly=copy(readonly)
        
        #select db
        db.select_db(db_name)
        #get number of fields
        #DOESNT WORK... ? self.n_fields = db.field_count()

        #############
        #this is conformant to python db-api 2.0
        
        c=db.cursor()
        c.execute('SELECT * FROM %s' % table_name)

        des=c.description
        del c
        for d in des:
            (name, type_code, display_size, internal_size, precision, scale, null_ok)=d
            self.field_description[name]=d
            self.fields.append(name)
            self.n_fields= self.n_fields+1

        #############
        #this is NOT conformant to python db-api 2.0, and may not be portable

        #use cursor to get columninfo on the columns
        c=db.cursor()
        c.execute('SHOW COLUMNS FROM %s' % table_name)
        columninfo= c.fetchone()

        while columninfo:
            (Field, Type, Null, Key, Default, Extra) = columninfo            
            self.default_row.append(Default)
            self.field_columninfo[Field]=columninfo
            columninfo= c.fetchone()


        #######
        #search keys
        i=0
        for f in self.fields:
            if is_primary(self.field_columninfo[f],
                          self.field_description[f]):
                self.primary_key_fields.append(f)
                self.n_primary=i
            if is_key(self.field_columninfo[f],
                      self.field_description[f]):
                self.key_fields.append(f)
                self.n_key=i
            i = i + 1


def row2db(fields,row):
    "converts a row in a database"
    a={}
    if row == None:
        return None
    for i in range(len(fields)):
        a[fields[i]]=row[i]
    return a

