/* sqlheavy-versioned-database.c generated by valac 0.12.1, the Vala compiler
 * generated from sqlheavy-versioned-database.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include "SQLHeavy.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _SQLHeavyVersionedDatabasePrivate {
	gchar* _schema;
};


static gpointer sql_heavy_versioned_database_parent_class = NULL;

#define SQL_HEAVY_VERSIONED_DATABASE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SQL_HEAVY_TYPE_VERSIONED_DATABASE, SQLHeavyVersionedDatabasePrivate))
enum  {
	SQL_HEAVY_VERSIONED_DATABASE_DUMMY_PROPERTY,
	SQL_HEAVY_VERSIONED_DATABASE_SCHEMA
};
static GObject * sql_heavy_versioned_database_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void sql_heavy_versioned_database_finalize (GObject* obj);
static void _vala_sql_heavy_versioned_database_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sql_heavy_versioned_database_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Create a VersionedDatabase
     *
     * @param file The filename of the database
     * @param directory the directory where the schema can be found
     */
SQLHeavyVersionedDatabase* sql_heavy_versioned_database_construct (GType object_type, const gchar* file, const gchar* directory, GError** error) {
	SQLHeavyVersionedDatabase * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (directory != NULL, NULL);
	_tmp0_ = g_strdup (file);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (":memory:");
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp2_;
	}
	self = (SQLHeavyVersionedDatabase*) g_object_new (object_type, "filename", _tmp1_, "schema", directory, NULL);
	_g_free0 (_tmp1_);
	return self;
}


SQLHeavyVersionedDatabase* sql_heavy_versioned_database_new (const gchar* file, const gchar* directory, GError** error) {
	return sql_heavy_versioned_database_construct (SQL_HEAVY_TYPE_VERSIONED_DATABASE, file, directory, error);
}


const gchar* sql_heavy_versioned_database_get_schema (SQLHeavyVersionedDatabase* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_schema;
	return result;
}


static void sql_heavy_versioned_database_set_schema (SQLHeavyVersionedDatabase* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_schema);
	self->priv->_schema = _tmp0_;
	g_object_notify ((GObject *) self, "schema");
}


static GObject * sql_heavy_versioned_database_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SQLHeavyVersionedDatabase * self;
	gint _tmp0_;
	gint version;
	gchar* script_name = NULL;
	SQLHeavyTransaction* trans;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (sql_heavy_versioned_database_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SQL_HEAVY_VERSIONED_DATABASE (obj);
	sql_heavy_database_init ((SQLHeavyDatabase*) self, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			goto __catch50_sql_heavy_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	goto __finally50;
	__catch50_sql_heavy_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("sqlheavy-versioned-database.vala:27: Unable to initialize versioned da" \
"tabase: %s", err->message);
		_g_error_free0 (err);
	}
	__finally50:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp0_ = sql_heavy_database_get_user_version ((SQLHeavyDatabase*) self);
	version = _tmp0_;
	if (version == 0) {
		gchar* _tmp1_ = NULL;
		gint _tmp2_;
		_tmp1_ = g_build_filename (self->priv->_schema, "Create.sql", NULL);
		_g_free0 (script_name);
		script_name = _tmp1_;
		sql_heavy_queryable_run_script ((SQLHeavyQueryable*) self, script_name, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				goto __catch51_sql_heavy_error;
			}
			_g_free0 (script_name);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		goto __finally51;
		__catch51_sql_heavy_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_critical ("sqlheavy-versioned-database.vala:39: Unable to run creation script `%s" \
"' (%s: %d).", script_name, e->message, e->code);
			_g_error_free0 (e);
		}
		__finally51:
		if (_inner_error_ != NULL) {
			_g_free0 (script_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp2_ = sql_heavy_database_get_user_version ((SQLHeavyDatabase*) self);
		version = _tmp2_;
		if (version == 0) {
			version = 1;
			sql_heavy_database_set_user_version ((SQLHeavyDatabase*) self, version);
		}
	}
	trans = NULL;
	while (TRUE) {
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		gboolean _tmp6_;
		_tmp3_ = g_strdup_printf ("Update-to-%d.sql", version + 1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_build_filename (self->priv->_schema, _tmp4_, NULL);
		_g_free0 (script_name);
		script_name = _tmp5_;
		_g_free0 (_tmp4_);
		_tmp6_ = g_file_test (script_name, G_FILE_TEST_EXISTS);
		if (!_tmp6_) {
			break;
		}
		if (trans == NULL) {
			SQLHeavyTransaction* _tmp7_ = NULL;
			SQLHeavyTransaction* _tmp8_;
			_tmp7_ = sql_heavy_queryable_begin_transaction ((SQLHeavyQueryable*) self, &_inner_error_);
			_tmp8_ = _tmp7_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (trans);
				if (_inner_error_->domain == SQL_HEAVY_ERROR) {
					goto __catch52_sql_heavy_error;
				}
				_g_object_unref0 (trans);
				_g_free0 (script_name);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_g_object_unref0 (trans);
			trans = _tmp8_;
		}
		sql_heavy_queryable_run_script ((SQLHeavyQueryable*) trans, script_name, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (trans);
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				goto __catch52_sql_heavy_error;
			}
			_g_object_unref0 (trans);
			_g_free0 (script_name);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		version = version + 1;
		sql_heavy_database_set_user_version ((SQLHeavyDatabase*) self, version);
	}
	if (trans != NULL) {
		sql_heavy_transaction_commit (trans, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (trans);
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				goto __catch52_sql_heavy_error;
			}
			_g_object_unref0 (trans);
			_g_free0 (script_name);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	_g_object_unref0 (trans);
	goto __finally52;
	__catch52_sql_heavy_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("sqlheavy-versioned-database.vala:65: Unable to run update script `%s' " \
"(%s: %d).", script_name, e->message, e->code);
		_g_error_free0 (e);
	}
	__finally52:
	if (_inner_error_ != NULL) {
		_g_free0 (script_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_g_free0 (script_name);
	return obj;
}


static void sql_heavy_versioned_database_class_init (SQLHeavyVersionedDatabaseClass * klass) {
	sql_heavy_versioned_database_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SQLHeavyVersionedDatabasePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_sql_heavy_versioned_database_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sql_heavy_versioned_database_set_property;
	G_OBJECT_CLASS (klass)->constructor = sql_heavy_versioned_database_constructor;
	G_OBJECT_CLASS (klass)->finalize = sql_heavy_versioned_database_finalize;
	/**
	     * Location of database schema directory
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_VERSIONED_DATABASE_SCHEMA, g_param_spec_string ("schema", "schema", "schema", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void sql_heavy_versioned_database_instance_init (SQLHeavyVersionedDatabase * self) {
	self->priv = SQL_HEAVY_VERSIONED_DATABASE_GET_PRIVATE (self);
}


static void sql_heavy_versioned_database_finalize (GObject* obj) {
	SQLHeavyVersionedDatabase * self;
	self = SQL_HEAVY_VERSIONED_DATABASE (obj);
	_g_free0 (self->priv->_schema);
	G_OBJECT_CLASS (sql_heavy_versioned_database_parent_class)->finalize (obj);
}


/**
   * A class used to represent a database and its schema
   *
   * The {@link schema} should be a directory which
   * contains a Create.sql script to create the database and set the
   * [[http://www.sqlite.org/pragma.html#version|user_version]].
   *
   * Each time the database is opened, it will check for scripts
   * named Update-to-%d.sql to update the schema to the version
   * number represented by %d (i.e., user_version + 1), and execute
   * them when appropriate.
   *
   * This provides an easy way to keep your database schema up to data
   * when you update your program.
   */
GType sql_heavy_versioned_database_get_type (void) {
	static volatile gsize sql_heavy_versioned_database_type_id__volatile = 0;
	if (g_once_init_enter (&sql_heavy_versioned_database_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SQLHeavyVersionedDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sql_heavy_versioned_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SQLHeavyVersionedDatabase), 0, (GInstanceInitFunc) sql_heavy_versioned_database_instance_init, NULL };
		GType sql_heavy_versioned_database_type_id;
		sql_heavy_versioned_database_type_id = g_type_register_static (SQL_HEAVY_TYPE_DATABASE, "SQLHeavyVersionedDatabase", &g_define_type_info, 0);
		g_once_init_leave (&sql_heavy_versioned_database_type_id__volatile, sql_heavy_versioned_database_type_id);
	}
	return sql_heavy_versioned_database_type_id__volatile;
}


static void _vala_sql_heavy_versioned_database_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SQLHeavyVersionedDatabase * self;
	self = SQL_HEAVY_VERSIONED_DATABASE (object);
	switch (property_id) {
		case SQL_HEAVY_VERSIONED_DATABASE_SCHEMA:
		g_value_set_string (value, sql_heavy_versioned_database_get_schema (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sql_heavy_versioned_database_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SQLHeavyVersionedDatabase * self;
	self = SQL_HEAVY_VERSIONED_DATABASE (object);
	switch (property_id) {
		case SQL_HEAVY_VERSIONED_DATABASE_SCHEMA:
		sql_heavy_versioned_database_set_schema (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



