// Copyright (c) 1999-2001  David Muse
// See the file COPYING for more information

#include <sqlrconnection.h>

void sqlrconnection_svr::commitCommand() {
	#ifdef SERVER_DEBUG
	debugPrint("connection",1,"commit");
	#endif
	clientsock->write(commit());
	flushWriteBuffer();
	commitorrollback=false;
}

bool sqlrconnection_svr::commit() {

	#ifdef SERVER_DEBUG
	debugPrint("connection",1,"commit...");
	#endif

	sqlrcursor_svr	*commitcur=initCursor();
	char	*commitquery="commit";
	int	commitquerylen=6;
	bool	retval=false;
	if (commitcur->openCursor(0) &&
		commitcur->prepareQuery(commitquery,commitquerylen)) {
		retval=commitcur->executeQuery(commitquery,commitquerylen,true);
	}
	commitcur->cleanUpData(true,true);
	commitcur->closeCursor();
	deleteCursor(commitcur);

	#ifdef SERVER_DEBUG
	char	string[36];
	snprintf(string,36,"commit result: %d",retval);
	debugPrint("connection",2,string);
	#endif

	return retval;
}
