/* @(#)checkerr.h	1.6 03/09/13 Copyright 2003 J. Schilling */
/*
 *	Error control for star.
 *
 *	Copyright (c) 2003 J. Schilling
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Error conditions handled by error control.
 */
#define	E_STAT		0x0001		/* Could not stat(2) file	   */
#define	E_GETACL	0x0002		/* Could not retrieve ACL info	   */
#define	E_OPEN		0x0004		/* Could not open file		   */
#define	E_READ		0x0008		/* Could not read file		   */
#define	E_WRITE		0x0010		/* Could not write file		   */
#define	E_GROW		0x0020		/* File did grow during backup	   */
#define	E_SHRINK	0x0040		/* File did shrink during backup   */
#define	E_MISSLINK	0x0080		/* Missing hard link(s) for file   */
#define	E_NAMETOOLONG	0x0100		/* File name too long for archive  */
#define	E_FILETOOBIG	0x0200		/* File too big for archive	   */
#define	E_SPECIALFILE	0x0400		/* Improper file type for archive  */
#define	E_READLINK	0x0800		/* Could not read symbolic link	   */
#define	E_GETXATTR	0x1000		/* Could not get xattr		   */

#define	E_SETTIME	0x10000		/* Could not set file times	   */
#define	E_SETMODE	0x20000		/* Could not set access modes	   */
#define	E_SECURITY	0x40000		/* Skipped for security reasons	   */
#define	E_LSECURITY	0x80000		/* Link skipped for security	   */
#define	E_SAMEFILE	0x100000	/* Skipped from/to identical	   */
#define	E_BADACL	0x200000	/* ACL string conversion error	   */
#define	E_SETACL	0x400000	/* Could not set ACL for file	   */
#define	E_SETXATTR	0x800000	/* Could not set xattr		   */

extern	int	errconfig	__PR((char *name));
extern	BOOL	errhidden	__PR((int etype, char *fname));
