/* @(#)restore.h	1.3 04/09/06 Copyright 2004 J. Schilling */
/*
 *	Data structures used to map old to new inode numbers
 *	when in incremental restore mode.
 *
 *	Copyright (c) 2004 J. Schilling
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef	_RESTORE_H
#define	_RESTORE_H

/*
 * Inode mapping from archive and /star-symtable
 */
typedef struct imap imap_t;

struct imap {
/* ? */	imap_t	*i_next;	/* Next in list			*/
	imap_t	*i_hnext;	/* Next in name hash list	*/
	imap_t	*i_honext;	/* Next in old inode hash list	*/
	imap_t	*i_hnnext;	/* Next in new inode hash list	*/
/* ? */	imap_t	*i_dnext;	/* Next Directory in cwd list	*/
	imap_t	*i_dparent;	/* Parent Directory		*/
	imap_t	*i_dir;		/* Directory content		*/
	imap_t	*i_dxnext;	/* Next entry in Directory cont	*/
	char	*i_name;	/* File name			*/
	int	i_hash;		/* File name hash value		*/
	ino_t	i_oino;		/* Old inode number		*/
	ino_t	i_nino;		/* New inode number		*/
	Int32_t	i_flags;	/* Flags (see below)		*/
};

/*
 * Flags for i_flags:
 */
#define	I_DIR		0x01	/* This is a directory		*/
#define	I_NOARCHIVE	0x02	/* Name in archive, file is not	*/
#define	I_DID_RENAME	0x04	/* Entry (dir) has been renamed	*/
#define	I_DELETE	0x80	/* Entry has been deleted	*/

#define	I_NO_INO	(ino_t)-1

#endif	/* _RESTORE_H */
