#include "compat.h"

#if ! HAVE_SNPRINTF
#include <stdarg.h>
#include <stdio.h>

int
snprintf(char * string, size_t size, const char * format, ...)
{
  char * buffer;
  int length;
  FILE * devnull = fopen("/dev/null", "w");
  va_list args;
  va_start(args, format);

  /* there's no ANSI function to output the length of a printf-formatted
   *  string without actually creating such output, so this is a kludge. */
  if (! devnull) {
    fprintf(stderr, "Sorry, you don't have /dev/null.\n\
I can't emulate snprintf() for you.\n");
    exit(EXIT_FAILURE);
  }
  length = vfprintf(devnull, format, args);

  buffer = malloc(length + 1);
  if (buffer == 0) {
    fprintf(stderr, "Sorry, out of memory.\n");
    exit(EXIT_FAILURE);
  }
  vsprintf(buffer, format, args);
  strncpy(string, buffer, size);

  /* clean up */
  va_end(args);
  fclose(devnull);
  free(buffer);

  /* according to the Linux Programmer's Manual, the ISO C99 standard has
   * snprintf returning the same number for a given format string as would
   * any other member of the printf family, even if length > size. */
  return length;
}
#endif
