#ifndef _COMPAT_H
#define _COMPAT_H

#include "../system.h"

#ifdef __cplusplus
namespace std {
  extern "C" {
#endif

/* Define prototypes for functions that may be missing from system libs. */

#if defined(toupper)
#undef toupper
extern int toupper(int c);
#endif

#if defined(tolower)
#undef tolower
extern int tolower(int c);
#endif

#if defined(isalpha)
#undef isalpha
extern int isalpha(int c);
#endif

#if ! HAVE_BIND_TEXTDOMAIN_CODESET
# ifdef ENABLE_NLS /* otherwise gettext.h does a similar thing to this */
#  define bind_textdomain_codeset(a, b) /* empty */
# endif
#endif

#if ! HAVE_ATAN2
extern double atan2(double y, double x);
#endif

#if ! HAVE_FLOOR
extern double floor(double x);
#endif

#if ! HAVE_LOG10
extern double log10(double x);
#endif

#if ! HAVE_POW
extern double pow(double x, double y);
#endif

#if ! HAVE_SNPRINTF
extern int snprintf(char *str, size_t size, const char *format, ...);
#endif

#if ! HAVE_SQRT
extern double sqrt(double x);
#endif

#if ! HAVE_STRLEN
extern size_t strlen(const char *s);
#endif

#if ! HAVE_STRTOD
extern double strtod(const char *nptr, char **endptr);
#endif

#if ! HAVE_STRTOL
extern long int strtol(const char *nptr, char **endptr, int base);
#endif

#ifdef __cplusplus
  }; /* end extern "C" */
}; /* end namespace std */

#define RECORD_MAX_LENGTH 2000
	
# if (! HAVE_STD__OSTRINGSTREAM) && HAVE_STD__OSTRSTREAM
#  if ! HAVE_STRING
#   error "Sorry, you don't have the C++ STL <string> header."
#  endif
#  include <strstream.h>
#  include <string>

namespace std {
   class ostringstream : public std::ostrstream {
    private: char buffer[RECORD_MAX_LENGTH + 1];
    public:
     ostringstream();
     std::string str() const;
   };
};
# endif /* end #if (! HAVE_STD_OSTRINGSTREAM) */
#endif /* end #ifdef __cplusplus */
#endif /* end #ifndef _COMPAT_H */

