/* StarPU --- Runtime system for heterogeneous multicore architectures.
 *
 * Copyright (C) 2009, 2010  Université de Bordeaux 1
 * Copyright (C) 2010, 2011  Centre National de la Recherche Scientifique
 *
 * StarPU is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.
 *
 * StarPU is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See the GNU Lesser General Public License in COPYING.LGPL for more details.
 */

#include <datawizard/datawizard.h>
#include <datawizard/write_back.h>

void _starpu_write_through_data(starpu_data_handle handle, uint32_t requesting_node, 
					   uint32_t write_through_mask)
{
	if ((write_through_mask & ~(1<<requesting_node)) == 0) {
		/* nothing will be done ... */
		return;
	}

	/* first commit all changes onto the nodes specified by the mask */
	uint32_t node;
	for (node = 0; node < STARPU_MAXNODES; node++)
	{
		if (write_through_mask & (1<<node)) {
			/* we need to commit the buffer on that node */
			if (node != requesting_node) 
			{
				while (_starpu_spin_trylock(&handle->header_lock))
					_starpu_datawizard_progress(requesting_node, 1);

				starpu_data_request_t r;
				r = create_request_to_fetch_data(handle, &handle->per_node[node],
								STARPU_R, 0, NULL, NULL);

			        /* If no request was created, the handle was already up-to-date on the
			         * node */
			        if (r)
				{
				        _starpu_spin_unlock(&handle->header_lock);
        				_starpu_wait_data_request_completion(r, 1);
				}
			}
		}
	}
}

void starpu_data_set_wt_mask(starpu_data_handle handle, uint32_t wt_mask)
{
	handle->wt_mask = wt_mask;

	/* in case the data has some children, set their wt_mask as well */
	if (handle->nchildren > 0) 
	{
		unsigned child;
		for (child = 0; child < handle->nchildren; child++)
			starpu_data_set_wt_mask(&handle->children[child], wt_mask);
	}
}
