
/* $Id: filedata.c,v 400.1 2002/07/25 08:43:16 sgifford Exp $ */

#include "filedata.h"
#include "phonebook.h"
#include "startalk.h"
#include "stdebug.h"

#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <ctype.h>

struct startalk_phonebook_entry *
startalk_get_phonebook_entry_from_file(FILE *f)
{
  char buf[8192];
  char *c;
  char *val;
  int othertype;
  unsigned int readattrs = 0;
  struct startalk_phonebook_entry *pbe;

  debugf(3,"startalk_get_phonebook_entry_from_file called.\n");
  
  if (!(pbe = startalk_new_phonebook_entry()))
    return (void *) reterr(0,"malloc error:");
  while (fgets(buf, 8191, f))
  {
    buf[8191] = 0;
    if ( buf[0] == '#' )
    {
      continue;
    }
    if ( (c=strchr(buf,'\n')) != 0)
      *c = '\0';

    if ( (buf[0] == 0) ) /* Blank line */
    {
      if (readattrs)
      {
        debugf(3,"startalk_get_phonebook_entry_from_file returning entry with %d attributes.\n",readattrs);
        return pbe;
      }
      else
        continue;
    }

    readattrs++;
    
    if (strncasecmp(buf,"position:",9)==0)
    {
      val=startalk_cleanup_from_file(buf+9);
      pbe->pos=atoi(val);
    }
    else if (strncasecmp(buf,"name:",5)==0)
    {
      val=startalk_cleanup_from_file(buf+5);
      strncpy(pbe->name, val, MAX_NAMELEN);
      pbe->name[MAX_NAMELEN]='\0';
    }
    else if (strncasecmp(buf,"company:",8)==0)
    {
      val=startalk_cleanup_from_file(buf+8);
      strncpy(pbe->company, val, MAX_COMPANYLEN);
      pbe->company[MAX_COMPANYLEN]='\0';
    }
    else if (strncasecmp(buf,"email:",6) == 0)
    {
      val=startalk_cleanup_from_file(buf+6);
      strncpy(pbe->email, val, MAX_EMAILLEN);
      pbe->email[MAX_EMAILLEN] = '\0';
    }
    else if (strncasecmp(buf,"phone-",6)==0)
    {
      if (strncasecmp(buf+6,"office:",7)==0)
      {
        val=startalk_cleanup_from_file(buf+13);
        startalk_add_phone_to_entry(pbe, STARTALK_PHONETYPE_OFFICE, val);
      }
      else if (strncasecmp(buf+6,"home:",5)==0)
      {
        val=startalk_cleanup_from_file(buf+11);
        startalk_add_phone_to_entry(pbe, STARTALK_PHONETYPE_HOME, val);
      }
      else if (strncasecmp(buf+6,"mobile:",7)==0)
      {
        val=startalk_cleanup_from_file(buf+13);
        startalk_add_phone_to_entry(pbe, STARTALK_PHONETYPE_MOBILE, val);
      }
      else if (strncasecmp(buf+6,"pager:",6)==0)
      {
        val=startalk_cleanup_from_file(buf+12);
        startalk_add_phone_to_entry(pbe, STARTALK_PHONETYPE_PAGER, val);
      }
      else if (strncasecmp(buf+6,"fax:",4)==0)
      {
        val=startalk_cleanup_from_file(buf+10);
        startalk_add_phone_to_entry(pbe, STARTALK_PHONETYPE_FAX, val);
      }
      else if (strncasecmp(buf+6,"qmark:",6)==0)
      {
        val=startalk_cleanup_from_file(buf+12);
        startalk_add_phone_to_entry(pbe, STARTALK_PHONETYPE_QMARK, val);
      }
      else if ((strncasecmp(buf+6,"other",5)==0) &&
               ( (buf[11] >= '0') && (buf[11] <= '9') ) &&
               buf[12] == ':' )
      {
        val=startalk_cleanup_from_file(buf+13);
        othertype = buf[11] - '0';
        startalk_add_phone_to_entry(pbe, othertype, val);
      }
      else
      {
        warn("Warning: Unknown phone number type in '%s'\n",buf);
      }
    }
    else
    {
      warn("Warning: Unknown attribute in '%s'\n",buf);
      readattrs--;
    }
  }
  if (readattrs)
  {
    debugf(3,"startalk_get_phonebook_entry_from_file returning entry with %d attributes.\n",readattrs);
    return pbe;
  }

  startalk_delete_phonebook_entry(pbe);
  debugf(3,"startalk_get_phonebook_entry_from_file returning no entry.\n");
  return NULL;
}

char *
startalk_cleanup_from_file(char *in)
{
  char *r;

  /* Remove whitespace from the end . . . */
  r=strchr(in,'\0')-1;
  while ( (r >= in) && isspace(*r) )
  {
    *r='\0';
    r--;
  }

  /* . . . And the beginning. */
  r=in;
  while (isspace(*r))
  {
    r++;
  }

  return r;
}
