#include <coal.h>
#include <configure.h>

static string|int get_value(string val)
{
  int      d;
  if ( sscanf(val, "%d", d) == 1 && (string)d == val )
    return d;
  return val;
}

class Client {
    inherit "client_base";
    
    static Service myService;

    void create(object service) {
      myService = service;
    }
  
  static void handle_command(string func, mixed args) {
    werror("handle_command(%O)\n", args);
    if ( func == "notify" )
      myService->notify(args);
    else
      myService->call_service(args->user, args->params, args->id);
  }
}

class Service {
  string           name;
  mapping     serverCfg;
  mapping    serviceCfg;
  object     connection;
  object serviceManager;
  object         myUser;
  
  void notify(mixed args) {
    
  }
  
  void create() {
    serverCfg = read_server_configuration();
    serviceCfg = read_service_configuration();
    connection = Client(this_object());
  }
  mixed send_cmd(object obj, string func, mixed args, int|void nowait) {
    return connection->send_cmd(obj, func, args, nowait);
  }
  
  static void run() {
  }
  
  void call_service(object user, mixed args, int|void id) {
    myUser = user;
    werror("service called !\n");
  }
  
  void callback_service(object user, object obj, int id, mixed res) {
    send_cmd(serviceManager, "handle_service", ({ user, obj, id, res }), 1);
  }

  void async_result(int id, mixed res) {
    werror("async_result is " + strlen(res) + " bytes ...\n");
    serviceManager->async_result(id, res);
  }
  
  
  final static void start(string ticket, string sname, int|void eid) {
    string host = serverCfg->ip;
    if ( !stringp(host) || sizeof(host)==0 ) host = "localhost";

    int tries = 0;
    while ( !connection->connect_server(host, (int)serverCfg->port) &&
            tries < 100 )
    {
	sleep(10);
	tries++;
    }
    if ( tries >= 100 ) {
	werror("Failed to connect to server !\n");
	error("Failed to build connection to server.");
    }
    
    werror("Registering Service "+sname+" with ticket="+ticket);
    // register service
    if ( !connection->login("service", ticket, 0) ) {
      error("Service: Fatal error while connecting to server, "+
	    "ticket rejected !");
      
    }
    
    connection->set_object(0);
    serviceManager =connection->send_cmd(0, "get_module", "ServiceManager");
    connection->set_object(serviceManager);
    
    connection->send_command(COAL_REG_SERVICE, ({ sname, eid }));
    werror("Service '"+sname+"' registered and running.\n");
    write("----------------------------------------------\n\n"+
	  "Service " + sname + " started on "+ctime(time())+"\n\n");
    
    
    // run service - events call notify function
    run();
  }
}

mapping read_server_configuration()
{
  mapping conf = ([ "port": 1900, ]); 
  string fname = CONFIG_DIR+"/steam.cnf";
  
  if ( !Stdio.exist(fname) )
    fname = "config/steam.cnf";
  if ( Stdio.exist(fname) ) {
    string data = Stdio.read_file(fname);
    array lines = data / "\n";
    foreach(lines, string line) {
      if ( strlen(line) == 0 )
	continue;
      if ( line[0] == '#' ) // comment
	continue;
      string key;
      mixed  val;
      
      if ( sscanf(line, "%s=%s", key, val) != 2 ) {
	werror("Skipping config line: %s", line);
	continue;
      }
      string v;
      if ( sscanf(val, "hbs(%s)", v) > 0 ) {
	conf[key] = get_value(v);
	continue;
      }
      conf[key] = get_value(val);
    }
    return conf;
  }
  return ([ ]);
}

mapping read_service_configuration()
{
  return ([ ]);
}

object get_module (string str) {
  return this_object();
}




