#! /bin/sh
#
# init.d file to start the sTeam server.

PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
DAEMON_DIR=/usr/share/steam
DAEMON=start
NAME=steam
DESC="sTeam Server"
PIDFILE=/var/run/$NAME.pid

if [ ! -x $DAEMON_DIR/$DAEMON ]; then
    echo -n "sTeam Daemon not executeable !"
    exit 0
fi

set -e

case "$1" in
  start)
	if [ -f $PIDFILE ]
	then
	    echo "PID file exists, restarting sTeam server."
	    invoke-rc.d steam stop || exit 0
	    sleep 5
	fi
	echo -n "Starting $DESC: $NAME"
	cd $DAEMON_DIR
	./$DAEMON >& /dev/null &
        echo -n $! > $PIDFILE
	echo " started."
	;;
  stop)
    echo -n "Stopping $DESC: "
    if [ ! -f $PIDFILE ]; then
        echo "$NAME not running"
        exit 0
    fi
    for p in `cat $PIDFILE`; do
       if [ -n "`ps -p $p --no-headers`" ]; then
            kill -TERM $p > /dev/null || true
       fi
    done
        rm -f $PIDFILE
        echo "$NAME."
        ;;
  #reload)
	#
	#	If the daemon can reload its config files on the fly
	#	for example by sending it SIGHUP, do it here.
	#
	#	If the daemon responds to changes in its config file
	#	directly anyway, make this a do-nothing entry.
	#
	# echo -n "Reloading $DESC configuration..."
	# start-stop-daemon --stop --signal 1 --quiet --pidfile \
	#	/var/run/$NAME.pid --exec $DAEMON
	# echo "done."
  #;;
  restart|force-reload)
	#
	#	If the "reload" option is implemented, move the "force-reload"
	#	option to the "reload" entry above. If not, "force-reload" is
	#	just the same as "restart".
	#

    invoke-rc.d steam stop
    invoke-rc.d steam start
	echo "."
	;;
  *)
	N=/etc/init.d/$NAME
	# echo "Usage: $N {start|stop|restart|reload|force-reload}" >&2
	echo "Usage: $N {start|stop|restart|force-reload}" >&2
	exit 1
	;;
esac

exit 0
