/* Copyright (C) 2000-2004  Thomas Bopp, Thorsten Hampel, Ludger Merkens
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * $Id: RoomFactory.pike,v 1.1.1.1 2006/03/27 12:40:08 exodusd Exp $
 */

constant cvs_version="$Id: RoomFactory.pike,v 1.1.1.1 2006/03/27 12:40:08 exodusd Exp $";

inherit "/factories/ContainerFactory";

#include <macros.h>
#include <classes.h>
#include <access.h>
#include <database.h>
#include <events.h>
#include <attributes.h>
#include <types.h>

static void init_factory()
{
    ::init_factory();
    init_class_attribute(ROOM_TRASHBIN, CMD_TYPE_OBJECT, 
			 "rooms trashbin", 
			 0, EVENT_ATTRIBUTES_CHANGE, 0,
			 CONTROL_ATTR_SERVER, 0);
}

object execute(mapping vars)
{
    object obj;
    try_event(EVENT_EXECUTE, CALLER, obj);
    if ( vars->transient ) {
      if ( mappingp(vars->attributes) )
	vars->attributes[OBJ_TEMP] = 1;
      else
	vars->attributes = ([ OBJ_TEMP : 1 ]);
    }
    obj = ::object_create(vars["name"], CLASS_NAME_ROOM, 0,vars["attributes"],
	    	vars["attributesAcquired"], vars["attributesLocked"]); 
    
    run_event(EVENT_EXECUTE, CALLER, obj);
    return obj->this();
}
 
string get_identifier() { return "Room.factory"; }
string get_class_name() { return "Room";}
int get_class_id() { return CLASS_ROOM; }
