import Visconte.SemWeb.RDF;



/**
 * <p>Class StatementContainer - A Container item which holds different Statements for the ontology</p>
 */

/**
 * <p>array holds all statments in the container</p>
 */
    public array container =({});
     
    
/**
 * <p>The iterator of the container</p>
 */
    private int iterator = -1;
    


/**
 * <p>Add a Resourc</p>
 * @param subj - the subject Ressource
 * @param pred - the predicate Ressource
 * @param obj - the object Ressource
 */
    public void add(Resource subj, Resource pred, Resource obj) {      
	    mapping(string:Resource) stmt = (["subj":subj, "pred":pred, "obj": obj]);
	    container+=({stmt});
	    iterator=0;
    } 

/**
 * <p>Returns the next Statement and pushes the iterator</p>
 * 
 * @return current_statement as mapping
 */
    public mapping next() 
    {        
	 mapping current_statement;
	 if(iterator>=0 && iterator <sizeof(container))
	 {
		current_statement = container[iterator];
		iterator++;
	 }
	 else
	 {
		iterator=0;
		current_statement = container[iterator];
		iterator++;
	 }
	 
	return 	current_statement;
		
    } 

/**
 * <p>Checks if there are further statements</p>
 * 
 * 
 * @return int - true or false
 */
    public int has_statements() 
    {        
         if(iterator>=0 && iterator <sizeof(container))
	 {
		 return 1;
	 }
	 else
	 {
		 return 0;                            
	 }
    }
    
    
/**
 * <p>Returns a string dump of the container</p>
 * 
 * 
 * @return string - dump
 */
    public string to_string() 
    {    
	   return sprintf("%O",container);
    }

