//============================================================================
//
//   SSSS    tt          lll  lll       
//  SS  SS   tt           ll   ll        
//  SS     tttttt  eeee   ll   ll   aaaa 
//   SSSS    tt   ee  ee  ll   ll      aa
//      SS   tt   eeeeee  ll   ll   aaaaa  --  "An Atari 2600 VCS Emulator"
//  SS  SS   tt   ee      ll   ll  aa  aa
//   SSSS     ttt  eeeee llll llll  aaaaa
//
// Copyright (c) 1995-2013 by Bradford W. Mott, Stephen Anthony
// and the Stella Team
//
// See the file "License.txt" for information on usage and redistribution of
// this file, and for a DISCLAIMER OF ALL WARRANTIES.
//
// $Id: CartFAWidget.hxx 2743 2013-05-29 16:27:12Z stephena $
//============================================================================

#ifndef CARTRIDGEFA_WIDGET_HXX
#define CARTRIDGEFA_WIDGET_HXX

class CartridgeFA;
class PopUpWidget;

#include "CartDebugWidget.hxx"

class CartridgeFAWidget : public CartDebugWidget
{
  public:
    CartridgeFAWidget(GuiObject* boss, const GUI::Font& font,
                      int x, int y, int w, int h,
                      CartridgeFA& cart);
    virtual ~CartridgeFAWidget() { }

    void loadConfig();
    void handleCommand(CommandSender* sender, int cmd, int data, int id);

    string bankState();

  private:
    CartridgeFA& myCart;
    PopUpWidget* myBank;

    enum { kBankChanged = 'bkCH' };
};

#endif
