/*
 * Stellarium
 * Copyright (C) 2005 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Suite 500, Boston, MA  02110-1335, USA.
 */

// This file contains translations for all translatable strings stored within data files
// It is not meant to be compiled but just parsed by gettext
// names of celestial objects for screen display (Sky language) have been taken to translations_skycultures.h

class Translations
{
	void Translations(){;}

	static translationList()
	{
		// Generate Gettext strings for traduction
		Q_ASSERT(0);

		// Cardinals names
		N_("N");	// North
		N_("S");	// South
		N_("E");	// East
		N_("W");	// West

		// =====================================================================
		// List of types solar system bodies
		// TRANSLATORS: Type of object
		N_("star");
		// TRANSLATORS: Type of object
		N_("planet");
		// TRANSLATORS: Type of object
		N_("comet");
		// TRANSLATORS: Type of object
		N_("asteroid");
		// TRANSLATORS: Type of object
		N_("moon");
		// TRANSLATORS: Type of object
		N_("plutino");
		// TRANSLATORS: Type of object
		N_("dwarf planet");
		// TRANSLATORS: Type of object
		N_("cubewano");
		// TRANSLATORS: Type of object
		N_("scattered disc object");
		// TRANSLATORS: Type of object
		N_("Oort cloud object");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Planets");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Comets");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Asteroids");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Moons");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Plutinos");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Dwarf planets");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Cubewanos");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Scattered disc objects");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Oort cloud objects");

		// =====================================================================
		// List of deep-sky objects types
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Bright galaxies");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Open star clusters");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Globular star clusters");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Nebulae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Planetary nebulae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Dark nebulae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Irregular galaxies");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Clusters associated with nebulosity");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("HII regions");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Reflection nebulae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("H-α emission regions");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("Messier Catalogue");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("Caldwell Catalogue");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("Barnard Catalogue");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("Sharpless Catalogue");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("Van den Bergh Catalogue");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("The Catalogue of Rodgers, Campbell, and Whiteoak");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("Collinder Catalogue");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("Melotte Catalogue");
		
		// =====================================================================
		// Constellation cultures
		N_("Arabic");
		N_("Arabic Moon Stations");
		N_("Aztec");
		N_("Boorong");
		N_("Chinese");
		N_("Egyptian");
		N_("Inuit");
		N_("Indian Vedic");
		N_("Japanese Moon Stations");
		N_("Korean");
		N_("Lakota");
		N_("Maori");
		N_("Mongolian");
		N_("Navajo");
		N_("Norse");
		N_("Polynesian");
		N_("Romanian");
		N_("Sami");
		// TRANSLATORS: Name of the sky culture
		N_("Siberian");
		N_("Tukano");
		N_("Tupi-Guarani");
		N_("Tongan");
		N_("Western");
		N_("Western (H.A.Rey)");

		
		// =====================================================================
		// Landscape names
		// TRANSLATORS: Name of landscape
		N_("Guereins");
		// TRANSLATORS: Name of landscape
		N_("Trees");
		// TRANSLATORS: Name of landscape
		N_("Moon");
		// TRANSLATORS: Landscape name: Hurricane Ridge
		N_("Hurricane");
		// TRANSLATORS: Name of landscape
		N_("Ocean");
		// TRANSLATORS: Landscape name: Garching bei Munchen
		N_("Garching");
		// TRANSLATORS: Name of landscape
		N_("Mars");
		// TRANSLATORS: Name of landscape
		N_("Jupiter");
		// TRANSLATORS: Name of landscape
		N_("Saturn");
		// TRANSLATORS: Name of landscape
		N_("Uranus");
		// TRANSLATORS: Name of landscape
		N_("Neptune");
		// TRANSLATORS: Name of landscape
		N_("Geneva");
		// TRANSLATORS: Name of landscape
		N_("Grossmugl");
		// TRANSLATORS: Name of landscape
		N_("Zero Horizon");

		// =====================================================================
		// 3D landscapes (scenes) names
		// TRANSLATORS: Name of 3D scene ("Sterngarten" is proper name)
		N_("Vienna Sterngarten");
		// TRANSLATORS: Name of 3D scene
		N_("Testscene")
		
		// =====================================================================
		// Script names
		// TRANSLATORS: Name of script
		N_("Landscape Tour");
		// TRANSLATORS: Name of script
		N_("Partial Lunar Eclipse");
		// TRANSLATORS: Name of script
		N_("Total Lunar Eclipse");
		// TRANSLATORS: Name of script
		N_("Screensaver");
		// TRANSLATORS: Name of script
		N_("Solar Eclipse 2009");
		// TRANSLATORS: Name of script
		N_("Startup Script");
		// TRANSLATORS: Name of script
		N_("Zodiac");
		// TRANSLATORS: Name of script
		N_("Mercury Triple Sunrise and Sunset");
		// TRANSLATORS: Name of script
		N_("Double eclipse from Deimos in 2017");
		// TRANSLATORS: Name of script
		N_("Double eclipse from Deimos in 2031");
		// TRANSLATORS: Name of script
		N_("Eclipse from Olympus Mons Jan 10 2068");
		// TRANSLATORS: Name of script
		N_("Occultation of Earth and Jupiter 2048");
		// TRANSLATORS: Name of script
		N_("3 Transits and 2 Eclipses from Deimos 2027");
		// TRANSLATORS: Name of script
		N_("Solar System Screensaver");
		// TRANSLATORS: Name of script
		N_("Constellations Tour");
		// TRANSLATORS: Name of script
		N_("Sun from different planets");
		// TRANSLATORS: Name of script
		N_("Earth best views from other bodies");
		// TRANSLATORS: Name of script
		N_("Transit of Venus");
		// TRANSLATORS: Name of script
		N_("Analemma");
		// TRANSLATORS: Name of script
		N_("Sky Culture Tour");
		// TRANSLATORS: Name and description of script
		N_("Earth Events from Mercury");
		// TRANSLATORS: Name and description of script
		N_("Earth Events from a floating city on Venus");
		// TRANSLATORS: Name and description of script
		N_("Earth Events from Mars");
		// TRANSLATORS: Name of script
		N_("Earth and Venus Greatest Elongations and Brilliancies from Mars");
		// TRANSLATORS: Name of script
		N_("Earth and Mars Greatest Elongations and Transits from Callisto");
		// TRANSLATORS: Name of script
		N_("Tycho's Supernova");
		
		// =====================================================================
		// Script descriptions
		
		// TRANSLATORS: Description of the landscape tour script.
		N_("Look around each installed landscape.");
		// TRANSLATORS: Description of the sky culture tour script.
		N_("Look at each installed sky culture.");
		N_("Script to demonstrate a partial lunar eclipse.");
		N_("Script to demonstrate a total lunar eclipse.");
		N_("A slow, infinite tour of the sky, looking at random objects.");
		N_("Script to demonstrate a total solar eclipse which has happened in 2009 (location=Rangpur, Bangladesh).");
		N_("Script which runs automatically at startup");
		N_("This script displays the constellations of the Zodiac. That means the constellations which lie along the line which the Sun traces across the celestial sphere over the course of a year.");
		N_("Due to the quirks in Mercury's orbit and rotation at certain spots the sun will rise & set 3 different times in one Mercury day.");
		N_("Just before Mars eclipses the sun, Phobos pops out from behind and eclipses it first. Takes place between Scorpio and Sagittarius on April 26, 2017.");
		N_("Just before Mars eclipses the sun, Phobos pops out from behind and eclipses it first. Takes place between Taurus and Gemini on July 23, 2031.");
		N_("Phobos eclipsing the Sun as seen from Olympus Mons on Jan 10, 2068.");
		N_("Phobos occultations of Earth are common, as are occultations of Jupiter. But occultations of both on the same day are very rare. Here's one that takes place 1/23/2048. In real speed.");
		N_("Phobos races ahead of Mars and transits the sun, passes through it and then retrogrades back towards the sun and just partially transits it again (only seen in the southern hemisphere of Deimos), then Mars totally eclipses the sun while Phobos transits in darkness between Mars and Deimos. When Phobos emerges from Mars it is still eclipsed and dimmed in Mars' shadow, only to light up later.");
		N_("Screensaver of various happenings in the Solar System. 232 events in all!");
		N_("A tour of the western constellations.");
		N_("Look at the Sun from big planets of Solar System and Pluto.");
		N_("Best views of Earth from other Solar System bodies in the 21st Century.");
		N_("Transit of Venus as seen from Sydney Australia, 6th June 2012.");
		N_("A demonstration of the analemma - the path of the Sun across the sky during the year.");
		N_("Flash of the supernova observed by Tycho Brahe in 1572. The Supernovae plugin has to be enabled.");
		N_("Earth and Venus Greatest Elongations and Brilliancies from Mars 2000-3000");
		N_("Earth Greatest Elongations and Transits from Callisto 2000-3000. Why Callisto? Well of the 4 Galilean Moons, Callisto is the only one outside of Jupiter's radiation belt. Therefore, if humans ever colonize Jupiter's moons, Callisto will be the one.");
		
		// =====================================================================
		// List of countries
		N_("Andorra");
		N_("United Arab Emirates");
		N_("Afghanistan");
		N_("Antigua and Barbuda");
		N_("Anguilla");
		N_("Albania");
		N_("Armenia");
		N_("Netherlands Antilles");
		N_("Angola");
		N_("Antarctica");
		N_("Argentina");
		N_("American Samoa");
		N_("Austria");
		N_("Australia");
		N_("Aruba");
		N_("Azerbaijan");
		N_("Bosnia and Herzegowina");
		N_("Barbados");
		N_("Bangladesh");
		N_("Belgium");
		N_("Burkina Faso");
		N_("Bulgaria");
		N_("Bahrain");
		N_("Burundi");
		N_("Benin");
		N_("Bermuda");
		N_("Brunei Darussalam");
		N_("Bolivia");
		N_("Brazil");
		N_("Bahamas");
		N_("Bhutan");
		N_("Bouvet Island");
		N_("Botswana");
		N_("Belarus");
		N_("Belize");
		N_("Canada");
		N_("Cocos Islands");
		N_("Democratic Republic of the Congo");
		N_("Central African Republic");
		N_("Republic of the Congo");
		N_("Switzerland");
		N_("Cote d'Ivoire");
		N_("Cook Islands");
		N_("Chile");
		N_("Cameroon");
		N_("China");
		N_("Colombia");
		N_("Costa Rica");
		N_("Serbia and Montenegro");
		N_("Cuba");
		N_("Cape Verde");
		N_("Christmas Island");
		N_("Cyprus");
		N_("Czech Republic");
		N_("Germany");
		N_("Djibouti");
		N_("Denmark");
		N_("Dominica");
		N_("Dominican Republic");
		N_("Algeria");
		N_("Ecuador");
		N_("Estonia");
		N_("Egypt");
		N_("Western Sahara");
		N_("Eritrea");
		N_("Spain");
		N_("Ethiopia");
		N_("Finland");
		N_("Fiji");
		N_("Falkland Islands");
		N_("Micronesia");
		N_("Faroe Islands");
		N_("France");
		N_("Gabon");
		N_("United Kingdom");
		N_("Grenada");
		N_("Georgia");
		N_("French Guiana");
		N_("Ghana");
		N_("Gibraltar");
		N_("Greenland");
		N_("Gambia");
		N_("Guinea");
		N_("Guadeloupe");
		N_("Equatorial Guinea");
		N_("Greece");
		N_("South Georgia and the South Sandwich Islands");
		N_("Guatemala");
		N_("Guam");
		N_("Guinea-Bissau");
		N_("Guyana");
		N_("Hong Kong");
		N_("Heard Island and McDonald Islands");
		N_("Honduras");
		N_("Croatia");
		N_("Haiti");
		N_("Hungary");
		N_("Indonesia");
		N_("Ireland");
		N_("Israel");
		N_("India");
		N_("British Indian Ocean Territory");
		N_("Iraq");
		N_("Iran");
		N_("Iceland");
		N_("Italy");
		N_("Jamaica");
		N_("Jordan");
		N_("Japan");
		N_("Kenya");
		N_("Kyrgyzstan");
		N_("Cambodia");
		N_("Kiribati");
		N_("Comoros");
		N_("Saint Kitts and Nevis");
		N_("Democratic People's Republic of Korea");
		N_("Republic of Korea");
		N_("Kuwait");
		N_("Cayman Islands");
		N_("Kazakhstan");
		N_("Lao");
		N_("Lebanon");
		N_("Saint Lucia");
		N_("Liechtenstein");
		N_("Sri Lanka");
		N_("Liberia");
		N_("Lesotho");
		N_("Lithuania");
		N_("Luxembourg");
		N_("Latvia");
		N_("Libyan Arab Jamahiriya");
		N_("Morocco");
		N_("Monaco");
		N_("Moldova");
		N_("Madagascar");
		N_("Marshall Islands");
		N_("Macedonia");
		N_("Mali");
		N_("Myanmar");
		N_("Mongolia");
		N_("Macau");
		N_("Northern Mariana Islands");
		N_("Martinique");
		N_("Mauritania");
		N_("Montserrat");
		N_("Malta");
		N_("Mauritius");
		N_("Maldives");
		N_("Malawi");
		N_("Mexico");
		N_("Malaysia");
		N_("Mozambique");
		N_("Namibia");
		N_("New Caledonia");
		N_("Niger");
		N_("Norfolk Island");
		N_("Nigeria");
		N_("Nicaragua");
		N_("Netherlands");
		N_("Norway");
		N_("Nepal");
		N_("Nauru");
		N_("Niue");
		N_("New Zealand");
		N_("Oman");
		N_("Panama");
		N_("Peru");
		N_("French Polynesia");
		N_("Papua New Guinea");
		N_("Philippines");
		N_("Pakistan");
		N_("Poland");
		N_("Saint Pierre and Miquelon");
		N_("Pitcairn");
		N_("Puerto Rico");
		N_("Palestinian Territories");
		N_("Portugal");
		N_("Palau");
		N_("Paraguay");
		N_("Qatar");
		N_("Réunion");
		N_("Romania");
		N_("Serbia");
		N_("Russian Federation");
		N_("Rwanda");
		N_("Saudi Arabia");
		N_("Solomon Islands");
		N_("Seychelles");
		N_("Sudan");
		N_("Sweden");
		N_("Singapore");
		N_("Saint Helena");
		N_("Slovenia");
		N_("Svalbard and Jan Mayen");
		N_("Slovakia");
		N_("Sierra Leone");
		N_("San Marino");
		N_("Senegal");
		N_("Somalia");
		N_("Suriname");
		N_("Sao Tome and Principe");
		N_("El Salvador");
		N_("Syrian Arab Republic");
		N_("Swaziland");
		N_("Turks and Caicos Islands");
		N_("Chad");
		N_("French Southern Territories");
		N_("Togo");
		N_("Thailand");
		N_("Tajikistan");
		N_("Tokelau");
		N_("East Timor");
		N_("Turkmenistan");
		N_("Tunisia");
		N_("Tonga");
		N_("Turkey");
		N_("Trinidad and Tobago");
		N_("Tuvalu");
		N_("Taiwan");
		N_("Tanzania");
		N_("Ukraine");
		N_("Uganda");
		N_("United States Minor Outlying Islands");
		N_("United States");
		N_("Uruguay");
		N_("Uzbekistan");
		N_("Vatican City State");
		N_("Saint Vincent and the Grenadines");
		N_("Venezuela");
		N_("British Virgin Islands");
		N_("United States Virgin Islands");
		N_("Viet Nam");
		N_("Vanuatu");
		N_("Wallis and Futuna");
		N_("Samoa");
		N_("Yemen");
		N_("Mayotte");
		N_("Yugoslavia");
		N_("South Africa");
		N_("Zambia");
		N_("Zimbabwe");

		// =====================================================================
		// List of GUI elements (Qt's dialogs)
		N_("&Undo");
		N_("&Redo");
		N_("Cu&t");
		N_("&Copy");
		N_("&Paste");
		N_("Delete");
		N_("Select All");
		N_("Look in:");
		N_("Directory:");
		N_("Folder");
		N_("&Choose");
		N_("Cancel");
		N_("Files of type:");
		N_("Date Modified");
		N_("Directories");
		N_("Computer");
		N_("&Open");
		N_("File &name:");
		N_("Copy &Link Location");
		N_("Abort");
		N_("Ignore");
	}
};
