#import "InstallerFrameworks.h"

@implementation InstallerFrameworks

- (void)install
{	
	// Copy in PNG.framework
	if (![fileManager fileExistsAtPath:@"/Library/Frameworks/PNG.framework"]) {
		[fileManager copyPath:[resourcesPath stringByAppendingString:@"PNG.framework"] toPath:@"/Library/Frameworks/PNG.framework" handler:NULL];
	}
	
	// Copy in OggVorbis.framework
	if (![fileManager fileExistsAtPath:@"/Library/Frameworks/OggVorbis.framework"]) {
		[fileManager copyPath:[resourcesPath stringByAppendingString:@"OggVorbis.framework"] toPath:@"/Library/Frameworks/OggVorbis.framework" handler:NULL];
	}
}

- (BOOL)prepare
{
	BOOL success = YES;
	
	// Create the Frameworks directory if it doesn't exist
	if (![fileManager fileExistsAtPath:@"/Library/Frameworks"])
		[fileManager createDirectoryAtPath:@"/Library/Frameworks" attributes:nil];
	
	// Check we can write to where we want to write
	if ((![fileManager fileExistsAtPath:@"/Library/Frameworks/PNG.framework"] ||
			![fileManager fileExistsAtPath:@"/Library/Frameworks/OggVorbis.framework"])
			&& ![fileManager isWritableFileAtPath:@"/Library/Frameworks"]) {
		
		// Complain that we don't have write access
		NSRunAlertPanel(@"Frameworks Cannot Be Installed", @"The Installer cannot install the frameworks necessary for FreeCraft and parts of the installer to run at \"/Library/Frameworks\". As such, these frameworks (PNG.framework and OggVorbis.framework) will be moved to the desktop and must be installed by yourself at \"/Library/Frameworks\" before the installation process can take place.", @"Ok", NULL, NULL);
		
		// Move the frameworks to the desktop as we said we would
		if (![fileManager fileExistsAtPath:[NSHomeDirectory() stringByAppendingString:@"/Desktop/PNG.framework"]]) {
			[fileManager movePath:[resourcesPath stringByAppendingString:@"PNG.framework"] toPath:[NSHomeDirectory() stringByAppendingString:@"/Desktop/PNG.framework"] handler:NULL];
		}
		if (![fileManager fileExistsAtPath:[NSHomeDirectory() stringByAppendingString:@"/Desktop/OggVorbis.framework"]]) {
			[fileManager movePath:[resourcesPath stringByAppendingString:@"OggVorbis.framework"] toPath:[NSHomeDirectory() stringByAppendingString:@"/Desktop/OggVorbis.framework"] handler:NULL];
		}
		
		success = NO;
	}
		
	return success;
}

@end
