module as-pattern
imports sunit

signature
  constructors
    A : S
    B : S
    C : S
    F : S * S -> S
    H : S * S * S -> S
    G : S * S -> S

rules

  R1 : F(x, y @ G(A, z)) -> H(x, y, z)
 
  R2 : F(x, G(y, B)) -> H(x, y, B)

strategies

  main = 
    test-suite(!"as-pattern-test",
	as-pattern1;
	as-pattern2
    )
	
  as-pattern1 = 
    apply-test(!"as-pattern1"
	      ,R1
              ,!F(B,G(A,C))
              ,!H(B,G(A,C),C)
              )

  as-pattern2 = 
    apply-test(!"as-pattern2"
	      ,R1 + R2
              ,!F(B,G(C,B))
              ,!H(B, C, B)
              )
