module prop
imports sunit
strategies

  main = 
    test-suite(!"prop",
        test1
    )

  test1 = 
    apply-test(!"test1"
              ,disj-nf

              ,!And(And(Or(Or(Atom("d_0"),Atom("a")),Or(Or(Atom("c_0"),Atom("a")),False)),Atom("b")),And(And(Or(Or(Atom("b_0"),Atom("a")),Or(Or(Atom("a_0"),Atom("a")),False)),Atom("b")),True))

              ,open(!"prop.res") 
              )

strategies

  bottomup(s) =
    rec x(all(x); s)

  innermost(s) = 
    bottomup(red(s))

  red(s) = 
    rec x(s; bottomup(x) <+ id)

  nf(s) = 
    bottomup(not(s))

signature
  sorts Prop
  constructors
    False : Prop
    True  : Prop
    Atom  : String -> Prop
    Not   : Prop -> Prop
    And   : Prop * Prop -> Prop
    Or    : Prop * Prop -> Prop
    Impl  : Prop * Prop -> Prop
    Eq    : Prop * Prop -> Prop

strategies

 disj-nf = 
   innermost(DAOL + DAOR + DN + DMA + DMO + T)

 T = T1 + T2 + T3 + T4 + T5 + T6 + T7 + T8 + T9 + T10 +
     T11 + T12 + T13 + T14 + T15 + T16 + T17 + T18 + T19
rules

  T1  : Not(True) -> False       T2  : Not(False) -> True

  T3  : And(True, x) -> x        T5  : And(False, x) -> False  
  T4  : And(x, True) -> x        T6  : And(x, False) -> False  
  
  T7  : Or(True, x) -> True      T9  : Or(False, x) -> x
  T8  : Or(x, True) -> True      T10 : Or(x, False) -> x

  T11 : Impl(True, x) -> x       T14 : Impl(False, False) -> True
  T12 : Impl(x, True) -> True    T15 : Impl(True, False) -> False
  T13 : Impl(False, x) -> True

  T16 : Eq(False, x) -> Not(x)   T18 : Eq(True, x) -> x
  T17 : Eq(x, False) -> Not(x)   T19 : Eq(x, True) -> x

rules

  AA    : And(And(x, y), z) -> And(x, And(y, z))
  AO    : Or(Or(x, y), z) -> Or(x, Or(y, z))
  AI    : Impl(Impl(x, y), z) -> Impl(x, Impl(y, z))
  AE    : Eq(Eq(x, y), z) -> Eq(x, Eq(y, z))
  
  CA    : And(x, y) -> And(y, x) 
  CO    : Or(x, y) -> Or(y, x)
  CE    : Eq(x, y) -> Eq(y, x)

  IDA   : And(x, x) -> x
  IDO   : Or(x, x) -> x
  IDI   : Impl(x, x) -> True
  IDE   : Eq(x, x) -> True

  DAOL  : And(Or(x, y), z) -> Or(And(x, z), And(y, z))
  DAOR  : And(z, Or(x, y)) -> Or(And(z, x), And(z, y))
  DOAL  : Or(And(x, y), z) -> And(Or(x, z), Or(y, z))
  DOAR  : Or(z, And(x, y)) -> And(Or(z, x), Or(z, y))

  DN    : Not(Not(x)) -> x

  DMA   : Not(And(x, y)) -> Or(Not(x), Not(y))
  DMO   : Not(Or(x, y))  -> And(Not(x), Not(y))
  DMI   : Not(Impl(x, y)) -> And(x, Not(y))
  DME   : Not(Eq(x, y)) -> Or(And(Not(x), y), And(x, Not(y)))

  DefN  : Not(x) -> Impl(x, False)
  DefI  : Impl(x, y) -> Or(Not(x), y)
  DefE  : Eq(x, y) -> And(Impl(x, y), Impl(y, x))
  DefO1 : Or(x, y) -> Impl(Not(x), y)
  DefO2 : Or(x, y) -> Not(And(Not(x), Not(y)))
  DefA1 : And(x, y) -> Not(Or(Not(x), Not(y)))
  DefA2 : And(x, y) -> Not(Impl(x, Not(y)))

  IDefI : Or(Not(x), y) -> Impl(x, y)
  IDefE : And(Impl(x, y), Impl(y, x)) -> Eq(x, y)
